/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.concurrent;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public class BlockingAwareFuture<T>
extends CompletableFuture<T> {
    private final AtomicBoolean blocked;

    public BlockingAwareFuture() {
        this(new AtomicBoolean());
    }

    private BlockingAwareFuture(AtomicBoolean blocked) {
        this.blocked = blocked;
    }

    public boolean isBlocked() {
        return this.blocked.get();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        this.blocked.set(true);
        try {
            Object t = super.get();
            return t;
        }
        finally {
            this.blocked.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.blocked.set(true);
        try {
            Object t = super.get(timeout, unit);
            return t;
        }
        finally {
            this.blocked.set(false);
        }
    }

    @Override
    public synchronized T join() {
        this.blocked.set(true);
        try {
            Object t = super.join();
            return t;
        }
        finally {
            this.blocked.set(false);
        }
    }

    private <U> CompletableFuture<U> wrap(CompletableFuture<U> future) {
        BlockingAwareFuture blockingFuture = new BlockingAwareFuture(this.blocked);
        future.whenComplete((T result, U error) -> {
            if (error == null) {
                blockingFuture.complete(result);
            } else {
                blockingFuture.completeExceptionally((Throwable)error);
            }
        });
        return blockingFuture;
    }

    @Override
    public <U> CompletableFuture<U> thenApply(Function<? super T, ? extends U> fn) {
        return this.wrap((CompletableFuture<U>)super.thenApply((Function)fn));
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn) {
        return this.wrap((CompletableFuture<U>)super.thenApplyAsync((Function)fn));
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        return this.wrap((CompletableFuture<U>)super.thenApplyAsync((Function)fn, executor));
    }

    @Override
    public CompletableFuture<Void> thenAccept(Consumer<? super T> action) {
        return this.wrap((CompletableFuture)super.thenAccept((Consumer)action));
    }

    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action) {
        return this.wrap((CompletableFuture)super.thenAcceptAsync((Consumer)action));
    }

    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action, Executor executor) {
        return this.wrap((CompletableFuture)super.thenAcceptAsync((Consumer)action, executor));
    }

    @Override
    public CompletableFuture<Void> thenRun(Runnable action) {
        return this.wrap((CompletableFuture)super.thenRun(action));
    }

    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action) {
        return this.wrap((CompletableFuture)super.thenRunAsync(action));
    }

    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action, Executor executor) {
        return this.wrap((CompletableFuture)super.thenRunAsync(action, executor));
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return this.wrap((CompletableFuture<U>)super.thenCombine((CompletionStage)other, (BiFunction)fn));
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        return this.wrap((CompletableFuture<U>)super.thenCombineAsync((CompletionStage)other, (BiFunction)fn));
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        return this.wrap((CompletableFuture<U>)super.thenCombineAsync((CompletionStage)other, (BiFunction)fn, executor));
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return this.wrap((CompletableFuture<U>)super.thenAcceptBoth((CompletionStage)other, (BiConsumer)action));
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        return this.wrap((CompletableFuture<U>)super.thenAcceptBothAsync((CompletionStage)other, (BiConsumer)action));
    }

    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action, Executor executor) {
        return this.wrap((CompletableFuture<U>)super.thenAcceptBothAsync((CompletionStage)other, (BiConsumer)action, executor));
    }

    @Override
    public CompletableFuture<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        return this.wrap((CompletableFuture)super.runAfterBoth((CompletionStage)other, action));
    }

    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        return this.wrap((CompletableFuture)super.runAfterBothAsync((CompletionStage)other, action));
    }

    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.wrap((CompletableFuture)super.runAfterBothAsync((CompletionStage)other, action, executor));
    }

    @Override
    public <U> CompletableFuture<U> applyToEither(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return this.wrap((CompletableFuture<U>)super.applyToEither((CompletionStage)other, (Function)fn));
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        return this.wrap((CompletableFuture<U>)super.applyToEitherAsync((CompletionStage)other, (Function)fn));
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn, Executor executor) {
        return this.wrap((CompletableFuture<U>)super.applyToEitherAsync((CompletionStage)other, (Function)fn, executor));
    }

    @Override
    public CompletableFuture<Void> acceptEither(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return this.wrap((CompletableFuture)super.acceptEither((CompletionStage)other, (Consumer)action));
    }

    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action) {
        return this.wrap((CompletableFuture)super.acceptEitherAsync((CompletionStage)other, (Consumer)action));
    }

    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action, Executor executor) {
        return this.wrap((CompletableFuture)super.acceptEitherAsync((CompletionStage)other, (Consumer)action, executor));
    }

    @Override
    public CompletableFuture<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        return this.wrap((CompletableFuture)super.runAfterEither((CompletionStage)other, action));
    }

    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        return this.wrap((CompletableFuture)super.runAfterEitherAsync((CompletionStage)other, action));
    }

    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        return this.wrap((CompletableFuture)super.runAfterEitherAsync((CompletionStage)other, action, executor));
    }

    @Override
    public <U> CompletableFuture<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
        return this.wrap((CompletableFuture<U>)super.thenCompose((Function)fn));
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn) {
        return this.wrap((CompletableFuture<U>)super.thenComposeAsync((Function)fn));
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn, Executor executor) {
        return this.wrap((CompletableFuture<U>)super.thenComposeAsync((Function)fn, executor));
    }

    @Override
    public CompletableFuture<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        return this.wrap((CompletableFuture)super.whenComplete((BiConsumer)action));
    }

    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action) {
        return this.wrap((CompletableFuture)super.whenCompleteAsync((BiConsumer)action));
    }

    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        return this.wrap((CompletableFuture)super.whenCompleteAsync((BiConsumer)action, executor));
    }

    @Override
    public <U> CompletableFuture<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        return this.wrap((CompletableFuture<U>)super.handle((BiFunction)fn));
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn) {
        return this.wrap((CompletableFuture<U>)super.handleAsync((BiFunction)fn));
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, Executor executor) {
        return this.wrap((CompletableFuture<U>)super.handleAsync((BiFunction)fn, executor));
    }
}

