/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.time;

import com.google.common.annotations.Beta;
import com.google.common.base.MoreObjects;
import io.atomix.time.Clock;
import io.atomix.time.LogicalTimestamp;
import io.atomix.time.VectorTimestamp;
import io.atomix.utils.Identifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@Beta
public class VectorClock<T extends Identifier>
implements Clock<VectorTimestamp<T>> {
    private final T localIdentifier;
    private final Map<T, VectorTimestamp<T>> vector = new HashMap<T, VectorTimestamp<T>>();

    public VectorClock(T localIdentifier) {
        this(new VectorTimestamp<T>(localIdentifier, 0L));
    }

    public VectorClock(VectorTimestamp<T> localTimestamp) {
        this(localTimestamp, Collections.emptyList());
    }

    public VectorClock(VectorTimestamp<T> localTimestamp, Collection<VectorTimestamp<T>> vector) {
        this.localIdentifier = localTimestamp.identifier();
        this.vector.put(localTimestamp.identifier(), localTimestamp);
        for (VectorTimestamp<T> timestamp : vector) {
            this.vector.put(timestamp.identifier(), timestamp);
        }
    }

    @Override
    public VectorTimestamp<T> getTime() {
        return this.vector.get(this.localIdentifier);
    }

    public LogicalTimestamp getLocalTimestamp() {
        return this.getTime();
    }

    public LogicalTimestamp getTimestamp(T identifier) {
        return this.vector.get(identifier);
    }

    public Collection<VectorTimestamp<T>> getTimestamps() {
        return this.vector.values();
    }

    public void update(VectorTimestamp<T> timestamp) {
        VectorTimestamp<T> currentTimestamp = this.vector.get(timestamp.identifier());
        if (currentTimestamp == null || currentTimestamp.value() < timestamp.value()) {
            this.vector.put(timestamp.identifier(), timestamp);
        }
    }

    public void update(VectorClock<T> clock) {
        for (VectorTimestamp<T> timestamp : clock.vector.values()) {
            this.update(timestamp);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("time", (Object)this.getTime()).add("vector", this.getTimestamps()).toString();
    }
}

