/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.manager;

import io.atomix.catalyst.concurrent.Futures;
import io.atomix.catalyst.concurrent.ThreadContext;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.transport.Transport;
import io.atomix.catalyst.util.Assert;
import io.atomix.catalyst.util.ConfigurationException;
import io.atomix.copycat.client.ConnectionStrategies;
import io.atomix.copycat.client.ConnectionStrategy;
import io.atomix.copycat.client.CopycatClient;
import io.atomix.copycat.client.RecoveryStrategies;
import io.atomix.copycat.client.ServerSelectionStrategies;
import io.atomix.manager.ResourceManager;
import io.atomix.manager.ResourceManagerException;
import io.atomix.manager.internal.GetResourceKeys;
import io.atomix.manager.internal.ResourceExists;
import io.atomix.manager.options.ClientOptions;
import io.atomix.manager.resource.internal.InstanceClient;
import io.atomix.manager.resource.internal.ResourceInstance;
import io.atomix.manager.util.ResourceManagerTypeResolver;
import io.atomix.resource.Resource;
import io.atomix.resource.ResourceRegistry;
import io.atomix.resource.ResourceType;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class ResourceClient
implements ResourceManager<ResourceClient> {
    private final CopycatClient client;
    private final Map<Class<? extends Resource<?>>, ResourceType> types = new ConcurrentHashMap();
    private final Map<String, Resource<?>> instances = new ConcurrentHashMap();
    private final Map<String, CompletableFuture> futures = new ConcurrentHashMap<String, CompletableFuture>();

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Properties properties) {
        ClientOptions clientProperties = new ClientOptions(properties);
        return new Builder().withTransport(clientProperties.transport()).withSerializer(clientProperties.serializer());
    }

    public ResourceClient(CopycatClient client) {
        this.client = Assert.notNull(client, "client");
    }

    public CopycatClient client() {
        return this.client;
    }

    @Override
    public ThreadContext context() {
        return this.client.context();
    }

    @Override
    public Serializer serializer() {
        return this.client.serializer();
    }

    @Override
    public final ResourceType type(Class<? extends Resource<?>> type) {
        return this.types.computeIfAbsent(type, ResourceType::new);
    }

    @Override
    public CompletableFuture<Boolean> exists(String key) {
        return this.client.submit(new ResourceExists(key));
    }

    @Override
    public CompletableFuture<Set<String>> keys() {
        return this.client.submit(new GetResourceKeys());
    }

    @Override
    public <T extends Resource> CompletableFuture<Set<String>> keys(Class<? super T> type) {
        return this.keys(this.type(type));
    }

    @Override
    public CompletableFuture<Set<String>> keys(ResourceType type) {
        return this.client.submit(new GetResourceKeys(Assert.notNull(type, "type").id()));
    }

    @Override
    public <T extends Resource> CompletableFuture<T> getResource(String key, Class<? super T> type) {
        return this.getResource(key, this.type(type), new Resource.Config(), new Resource.Options());
    }

    @Override
    public <T extends Resource> CompletableFuture<T> getResource(String key, Class<? super T> type, Resource.Config config) {
        return this.getResource(key, this.type(type), config, new Resource.Options());
    }

    @Override
    public <T extends Resource> CompletableFuture<T> getResource(String key, Class<? super T> type, Resource.Options options) {
        return this.getResource(key, this.type(type), new Resource.Config(), options);
    }

    @Override
    public <T extends Resource> CompletableFuture<T> getResource(String key, Class<? super T> type, Resource.Config config, Resource.Options options) {
        return this.getResource(key, this.type(type), config, options);
    }

    @Override
    public <T extends Resource> CompletableFuture<T> getResource(String key, ResourceType type) {
        return this.getResource(key, type, new Resource.Config(), new Resource.Options());
    }

    @Override
    public <T extends Resource> CompletableFuture<T> getResource(String key, ResourceType type, Resource.Config config) {
        return this.getResource(key, type, config, new Resource.Options());
    }

    @Override
    public <T extends Resource> CompletableFuture<T> getResource(String key, ResourceType type, Resource.Options options) {
        return this.getResource(key, type, new Resource.Config(), options);
    }

    @Override
    public synchronized <T extends Resource> CompletableFuture<T> getResource(String key, ResourceType type, Resource.Config config, Resource.Options options) {
        Assert.notNull(key, "key");
        Assert.notNull(type, "type");
        Assert.notNull(config, "config");
        Assert.notNull(options, "options");
        Resource<?> check = this.instances.get(key);
        if (check == null) {
            ResourceInstance instance = new ResourceInstance(key, type, config, this::close);
            InstanceClient client = new InstanceClient(instance, this.client);
            try {
                check = type.factory().newInstance().createInstance(client, options);
                this.instances.put(key, check);
            }
            catch (IllegalAccessException | InstantiationException e) {
                return Futures.exceptionalFuture(e);
            }
        }
        if (check.type().id() != type.id()) {
            return Futures.exceptionalFuture(new IllegalArgumentException("inconsistent resource type: " + type));
        }
        Resource<?> resource = check;
        return this.futures.computeIfAbsent(key, k -> resource.open());
    }

    private synchronized void close(ResourceInstance instance) {
        this.instances.remove(instance.key());
        this.futures.remove(instance.key());
    }

    public CopycatClient.State state() {
        return this.client.state();
    }

    public CompletableFuture<ResourceClient> connect(Address ... cluster) {
        return this.connect(Arrays.asList(cluster));
    }

    public CompletableFuture<ResourceClient> connect(Collection<Address> cluster) {
        return this.client.connect(cluster).thenApply(v -> this);
    }

    public synchronized CompletableFuture<Void> close() {
        CompletableFuture[] futures = new CompletableFuture[this.instances.size()];
        int i = 0;
        for (Resource<?> instance : this.instances.values()) {
            futures[i++] = instance.close();
        }
        return CompletableFuture.allOf(futures).thenCompose(v -> this.client.close());
    }

    public String toString() {
        return String.format("%s[session=%s]", this.getClass().getSimpleName(), this.client.session());
    }

    public static class Builder
    implements io.atomix.catalyst.util.Builder<ResourceClient> {
        private final ResourceRegistry registry = new ResourceRegistry();
        private CopycatClient.Builder clientBuilder = CopycatClient.builder().withServerSelectionStrategy(ServerSelectionStrategies.ANY).withConnectionStrategy(ConnectionStrategies.FIBONACCI_BACKOFF).withRecoveryStrategy(RecoveryStrategies.RECOVER);
        private Transport transport;

        protected Builder() {
        }

        public Builder withTransport(Transport transport) {
            this.clientBuilder.withTransport(transport);
            this.transport = transport;
            return this;
        }

        public Builder withConnectionStrategy(ConnectionStrategy connectionStrategy) {
            this.clientBuilder.withConnectionStrategy(connectionStrategy);
            return this;
        }

        public Builder withSerializer(Serializer serializer) {
            this.clientBuilder.withSerializer(serializer);
            return this;
        }

        public Builder withSessionTimeout(Duration sessionTimeout) {
            this.clientBuilder.withSessionTimeout(sessionTimeout);
            return this;
        }

        public Builder withResourceTypes(Class<? extends Resource<?>> ... types) {
            return this.withResourceTypes(Arrays.asList(types).stream().map(ResourceType::new).collect(Collectors.toList()));
        }

        public Builder withResourceTypes(ResourceType ... types) {
            return this.withResourceTypes(Arrays.asList(types));
        }

        public Builder withResourceTypes(Collection<ResourceType> types) {
            types.forEach(this.registry::register);
            return this;
        }

        public Builder addResourceType(Class<? extends Resource<?>> type) {
            return this.addResourceType(new ResourceType(type));
        }

        public Builder addResourceType(ResourceType type) {
            this.registry.register(type);
            return this;
        }

        @Override
        public ResourceClient build() {
            if (this.transport == null) {
                try {
                    this.transport = (Transport)Class.forName("io.atomix.catalyst.transport.netty.NettyTransport").newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new ConfigurationException("transport not configured", new Object[0]);
                }
            }
            CopycatClient client = this.clientBuilder.build();
            client.serializer().resolve(new ResourceManagerTypeResolver());
            for (ResourceType type : this.registry.types()) {
                try {
                    type.factory().newInstance().createSerializableTypeResolver().resolve(client.serializer().registry());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new ResourceManagerException(e);
                }
            }
            return new ResourceClient(client);
        }
    }
}

