/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.storage.system;

import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.server.cluster.Member;
import java.util.Collection;

public class Configuration {
    private final long index;
    private final long term;
    private final long time;
    private final Collection<Member> members;

    public Configuration(long index, long term, long time, Collection<Member> members) {
        this.index = index;
        this.term = term;
        this.time = Assert.argNot(time, time <= 0L, "time must be positive", new Object[0]);
        this.members = Assert.notNull(members, "members");
    }

    public long index() {
        return this.index;
    }

    public long term() {
        return this.term;
    }

    public long time() {
        return this.time;
    }

    public Collection<Member> members() {
        return this.members;
    }

    public String toString() {
        return String.format("%s[index=%d, time=%d, members=%s]", this.getClass().getSimpleName(), this.index, this.time, this.members);
    }
}

