/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.storage.entry;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.catalyst.util.reference.ReferenceManager;
import io.atomix.copycat.server.storage.entry.Entry;
import io.atomix.copycat.server.storage.entry.TimestampedEntry;

public class RegisterEntry
extends TimestampedEntry<RegisterEntry> {
    private String client;
    private long timeout;

    public RegisterEntry() {
    }

    public RegisterEntry(ReferenceManager<Entry<?>> referenceManager) {
        super(referenceManager);
    }

    public String getClient() {
        return this.client;
    }

    public RegisterEntry setClient(String client) {
        this.client = Assert.notNull(client, "client");
        return this;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public RegisterEntry setTimeout(long timeout) {
        this.timeout = Assert.argNot(timeout, timeout <= 0L, "timeout must be positive", new Object[0]);
        return this;
    }

    @Override
    public void writeObject(BufferOutput buffer, Serializer serializer) {
        super.writeObject(buffer, serializer);
        buffer.writeString(this.client);
        buffer.writeLong(this.timeout);
    }

    @Override
    public void readObject(BufferInput buffer, Serializer serializer) {
        super.readObject(buffer, serializer);
        this.client = buffer.readString();
        this.timeout = buffer.readLong();
    }

    @Override
    public String toString() {
        return String.format("%s[index=%d, term=%d, client=%s, timeout=%d]", this.getClass().getSimpleName(), this.getIndex(), this.getTerm(), this.getClient(), this.getTimestamp());
    }
}

