/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.storage.compaction;

import io.atomix.catalyst.concurrent.ThreadContext;
import io.atomix.catalyst.concurrent.ThreadPoolContext;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.server.storage.Segment;
import io.atomix.copycat.server.storage.SegmentManager;
import io.atomix.copycat.server.storage.Storage;
import io.atomix.copycat.server.storage.compaction.Compaction;
import io.atomix.copycat.server.storage.compaction.CompactionManager;
import io.atomix.copycat.server.storage.compaction.CompactionTask;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Compactor
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Compactor.class);
    private final Storage storage;
    private final SegmentManager segments;
    private final ScheduledExecutorService executor;
    private long minorIndex;
    private long majorIndex;
    private long snapshotIndex;
    private long compactIndex;
    private Compaction.Mode defaultCompactionMode = Compaction.Mode.SEQUENTIAL;
    private ScheduledFuture<?> minor;
    private ScheduledFuture<?> major;
    private CompletableFuture<Void> future = CompletableFuture.completedFuture(null);

    public Compactor(Storage storage, SegmentManager segments, ScheduledExecutorService executor) {
        this.storage = Assert.notNull(storage, "storage");
        this.segments = Assert.notNull(segments, "segments");
        this.executor = Assert.notNull(executor, "executor");
        this.minor = executor.scheduleAtFixedRate(() -> this.compact(Compaction.MINOR), storage.minorCompactionInterval().toMillis(), storage.minorCompactionInterval().toMillis(), TimeUnit.MILLISECONDS);
        this.major = executor.scheduleAtFixedRate(() -> this.compact(Compaction.MAJOR), storage.majorCompactionInterval().toMillis(), storage.majorCompactionInterval().toMillis(), TimeUnit.MILLISECONDS);
    }

    public Compactor withDefaultCompactionMode(Compaction.Mode mode) {
        Assert.notNull(mode, "mode");
        Assert.argNot(mode, mode == Compaction.Mode.DEFAULT, "DEFAULT cannot be the default compaction mode", new Object[0]);
        this.defaultCompactionMode = mode;
        return this;
    }

    public Compaction.Mode getDefaultCompactionMode() {
        return this.defaultCompactionMode;
    }

    public Compactor minorIndex(long index) {
        this.minorIndex = Math.max(this.minorIndex, index);
        Segment segment = this.segments.segment(this.minorIndex);
        if (segment != null) {
            this.compactIndex = segment.firstIndex();
        }
        return this;
    }

    public long minorIndex() {
        return this.minorIndex;
    }

    public Compactor majorIndex(long index) {
        this.majorIndex = Math.max(this.majorIndex, index);
        return this;
    }

    public long majorIndex() {
        return this.majorIndex;
    }

    public Compactor snapshotIndex(long index) {
        this.snapshotIndex = Math.max(this.snapshotIndex, index);
        return this;
    }

    public long snapshotIndex() {
        return this.snapshotIndex;
    }

    public long compactIndex() {
        return this.compactIndex;
    }

    public CompletableFuture<Void> compact() {
        return this.compact(Compaction.MINOR);
    }

    public synchronized CompletableFuture<Void> compact(Compaction compaction) {
        CompletableFuture future = new CompletableFuture();
        ThreadContext context = ThreadContext.currentContext();
        this.future.whenComplete((result, error) -> this.compact(compaction, future, context));
        this.future = future;
        return this.future;
    }

    private synchronized CompletableFuture<Void> compact(Compaction compaction, CompletableFuture<Void> future, ThreadContext context) {
        CompactionManager manager = compaction.manager(this);
        AtomicInteger counter = new AtomicInteger();
        Collection<CompactionTask> tasks = manager.buildTasks(this.storage, this.segments);
        if (!tasks.isEmpty()) {
            LOGGER.info("Compacting log with compaction: {}", (Object)compaction);
            LOGGER.debug("Executing {} compaction task(s)", (Object)tasks.size());
            for (CompactionTask task : tasks) {
                LOGGER.debug("Executing {}", (Object)task);
                ThreadPoolContext taskThread = new ThreadPoolContext(this.executor, this.segments.serializer());
                taskThread.execute(task).whenComplete((result, error) -> {
                    LOGGER.debug("{} complete", (Object)task);
                    if (counter.incrementAndGet() == tasks.size()) {
                        if (context != null) {
                            context.executor().execute(() -> future.complete(null));
                        } else {
                            future.complete(null);
                        }
                    }
                });
            }
        } else {
            future.complete(null);
        }
        return future;
    }

    @Override
    public void close() {
        if (this.minor != null) {
            this.minor.cancel(true);
        }
        if (this.major != null) {
            this.major.cancel(true);
        }
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

