/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.state;

import io.atomix.copycat.protocol.Request;
import io.atomix.copycat.protocol.Response;
import io.atomix.copycat.server.CopycatServer;
import io.atomix.copycat.server.state.ServerContext;
import io.atomix.copycat.server.state.ServerState;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractState
implements ServerState {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    protected final ServerContext context;
    private boolean open = true;

    protected AbstractState(ServerContext context) {
        this.context = context;
    }

    @Override
    public abstract CopycatServer.State type();

    protected final <R extends Request> R logRequest(R request) {
        this.LOGGER.trace("{} - Received {}", (Object)this.context.getCluster().member().address(), (Object)request);
        return request;
    }

    protected final <R extends Response> R logResponse(R response) {
        this.LOGGER.trace("{} - Sending {}", (Object)this.context.getCluster().member().address(), (Object)response);
        return response;
    }

    @Override
    public CompletableFuture<ServerState> open() {
        this.context.checkThread();
        this.open = true;
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    protected <T extends Request, U extends Response> CompletableFuture<U> forward(T request) {
        CompletableFuture future = new CompletableFuture();
        this.context.getConnections().getConnection(this.context.getLeader().serverAddress()).whenComplete((connection, connectError) -> {
            if (connectError == null) {
                connection.sendAndReceive(request).whenComplete((response, responseError) -> {
                    if (responseError == null) {
                        future.complete(response);
                    } else {
                        future.completeExceptionally((Throwable)responseError);
                    }
                });
            } else {
                future.completeExceptionally((Throwable)connectError);
            }
        });
        return future;
    }

    protected boolean updateTermAndLeader(long term, int leader) {
        if (term > this.context.getTerm() || term == this.context.getTerm() && this.context.getLeader() == null && leader != 0) {
            this.context.setTerm(term);
            this.context.setLeader(leader);
            this.context.getClusterState().reset();
            return true;
        }
        return false;
    }

    @Override
    public CompletableFuture<Void> close() {
        this.context.checkThread();
        this.open = false;
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public boolean isClosed() {
        return !this.open;
    }

    public String toString() {
        return String.format("%s[context=%s]", this.getClass().getSimpleName(), this.context);
    }
}

