/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.buffer;

import io.atomix.catalyst.buffer.Buffer;
import io.atomix.catalyst.buffer.BufferPool;
import io.atomix.catalyst.buffer.UnsafeHeapBuffer;
import io.atomix.catalyst.buffer.UnsafeHeapBytes;
import io.atomix.catalyst.util.reference.ReferenceFactory;
import io.atomix.catalyst.util.reference.ReferenceManager;

public class UnsafeHeapBufferPool
extends BufferPool {
    public UnsafeHeapBufferPool() {
        super(new HeapBufferFactory());
    }

    @Override
    public void release(Buffer reference) {
        reference.rewind();
        super.release(reference);
    }

    private static class HeapBufferFactory
    implements ReferenceFactory<Buffer> {
        private HeapBufferFactory() {
        }

        @Override
        public Buffer createReference(ReferenceManager<Buffer> manager) {
            UnsafeHeapBuffer buffer = new UnsafeHeapBuffer(UnsafeHeapBytes.allocate(1024L), manager);
            buffer.reset(0L, 1024L, Long.MAX_VALUE);
            return buffer;
        }
    }
}

