/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.backup;

import com.google.common.base.Preconditions;
import io.atomix.cluster.ClusterMembershipService;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.Recovery;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.partition.PrimaryElection;
import io.atomix.primitive.service.ServiceConfig;
import io.atomix.primitive.session.SessionClient;
import io.atomix.primitive.session.SessionId;
import io.atomix.primitive.session.SessionIdService;
import io.atomix.primitive.session.impl.BlockingAwareSessionClient;
import io.atomix.primitive.session.impl.RecoveringSessionClient;
import io.atomix.primitive.session.impl.RetryingSessionClient;
import io.atomix.protocols.backup.protocol.PrimaryBackupClientProtocol;
import io.atomix.protocols.backup.protocol.PrimitiveDescriptor;
import io.atomix.protocols.backup.session.PrimaryBackupSessionClient;
import io.atomix.utils.concurrent.Scheduler;
import io.atomix.utils.concurrent.ThreadContext;
import io.atomix.utils.concurrent.ThreadContextFactory;
import io.atomix.utils.concurrent.ThreadModel;
import io.atomix.utils.logging.ContextualLogger;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Serializer;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.slf4j.Logger;

public class PrimaryBackupClient {
    private final String clientName;
    private final PartitionId partitionId;
    private final ClusterMembershipService clusterMembershipService;
    private final PrimaryBackupClientProtocol protocol;
    private final PrimaryElection primaryElection;
    private final SessionIdService sessionIdService;
    private final ThreadContextFactory threadContextFactory;
    private final ThreadContext threadContext;
    private final boolean closeOnStop;

    public static Builder builder() {
        return new Builder();
    }

    public PrimaryBackupClient(String clientName, PartitionId partitionId, ClusterMembershipService clusterMembershipService, PrimaryBackupClientProtocol protocol, PrimaryElection primaryElection, SessionIdService sessionIdService, ThreadContextFactory threadContextFactory, boolean closeOnStop) {
        this.clientName = clientName;
        this.partitionId = partitionId;
        this.clusterMembershipService = clusterMembershipService;
        this.protocol = protocol;
        this.primaryElection = primaryElection;
        this.sessionIdService = sessionIdService;
        this.threadContextFactory = threadContextFactory;
        this.threadContext = threadContextFactory.createContext();
        this.closeOnStop = closeOnStop;
    }

    public PrimaryBackupSessionClient.Builder sessionBuilder(final String primitiveName, final PrimitiveType primitiveType, ServiceConfig serviceConfig) {
        final byte[] configBytes = Serializer.using((Namespace)primitiveType.namespace()).encode((Object)serviceConfig);
        return new PrimaryBackupSessionClient.Builder(){

            public SessionClient build() {
                Supplier<SessionClient> proxyBuilder = () -> new PrimaryBackupSessionClient(PrimaryBackupClient.this.clientName, PrimaryBackupClient.this.partitionId, (SessionId)PrimaryBackupClient.this.sessionIdService.nextSessionId().join(), primitiveType, new PrimitiveDescriptor(primitiveName, primitiveType.name(), configBytes, this.numBackups, this.replication), PrimaryBackupClient.this.clusterMembershipService, PrimaryBackupClient.this.protocol, PrimaryBackupClient.this.primaryElection, PrimaryBackupClient.this.threadContextFactory.createContext());
                ThreadContext context = PrimaryBackupClient.this.threadContextFactory.createContext();
                Object proxy = this.recovery == Recovery.RECOVER ? new RecoveringSessionClient(PrimaryBackupClient.this.clientName, PrimaryBackupClient.this.partitionId, primitiveName, primitiveType, proxyBuilder, context) : proxyBuilder.get();
                if (this.maxRetries > 0) {
                    proxy = new RetryingSessionClient(proxy, (Scheduler)context, this.maxRetries, this.retryDelay);
                }
                return new BlockingAwareSessionClient(proxy, context);
            }
        };
    }

    public CompletableFuture<Void> close() {
        this.threadContext.close();
        if (this.closeOnStop) {
            this.threadContextFactory.close();
        }
        return CompletableFuture.completedFuture(null);
    }

    public static class Builder
    implements io.atomix.utils.Builder<PrimaryBackupClient> {
        protected String clientName = "atomix";
        protected PartitionId partitionId;
        protected ClusterMembershipService clusterMembershipService;
        protected PrimaryBackupClientProtocol protocol;
        protected PrimaryElection primaryElection;
        protected SessionIdService sessionIdService;
        protected ThreadModel threadModel = ThreadModel.SHARED_THREAD_POOL;
        protected int threadPoolSize = Runtime.getRuntime().availableProcessors();
        protected ThreadContextFactory threadContextFactory;

        public Builder withClientName(String clientName) {
            this.clientName = (String)Preconditions.checkNotNull((Object)clientName, (Object)"clientName cannot be null");
            return this;
        }

        public Builder withPartitionId(PartitionId partitionId) {
            this.partitionId = (PartitionId)Preconditions.checkNotNull((Object)partitionId, (Object)"partitionId cannot be null");
            return this;
        }

        public Builder withMembershipService(ClusterMembershipService membershipService) {
            this.clusterMembershipService = (ClusterMembershipService)Preconditions.checkNotNull((Object)membershipService, (Object)"membershipService cannot be null");
            return this;
        }

        public Builder withProtocol(PrimaryBackupClientProtocol protocol) {
            this.protocol = (PrimaryBackupClientProtocol)Preconditions.checkNotNull((Object)protocol, (Object)"protocol cannot be null");
            return this;
        }

        public Builder withPrimaryElection(PrimaryElection primaryElection) {
            this.primaryElection = (PrimaryElection)Preconditions.checkNotNull((Object)primaryElection, (Object)"primaryElection cannot be null");
            return this;
        }

        public Builder withSessionIdProvider(SessionIdService sessionIdService) {
            this.sessionIdService = (SessionIdService)Preconditions.checkNotNull((Object)sessionIdService, (Object)"sessionIdProvider cannot be null");
            return this;
        }

        public Builder withThreadModel(ThreadModel threadModel) {
            this.threadModel = (ThreadModel)Preconditions.checkNotNull((Object)threadModel, (Object)"threadModel cannot be null");
            return this;
        }

        public Builder withThreadPoolSize(int threadPoolSize) {
            Preconditions.checkArgument((threadPoolSize > 0 ? 1 : 0) != 0, (Object)"threadPoolSize must be positive");
            this.threadPoolSize = threadPoolSize;
            return this;
        }

        public Builder withThreadContextFactory(ThreadContextFactory threadContextFactory) {
            this.threadContextFactory = (ThreadContextFactory)Preconditions.checkNotNull((Object)threadContextFactory, (Object)"threadContextFactory cannot be null");
            return this;
        }

        public PrimaryBackupClient build() {
            boolean closeOnStop;
            ThreadContextFactory threadContextFactory;
            ContextualLogger log = ContextualLoggerFactory.getLogger(PrimaryBackupClient.class, (LoggerContext)LoggerContext.builder(PrimaryBackupClient.class).addValue((Object)this.clientName).build());
            if (this.threadContextFactory == null) {
                threadContextFactory = this.threadModel.factory("backup-client-" + this.clientName + "-%d", this.threadPoolSize, (Logger)log);
                closeOnStop = true;
            } else {
                threadContextFactory = this.threadContextFactory;
                closeOnStop = false;
            }
            return new PrimaryBackupClient(this.clientName, this.partitionId, this.clusterMembershipService, this.protocol, this.primaryElection, this.sessionIdService, threadContextFactory, closeOnStop);
        }
    }
}

