/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.backup;

import io.atomix.primitive.Consistency;
import io.atomix.primitive.Recovery;
import io.atomix.primitive.Replication;
import io.atomix.primitive.partition.Partitioner;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.primitive.protocol.PrimitiveProtocolConfig;
import io.atomix.protocols.backup.MultiPrimaryProtocol;
import java.time.Duration;

public class MultiPrimaryProtocolConfig
extends PrimitiveProtocolConfig<MultiPrimaryProtocolConfig> {
    private Partitioner<String> partitioner = Partitioner.MURMUR3;
    private Consistency consistency = Consistency.SEQUENTIAL;
    private Replication replication = Replication.ASYNCHRONOUS;
    private Recovery recovery = Recovery.RECOVER;
    private int backups = 1;
    private int maxRetries = 0;
    private Duration retryDelay = Duration.ofMillis(100L);

    public PrimitiveProtocol.Type getType() {
        return MultiPrimaryProtocol.TYPE;
    }

    public Partitioner<String> getPartitioner() {
        return this.partitioner;
    }

    public MultiPrimaryProtocolConfig setPartitioner(Partitioner<String> partitioner) {
        this.partitioner = partitioner;
        return this;
    }

    public Consistency getConsistency() {
        return this.consistency;
    }

    public MultiPrimaryProtocolConfig setConsistency(Consistency consistency) {
        this.consistency = consistency;
        return this;
    }

    public Replication getReplication() {
        return this.replication;
    }

    public MultiPrimaryProtocolConfig setReplication(Replication replication) {
        this.replication = replication;
        return this;
    }

    public Recovery getRecovery() {
        return this.recovery;
    }

    public MultiPrimaryProtocolConfig setRecovery(Recovery recovery) {
        this.recovery = recovery;
        return this;
    }

    public int getBackups() {
        return this.backups;
    }

    public MultiPrimaryProtocolConfig setBackups(int numBackups) {
        this.backups = numBackups;
        return this;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public MultiPrimaryProtocolConfig setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }

    public Duration getRetryDelay() {
        return this.retryDelay;
    }

    public MultiPrimaryProtocolConfig setRetryDelayMillis(long retryDelayMillis) {
        return this.setRetryDelay(Duration.ofMillis(retryDelayMillis));
    }

    public MultiPrimaryProtocolConfig setRetryDelay(Duration retryDelay) {
        this.retryDelay = retryDelay;
        return this;
    }
}

