/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.coordination.state;

import io.atomix.coordination.DistributedGroup;
import io.atomix.coordination.state.GroupCommands;
import io.atomix.copycat.server.Commit;
import io.atomix.copycat.server.session.ServerSession;
import io.atomix.copycat.server.session.SessionListener;
import io.atomix.copycat.session.Session;
import io.atomix.resource.ResourceStateMachine;
import io.atomix.resource.ResourceType;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public class GroupState
extends ResourceStateMachine
implements SessionListener {
    private final Set<ServerSession> sessions = new HashSet<ServerSession>();
    private final Map<String, Commit<GroupCommands.Join>> members = new HashMap<String, Commit<GroupCommands.Join>>();
    private final Map<String, Map<String, Commit<GroupCommands.SetProperty>>> properties = new HashMap<String, Map<String, Commit<GroupCommands.SetProperty>>>();
    private final Queue<Commit<GroupCommands.Join>> candidates = new ArrayDeque<Commit<GroupCommands.Join>>();
    private Commit<GroupCommands.Join> leader;
    private long term;

    public GroupState() {
        super(new ResourceType(DistributedGroup.class));
    }

    public void close(ServerSession session) {
        HashMap<Long, Commit<GroupCommands.Join>> left = new HashMap<Long, Commit<GroupCommands.Join>>();
        this.sessions.remove(session);
        Iterator<Map.Entry<String, Commit<GroupCommands.Join>>> iterator = this.members.entrySet().iterator();
        while (iterator.hasNext()) {
            Map<String, Commit<GroupCommands.SetProperty>> properties;
            Commit<GroupCommands.Join> commit = iterator.next().getValue();
            if (!commit.session().equals(session)) continue;
            iterator.remove();
            if (!((GroupCommands.Join)commit.operation()).persist() && (properties = this.properties.remove(((GroupCommands.Join)commit.operation()).member())) != null) {
                properties.values().forEach(Commit::close);
            }
            this.candidates.remove(commit);
            left.put(commit.index(), commit);
        }
        if (this.leader != null && left.containsKey(this.leader.index())) {
            this.resignLeader(false);
            this.incrementTerm();
            this.electLeader();
        }
        this.sessions.forEach(s -> {
            if (s.state() == Session.State.OPEN) {
                for (Map.Entry entry : left.entrySet()) {
                    s.publish("leave", (Object)((Commit)entry.getValue()).index());
                }
            }
        });
        for (Map.Entry entry : left.entrySet()) {
            Commit commit = (Commit)entry.getValue();
            commit.close();
        }
    }

    private void incrementTerm() {
        this.term = this.context.index();
        for (ServerSession session : this.sessions) {
            if (session.state() != Session.State.OPEN) continue;
            session.publish("term", (Object)this.term);
        }
    }

    private void resignLeader(boolean toCandidate) {
        if (this.leader != null) {
            for (ServerSession session : this.sessions) {
                if (session.state() != Session.State.OPEN) continue;
                session.publish("resign", (Object)((GroupCommands.Join)this.leader.operation()).member());
            }
            if (toCandidate) {
                this.candidates.add(this.leader);
            }
            this.leader = null;
        }
    }

    private void electLeader() {
        Commit<GroupCommands.Join> commit = this.candidates.poll();
        while (commit != null) {
            if (commit.session().state() == Session.State.EXPIRED || commit.session().state() == Session.State.CLOSED) {
                commit = this.candidates.poll();
                continue;
            }
            this.leader = commit;
            for (ServerSession session : this.sessions) {
                if (session.state() != Session.State.OPEN) continue;
                session.publish("elect", (Object)((GroupCommands.Join)this.leader.operation()).member());
            }
        }
    }

    public String join(Commit<GroupCommands.Join> commit) {
        try {
            String memberId = ((GroupCommands.Join)commit.operation()).member();
            this.members.put(memberId, commit);
            this.candidates.add(commit);
            for (ServerSession session : this.sessions) {
                if (session.state() != Session.State.OPEN) continue;
                session.publish("join", (Object)memberId);
            }
            if (this.term == 0L) {
                this.incrementTerm();
            }
            if (this.leader == null) {
                this.electLeader();
            }
            return memberId;
        }
        catch (Exception e) {
            commit.close();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void leave(Commit<GroupCommands.Leave> commit) {
        try {
            String memberId = ((GroupCommands.Leave)commit.operation()).member();
            Commit<GroupCommands.Join> join = this.members.remove(memberId);
            if (join != null) {
                Map<String, Commit<GroupCommands.SetProperty>> properties = this.properties.remove(memberId);
                if (properties != null) {
                    properties.values().forEach(Commit::close);
                }
                this.candidates.remove(join);
                if (((GroupCommands.Join)this.leader.operation()).member().equals(memberId)) {
                    this.resignLeader(false);
                    this.incrementTerm();
                    this.electLeader();
                }
                for (ServerSession session : this.sessions) {
                    if (session.state() != Session.State.OPEN) continue;
                    session.publish("leave", (Object)memberId);
                }
                join.close();
            }
        }
        finally {
            commit.close();
        }
    }

    public Set<String> listen(Commit<GroupCommands.Listen> commit) {
        try {
            this.sessions.add(commit.session());
            HashSet<String> hashSet = new HashSet<String>(this.members.keySet());
            return hashSet;
        }
        finally {
            commit.close();
        }
    }

    public void resign(Commit<GroupCommands.Resign> commit) {
        try {
            if (((GroupCommands.Join)this.leader.operation()).member().equals(((GroupCommands.Resign)commit.operation()).member())) {
                this.resignLeader(true);
                this.incrementTerm();
                this.electLeader();
            }
        }
        finally {
            commit.close();
        }
    }

    public void setProperty(Commit<GroupCommands.SetProperty> commit) {
        Map<String, Commit<GroupCommands.SetProperty>> properties = this.properties.get(((GroupCommands.SetProperty)commit.operation()).member());
        if (properties == null) {
            properties = new HashMap<String, Commit<GroupCommands.SetProperty>>();
            this.properties.put(((GroupCommands.SetProperty)commit.operation()).member(), properties);
        }
        properties.put(((GroupCommands.SetProperty)commit.operation()).property(), commit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getProperty(Commit<GroupCommands.GetProperty> commit) {
        try {
            Map<String, Commit<GroupCommands.SetProperty>> properties = this.properties.get(((GroupCommands.GetProperty)commit.operation()).member());
            if (properties != null) {
                Commit<GroupCommands.SetProperty> value = properties.get(((GroupCommands.GetProperty)commit.operation()).property());
                Object object = value != null ? ((GroupCommands.SetProperty)value.operation()).value() : null;
                return object;
            }
            Object var3_4 = null;
            return var3_4;
        }
        finally {
            commit.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProperty(Commit<GroupCommands.RemoveProperty> commit) {
        try {
            Map<String, Commit<GroupCommands.SetProperty>> properties = this.properties.get(((GroupCommands.RemoveProperty)commit.operation()).member());
            if (properties != null) {
                Commit<GroupCommands.SetProperty> previous = properties.remove(((GroupCommands.RemoveProperty)commit.operation()).property());
                if (previous != null) {
                    previous.close();
                }
                if (properties.isEmpty()) {
                    this.properties.remove(((GroupCommands.RemoveProperty)commit.operation()).member());
                }
            }
        }
        finally {
            commit.close();
        }
    }

    public void send(Commit<GroupCommands.Send> commit) {
        try {
            Commit<GroupCommands.Join> join = this.members.get(((GroupCommands.Send)commit.operation()).member());
            if (join == null) {
                throw new IllegalArgumentException("unknown member: " + ((GroupCommands.Send)commit.operation()).member());
            }
            join.session().publish("message", (Object)new GroupCommands.Message(((GroupCommands.Send)commit.operation()).member(), ((GroupCommands.Send)commit.operation()).topic(), ((GroupCommands.Send)commit.operation()).message()));
        }
        finally {
            commit.close();
        }
    }

    public void schedule(Commit<GroupCommands.Schedule> commit) {
        try {
            if (!this.members.containsKey(((GroupCommands.Schedule)commit.operation()).member())) {
                throw new IllegalArgumentException("unknown member: " + ((GroupCommands.Schedule)commit.operation()).member());
            }
            this.executor.schedule(Duration.ofMillis(((GroupCommands.Schedule)commit.operation()).delay()), () -> {
                Commit<GroupCommands.Join> member = this.members.get(((GroupCommands.Schedule)commit.operation()).member());
                if (member != null) {
                    member.session().publish("execute", (Object)((GroupCommands.Schedule)commit.operation()).callback());
                }
                commit.close();
            });
        }
        catch (Exception e) {
            commit.close();
            throw e;
        }
    }

    public void execute(Commit<GroupCommands.Execute> commit) {
        try {
            Commit<GroupCommands.Join> member = this.members.get(((GroupCommands.Execute)commit.operation()).member());
            if (member == null) {
                throw new IllegalArgumentException("unknown member: " + ((GroupCommands.Execute)commit.operation()).member());
            }
            member.session().publish("execute", (Object)((GroupCommands.Execute)commit.operation()).callback());
        }
        finally {
            commit.close();
        }
    }

    public void delete() {
        this.members.values().forEach(Commit::close);
        this.members.clear();
    }
}

