/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.coordination;

import io.atomix.catalyst.util.Listener;
import io.atomix.catalyst.util.Listeners;
import io.atomix.coordination.GroupMember;
import io.atomix.coordination.LocalGroupMember;
import io.atomix.coordination.state.GroupCommands;
import io.atomix.coordination.state.GroupState;
import io.atomix.copycat.Command;
import io.atomix.copycat.client.CopycatClient;
import io.atomix.resource.Resource;
import io.atomix.resource.ResourceTypeInfo;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

@ResourceTypeInfo(id=-20, stateMachine=GroupState.class, typeResolver=GroupCommands.TypeResolver.class)
public class DistributedGroup
extends Resource<DistributedGroup> {
    private final Listeners<GroupMember> joinListeners = new Listeners();
    private final Listeners<GroupMember> leaveListeners = new Listeners();
    private final Listeners<Long> termListeners = new Listeners();
    private final Listeners<GroupMember> electionListeners = new Listeners();
    private final Map<String, InternalLocalGroupMember> localMembers = new ConcurrentHashMap<String, InternalLocalGroupMember>();
    private final Map<String, GroupMember> members = new ConcurrentHashMap<String, GroupMember>();
    private volatile String leader;
    private volatile long term;

    public static Resource.Options options() {
        return new Resource.Options();
    }

    public static Resource.Config config() {
        return new Resource.Config();
    }

    public DistributedGroup(CopycatClient client, Resource.Options options) {
        super(client, options);
    }

    public CompletableFuture<DistributedGroup> open() {
        return ((CompletableFuture)((CompletableFuture)super.open().thenApply(result -> {
            this.client.onEvent("join", memberId -> {
                GroupMember member = this.members.computeIfAbsent((String)memberId, arg_0 -> InternalGroupMember.new(this, arg_0));
                for (Listener listener : this.joinListeners) {
                    listener.accept((Object)member);
                }
            });
            this.client.onEvent("leave", memberId -> {
                GroupMember member = this.members.remove(memberId);
                if (member != null) {
                    for (Listener listener : this.leaveListeners) {
                        listener.accept((Object)member);
                    }
                }
            });
            this.client.onEvent("term", term -> {
                this.term = term;
                this.termListeners.accept(term);
            });
            this.client.onEvent("elect", leader -> {
                this.leader = leader;
                this.electionListeners.accept((Object)this.member((String)leader));
                InternalLocalGroupMember member = this.localMembers.get(leader);
                if (member != null) {
                    member.electionListeners.accept((Object)this.term);
                }
            });
            this.client.onEvent("resign", leader -> {
                if (this.leader != null && this.leader.equals(leader)) {
                    this.leader = null;
                }
            });
            this.client.onEvent("message", message -> {
                InternalLocalGroupMember localMember = this.localMembers.get(message.member());
                if (localMember != null) {
                    localMember.handle(message);
                }
            });
            this.client.onEvent("execute", Runnable::run);
            return result;
        })).thenCompose(v -> this.sync())).thenApply(v -> this);
    }

    private CompletableFuture<Void> sync() {
        return this.submit(new GroupCommands.Listen()).thenAccept(members -> {
            for (String memberId : members) {
                this.members.computeIfAbsent(memberId, arg_0 -> InternalGroupMember.new(this, arg_0));
            }
        });
    }

    public GroupMember leader() {
        return this.leader != null ? this.members.get(this.leader) : null;
    }

    public long term() {
        return this.term;
    }

    public Listener<Long> onTerm(Consumer<Long> callback) {
        return this.termListeners.add(callback);
    }

    public Listener<GroupMember> onElection(Consumer<GroupMember> callback) {
        return this.electionListeners.add(callback);
    }

    public GroupMember member(String memberId) {
        return this.members.get(memberId);
    }

    public Collection<GroupMember> members() {
        return this.members.values();
    }

    public CompletableFuture<LocalGroupMember> join() {
        return this.submit(new GroupCommands.Join(UUID.randomUUID().toString(), false)).thenApply(memberId -> {
            InternalLocalGroupMember member = new InternalLocalGroupMember((String)memberId);
            this.localMembers.put(member.id(), member);
            return member;
        });
    }

    public CompletableFuture<LocalGroupMember> join(String memberId) {
        return this.submit(new GroupCommands.Join(memberId, true)).thenApply(id -> {
            InternalLocalGroupMember member = new InternalLocalGroupMember((String)id);
            this.localMembers.put(member.id(), member);
            return member;
        });
    }

    public Listener<GroupMember> onJoin(Consumer<GroupMember> listener) {
        return this.joinListeners.add(listener);
    }

    public Listener<GroupMember> onLeave(Consumer<GroupMember> listener) {
        return this.leaveListeners.add(listener);
    }

    protected <T> CompletableFuture<T> submit(Command<T> command) {
        return super.submit(command);
    }

    private class InternalGroupMember
    implements GroupMember {
        protected final String memberId;

        InternalGroupMember(String memberId) {
            this.memberId = memberId;
        }

        @Override
        public String id() {
            return this.memberId;
        }

        @Override
        public boolean isLeader() {
            return DistributedGroup.this.leader != null && DistributedGroup.this.leader.equals(this.memberId);
        }

        @Override
        public <T> CompletableFuture<T> get(String property) {
            return DistributedGroup.this.submit(new GroupCommands.GetProperty(this.memberId, property)).thenApply(result -> result);
        }

        @Override
        public CompletableFuture<Void> send(String topic, Object message) {
            return DistributedGroup.this.submit(new GroupCommands.Send(this.memberId, topic, message));
        }

        @Override
        public CompletableFuture<Void> schedule(Instant instant, Runnable callback) {
            return this.schedule(Duration.ofMillis(instant.toEpochMilli() - System.currentTimeMillis()), callback);
        }

        @Override
        public CompletableFuture<Void> schedule(Duration delay, Runnable callback) {
            return DistributedGroup.this.submit(new GroupCommands.Schedule(this.memberId, delay.toMillis(), callback));
        }

        @Override
        public CompletableFuture<Void> execute(Runnable callback) {
            return DistributedGroup.this.submit(new GroupCommands.Execute(this.memberId, callback));
        }

        public String toString() {
            return this.memberId;
        }
    }

    private class InternalLocalGroupMember
    extends InternalGroupMember
    implements LocalGroupMember {
        private final Map<String, ListenerHolder> listeners;
        private final Listeners<Long> electionListeners;

        InternalLocalGroupMember(String memberId) {
            super(memberId);
            this.listeners = new ConcurrentHashMap<String, ListenerHolder>();
            this.electionListeners = new Listeners();
        }

        @Override
        public CompletableFuture<Void> set(String property, Object value) {
            return DistributedGroup.this.submit(new GroupCommands.SetProperty(this.memberId, property, value));
        }

        @Override
        public CompletableFuture<Void> remove(String property) {
            return DistributedGroup.this.submit(new GroupCommands.RemoveProperty(this.memberId, property));
        }

        @Override
        public <T> Listener<T> onMessage(String topic, Consumer<T> consumer) {
            ListenerHolder listener = new ListenerHolder(consumer);
            this.listeners.put(topic, listener);
            return listener;
        }

        private void handle(GroupCommands.Message message) {
            ListenerHolder listener = this.listeners.get(message.topic());
            if (listener != null) {
                listener.accept(message.body());
            }
        }

        @Override
        public Listener<Long> onElection(Consumer<Long> callback) {
            Listener listener = this.electionListeners.add(callback);
            if (this.isLeader()) {
                listener.accept((Object)DistributedGroup.this.term);
            }
            return listener;
        }

        @Override
        public CompletableFuture<Void> resign() {
            return DistributedGroup.this.submit(new GroupCommands.Resign(this.memberId));
        }

        @Override
        public CompletableFuture<Void> leave() {
            return DistributedGroup.this.submit(new GroupCommands.Leave(this.memberId)).whenComplete((result, error) -> DistributedGroup.this.localMembers.remove(this.memberId));
        }

        private class ListenerHolder
        implements Listener {
            private final Consumer consumer;

            private ListenerHolder(Consumer consumer) {
                this.consumer = consumer;
            }

            public void accept(Object message) {
                this.consumer.accept(message);
            }

            public void close() {
                InternalLocalGroupMember.this.listeners.remove(this);
            }
        }
    }
}

