/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.coordination.state;

import io.atomix.coordination.state.TopicCommands;
import io.atomix.copycat.client.session.Session;
import io.atomix.copycat.server.Commit;
import io.atomix.copycat.server.StateMachineExecutor;
import io.atomix.resource.ResourceStateMachine;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TopicState
extends ResourceStateMachine {
    private final Map<Long, Commit<TopicCommands.Listen>> listeners = new HashMap<Long, Commit<TopicCommands.Listen>>();

    public void configure(StateMachineExecutor executor) {
        executor.register(TopicCommands.Listen.class, this::listen);
        executor.register(TopicCommands.Unlisten.class, this::unlisten);
        executor.register(TopicCommands.Publish.class, this::publish);
    }

    public void close(Session session) {
        this.listeners.remove(session.id());
    }

    protected void listen(Commit<TopicCommands.Listen> commit) {
        if (!this.listeners.containsKey(commit.session().id())) {
            this.listeners.put(commit.session().id(), commit);
        } else {
            commit.clean();
        }
    }

    protected void unlisten(Commit<TopicCommands.Unlisten> commit) {
        try {
            Commit<TopicCommands.Listen> listener = this.listeners.remove(commit.session().id());
            if (listener != null) {
                listener.clean();
            }
        }
        finally {
            commit.clean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publish(Commit<TopicCommands.Publish> commit) {
        try {
            Iterator<Map.Entry<Long, Commit<TopicCommands.Listen>>> iterator = this.listeners.entrySet().iterator();
            while (iterator.hasNext()) {
                Commit<TopicCommands.Listen> listener = iterator.next().getValue();
                if (listener.session().isOpen()) {
                    listener.session().publish("message", ((TopicCommands.Publish)commit.operation()).message());
                    continue;
                }
                iterator.remove();
                listener.clean();
            }
        }
        finally {
            commit.clean();
        }
    }

    public void delete() {
        this.listeners.values().forEach(Commit::clean);
        this.listeners.clear();
    }
}

