/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.coordination.state;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.CatalystSerializable;
import io.atomix.catalyst.serializer.SerializeWith;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.copycat.client.Command;

public class TopicCommands {
    private TopicCommands() {
    }

    @SerializeWith(id=127)
    public static class Publish<T>
    extends TopicCommand<Void> {
        private T message;

        public Publish() {
        }

        public Publish(T message) {
            this.message = message;
        }

        public T message() {
            return this.message;
        }

        @Override
        public void writeObject(BufferOutput buffer, Serializer serializer) {
            serializer.writeObject(this.message, buffer);
        }

        @Override
        public void readObject(BufferInput buffer, Serializer serializer) {
            this.message = serializer.readObject(buffer);
        }
    }

    @SerializeWith(id=126)
    public static class Unlisten
    extends TopicCommand<Void> {
        public Command.ConsistencyLevel consistency() {
            return Command.ConsistencyLevel.LINEARIZABLE;
        }

        public Command.PersistenceLevel persistence() {
            return Command.PersistenceLevel.PERSISTENT;
        }
    }

    @SerializeWith(id=125)
    public static class Listen
    extends TopicCommand<Void> {
        public Command.ConsistencyLevel consistency() {
            return Command.ConsistencyLevel.LINEARIZABLE;
        }
    }

    public static abstract class TopicCommand<V>
    implements Command<V>,
    CatalystSerializable {
        public void writeObject(BufferOutput buffer, Serializer serializer) {
        }

        public void readObject(BufferInput buffer, Serializer serializer) {
        }
    }
}

