/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.coordination.state;

import io.atomix.catalyst.transport.Address;
import io.atomix.coordination.state.MessageBusCommands;
import io.atomix.copycat.client.session.Session;
import io.atomix.copycat.server.Commit;
import io.atomix.copycat.server.StateMachineExecutor;
import io.atomix.resource.ResourceStateMachine;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class MessageBusState
extends ResourceStateMachine {
    private final Map<Long, Commit<MessageBusCommands.Join>> members = new HashMap<Long, Commit<MessageBusCommands.Join>>();
    private final Map<String, Map<Long, Commit<MessageBusCommands.Register>>> topics = new HashMap<String, Map<Long, Commit<MessageBusCommands.Register>>>();

    public void configure(StateMachineExecutor executor) {
        executor.register(MessageBusCommands.Join.class, this::join);
        executor.register(MessageBusCommands.Leave.class, this::leave);
        executor.register(MessageBusCommands.Register.class, this::registerConsumer);
        executor.register(MessageBusCommands.Unregister.class, this::unregisterConsumer);
    }

    public void close(Session session) {
        this.members.remove(session.id());
        for (Commit<MessageBusCommands.Join> member : this.members.values()) {
            member.session().publish("leave", (Object)session.id());
        }
    }

    protected Map<String, Set<Address>> join(Commit<MessageBusCommands.Join> commit) {
        try {
            this.members.put(commit.session().id(), commit);
            HashMap<String, Set<Address>> topics = new HashMap<String, Set<Address>>();
            for (Map.Entry<String, Map<Long, Commit<MessageBusCommands.Register>>> entry : this.topics.entrySet()) {
                HashSet<Address> addresses = new HashSet<Address>();
                for (Map.Entry<Long, Commit<MessageBusCommands.Register>> subEntry : entry.getValue().entrySet()) {
                    Commit<MessageBusCommands.Join> member = this.members.get(subEntry.getKey());
                    if (member == null) continue;
                    addresses.add(((MessageBusCommands.Join)member.operation()).member());
                }
                topics.put(entry.getKey(), addresses);
            }
            return topics;
        }
        catch (Exception e) {
            commit.clean();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void leave(Commit<MessageBusCommands.Leave> commit) {
        try {
            Commit<MessageBusCommands.Join> previous = this.members.remove(commit.session().id());
            if (previous != null) {
                previous.clean();
                Iterator<Map.Entry<String, Map<Long, Commit<MessageBusCommands.Register>>>> iterator = this.topics.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, Map<Long, Commit<MessageBusCommands.Register>>> entry = iterator.next();
                    String topic = entry.getKey();
                    Map<Long, Commit<MessageBusCommands.Register>> registrations = entry.getValue();
                    Commit<MessageBusCommands.Register> registration = registrations.remove(commit.session().id());
                    if (registration == null) continue;
                    for (Commit<MessageBusCommands.Join> member : this.members.values()) {
                        member.session().publish("unregister", (Object)new MessageBusCommands.ConsumerInfo(topic, ((MessageBusCommands.Join)previous.operation()).member()));
                    }
                    if (!registrations.isEmpty()) continue;
                    iterator.remove();
                }
            }
        }
        finally {
            commit.clean();
        }
    }

    private void registerConsumer(Commit<MessageBusCommands.Register> commit) {
        try {
            Commit<MessageBusCommands.Join> parent = this.members.get(commit.session().id());
            if (parent == null) {
                throw new IllegalStateException("unknown session: " + commit.session().id());
            }
            Map registrations = this.topics.computeIfAbsent(((MessageBusCommands.Register)commit.operation()).topic(), t -> new HashMap());
            registrations.put(commit.session().id(), commit);
            for (Commit<MessageBusCommands.Join> member : this.members.values()) {
                member.session().publish("register", (Object)new MessageBusCommands.ConsumerInfo(((MessageBusCommands.Register)commit.operation()).topic(), ((MessageBusCommands.Join)parent.operation()).member()));
            }
        }
        catch (Exception e) {
            commit.clean();
            throw e;
        }
    }

    private void unregisterConsumer(Commit<MessageBusCommands.Unregister> commit) {
        try {
            Commit<MessageBusCommands.Register> registration;
            Map<Long, Commit<MessageBusCommands.Register>> registrations = this.topics.get(((MessageBusCommands.Unregister)commit.operation()).topic());
            if (registrations != null && (registration = registrations.remove(commit.session().id())) != null) {
                registration.clean();
                Commit<MessageBusCommands.Join> parent = this.members.get(registration.session().id());
                if (parent != null) {
                    for (Commit<MessageBusCommands.Join> member : this.members.values()) {
                        member.session().publish("unregister", (Object)new MessageBusCommands.ConsumerInfo(((MessageBusCommands.Unregister)commit.operation()).topic(), ((MessageBusCommands.Join)parent.operation()).member()));
                    }
                }
            }
        }
        catch (Exception e) {
            commit.clean();
            throw e;
        }
    }

    public void delete() {
        this.members.values().forEach(Commit::clean);
        this.topics.values().forEach(m -> m.values().forEach(Commit::clean));
        this.topics.clear();
    }
}

