/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.coordination.state;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.CatalystSerializable;
import io.atomix.catalyst.serializer.SerializeWith;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.client.Command;
import java.util.Map;
import java.util.Set;

public class MessageBusCommands {
    private MessageBusCommands() {
    }

    @SerializeWith(id=89)
    public static class ConsumerInfo
    implements CatalystSerializable {
        private String topic;
        private Address address;

        public ConsumerInfo() {
        }

        public ConsumerInfo(String topic, Address address) {
            this.topic = topic;
            this.address = address;
        }

        public String topic() {
            return this.topic;
        }

        public Address address() {
            return this.address;
        }

        public void writeObject(BufferOutput buffer, Serializer serializer) {
            buffer.writeString(this.topic);
            serializer.writeObject((Object)this.address, buffer);
        }

        public void readObject(BufferInput buffer, Serializer serializer) {
            this.topic = buffer.readString();
            this.address = (Address)serializer.readObject(buffer);
        }
    }

    @SerializeWith(id=88)
    public static class Unregister
    extends MessageBusCommand<Void> {
        private String topic;

        public Unregister() {
        }

        public Unregister(String topic) {
            this.topic = (String)Assert.notNull((Object)topic, (String)"topic");
        }

        public String topic() {
            return this.topic;
        }

        public Command.PersistenceLevel persistence() {
            return Command.PersistenceLevel.PERSISTENT;
        }

        @Override
        public void writeObject(BufferOutput buffer, Serializer serializer) {
            buffer.writeString(this.topic);
        }

        @Override
        public void readObject(BufferInput buffer, Serializer serializer) {
            this.topic = buffer.readString();
        }
    }

    @SerializeWith(id=87)
    public static class Register
    extends MessageBusCommand<Void> {
        private String topic;

        public Register() {
        }

        public Register(String topic) {
            this.topic = (String)Assert.notNull((Object)topic, (String)"topic");
        }

        public String topic() {
            return this.topic;
        }

        @Override
        public void writeObject(BufferOutput buffer, Serializer serializer) {
            buffer.writeString(this.topic);
        }

        @Override
        public void readObject(BufferInput buffer, Serializer serializer) {
            this.topic = buffer.readString();
        }
    }

    @SerializeWith(id=86)
    public static class Leave
    extends MessageBusCommand<Void> {
        public Command.PersistenceLevel persistence() {
            return Command.PersistenceLevel.PERSISTENT;
        }
    }

    @SerializeWith(id=85)
    public static class Join
    extends MessageBusCommand<Map<String, Set<Address>>> {
        protected Address address;

        public Join() {
        }

        public Join(Address address) {
            this.address = (Address)Assert.notNull((Object)address, (String)"address");
        }

        public Address member() {
            return this.address;
        }

        @Override
        public void readObject(BufferInput buffer, Serializer serializer) {
            this.address = (Address)serializer.readObject(buffer);
        }

        @Override
        public void writeObject(BufferOutput buffer, Serializer serializer) {
            serializer.writeObject((Object)this.address, buffer);
        }
    }

    public static abstract class MessageBusCommand<V>
    implements Command<V>,
    CatalystSerializable {
        public Command.ConsistencyLevel consistency() {
            return Command.ConsistencyLevel.LINEARIZABLE;
        }

        public void writeObject(BufferOutput buffer, Serializer serializer) {
        }

        public void readObject(BufferInput buffer, Serializer serializer) {
        }
    }
}

