/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.coordination.state;

import io.atomix.coordination.state.MembershipGroupCommands;
import io.atomix.copycat.client.session.Session;
import io.atomix.copycat.server.Commit;
import io.atomix.copycat.server.StateMachineExecutor;
import io.atomix.resource.ResourceStateMachine;
import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MembershipGroupState
extends ResourceStateMachine {
    private final Map<Long, Commit<MembershipGroupCommands.Join>> members = new HashMap<Long, Commit<MembershipGroupCommands.Join>>();

    public void configure(StateMachineExecutor executor) {
        executor.register(MembershipGroupCommands.Join.class, this::join);
        executor.register(MembershipGroupCommands.Leave.class, this::leave);
        executor.register(MembershipGroupCommands.Schedule.class, this::schedule);
        executor.register(MembershipGroupCommands.Execute.class, this::execute);
    }

    public void close(Session session) {
        this.members.remove(session.id());
        for (Commit<MembershipGroupCommands.Join> member : this.members.values()) {
            member.session().publish("leave", (Object)session.id());
        }
    }

    protected Set<Long> join(Commit<MembershipGroupCommands.Join> commit) {
        try {
            Commit<MembershipGroupCommands.Join> previous = this.members.put(commit.session().id(), commit);
            if (previous != null) {
                previous.clean();
            } else {
                for (Commit<MembershipGroupCommands.Join> member : this.members.values()) {
                    if (member.index() == commit.index()) continue;
                    member.session().publish("join", (Object)commit.session().id());
                }
            }
            return new HashSet<Long>(this.members.keySet());
        }
        catch (Exception e) {
            commit.clean();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void leave(Commit<MembershipGroupCommands.Leave> commit) {
        try {
            Commit<MembershipGroupCommands.Join> previous = this.members.remove(commit.session().id());
            if (previous != null) {
                previous.clean();
                for (Commit<MembershipGroupCommands.Join> member : this.members.values()) {
                    member.session().publish("leave", (Object)commit.session().id());
                }
            }
        }
        finally {
            commit.clean();
        }
    }

    protected void schedule(Commit<MembershipGroupCommands.Schedule> commit) {
        try {
            if (!this.members.containsKey(((MembershipGroupCommands.Schedule)commit.operation()).member())) {
                throw new IllegalArgumentException("unknown member: " + ((MembershipGroupCommands.Schedule)commit.operation()).member());
            }
            this.executor().schedule(Duration.ofMillis(((MembershipGroupCommands.Schedule)commit.operation()).delay()), () -> {
                Commit<MembershipGroupCommands.Join> member = this.members.get(((MembershipGroupCommands.Schedule)commit.operation()).member());
                if (member != null) {
                    member.session().publish("execute", (Object)((MembershipGroupCommands.Schedule)commit.operation()).callback());
                }
                commit.clean();
            });
        }
        catch (Exception e) {
            commit.clean();
            throw e;
        }
    }

    protected void execute(Commit<MembershipGroupCommands.Execute> commit) {
        try {
            Commit<MembershipGroupCommands.Join> member = this.members.get(((MembershipGroupCommands.Execute)commit.operation()).member());
            if (member == null) {
                throw new IllegalArgumentException("unknown member: " + ((MembershipGroupCommands.Execute)commit.operation()).member());
            }
            member.session().publish("execute", (Object)((MembershipGroupCommands.Execute)commit.operation()).callback());
        }
        finally {
            commit.clean();
        }
    }

    public void delete() {
        this.members.values().forEach(Commit::clean);
        this.members.clear();
    }
}

