/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.coordination.state;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.CatalystSerializable;
import io.atomix.catalyst.serializer.SerializeWith;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.client.Command;
import java.util.Set;

public class MembershipGroupCommands {
    private MembershipGroupCommands() {
    }

    @SerializeWith(id=123)
    public static class Execute
    extends GroupCommand<Void> {
        private long member;
        private Runnable callback;

        public Execute() {
        }

        public Execute(long member, Runnable callback) {
            this.member = (Long)Assert.argNot((Object)member, (member <= 0L ? 1 : 0) != 0, (String)"member must be positive", (Object[])new Object[0]);
            this.callback = (Runnable)Assert.notNull((Object)callback, (String)"callback");
        }

        public long member() {
            return this.member;
        }

        public Runnable callback() {
            return this.callback;
        }

        @Override
        public void writeObject(BufferOutput buffer, Serializer serializer) {
            buffer.writeLong(this.member);
            serializer.writeObject((Object)this.callback, buffer);
        }

        @Override
        public void readObject(BufferInput buffer, Serializer serializer) {
            this.member = buffer.readLong();
            this.callback = (Runnable)serializer.readObject(buffer);
        }
    }

    @SerializeWith(id=122)
    public static class Schedule
    extends GroupCommand<Void> {
        private long member;
        private long delay;
        private Runnable callback;

        public Schedule() {
        }

        public Schedule(long member, long delay, Runnable callback) {
            this.member = (Long)Assert.argNot((Object)member, (member <= 0L ? 1 : 0) != 0, (String)"member must be positive", (Object[])new Object[0]);
            this.delay = (Long)Assert.argNot((Object)delay, (delay <= 0L ? 1 : 0) != 0, (String)"delay must be positive", (Object[])new Object[0]);
            this.callback = (Runnable)Assert.notNull((Object)callback, (String)"callback");
        }

        public long member() {
            return this.member;
        }

        public long delay() {
            return this.delay;
        }

        public Runnable callback() {
            return this.callback;
        }

        @Override
        public void writeObject(BufferOutput buffer, Serializer serializer) {
            buffer.writeLong(this.member).writeLong(this.delay);
            serializer.writeObject((Object)this.callback, buffer);
        }

        @Override
        public void readObject(BufferInput buffer, Serializer serializer) {
            this.member = buffer.readLong();
            this.delay = buffer.readLong();
            this.callback = (Runnable)serializer.readObject(buffer);
        }
    }

    @SerializeWith(id=121)
    public static class Leave
    extends GroupCommand<Void> {
        public Command.PersistenceLevel persistence() {
            return Command.PersistenceLevel.PERSISTENT;
        }
    }

    @SerializeWith(id=120)
    public static class Join
    extends GroupCommand<Set<Long>> {
    }

    public static abstract class GroupCommand<V>
    implements Command<V>,
    CatalystSerializable {
        public Command.ConsistencyLevel consistency() {
            return Command.ConsistencyLevel.LINEARIZABLE;
        }

        public void writeObject(BufferOutput buffer, Serializer serializer) {
        }

        public void readObject(BufferInput buffer, Serializer serializer) {
        }
    }
}

