/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.coordination.state;

import io.atomix.catalyst.util.concurrent.Scheduled;
import io.atomix.coordination.state.LockCommands;
import io.atomix.copycat.server.Commit;
import io.atomix.copycat.server.StateMachineExecutor;
import io.atomix.resource.ResourceStateMachine;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;

public class LockState
extends ResourceStateMachine {
    private Commit<LockCommands.Lock> lock;
    private final Queue<Commit<LockCommands.Lock>> queue = new ArrayDeque<Commit<LockCommands.Lock>>();
    private final Map<Long, Scheduled> timers = new HashMap<Long, Scheduled>();

    public void configure(StateMachineExecutor executor) {
        executor.register(LockCommands.Lock.class, this::lock);
        executor.register(LockCommands.Unlock.class, this::unlock);
    }

    protected void lock(Commit<LockCommands.Lock> commit) {
        if (this.lock == null) {
            this.lock = commit;
            commit.session().publish("lock", (Object)true);
        } else if (((LockCommands.Lock)commit.operation()).timeout() == 0L) {
            try {
                commit.session().publish("lock", (Object)false);
            }
            finally {
                commit.clean();
            }
        } else {
            this.queue.add(commit);
            if (((LockCommands.Lock)commit.operation()).timeout() > 0L) {
                this.timers.put(commit.index(), this.executor().schedule(Duration.ofMillis(((LockCommands.Lock)commit.operation()).timeout()), () -> {
                    this.timers.remove(commit.index());
                    this.queue.remove(commit);
                    commit.clean();
                }));
            }
        }
    }

    protected void unlock(Commit<LockCommands.Unlock> commit) {
        try {
            if (this.lock != null) {
                if (!this.lock.session().equals(commit.session())) {
                    throw new IllegalStateException("not the lock holder");
                }
                this.lock.clean();
                this.lock = this.queue.poll();
                if (this.lock != null) {
                    Scheduled timer = this.timers.remove(this.lock.index());
                    if (timer != null) {
                        timer.cancel();
                    }
                    this.lock.session().publish("lock", (Object)true);
                }
            }
        }
        finally {
            commit.clean();
        }
    }

    public void delete() {
        if (this.lock != null) {
            this.lock.clean();
        }
        this.queue.forEach(Commit::clean);
        this.queue.clear();
        this.timers.values().forEach(Scheduled::cancel);
        this.timers.clear();
    }
}

