/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.coordination.state;

import io.atomix.coordination.state.LeaderElectionCommands;
import io.atomix.copycat.client.session.Session;
import io.atomix.copycat.server.Commit;
import io.atomix.copycat.server.StateMachineExecutor;
import io.atomix.resource.ResourceStateMachine;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class LeaderElectionState
extends ResourceStateMachine {
    private Commit<LeaderElectionCommands.Listen> leader;
    private final Map<Long, Commit<LeaderElectionCommands.Listen>> listeners = new LinkedHashMap<Long, Commit<LeaderElectionCommands.Listen>>();

    public void configure(StateMachineExecutor executor) {
        executor.register(LeaderElectionCommands.Listen.class, this::listen);
        executor.register(LeaderElectionCommands.Unlisten.class, this::unlisten);
        executor.register(LeaderElectionCommands.IsLeader.class, this::isLeader);
    }

    public void close(Session session) {
        if (this.leader != null && this.leader.session().equals(session)) {
            this.leader.clean();
            this.leader = null;
            if (!this.listeners.isEmpty()) {
                Iterator<Map.Entry<Long, Commit<LeaderElectionCommands.Listen>>> iterator = this.listeners.entrySet().iterator();
                this.leader = iterator.next().getValue();
                iterator.remove();
                this.leader.session().publish("elect", (Object)this.leader.index());
            }
        } else {
            Commit<LeaderElectionCommands.Listen> listener = this.listeners.remove(session.id());
            if (listener != null) {
                listener.clean();
            }
        }
    }

    protected void listen(Commit<LeaderElectionCommands.Listen> commit) {
        if (this.leader == null) {
            this.leader = commit;
            this.leader.session().publish("elect", (Object)this.leader.index());
        } else if (!this.listeners.containsKey(commit.session().id())) {
            this.listeners.put(commit.session().id(), commit);
        } else {
            commit.clean();
        }
    }

    protected void unlisten(Commit<LeaderElectionCommands.Unlisten> commit) {
        try {
            if (this.leader != null && this.leader.session().equals(commit.session())) {
                this.leader.clean();
                this.leader = null;
                if (!this.listeners.isEmpty()) {
                    Iterator<Map.Entry<Long, Commit<LeaderElectionCommands.Listen>>> iterator = this.listeners.entrySet().iterator();
                    this.leader = iterator.next().getValue();
                    iterator.remove();
                    this.leader.session().publish("elect", (Object)this.leader.index());
                }
            } else {
                Commit<LeaderElectionCommands.Listen> listener = this.listeners.remove(commit.session().id());
                if (listener != null) {
                    listener.clean();
                }
            }
        }
        finally {
            commit.clean();
        }
    }

    protected boolean isLeader(Commit<LeaderElectionCommands.IsLeader> commit) {
        return this.leader != null && this.leader.session().equals(commit.session()) && this.leader.index() == ((LeaderElectionCommands.IsLeader)commit.operation()).epoch();
    }

    public void delete() {
        if (this.leader != null) {
            this.leader.clean();
        }
        this.listeners.values().forEach(Commit::clean);
        this.listeners.clear();
    }
}

