/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.coordination.state;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.CatalystSerializable;
import io.atomix.catalyst.serializer.SerializeWith;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.client.Command;
import io.atomix.copycat.client.Query;

public class LeaderElectionCommands {
    private LeaderElectionCommands() {
    }

    @SerializeWith(id=112)
    public static class IsLeader
    extends ElectionQuery<Boolean> {
        private long epoch;

        public IsLeader() {
        }

        public IsLeader(long epoch) {
            this.epoch = (Long)Assert.argNot((Object)epoch, (epoch < 0L ? 1 : 0) != 0, (String)"epoch cannot be negative", (Object[])new Object[0]);
        }

        public long epoch() {
            return this.epoch;
        }

        @Override
        public Query.ConsistencyLevel consistency() {
            return Query.ConsistencyLevel.LINEARIZABLE;
        }
    }

    @SerializeWith(id=111)
    public static class Unlisten
    extends ElectionCommand<Void> {
        public Command.PersistenceLevel persistence() {
            return Command.PersistenceLevel.PERSISTENT;
        }
    }

    @SerializeWith(id=110)
    public static class Listen
    extends ElectionCommand<Void> {
    }

    public static abstract class ElectionCommand<V>
    implements Command<V>,
    CatalystSerializable {
        public Command.ConsistencyLevel consistency() {
            return Command.ConsistencyLevel.LINEARIZABLE;
        }

        public void writeObject(BufferOutput buffer, Serializer serializer) {
        }

        public void readObject(BufferInput buffer, Serializer serializer) {
        }
    }

    public static abstract class ElectionQuery<V>
    implements Query<V>,
    CatalystSerializable {
        public Query.ConsistencyLevel consistency() {
            return Query.ConsistencyLevel.LINEARIZABLE;
        }

        public void writeObject(BufferOutput buffer, Serializer serializer) {
        }

        public void readObject(BufferInput buffer, Serializer serializer) {
        }
    }
}

