/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.coordination;

import io.atomix.catalyst.util.Listener;
import io.atomix.catalyst.util.Listeners;
import io.atomix.coordination.GroupMember;
import io.atomix.coordination.state.MembershipGroupCommands;
import io.atomix.coordination.state.MembershipGroupState;
import io.atomix.copycat.client.Command;
import io.atomix.copycat.client.RaftClient;
import io.atomix.resource.AbstractResource;
import io.atomix.resource.Consistency;
import io.atomix.resource.ResourceInfo;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

@ResourceInfo(stateMachine=MembershipGroupState.class)
public class DistributedMembershipGroup
extends AbstractResource {
    private final Listeners<GroupMember> joinListeners = new Listeners();
    private final Listeners<GroupMember> leaveListeners = new Listeners();
    private GroupMember member;
    private final Map<Long, GroupMember> members = new ConcurrentHashMap<Long, GroupMember>();

    public DistributedMembershipGroup(RaftClient client) {
        super(client);
        client.session().onEvent("join", memberId -> {
            GroupMember member = this.members.computeIfAbsent((Long)memberId, arg_0 -> InternalGroupMember.new(this, arg_0));
            for (Listener listener : this.joinListeners) {
                listener.accept((Object)member);
            }
        });
        client.session().onEvent("leave", memberId -> {
            GroupMember member = this.members.remove(memberId);
            if (member != null) {
                for (Listener listener : this.leaveListeners) {
                    listener.accept((Object)member);
                }
            }
        });
        client.session().onEvent("execute", Runnable::run);
    }

    public DistributedMembershipGroup with(Consistency consistency) {
        super.with(consistency);
        return this;
    }

    public GroupMember member() {
        return this.member;
    }

    public GroupMember member(long memberId) {
        return this.members.get(memberId);
    }

    public Collection<GroupMember> members() {
        return this.members.values();
    }

    public CompletableFuture<GroupMember> join() {
        return this.submit(new MembershipGroupCommands.Join()).thenApply(members -> {
            this.member = new InternalGroupMember(this.client.session().id());
            Iterator iterator = members.iterator();
            while (iterator.hasNext()) {
                long memberId = (Long)iterator.next();
                this.members.computeIfAbsent(memberId, arg_0 -> InternalGroupMember.new(this, arg_0));
            }
            return this.member;
        });
    }

    public Listener<GroupMember> onJoin(Consumer<GroupMember> listener) {
        return this.joinListeners.add(listener);
    }

    public CompletableFuture<Void> leave() {
        return this.submit(new MembershipGroupCommands.Leave()).whenComplete((result, error) -> {
            this.member = null;
            this.members.clear();
        });
    }

    public Listener<GroupMember> onLeave(Consumer<GroupMember> listener) {
        return this.leaveListeners.add(listener);
    }

    protected <T> CompletableFuture<T> submit(Command<T> command) {
        return super.submit(command);
    }

    private class InternalGroupMember
    implements GroupMember {
        private final long memberId;

        InternalGroupMember(long memberId) {
            this.memberId = memberId;
        }

        @Override
        public long id() {
            return this.memberId;
        }

        @Override
        public CompletableFuture<Void> schedule(Instant instant, Runnable callback) {
            return this.schedule(Duration.ofMillis(instant.toEpochMilli() - System.currentTimeMillis()), callback);
        }

        @Override
        public CompletableFuture<Void> schedule(Duration delay, Runnable callback) {
            return DistributedMembershipGroup.this.submit(new MembershipGroupCommands.Schedule(this.memberId, delay.toMillis(), callback));
        }

        @Override
        public CompletableFuture<Void> execute(Runnable callback) {
            return DistributedMembershipGroup.this.submit(new MembershipGroupCommands.Execute(this.memberId, callback));
        }
    }
}

