/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.coordination;

import io.atomix.coordination.state.LockCommands;
import io.atomix.coordination.state.LockState;
import io.atomix.copycat.client.RaftClient;
import io.atomix.resource.AbstractResource;
import io.atomix.resource.Consistency;
import io.atomix.resource.ResourceInfo;
import java.time.Duration;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;

@ResourceInfo(stateMachine=LockState.class)
public class DistributedLock
extends AbstractResource {
    private final Queue<Consumer<Boolean>> queue = new ConcurrentLinkedQueue<Consumer<Boolean>>();

    public DistributedLock(RaftClient client) {
        super(client);
        client.session().onEvent("lock", this::handleEvent);
    }

    public DistributedLock with(Consistency consistency) {
        super.with(consistency);
        return this;
    }

    private void handleEvent(boolean locked) {
        Consumer<Boolean> consumer = this.queue.poll();
        if (consumer != null) {
            consumer.accept(locked);
        }
    }

    public CompletableFuture<Void> lock() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        Consumer<Boolean> consumer = locked -> future.complete(null);
        this.queue.add(consumer);
        this.submit(new LockCommands.Lock(-1L)).whenComplete((result, error) -> {
            if (error != null) {
                this.queue.remove(consumer);
            }
        });
        return future;
    }

    public CompletableFuture<Boolean> tryLock() {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        Consumer<Boolean> consumer = future::complete;
        this.queue.add(consumer);
        this.submit(new LockCommands.Lock()).whenComplete((result, error) -> {
            if (error != null) {
                this.queue.remove(consumer);
            }
        });
        return future;
    }

    public CompletableFuture<Boolean> tryLock(Duration timeout) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        Consumer<Boolean> consumer = future::complete;
        this.queue.add(consumer);
        this.submit(new LockCommands.Lock(timeout.toMillis())).whenComplete((result, error) -> {
            if (error != null) {
                this.queue.remove(consumer);
            }
        });
        return future;
    }

    public CompletableFuture<Void> unlock() {
        return this.submit(new LockCommands.Unlock());
    }
}

