/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.coordination;

import io.atomix.catalyst.util.Listener;
import io.atomix.coordination.state.LeaderElectionCommands;
import io.atomix.coordination.state.LeaderElectionState;
import io.atomix.copycat.client.RaftClient;
import io.atomix.resource.AbstractResource;
import io.atomix.resource.Consistency;
import io.atomix.resource.ResourceInfo;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

@ResourceInfo(stateMachine=LeaderElectionState.class)
public class DistributedLeaderElection
extends AbstractResource {
    private final Set<Consumer<Long>> listeners = Collections.newSetFromMap(new ConcurrentHashMap());

    public DistributedLeaderElection(RaftClient client) {
        super(client);
        client.session().onEvent("elect", epoch -> {
            for (Consumer<Long> listener : this.listeners) {
                listener.accept((Long)epoch);
            }
        });
    }

    public DistributedLeaderElection with(Consistency consistency) {
        super.with(consistency);
        return this;
    }

    public CompletableFuture<Listener<Long>> onElection(Consumer<Long> listener) {
        if (!this.listeners.isEmpty()) {
            this.listeners.add(listener);
            return CompletableFuture.completedFuture(new ElectionListener(listener));
        }
        this.listeners.add(listener);
        return this.submit(new LeaderElectionCommands.Listen()).thenApply(v -> new ElectionListener(listener));
    }

    public CompletableFuture<Boolean> isLeader(long epoch) {
        return this.submit(new LeaderElectionCommands.IsLeader(epoch));
    }

    private class ElectionListener
    implements Listener<Long> {
        private final Consumer<Long> listener;

        private ElectionListener(Consumer<Long> listener) {
            this.listener = listener;
        }

        public void accept(Long epoch) {
            this.listener.accept(epoch);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            DistributedLeaderElection distributedLeaderElection = DistributedLeaderElection.this;
            synchronized (distributedLeaderElection) {
                DistributedLeaderElection.this.listeners.remove(this.listener);
                if (DistributedLeaderElection.this.listeners.isEmpty()) {
                    DistributedLeaderElection.this.submit(new LeaderElectionCommands.Unlisten());
                }
            }
        }
    }
}

