/*
 * Decompiled with CFR 0.152.
 */
package io.atleon.kafka.embedded;

import java.util.Map;
import java.util.Objects;
import kafka.server.KafkaConfig;

public class EmbeddedKafkaConfig {
    private final Map<String, ?> kafkaConfigValues;

    private EmbeddedKafkaConfig(Map<String, ?> kafkaConfigValues) {
        this.kafkaConfigValues = kafkaConfigValues;
    }

    static EmbeddedKafkaConfig fromKafkaConfig(KafkaConfig kafkaConfig) {
        return new EmbeddedKafkaConfig(kafkaConfig.values());
    }

    public String getZooKeeperConnect() {
        return Objects.toString(this.kafkaConfigValues.get(KafkaConfig.ZkConnectProp()));
    }

    public String getSecureConnect() {
        return this.getSecurityProtocol() + "://" + this.getConnect();
    }

    public String getSecurityProtocol() {
        return Objects.toString(this.kafkaConfigValues.get(KafkaConfig.InterBrokerSecurityProtocolProp()));
    }

    public String getConnect() {
        return Objects.toString(this.kafkaConfigValues.get(KafkaConfig.ListenersProp()));
    }
}

