/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.xml.module;

import io.atlasmap.core.AtlasMappingUtil;
import io.atlasmap.core.DefaultAtlasConversionService;
import io.atlasmap.core.DefaultAtlasFieldActionService;
import io.atlasmap.spi.AtlasConversionService;
import io.atlasmap.spi.AtlasFieldActionService;
import io.atlasmap.spi.AtlasModuleDetail;
import io.atlasmap.spi.AtlasModuleMode;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.DataSource;
import io.atlasmap.v2.DataSourceType;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.Mapping;
import io.atlasmap.v2.MappingType;
import io.atlasmap.v2.MockField;
import io.atlasmap.v2.Validation;
import io.atlasmap.v2.ValidationScope;
import io.atlasmap.v2.ValidationStatus;
import io.atlasmap.validators.AtlasValidationTestHelper;
import io.atlasmap.xml.module.XmlModule;
import io.atlasmap.xml.module.XmlValidationService;
import io.atlasmap.xml.v2.AtlasXmlModelFactory;
import io.atlasmap.xml.v2.XmlField;
import java.util.List;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlValidationServiceTest {
    private static final Logger LOG = LoggerFactory.getLogger(XmlValidationServiceTest.class);
    protected AtlasMappingUtil mappingUtil = null;
    protected DefaultAtlasFieldActionService fieldActionService;
    protected XmlValidationService sourceValidationService = null;
    protected XmlValidationService targetValidationService = null;
    protected AtlasValidationTestHelper validationHelper = null;
    protected List<Validation> validations = null;
    protected AtlasModuleDetail moduleDetail = null;

    @BeforeEach
    public void setUp() {
        this.mappingUtil = new AtlasMappingUtil();
        this.moduleDetail = XmlModule.class.getAnnotation(AtlasModuleDetail.class);
        this.fieldActionService = DefaultAtlasFieldActionService.getInstance();
        this.fieldActionService.init();
        this.sourceValidationService = new XmlValidationService((AtlasConversionService)DefaultAtlasConversionService.getInstance(), (AtlasFieldActionService)this.fieldActionService);
        this.sourceValidationService.setMode(AtlasModuleMode.SOURCE);
        this.targetValidationService = new XmlValidationService((AtlasConversionService)DefaultAtlasConversionService.getInstance(), (AtlasFieldActionService)this.fieldActionService);
        this.targetValidationService.setMode(AtlasModuleMode.TARGET);
        this.validationHelper = new AtlasValidationTestHelper();
        this.validations = this.validationHelper.getValidation();
    }

    @AfterEach
    public void tearDown() {
        this.mappingUtil = null;
        this.sourceValidationService = null;
        this.targetValidationService = null;
        this.validationHelper = null;
        this.validations = null;
    }

    protected AtlasMapping getAtlasMappingFullValid() {
        AtlasMapping mapping = AtlasModelFactory.createAtlasMapping();
        mapping.setName("thisis_a_valid.name");
        mapping.getDataSource().add(this.generateDataSource("atlas:xml:MockXml", DataSourceType.SOURCE));
        mapping.getDataSource().add(this.generateDataSource("atlas:xml:MockXml", DataSourceType.TARGET));
        Mapping mapMapping = (Mapping)AtlasModelFactory.createMapping((MappingType)MappingType.MAP);
        Mapping sepMapping = (Mapping)AtlasModelFactory.createMapping((MappingType)MappingType.SEPARATE);
        Mapping combineMapping = (Mapping)AtlasModelFactory.createMapping((MappingType)MappingType.COMBINE);
        XmlField inputField = AtlasXmlModelFactory.createXmlField();
        inputField.setFieldType(FieldType.STRING);
        inputField.setPath("firstName");
        XmlField outputField = AtlasXmlModelFactory.createXmlField();
        outputField.setFieldType(FieldType.STRING);
        outputField.setPath("firstName");
        mapMapping.getInputField().add(inputField);
        mapMapping.getOutputField().add(outputField);
        XmlField sIJavaField = AtlasXmlModelFactory.createXmlField();
        sIJavaField.setFieldType(FieldType.STRING);
        sIJavaField.setPath("displayName");
        sepMapping.getInputField().add(sIJavaField);
        XmlField sOJavaField = AtlasXmlModelFactory.createXmlField();
        sOJavaField.setFieldType(FieldType.STRING);
        sOJavaField.setPath("lastName");
        sOJavaField.setIndex(Integer.valueOf(1));
        sepMapping.getOutputField().add(sOJavaField);
        XmlField cIJavaField = AtlasXmlModelFactory.createXmlField();
        cIJavaField.setFieldType(FieldType.STRING);
        cIJavaField.setPath("displayName");
        combineMapping.getInputField().add(cIJavaField);
        XmlField cOJavaField = AtlasXmlModelFactory.createXmlField();
        cOJavaField.setFieldType(FieldType.STRING);
        cOJavaField.setPath("lastName");
        cOJavaField.setIndex(Integer.valueOf(1));
        combineMapping.getOutputField().add(cOJavaField);
        mapping.getMappings().getMapping().add(mapMapping);
        mapping.getMappings().getMapping().add(sepMapping);
        mapping.getMappings().getMapping().add(combineMapping);
        return mapping;
    }

    protected DataSource generateDataSource(String uri, DataSourceType type) {
        DataSource ds = new DataSource();
        ds.setUri(uri);
        ds.setDataSourceType(type);
        return ds;
    }

    protected Mapping createMockMapping() {
        MockField inputField = new MockField();
        inputField.setName("input.name");
        MockField outputField = new MockField();
        outputField.setName("out.name");
        Mapping mapping = new Mapping();
        mapping.setMappingType(MappingType.MAP);
        mapping.getInputField().add(inputField);
        mapping.getOutputField().add(inputField);
        return mapping;
    }

    protected void debugErrors(List<Validation> validations) {
        for (Validation validation : validations) {
            LOG.debug(AtlasValidationTestHelper.validationToString((Validation)validation));
        }
    }

    @Test
    public void testValidateMappingHappyPath() {
        AtlasMapping mapping = this.getAtlasMappingFullValid();
        Assertions.assertNotNull((Object)mapping);
        this.validations.addAll(this.sourceValidationService.validateMapping(mapping));
        this.validations.addAll(this.targetValidationService.validateMapping(mapping));
        Assertions.assertFalse((boolean)this.validationHelper.hasErrors());
        Assertions.assertFalse((boolean)this.validationHelper.hasWarnings());
        Assertions.assertFalse((boolean)this.validationHelper.hasInfos());
    }

    @Test
    public void testValidateMappingHappyPathFromFile() throws Exception {
        AtlasMapping mapping = this.mappingUtil.loadMapping("src/test/resources/mappings/HappyPathMapping.json");
        Assertions.assertNotNull((Object)mapping);
        this.validations.addAll(this.sourceValidationService.validateMapping(mapping));
        this.validations.addAll(this.targetValidationService.validateMapping(mapping));
        Assertions.assertFalse((boolean)this.validationHelper.hasErrors());
        Assertions.assertFalse((boolean)this.validationHelper.hasWarnings());
        Assertions.assertFalse((boolean)this.validationHelper.hasInfos());
    }

    @Test
    public void testValidateMappingMismatchedFieldType() {
        AtlasMapping mapping = this.getAtlasMappingFullValid();
        Assertions.assertNotNull((Object)mapping);
        mapping.getMappings().getMapping().clear();
        mapping.getMappings().getMapping().add(this.createMockMapping());
        this.validations.addAll(this.sourceValidationService.validateMapping(mapping));
        this.validations.addAll(this.targetValidationService.validateMapping(mapping));
        Assertions.assertFalse((boolean)this.validationHelper.hasErrors());
        Assertions.assertFalse((boolean)this.validationHelper.hasWarnings());
        Assertions.assertFalse((boolean)this.validationHelper.hasInfos());
    }

    @Test
    public void testValidateMappingInvalidCombineInputFieldType() {
        AtlasMapping atlasMapping = this.getAtlasMappingFullValid();
        Mapping combineFieldMapping = (Mapping)AtlasModelFactory.createMapping((MappingType)MappingType.COMBINE);
        combineFieldMapping.setId("combine.firstName.lastName");
        XmlField bIJavaField = new XmlField();
        bIJavaField.setFieldType(FieldType.STRING);
        bIJavaField.setValue((Object)Boolean.TRUE);
        bIJavaField.setPath("firstName");
        combineFieldMapping.getInputField().add(bIJavaField);
        XmlField sOJavaField = new XmlField();
        sOJavaField.setFieldType(FieldType.BOOLEAN);
        sOJavaField.setPath("lastName");
        sOJavaField.setIndex(Integer.valueOf(0));
        combineFieldMapping.getOutputField().add(sOJavaField);
        atlasMapping.getMappings().getMapping().add(combineFieldMapping);
        this.validations.addAll(this.sourceValidationService.validateMapping(atlasMapping));
        this.validations.addAll(this.targetValidationService.validateMapping(atlasMapping));
        Assertions.assertTrue((boolean)this.validationHelper.hasErrors());
        Assertions.assertFalse((boolean)this.validationHelper.hasWarnings());
        Assertions.assertFalse((boolean)this.validationHelper.hasInfos());
        Assertions.assertEquals((Integer)1, (Integer)this.validationHelper.getCount());
        Validation validation = this.validations.get(0);
        Assertions.assertNotNull((Object)validation);
        Assertions.assertEquals((Object)ValidationScope.MAPPING, (Object)validation.getScope());
        Assertions.assertEquals((Object)"combine.firstName.lastName", (Object)validation.getId());
        Assertions.assertEquals((Object)"Target field 'lastName' must be of type 'STRING' for a Combine Mapping", (Object)validation.getMessage());
        Assertions.assertEquals((Object)ValidationStatus.ERROR, (Object)validation.getStatus());
    }

    @Test
    public void testValidateMappingInvalidModuleType() {
        AtlasMapping mapping = AtlasModelFactory.createAtlasMapping();
        mapping.setName("thisis_a_valid.name");
        mapping.getDataSource().add(this.generateDataSource("atlas:java", DataSourceType.SOURCE));
        mapping.getDataSource().add(this.generateDataSource("atlas:json", DataSourceType.TARGET));
        this.validations.addAll(this.sourceValidationService.validateMapping(mapping));
        this.validations.addAll(this.targetValidationService.validateMapping(mapping));
        Assertions.assertTrue((boolean)this.validationHelper.hasErrors());
        Assertions.assertFalse((boolean)this.validationHelper.hasWarnings());
        Assertions.assertFalse((boolean)this.validationHelper.hasInfos());
    }

    @Test
    public void testValidateMappingInvalidSeparateInputFieldType() {
        AtlasMapping atlasMapping = this.getAtlasMappingFullValid();
        Mapping separateFieldMapping = (Mapping)AtlasModelFactory.createMapping((MappingType)MappingType.SEPARATE);
        separateFieldMapping.setId("separate.firstName.lastName");
        XmlField bIJavaField = new XmlField();
        bIJavaField.setFieldType(FieldType.BOOLEAN);
        bIJavaField.setValue((Object)Boolean.TRUE);
        bIJavaField.setPath("firstName");
        separateFieldMapping.getInputField().add(bIJavaField);
        XmlField sOJavaField = new XmlField();
        sOJavaField.setFieldType(FieldType.STRING);
        sOJavaField.setPath("lastName");
        sOJavaField.setIndex(Integer.valueOf(0));
        separateFieldMapping.getOutputField().add(sOJavaField);
        atlasMapping.getMappings().getMapping().add(separateFieldMapping);
        this.validations.addAll(this.sourceValidationService.validateMapping(atlasMapping));
        this.validations.addAll(this.targetValidationService.validateMapping(atlasMapping));
        Assertions.assertTrue((boolean)this.validationHelper.hasErrors());
        Assertions.assertFalse((boolean)this.validationHelper.hasWarnings());
        Assertions.assertFalse((boolean)this.validationHelper.hasInfos());
        Assertions.assertEquals((Integer)1, (Integer)this.validationHelper.getCount());
        Validation validation = this.validations.get(0);
        Assertions.assertNotNull((Object)validation);
        Assertions.assertEquals((Object)ValidationScope.MAPPING, (Object)validation.getScope());
        Assertions.assertEquals((Object)"separate.firstName.lastName", (Object)validation.getId());
        Assertions.assertEquals((Object)"Source field 'firstName' must be of type 'STRING' for a Separate Mapping", (Object)validation.getMessage());
        Assertions.assertEquals((Object)ValidationStatus.ERROR, (Object)validation.getStatus());
    }

    @Test
    public void testValidateMappingSupportedSourceToTargetConversion() throws Exception {
        AtlasMapping mapping = this.mappingUtil.loadMapping("src/test/resources/mappings/HappyPathMapping.json");
        Assertions.assertNotNull((Object)mapping);
        Mapping fieldMapping = (Mapping)mapping.getMappings().getMapping().get(0);
        XmlField in = (XmlField)fieldMapping.getInputField().get(0);
        in.setFieldType(FieldType.CHAR);
        this.validations.addAll(this.sourceValidationService.validateMapping(mapping));
        this.validations.addAll(this.targetValidationService.validateMapping(mapping));
        if (LOG.isDebugEnabled()) {
            this.debugErrors(this.validations);
        }
        Assertions.assertFalse((boolean)this.validationHelper.hasErrors());
        Assertions.assertFalse((boolean)this.validationHelper.hasWarnings());
        Assertions.assertFalse((boolean)this.validationHelper.hasInfos());
    }

    @Test
    public void testValidateMappingSourceToTargetRangeConcerns() throws Exception {
        AtlasMapping mapping = this.mappingUtil.loadMapping("src/test/resources/mappings/HappyPathMapping.json");
        Assertions.assertNotNull((Object)mapping);
        Mapping fieldMapping = (Mapping)mapping.getMappings().getMapping().get(0);
        XmlField in = (XmlField)fieldMapping.getInputField().get(0);
        in.setFieldType(FieldType.DOUBLE);
        XmlField out = (XmlField)fieldMapping.getOutputField().get(0);
        out.setFieldType(FieldType.LONG);
        this.validations.addAll(this.sourceValidationService.validateMapping(mapping));
        this.validations.addAll(this.targetValidationService.validateMapping(mapping));
        if (LOG.isDebugEnabled()) {
            this.debugErrors(this.validations);
        }
        Assertions.assertFalse((boolean)this.validationHelper.hasErrors());
        Assertions.assertTrue((boolean)this.validationHelper.hasWarnings());
        Assertions.assertFalse((boolean)this.validationHelper.hasInfos());
        Assertions.assertEquals((int)1, (int)this.validationHelper.getCount());
        Assertions.assertTrue((boolean)this.validations.stream().anyMatch(atlasMappingError -> atlasMappingError.getMessage().contains("range")));
    }

    @Test
    public void testValidateMappingSourceToTargetFormatConcerns() throws Exception {
        AtlasMapping mapping = this.mappingUtil.loadMapping("src/test/resources/mappings/HappyPathMapping.json");
        Assertions.assertNotNull((Object)mapping);
        Mapping fieldMapping = (Mapping)mapping.getMappings().getMapping().get(0);
        XmlField in = (XmlField)fieldMapping.getInputField().get(0);
        in.setFieldType(FieldType.STRING);
        XmlField out = (XmlField)fieldMapping.getOutputField().get(0);
        out.setFieldType(FieldType.LONG);
        this.validations.addAll(this.sourceValidationService.validateMapping(mapping));
        this.validations.addAll(this.targetValidationService.validateMapping(mapping));
        if (LOG.isDebugEnabled()) {
            this.debugErrors(this.validations);
        }
        Assertions.assertFalse((boolean)this.validationHelper.hasErrors());
        Assertions.assertTrue((boolean)this.validationHelper.hasWarnings());
        Assertions.assertFalse((boolean)this.validationHelper.hasInfos());
        Assertions.assertEquals((int)3, (int)this.validationHelper.getCount());
        Assertions.assertTrue((boolean)this.validations.stream().anyMatch(atlasMappingError -> atlasMappingError.getMessage().contains("range")));
        Assertions.assertTrue((boolean)this.validations.stream().anyMatch(atlasMappingError -> atlasMappingError.getMessage().contains("format")));
        Assertions.assertTrue((boolean)this.validations.stream().anyMatch(atlasMappingError -> atlasMappingError.getMessage().contains("fractional part")));
    }

    @Test
    public void testValidateMappingPathNull() throws Exception {
        AtlasMapping mapping = this.mappingUtil.loadMapping("src/test/resources/mappings/HappyPathMapping.json");
        Assertions.assertNotNull((Object)mapping);
        Mapping fieldMapping = (Mapping)mapping.getMappings().getMapping().get(0);
        XmlField in = (XmlField)fieldMapping.getInputField().get(0);
        in.setPath(null);
        this.validations.addAll(this.sourceValidationService.validateMapping(mapping));
        this.validations.addAll(this.targetValidationService.validateMapping(mapping));
        Assertions.assertTrue((boolean)this.validationHelper.hasErrors());
        Assertions.assertFalse((boolean)this.validationHelper.hasWarnings());
        Assertions.assertFalse((boolean)this.validationHelper.hasInfos());
    }

    public static <T> Collector<T, ?, T> singletonCollector() {
        return Collectors.collectingAndThen(Collectors.toList(), list -> {
            if (list.size() != 1) {
                throw new IllegalStateException();
            }
            return list.get(0);
        });
    }
}

