/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.xml.module;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.api.AtlasValidationException;
import io.atlasmap.core.AtlasUtil;
import io.atlasmap.core.BaseAtlasModule;
import io.atlasmap.core.PathUtil;
import io.atlasmap.spi.AtlasModuleDetail;
import io.atlasmap.v2.Audit;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.BaseMapping;
import io.atlasmap.v2.ConstantField;
import io.atlasmap.v2.DataSource;
import io.atlasmap.v2.DataSourceType;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.Mapping;
import io.atlasmap.v2.PropertyField;
import io.atlasmap.v2.SimpleField;
import io.atlasmap.xml.core.XmlFieldReader;
import io.atlasmap.xml.core.XmlFieldWriter;
import io.atlasmap.xml.module.XmlValidationService;
import io.atlasmap.xml.v2.AtlasXmlModelFactory;
import io.atlasmap.xml.v2.XmlDataSource;
import io.atlasmap.xml.v2.XmlField;
import io.atlasmap.xml.v2.XmlNamespace;
import io.atlasmap.xml.v2.XmlNamespaces;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@AtlasModuleDetail(name="XmlModule", uri="atlas:xml", modes={"SOURCE", "TARGET"}, dataFormats={"xml"}, configPackages={"io.atlasmap.xml.v2"})
public class XmlModule
extends BaseAtlasModule {
    private static final Logger logger = LoggerFactory.getLogger(XmlModule.class);

    public void processPreOutputExecution(AtlasSession session) throws AtlasException {
        XmlNamespaces xmlNs = null;
        String template = null;
        for (Object ds : session.getMapping().getDataSource()) {
            if (!DataSourceType.TARGET.equals((Object)ds.getDataSourceType()) || !(ds instanceof XmlDataSource)) continue;
            xmlNs = ((XmlDataSource)ds).getXmlNamespaces();
            template = ((XmlDataSource)ds).getTemplate();
        }
        HashMap<String, String> nsMap = new HashMap<String, String>();
        if (xmlNs != null && xmlNs.getXmlNamespace() != null && !xmlNs.getXmlNamespace().isEmpty()) {
            for (XmlNamespace ns : xmlNs.getXmlNamespace()) {
                nsMap.put(ns.getAlias(), ns.getUri());
            }
        }
        XmlFieldWriter writer = new XmlFieldWriter(nsMap, template);
        session.setOutput((Object)writer);
        if (logger.isDebugEnabled()) {
            logger.debug("processPreOutputExcution completed");
        }
    }

    public void processPreValidation(AtlasSession atlasSession) throws AtlasException {
        if (atlasSession == null || atlasSession.getMapping() == null) {
            logger.error("Invalid session: Session and AtlasMapping must be specified");
            throw new AtlasValidationException("Invalid session");
        }
        XmlValidationService xmlValidationService = new XmlValidationService(this.getConversionService());
        List xmlValidations = xmlValidationService.validateMapping(atlasSession.getMapping());
        atlasSession.getValidations().getValidation().addAll(xmlValidations);
        if (logger.isDebugEnabled()) {
            logger.debug("Detected " + xmlValidations.size() + " xml validation notices");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("processPreValidation completed");
        }
    }

    public void processInputMapping(AtlasSession session, BaseMapping baseMapping) throws AtlasException {
        for (Mapping mapping : this.generateInputMappings(session, baseMapping)) {
            if (mapping.getInputField() == null || mapping.getInputField().isEmpty()) {
                this.addAudit(session, null, String.format("Mapping does not contain at least one input field alias=%s desc=%s", mapping.getAlias(), mapping.getDescription()), null, AuditStatus.WARN, null);
                return;
            }
            for (Field field : mapping.getInputField()) {
                if (!this.isSupportedField(field).booleanValue()) {
                    this.addAudit(session, field.getDocId(), String.format("Unsupported input field type=%s", field.getClass().getName()), field.getPath(), AuditStatus.ERROR, null);
                    return;
                }
                if (field instanceof ConstantField) {
                    this.processConstantField(session, mapping);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Processed input constantField sPath=" + field.getPath() + " sV=" + field.getValue() + " sT=" + field.getFieldType() + " docId: " + field.getDocId());
                    continue;
                }
                if (field instanceof PropertyField) {
                    this.processPropertyField(session, mapping, session.getAtlasContext().getContextFactory().getPropertyStrategy());
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Processed input propertyField sPath=" + field.getPath() + " sV=" + field.getValue() + " sT=" + field.getFieldType() + " docId: " + field.getDocId());
                    continue;
                }
                XmlField inputField = (XmlField)field;
                Object sourceObject = null;
                sourceObject = field.getDocId() != null && session.hasInput(field.getDocId()) ? session.getInput(field.getDocId()) : session.getInput();
                if (sourceObject == null || !(sourceObject instanceof String)) {
                    this.addAudit(session, field.getDocId(), String.format("Unsupported input object type=%s", field.getClass().getName()), field.getPath(), AuditStatus.ERROR, null);
                    return;
                }
                Document document = null;
                Map sourceUriParams = AtlasUtil.getUriParameters((String)((DataSource)session.getMapping().getDataSource().get(0)).getUri());
                boolean enableNamespaces = true;
                for (String key : sourceUriParams.keySet()) {
                    if (!"disableNamespaces".equals(key) || !"true".equals(sourceUriParams.get("disableNamespaces"))) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Disabling namespace support");
                    }
                    enableNamespaces = false;
                }
                try {
                    document = this.getDocument((String)sourceObject, enableNamespaces);
                }
                catch (IOException | ParserConfigurationException | SAXException e) {
                    logger.error(String.format("Error parsing xml input object msg=%s", e.getMessage()), (Throwable)e);
                    Audit audit = new Audit();
                    audit.setDocId(field.getDocId());
                    audit.setPath(field.getPath());
                    audit.setStatus(AuditStatus.ERROR);
                    audit.setMessage(String.format("Error parsing xml input object msg=%s", field.getClass().getName()));
                    session.getAudits().getAudit().add(audit);
                    return;
                }
                XmlFieldReader dxfr = new XmlFieldReader();
                dxfr.readNew(document, inputField);
                if (inputField.getFieldType() == null) {
                    inputField.setFieldType(FieldType.STRING);
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Processed input field sPath=" + field.getPath() + " sV=" + field.getValue() + " sT=" + field.getFieldType() + " docId: " + field.getDocId());
            }
        }
    }

    public void processOutputMapping(AtlasSession session, BaseMapping baseMapping) throws AtlasException {
        XmlFieldWriter writer = null;
        if (session.getOutput() == null) {
            writer = new XmlFieldWriter();
            session.setOutput((Object)writer);
        } else if (session.getOutput() != null && session.getOutput() instanceof XmlFieldWriter) {
            writer = (XmlFieldWriter)session.getOutput();
        } else {
            this.addAudit(session, null, String.format("Unsupported output object type=%s", session.getOutput().getClass().getName()), null, AuditStatus.ERROR, null);
            return;
        }
        block8: for (Mapping mapping : this.getOutputMappings(session, baseMapping)) {
            if (mapping.getOutputField() == null || mapping.getOutputField().isEmpty()) {
                this.addAudit(session, null, String.format("Mapping does not contain at least one output field alias=%s desc=%s", mapping.getAlias(), mapping.getDescription()), null, AuditStatus.ERROR, null);
                return;
            }
            Field outputField = (Field)mapping.getOutputField().get(0);
            if (!(outputField instanceof XmlField)) {
                this.addAudit(session, outputField.getDocId(), String.format("Unsupported output field type=%s", outputField.getClass().getName()), outputField.getPath(), AuditStatus.ERROR, null);
                return;
            }
            switch (mapping.getMappingType()) {
                case MAP: {
                    Field inField = (Field)mapping.getInputField().get(0);
                    if (inField.getValue() == null) continue block8;
                    if (outputField.getFieldType() == null && inField.getValue() != null) {
                        outputField.setFieldType(this.getConversionService().fieldTypeFromClass(inField.getValue().getClass()));
                    }
                    Object outputValue = null;
                    if (inField.getFieldType() != null && inField.getFieldType().equals((Object)outputField.getFieldType())) {
                        outputValue = inField.getValue();
                    } else {
                        try {
                            outputValue = this.getConversionService().convertType(inField.getValue(), inField.getFieldType(), outputField.getFieldType());
                        }
                        catch (AtlasConversionException e) {
                            logger.error(String.format("Unable to auto-convert for iT=%s oT=%s oF=%s msg=%s", inField.getFieldType(), outputField.getFieldType(), outputField.getPath(), e.getMessage()), (Throwable)e);
                            continue block8;
                        }
                    }
                    outputField.setValue(outputValue);
                    if (outputField.getActions() != null && outputField.getActions().getActions() != null && !outputField.getActions().getActions().isEmpty()) {
                        this.processFieldActions(session.getAtlasContext().getContextFactory().getFieldActionService(), outputField);
                    }
                    writer.write((Field)((XmlField)outputField));
                    break;
                }
                case COMBINE: {
                    this.processCombineField(session, mapping, mapping.getInputField(), outputField);
                    SimpleField combinedField = new SimpleField();
                    combinedField.setFieldType(FieldType.STRING);
                    combinedField.setPath(outputField.getPath());
                    combinedField.setValue(outputField.getValue());
                    if (combinedField.getActions() != null && combinedField.getActions().getActions() != null && !combinedField.getActions().getActions().isEmpty()) {
                        this.processFieldActions(session.getAtlasContext().getContextFactory().getFieldActionService(), (Field)combinedField);
                    }
                    writer.write((Field)combinedField);
                    break;
                }
                case LOOKUP: {
                    Field inputFieldlkp = (Field)mapping.getInputField().get(0);
                    if (inputFieldlkp.getValue() != null && inputFieldlkp.getValue().getClass().isAssignableFrom(String.class)) {
                        this.processLookupField(session, mapping.getLookupTableName(), (String)inputFieldlkp.getValue(), outputField);
                    } else {
                        this.processLookupField(session, mapping.getLookupTableName(), (String)this.getConversionService().convertType(inputFieldlkp.getValue(), inputFieldlkp.getFieldType(), FieldType.STRING), outputField);
                    }
                    if (outputField.getActions() != null && outputField.getActions().getActions() != null && !outputField.getActions().getActions().isEmpty()) {
                        this.processFieldActions(session.getAtlasContext().getContextFactory().getFieldActionService(), outputField);
                    }
                    writer.write(outputField);
                    break;
                }
                case SEPARATE: {
                    Field inputFieldsep = (Field)mapping.getInputField().get(0);
                    for (Field outputFieldsep : mapping.getOutputField()) {
                        Field separateField = this.processSeparateField(session, mapping, inputFieldsep, outputFieldsep);
                        if (separateField == null) continue;
                        outputFieldsep.setValue(separateField.getValue());
                        if (outputFieldsep.getFieldType() == null) {
                            outputFieldsep.setFieldType(separateField.getFieldType());
                        }
                        if (outputFieldsep.getActions() != null && outputFieldsep.getActions().getActions() != null && !outputFieldsep.getActions().getActions().isEmpty()) {
                            this.processFieldActions(session.getAtlasContext().getContextFactory().getFieldActionService(), outputFieldsep);
                        }
                        writer.write(outputFieldsep);
                    }
                    break;
                }
                default: {
                    logger.error("Unsupported mappingType=%s detected", (Object)mapping.getMappingType());
                    return;
                }
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug(String.format("Processed output field oP=%s oV=%s oT=%s docId: %s", outputField.getPath(), outputField.getValue(), outputField.getFieldType(), outputField.getDocId()));
        }
    }

    public void processPostOutputExecution(AtlasSession session) throws AtlasException {
        Object output;
        if (logger.isDebugEnabled()) {
            logger.debug("processPostOutputExecution completed");
        }
        if ((output = session.getOutput()) != null && output instanceof XmlFieldWriter) {
            session.setOutput((Object)this.convertDocumentToString(((XmlFieldWriter)output).getDocument()));
        }
    }

    public Boolean isSupportedField(Field field) {
        if (field instanceof XmlField) {
            return true;
        }
        if (field instanceof PropertyField) {
            return true;
        }
        if (field instanceof ConstantField) {
            return true;
        }
        if (field instanceof SimpleField) {
            return true;
        }
        return false;
    }

    private String convertDocumentToString(Document document) throws AtlasException {
        DocumentBuilderFactory domFact = DocumentBuilderFactory.newInstance();
        domFact.setNamespaceAware(true);
        StringWriter writer = null;
        try {
            DOMSource domSource = new DOMSource(document);
            writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.transform(domSource, result);
            return writer.toString();
        }
        catch (TransformerException e) {
            logger.error(String.format("Error converting Xml document to string msg=%s", e.getMessage()), (Throwable)e);
            throw new AtlasException(e.getMessage(), (Throwable)e);
        }
    }

    private Document getDocument(String data, boolean namespaced) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(namespaced);
        DocumentBuilder b = dbf.newDocumentBuilder();
        return b.parse(new ByteArrayInputStream(data.getBytes("UTF-8")));
    }

    public int getCollectionSize(AtlasSession session, Field field) throws AtlasException {
        try {
            Object sourceObject = null;
            sourceObject = field.getDocId() != null && session.hasInput(field.getDocId()) ? session.getInput(field.getDocId()) : session.getInput();
            Document document = this.getDocument((String)sourceObject, false);
            Element parentNode = document.getDocumentElement();
            for (PathUtil.SegmentContext sc : new PathUtil(field.getPath()).getSegmentContexts(false)) {
                List children;
                if (sc.getPrev() == null) continue;
                String childrenElementName = PathUtil.cleanPathSegment((String)sc.getSegment());
                String namespaceAlias = PathUtil.getNamespace((String)sc.getSegment());
                if (namespaceAlias != null && !"".equals(namespaceAlias)) {
                    childrenElementName = namespaceAlias + ":" + childrenElementName;
                }
                if ((children = XmlFieldWriter.getChildrenWithName((String)childrenElementName, (Element)parentNode)) == null || children.isEmpty()) {
                    return 0;
                }
                if (PathUtil.isCollectionSegment((String)sc.getSegment()).booleanValue()) {
                    return children.size();
                }
                parentNode = (Element)children.get(0);
            }
            return 0;
        }
        catch (Exception e) {
            throw new AtlasException((Throwable)e);
        }
    }

    public Field cloneField(Field field) throws AtlasException {
        return AtlasXmlModelFactory.cloneField((Field)field);
    }
}

