/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.xml.module;

import io.atlasmap.api.AtlasConversionService;
import io.atlasmap.core.AtlasMappingUtil;
import io.atlasmap.core.DefaultAtlasConversionService;
import io.atlasmap.spi.AtlasModuleDetail;
import io.atlasmap.spi.AtlasModuleMode;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.DataSource;
import io.atlasmap.v2.DataSourceType;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.Mapping;
import io.atlasmap.v2.MappingType;
import io.atlasmap.v2.MockField;
import io.atlasmap.v2.Validation;
import io.atlasmap.v2.ValidationStatus;
import io.atlasmap.validators.AtlasValidationTestHelper;
import io.atlasmap.xml.module.XmlModule;
import io.atlasmap.xml.module.XmlValidationService;
import io.atlasmap.xml.v2.AtlasXmlModelFactory;
import io.atlasmap.xml.v2.ObjectFactory;
import io.atlasmap.xml.v2.XmlComplexType;
import io.atlasmap.xml.v2.XmlField;
import io.atlasmap.xml.v2.XmlFields;
import java.util.List;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlValidationServiceTest {
    private static final Logger logger = LoggerFactory.getLogger(XmlValidationServiceTest.class);
    protected ObjectFactory xmlModelFactory = null;
    protected AtlasMappingUtil mappingUtil = null;
    protected XmlValidationService sourceValidationService = null;
    protected XmlValidationService targetValidationService = null;
    protected AtlasValidationTestHelper validationHelper = null;
    protected List<Validation> validations = null;
    protected AtlasModuleDetail moduleDetail = null;

    @Before
    public void setUp() {
        this.xmlModelFactory = new ObjectFactory();
        this.mappingUtil = new AtlasMappingUtil("io.atlasmap.v2:io.atlasmap.xml.v2");
        this.moduleDetail = XmlModule.class.getAnnotation(AtlasModuleDetail.class);
        this.sourceValidationService = new XmlValidationService((AtlasConversionService)DefaultAtlasConversionService.getInstance());
        this.sourceValidationService.setMode(AtlasModuleMode.SOURCE);
        this.targetValidationService = new XmlValidationService((AtlasConversionService)DefaultAtlasConversionService.getInstance());
        this.targetValidationService.setMode(AtlasModuleMode.TARGET);
        this.validationHelper = new AtlasValidationTestHelper();
        this.validations = this.validationHelper.getValidation();
    }

    @After
    public void tearDown() {
        this.xmlModelFactory = null;
        this.mappingUtil = null;
        this.sourceValidationService = null;
        this.targetValidationService = null;
        this.validationHelper = null;
        this.validations = null;
    }

    protected AtlasMapping getAtlasMappingFullValid() throws Exception {
        AtlasMapping mapping = AtlasModelFactory.createAtlasMapping();
        mapping.setName("thisis_a_valid.name");
        mapping.getDataSource().add(this.generateDataSource("atlas:xml:MockXml", DataSourceType.SOURCE));
        mapping.getDataSource().add(this.generateDataSource("atlas:xml:MockXml", DataSourceType.TARGET));
        Mapping mapMapping = (Mapping)AtlasModelFactory.createMapping((MappingType)MappingType.MAP);
        Mapping sepMapping = (Mapping)AtlasModelFactory.createMapping((MappingType)MappingType.SEPARATE);
        XmlField inputField = AtlasXmlModelFactory.createXmlField();
        inputField.setFieldType(FieldType.STRING);
        inputField.setPath("firstName");
        XmlField outputField = AtlasXmlModelFactory.createXmlField();
        outputField.setFieldType(FieldType.STRING);
        outputField.setPath("firstName");
        mapMapping.getInputField().add(inputField);
        mapMapping.getOutputField().add(outputField);
        XmlField sIJavaField = AtlasXmlModelFactory.createXmlField();
        sIJavaField.setFieldType(FieldType.STRING);
        sIJavaField.setPath("displayName");
        sepMapping.getInputField().add(sIJavaField);
        XmlField sOJavaField = AtlasXmlModelFactory.createXmlField();
        sOJavaField.setFieldType(FieldType.STRING);
        sOJavaField.setPath("lastName");
        sOJavaField.setIndex(Integer.valueOf(1));
        sepMapping.getOutputField().add(sOJavaField);
        mapping.getMappings().getMapping().add(mapMapping);
        mapping.getMappings().getMapping().add(sepMapping);
        return mapping;
    }

    protected DataSource generateDataSource(String uri, DataSourceType type) {
        DataSource ds = new DataSource();
        ds.setUri(uri);
        ds.setDataSourceType(type);
        return ds;
    }

    protected Mapping createMockMapping() {
        MockField inputField = new MockField();
        inputField.setName("input.name");
        MockField outputField = new MockField();
        outputField.setName("out.name");
        Mapping mapping = new Mapping();
        mapping.setMappingType(MappingType.MAP);
        mapping.getInputField().add(inputField);
        mapping.getOutputField().add(inputField);
        return mapping;
    }

    protected void debugErrors(List<Validation> validations) {
        for (Validation validation : validations) {
            logger.debug(AtlasValidationTestHelper.validationToString((Validation)validation));
        }
    }

    @Test
    public void testValidateMappingHappyPath() throws Exception {
        AtlasMapping mapping = this.getAtlasMappingFullValid();
        Assert.assertNotNull((Object)mapping);
        this.validations.addAll(this.sourceValidationService.validateMapping(mapping));
        this.validations.addAll(this.targetValidationService.validateMapping(mapping));
        Assert.assertFalse((boolean)this.validationHelper.hasErrors());
        Assert.assertFalse((boolean)this.validationHelper.hasWarnings());
        Assert.assertFalse((boolean)this.validationHelper.hasInfos());
    }

    @Test
    public void testValidateMappingHappyPathFromFile() throws Exception {
        AtlasMapping mapping = this.mappingUtil.loadMapping("src/test/resources/mappings/HappyPathMapping.xml");
        Assert.assertNotNull((Object)mapping);
        this.validations.addAll(this.sourceValidationService.validateMapping(mapping));
        this.validations.addAll(this.targetValidationService.validateMapping(mapping));
        Assert.assertFalse((boolean)this.validationHelper.hasErrors());
        Assert.assertFalse((boolean)this.validationHelper.hasWarnings());
        Assert.assertFalse((boolean)this.validationHelper.hasInfos());
    }

    @Test
    public void testValidateMappingMismatchedFieldType() throws Exception {
        AtlasMapping mapping = this.getAtlasMappingFullValid();
        Assert.assertNotNull((Object)mapping);
        mapping.getMappings().getMapping().clear();
        mapping.getMappings().getMapping().add(this.createMockMapping());
        this.validations.addAll(this.sourceValidationService.validateMapping(mapping));
        this.validations.addAll(this.targetValidationService.validateMapping(mapping));
        Assert.assertTrue((boolean)this.validationHelper.hasErrors());
        Assert.assertFalse((boolean)this.validationHelper.hasWarnings());
        Assert.assertFalse((boolean)this.validationHelper.hasInfos());
    }

    @Test
    public void testValidateMappingInvalidModuleType() throws Exception {
        AtlasMapping mapping = AtlasModelFactory.createAtlasMapping();
        mapping.setName("thisis_a_valid.name");
        mapping.getDataSource().add(this.generateDataSource("atlas:java", DataSourceType.SOURCE));
        mapping.getDataSource().add(this.generateDataSource("atlas:json", DataSourceType.TARGET));
        this.validations.addAll(this.sourceValidationService.validateMapping(mapping));
        this.validations.addAll(this.targetValidationService.validateMapping(mapping));
        Assert.assertTrue((boolean)this.validationHelper.hasErrors());
        Assert.assertFalse((boolean)this.validationHelper.hasWarnings());
        Assert.assertFalse((boolean)this.validationHelper.hasInfos());
    }

    @Test
    public void testValidateMappingInvalidSeparateInputFieldType() throws Exception {
        AtlasMapping atlasMapping = this.getAtlasMappingFullValid();
        Mapping separateFieldMapping = (Mapping)AtlasModelFactory.createMapping((MappingType)MappingType.SEPARATE);
        XmlField bIJavaField = this.xmlModelFactory.createXmlField();
        bIJavaField.setFieldType(FieldType.BOOLEAN);
        bIJavaField.setValue((Object)Boolean.TRUE);
        bIJavaField.setPath("firstName");
        separateFieldMapping.getInputField().add(bIJavaField);
        XmlField sOJavaField = this.xmlModelFactory.createXmlField();
        sOJavaField.setFieldType(FieldType.STRING);
        sOJavaField.setPath("lastName");
        sOJavaField.setIndex(Integer.valueOf(0));
        separateFieldMapping.getOutputField().add(sOJavaField);
        atlasMapping.getMappings().getMapping().add(separateFieldMapping);
        this.validations.addAll(this.sourceValidationService.validateMapping(atlasMapping));
        this.validations.addAll(this.targetValidationService.validateMapping(atlasMapping));
        Assert.assertTrue((boolean)this.validationHelper.hasErrors());
        Assert.assertFalse((boolean)this.validationHelper.hasWarnings());
        Assert.assertTrue((boolean)this.validationHelper.hasInfos());
        Assert.assertEquals((Object)new Integer(2), (Object)new Integer(this.validationHelper.getCount()));
        Validation validation = this.validations.get(0);
        Assert.assertNotNull((Object)validation);
        Assert.assertEquals((Object)"Input.Field", (Object)validation.getField());
        Assert.assertEquals((Object)"(BOOLEAN)", (Object)validation.getValue().toString());
        Assert.assertEquals((Object)"Input field must be of type STRING for a Separate Mapping", (Object)validation.getMessage());
        Assert.assertEquals((Object)ValidationStatus.ERROR, (Object)validation.getStatus());
        validation = this.validations.get(1);
        Assert.assertNotNull((Object)validation);
        Assert.assertEquals((Object)"Field.Input/Output.conversion", (Object)validation.getField());
        Assert.assertEquals((Object)"(BOOLEAN) --> (STRING)", (Object)validation.getValue().toString());
        Assert.assertEquals((Object)"Conversion between source and target types is supported", (Object)validation.getMessage());
        Assert.assertEquals((Object)ValidationStatus.INFO, (Object)validation.getStatus());
    }

    @Test
    public void testValidateMappingSupportedSourceToTargetConversion() throws Exception {
        AtlasMapping mapping = this.mappingUtil.loadMapping("src/test/resources/mappings/HappyPathMapping.xml");
        Assert.assertNotNull((Object)mapping);
        Mapping fieldMapping = (Mapping)mapping.getMappings().getMapping().get(0);
        XmlField in = (XmlField)fieldMapping.getInputField().get(0);
        in.setFieldType(FieldType.CHAR);
        this.validations.addAll(this.sourceValidationService.validateMapping(mapping));
        this.validations.addAll(this.targetValidationService.validateMapping(mapping));
        if (logger.isDebugEnabled()) {
            this.debugErrors(this.validations);
        }
        Assert.assertFalse((boolean)this.validationHelper.hasErrors());
        Assert.assertFalse((boolean)this.validationHelper.hasWarnings());
        Assert.assertTrue((boolean)this.validationHelper.hasInfos());
    }

    @Test
    public void testValidateAtlasMappingFileConversionRequired() throws Exception {
        AtlasMapping mapping = this.mappingUtil.loadMapping("src/test/resources/mappings/HappyPathMapping.xml");
        Assert.assertNotNull((Object)mapping);
        Mapping fieldMapping = (Mapping)mapping.getMappings().getMapping().get(0);
        XmlComplexType complex = this.xmlModelFactory.createXmlComplexType();
        complex.setFieldType(FieldType.COMPLEX);
        XmlField in = (XmlField)fieldMapping.getInputField().get(0);
        complex.setXmlFields(new XmlFields());
        complex.setPath("/nest");
        complex.setName("nest");
        in.setPath("/nest/" + in.getPath());
        complex.getXmlFields().getXmlField().add(in);
        fieldMapping.getInputField().set(0, complex);
        XmlField out = (XmlField)fieldMapping.getOutputField().get(0);
        out.setFieldType(FieldType.STRING);
        this.validations.addAll(this.sourceValidationService.validateMapping(mapping));
        this.validations.addAll(this.targetValidationService.validateMapping(mapping));
        Assert.assertFalse((boolean)this.validationHelper.hasErrors());
        Assert.assertTrue((boolean)this.validationHelper.hasWarnings());
        Assert.assertFalse((boolean)this.validationHelper.hasInfos());
        Assert.assertThat((Object)1, (Matcher)CoreMatchers.is((Object)this.validationHelper.getCount()));
        Assert.assertTrue((boolean)this.validations.stream().anyMatch(me -> me.getField().equals("Field.Input/Output.conversion")));
        Long errorCount = this.validations.stream().filter(atlasMappingError -> atlasMappingError.getStatus().compareTo((Enum)ValidationStatus.WARN) == 0).count();
        Assert.assertNotNull((Object)errorCount);
        Assert.assertEquals((long)1L, (long)errorCount);
    }

    @Test
    public void testValidateMappingSourceToTargetRangeConcerns() throws Exception {
        AtlasMapping mapping = this.mappingUtil.loadMapping("src/test/resources/mappings/HappyPathMapping.xml");
        Assert.assertNotNull((Object)mapping);
        Mapping fieldMapping = (Mapping)mapping.getMappings().getMapping().get(0);
        XmlField in = (XmlField)fieldMapping.getInputField().get(0);
        in.setFieldType(FieldType.DOUBLE);
        XmlField out = (XmlField)fieldMapping.getOutputField().get(0);
        out.setFieldType(FieldType.LONG);
        this.validations.addAll(this.sourceValidationService.validateMapping(mapping));
        this.validations.addAll(this.targetValidationService.validateMapping(mapping));
        if (logger.isDebugEnabled()) {
            this.debugErrors(this.validations);
        }
        Assert.assertFalse((boolean)this.validationHelper.hasErrors());
        Assert.assertTrue((boolean)this.validationHelper.hasWarnings());
        Assert.assertFalse((boolean)this.validationHelper.hasInfos());
        Assert.assertThat((Object)1, (Matcher)CoreMatchers.is((Object)this.validationHelper.getCount()));
        Assert.assertTrue((boolean)this.validations.stream().anyMatch(atlasMappingError -> atlasMappingError.getMessage().contains("range")));
    }

    @Test
    public void testValidateMappingSourceToTargetFormatConcerns() throws Exception {
        AtlasMapping mapping = this.mappingUtil.loadMapping("src/test/resources/mappings/HappyPathMapping.xml");
        Assert.assertNotNull((Object)mapping);
        Mapping fieldMapping = (Mapping)mapping.getMappings().getMapping().get(0);
        XmlField in = (XmlField)fieldMapping.getInputField().get(0);
        in.setFieldType(FieldType.STRING);
        XmlField out = (XmlField)fieldMapping.getOutputField().get(0);
        out.setFieldType(FieldType.LONG);
        this.validations.addAll(this.sourceValidationService.validateMapping(mapping));
        this.validations.addAll(this.targetValidationService.validateMapping(mapping));
        if (logger.isDebugEnabled()) {
            this.debugErrors(this.validations);
        }
        Assert.assertFalse((boolean)this.validationHelper.hasErrors());
        Assert.assertTrue((boolean)this.validationHelper.hasWarnings());
        Assert.assertFalse((boolean)this.validationHelper.hasInfos());
        Assert.assertThat((Object)2, (Matcher)CoreMatchers.is((Object)this.validationHelper.getCount()));
        Assert.assertTrue((boolean)this.validations.stream().anyMatch(atlasMappingError -> atlasMappingError.getMessage().contains("range")));
        Assert.assertTrue((boolean)this.validations.stream().anyMatch(atlasMappingError -> atlasMappingError.getMessage().contains("format")));
    }

    @Test
    public void testValidateMappingPathNull() throws Exception {
        AtlasMapping mapping = this.mappingUtil.loadMapping("src/test/resources/mappings/HappyPathMapping.xml");
        Assert.assertNotNull((Object)mapping);
        Mapping fieldMapping = (Mapping)mapping.getMappings().getMapping().get(0);
        XmlField in = (XmlField)fieldMapping.getInputField().get(0);
        in.setPath(null);
        this.validations.addAll(this.sourceValidationService.validateMapping(mapping));
        this.validations.addAll(this.targetValidationService.validateMapping(mapping));
        Assert.assertTrue((boolean)this.validationHelper.hasErrors());
        Assert.assertFalse((boolean)this.validationHelper.hasWarnings());
        Assert.assertFalse((boolean)this.validationHelper.hasInfos());
    }

    public static <T> Collector<T, ?, T> singletonCollector() {
        return Collectors.collectingAndThen(Collectors.toList(), list -> {
            if (list.size() != 1) {
                throw new IllegalStateException();
            }
            return list.get(0);
        });
    }
}

