/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.xml.v2;

import io.atlasmap.v2.Action;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.Camelize;
import io.atlasmap.v2.Capitalize;
import io.atlasmap.v2.Collection;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.ConstantField;
import io.atlasmap.v2.DataSource;
import io.atlasmap.v2.DataSourceType;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldStatus;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.Length;
import io.atlasmap.v2.LookupEntry;
import io.atlasmap.v2.LookupTable;
import io.atlasmap.v2.Lowercase;
import io.atlasmap.v2.Mapping;
import io.atlasmap.v2.MappingType;
import io.atlasmap.v2.Mappings;
import io.atlasmap.v2.Properties;
import io.atlasmap.v2.Property;
import io.atlasmap.v2.PropertyField;
import io.atlasmap.v2.SeparateByDash;
import io.atlasmap.v2.SeparateByUnderscore;
import io.atlasmap.v2.StringList;
import io.atlasmap.v2.Trim;
import io.atlasmap.v2.TrimLeft;
import io.atlasmap.v2.TrimRight;
import io.atlasmap.v2.Uppercase;
import io.atlasmap.xml.v2.InspectionType;
import io.atlasmap.xml.v2.NodeType;
import io.atlasmap.xml.v2.Restriction;
import io.atlasmap.xml.v2.RestrictionType;
import io.atlasmap.xml.v2.Restrictions;
import io.atlasmap.xml.v2.XmlDataSource;
import io.atlasmap.xml.v2.XmlField;
import io.atlasmap.xml.v2.XmlInspectionRequest;
import io.atlasmap.xml.v2.XmlNamespace;
import io.atlasmap.xml.v2.XmlNamespaces;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;

public abstract class BaseMarshallerTest {
    public boolean deleteTestFolders = true;
    @Rule
    public TestName testName = new TestName();

    @Before
    public void setUp() throws Exception {
        Files.createDirectories(Paths.get("target/junit/" + this.testName.getMethodName(), new String[0]), new FileAttribute[0]);
    }

    @After
    public void tearDown() throws Exception {
        if (this.deleteTestFolders) {
            Path directory = Paths.get("target/junit/" + this.testName.getMethodName(), new String[0]);
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (exc == null) {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }
                    throw exc;
                }
            });
        }
    }

    protected AtlasMapping generateAtlasMapping() {
        AtlasMapping atlasMapping = AtlasModelFactory.createAtlasMapping();
        atlasMapping.setName("junit");
        this.generateXmlDataSource(atlasMapping);
        this.generateLookupTables(atlasMapping);
        ArrayList<Action> actions = this.generateactions();
        StringList stringList = new StringList();
        stringList.getString().add("XmlAccessorType");
        stringList.getString().add("XmlType");
        Restrictions restrictions = new Restrictions();
        Restriction restriction = new Restriction();
        restriction.setType(RestrictionType.LENGTH);
        restriction.setValue("100");
        restrictions.getRestriction().add(restriction);
        Mapping mapping = (Mapping)AtlasModelFactory.createMapping((MappingType)MappingType.MAP);
        XmlField inputField = this.generateXmlField(actions, stringList, restrictions);
        mapping.getInputField().add(inputField);
        XmlField outputField = this.generateXmlField(actions, stringList, restrictions);
        mapping.getOutputField().add(outputField);
        mapping.setMappingType(MappingType.MAP);
        mapping.setDelimiterString(",");
        mapping.setAlias("MapPropertyFieldAlias");
        mapping.setDelimiter(",");
        mapping.setDescription("description");
        mapping.setId("id");
        mapping.setLookupTableName("lookupTableName");
        mapping.setStrategy("strategy");
        mapping.setStrategyClassName("strategyClassName");
        atlasMapping.getMappings().getMapping().add(mapping);
        this.generateProperties(atlasMapping);
        return atlasMapping;
    }

    private void generateProperties(AtlasMapping atlasMapping) {
        Property p = new Property();
        p.setName("foo");
        p.setValue("bar");
        p.setFieldType(FieldType.INTEGER);
        atlasMapping.setProperties(new Properties());
        atlasMapping.getProperties().getProperty().add(p);
    }

    private XmlField generateXmlField(ArrayList<Action> actions, StringList stringList, Restrictions restrictions) {
        XmlField inputField = new XmlField();
        inputField.setName("foo");
        inputField.setValue((Object)"bar");
        inputField.setActions(actions);
        inputField.setArrayDimensions(Integer.valueOf(3));
        inputField.setArraySize(Integer.valueOf(3));
        inputField.setCollectionType(CollectionType.ARRAY);
        inputField.setDocId("docid");
        inputField.setPath("/path");
        inputField.setRequired(Boolean.valueOf(false));
        inputField.setStatus(FieldStatus.SUPPORTED);
        inputField.setFieldType(FieldType.INTEGER);
        inputField.setIndex(Integer.valueOf(3));
        inputField.setAnnotations(stringList);
        inputField.setPrimitive(Boolean.FALSE);
        inputField.setNodeType(NodeType.ELEMENT);
        inputField.setRestrictions(restrictions);
        inputField.setTypeName("typeName");
        inputField.setUserCreated(Boolean.TRUE);
        return inputField;
    }

    private ArrayList<Action> generateactions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add((Action)new Camelize());
        actions.add((Action)new Capitalize());
        actions.add((Action)new Length());
        actions.add((Action)new Lowercase());
        actions.add((Action)new SeparateByDash());
        actions.add((Action)new SeparateByUnderscore());
        actions.add((Action)new Trim());
        actions.add((Action)new TrimLeft());
        actions.add((Action)new TrimRight());
        actions.add((Action)new Uppercase());
        return actions;
    }

    private void generateLookupTables(AtlasMapping atlasMapping) {
        LookupTable table = new LookupTable();
        table.setName("lookupTable");
        table.setDescription("lookupTableDescription");
        LookupEntry l1 = new LookupEntry();
        l1.setSourceType(FieldType.STRING);
        l1.setSourceValue("Foo");
        l1.setTargetType(FieldType.STRING);
        l1.setTargetValue("Bar");
        table.getLookupEntry().add(l1);
        atlasMapping.getLookupTables().getLookupTable().add(table);
    }

    private void generateXmlDataSource(AtlasMapping atlasMapping) {
        XmlNamespace xmlNs = this.generateXmlNamespace("alias", "http://atlasmap.io/xml/test/v2", "http://atlasmap.io/xml/test/v2", Boolean.FALSE);
        XmlDataSource src = this.generateXmlDataSource("srcId", "srcUri", DataSourceType.SOURCE, "template", xmlNs);
        xmlNs = this.generateXmlNamespace("alias", "http://atlasmap.io/xml/test/v2", "http://atlasmap.io/xml/test/v2", Boolean.TRUE);
        XmlDataSource tgt = this.generateXmlDataSource("tgtId", "tgtUri", DataSourceType.TARGET, "template", xmlNs);
        atlasMapping.getDataSource().add(src);
        atlasMapping.getDataSource().add(tgt);
    }

    private XmlNamespace generateXmlNamespace(String alias, String uri, String location, boolean isTarget) {
        XmlNamespace xmlNs = new XmlNamespace();
        xmlNs.setAlias(alias);
        xmlNs.setUri(uri);
        xmlNs.setLocationUri(location);
        xmlNs.setTargetNamespace(Boolean.valueOf(isTarget));
        return xmlNs;
    }

    private XmlDataSource generateXmlDataSource(String id, String uri, DataSourceType dataSourceType, String template, XmlNamespace xmlNs) {
        XmlDataSource src = new XmlDataSource();
        src.setId(id);
        src.setUri(uri);
        src.setDataSourceType(dataSourceType);
        src.setTemplate(template);
        src.setXmlNamespaces(new XmlNamespaces());
        src.getXmlNamespaces().getXmlNamespace().add(xmlNs);
        return src;
    }

    protected AtlasMapping generateCollectionMapping() {
        AtlasMapping innerMapping1 = this.generateAtlasMapping();
        AtlasMapping innerMapping2 = this.generateAtlasMapping();
        Collection cMapping = new Collection();
        cMapping.getMappings().getMapping().addAll(innerMapping1.getMappings().getMapping());
        cMapping.getMappings().getMapping().addAll(innerMapping2.getMappings().getMapping());
        cMapping.setCollectionType(CollectionType.LIST);
        AtlasMapping mapping = this.generateAtlasMapping();
        mapping.getMappings().getMapping().clear();
        mapping.getMappings().getMapping().add(cMapping);
        return mapping;
    }

    protected AtlasMapping generateCombineMapping() {
        XmlField inputFieldA = new XmlField();
        inputFieldA.setName("foo");
        inputFieldA.setValue((Object)"bar");
        XmlField inputFieldB = new XmlField();
        inputFieldB.setName("foo3");
        inputFieldB.setValue((Object)"bar3");
        XmlField outputFieldA = new XmlField();
        outputFieldA.setName("woot");
        outputFieldA.setValue((Object)"blerg");
        Mapping fm = (Mapping)AtlasModelFactory.createMapping((MappingType)MappingType.COMBINE);
        fm.getInputField().add(inputFieldA);
        fm.getInputField().add(inputFieldB);
        fm.getOutputField().add(outputFieldA);
        AtlasMapping mapping = this.generateAtlasMapping();
        mapping.getMappings().getMapping().clear();
        mapping.getMappings().getMapping().add(fm);
        return mapping;
    }

    protected AtlasMapping generatePropertyReferenceMapping() {
        AtlasMapping mapping = this.generateAtlasMapping();
        PropertyField inputField = new PropertyField();
        inputField.setName("foo");
        Mapping fm = (Mapping)mapping.getMappings().getMapping().get(0);
        fm.getInputField().add(inputField);
        Property p = new Property();
        p.setName("foo");
        p.setValue("bar");
        mapping.setProperties(new Properties());
        mapping.getProperties().getProperty().add(p);
        return mapping;
    }

    protected AtlasMapping generateConstantMapping() {
        AtlasMapping mapping = this.generateAtlasMapping();
        ConstantField inputField = new ConstantField();
        inputField.setValue((Object)"foo");
        Mapping fm = (Mapping)mapping.getMappings().getMapping().get(0);
        fm.getInputField().add(inputField);
        return mapping;
    }

    protected AtlasMapping generateMultiSourceMapping() {
        AtlasMapping mapping = this.generateSeparateAtlasMapping();
        DataSource source1 = new DataSource();
        source1.setUri("xml:foo1");
        source1.setDataSourceType(DataSourceType.SOURCE);
        source1.setId("xml1");
        DataSource source2 = new DataSource();
        source2.setUri("xml:foo2");
        source2.setDataSourceType(DataSourceType.SOURCE);
        source2.setId("xml2");
        DataSource target = new DataSource();
        target.setUri("xml:bar");
        target.setDataSourceType(DataSourceType.TARGET);
        target.setId("target1");
        mapping.getDataSource().add(source1);
        mapping.getDataSource().add(source2);
        mapping.getDataSource().add(target);
        Mapping fm = (Mapping)mapping.getMappings().getMapping().get(0);
        ((Field)fm.getInputField().get(0)).setDocId("xml1");
        ((Field)fm.getOutputField().get(0)).setDocId("target1");
        ((Field)fm.getOutputField().get(1)).setDocId("target1");
        return mapping;
    }

    protected void validateAtlasMapping(AtlasMapping mapping) {
        Assert.assertNotNull((Object)mapping);
        Assert.assertNotNull((Object)mapping.getName());
        Assert.assertEquals((Object)"junit", (Object)mapping.getName());
        Assert.assertEquals((long)2L, (long)mapping.getDataSource().size());
        Assert.assertEquals((Object)DataSourceType.SOURCE, (Object)((DataSource)mapping.getDataSource().get(0)).getDataSourceType());
        Assert.assertEquals((Object)"srcId", (Object)((DataSource)mapping.getDataSource().get(0)).getId());
        Assert.assertEquals((Object)"srcUri", (Object)((DataSource)mapping.getDataSource().get(0)).getUri());
        Assert.assertEquals((Object)"template", (Object)((XmlDataSource)mapping.getDataSource().get(0)).getTemplate());
        Assert.assertEquals((Object)"alias", (Object)((XmlNamespace)((XmlDataSource)mapping.getDataSource().get(0)).getXmlNamespaces().getXmlNamespace().get(0)).getAlias());
        Assert.assertEquals((Object)"http://atlasmap.io/xml/test/v2", (Object)((XmlNamespace)((XmlDataSource)mapping.getDataSource().get(0)).getXmlNamespaces().getXmlNamespace().get(0)).getUri());
        Assert.assertEquals((Object)"http://atlasmap.io/xml/test/v2", (Object)((XmlNamespace)((XmlDataSource)mapping.getDataSource().get(0)).getXmlNamespaces().getXmlNamespace().get(0)).getLocationUri());
        Assert.assertEquals((Object)Boolean.FALSE, (Object)((XmlNamespace)((XmlDataSource)mapping.getDataSource().get(0)).getXmlNamespaces().getXmlNamespace().get(0)).isTargetNamespace());
        Assert.assertEquals((Object)DataSourceType.TARGET, (Object)((DataSource)mapping.getDataSource().get(1)).getDataSourceType());
        Assert.assertEquals((Object)"tgtId", (Object)((DataSource)mapping.getDataSource().get(1)).getId());
        Assert.assertEquals((Object)"tgtUri", (Object)((DataSource)mapping.getDataSource().get(1)).getUri());
        Assert.assertEquals((Object)"template", (Object)((XmlDataSource)mapping.getDataSource().get(1)).getTemplate());
        Assert.assertEquals((Object)"alias", (Object)((XmlNamespace)((XmlDataSource)mapping.getDataSource().get(1)).getXmlNamespaces().getXmlNamespace().get(0)).getAlias());
        Assert.assertEquals((Object)"http://atlasmap.io/xml/test/v2", (Object)((XmlNamespace)((XmlDataSource)mapping.getDataSource().get(1)).getXmlNamespaces().getXmlNamespace().get(0)).getUri());
        Assert.assertEquals((Object)"http://atlasmap.io/xml/test/v2", (Object)((XmlNamespace)((XmlDataSource)mapping.getDataSource().get(1)).getXmlNamespaces().getXmlNamespace().get(0)).getLocationUri());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)((XmlNamespace)((XmlDataSource)mapping.getDataSource().get(1)).getXmlNamespaces().getXmlNamespace().get(0)).isTargetNamespace());
        Assert.assertNotNull((Object)mapping.getLookupTables());
        Assert.assertEquals((long)1L, (long)mapping.getLookupTables().getLookupTable().size());
        this.validateLookupTable((LookupTable)mapping.getLookupTables().getLookupTable().get(0));
        Assert.assertNotNull((Object)mapping.getMappings());
        Assert.assertEquals((Object)new Integer(1), (Object)new Integer(mapping.getMappings().getMapping().size()));
        this.validateMapping((Mapping)mapping.getMappings().getMapping().get(0));
        Assert.assertNotNull((Object)mapping.getProperties());
        Assert.assertEquals((long)1L, (long)mapping.getProperties().getProperty().size());
        this.validateProperty((Property)mapping.getProperties().getProperty().get(0));
    }

    private void validateMapping(Mapping mapping) {
        Assert.assertEquals((Object)"MapPropertyFieldAlias", (Object)mapping.getAlias());
        Assert.assertEquals((Object)MappingType.MAP, (Object)mapping.getMappingType());
        Assert.assertEquals((Object)",", (Object)mapping.getDelimiter());
        Assert.assertEquals((Object)",", (Object)mapping.getDelimiterString());
        Assert.assertEquals((Object)"description", (Object)mapping.getDescription());
        Assert.assertEquals((Object)"id", (Object)mapping.getId());
        Assert.assertEquals((long)1L, (long)mapping.getInputField().size());
        this.validateXmlField((XmlField)mapping.getInputField().get(0));
        Assert.assertEquals((Object)"lookupTableName", (Object)mapping.getLookupTableName());
        Assert.assertEquals((long)1L, (long)mapping.getOutputField().size());
        this.validateXmlField((XmlField)mapping.getOutputField().get(0));
        Assert.assertEquals((Object)"strategy", (Object)mapping.getStrategy());
        Assert.assertEquals((Object)"strategyClassName", (Object)mapping.getStrategyClassName());
    }

    private void validateXmlField(XmlField field) {
        Assert.assertEquals((long)10L, (long)field.getActions().size());
        Assert.assertEquals((Object)"XmlAccessorType", field.getAnnotations().getString().get(0));
        Assert.assertEquals((Object)"XmlType", field.getAnnotations().getString().get(1));
        Assert.assertEquals((Object)3, (Object)field.getArrayDimensions());
        Assert.assertEquals((Object)3, (Object)field.getArraySize());
        Assert.assertEquals((Object)CollectionType.ARRAY, (Object)field.getCollectionType());
        Assert.assertEquals((Object)"docid", (Object)field.getDocId());
        Assert.assertEquals((Object)FieldType.INTEGER, (Object)field.getFieldType());
        Assert.assertEquals((Object)3, (Object)field.getIndex());
        Assert.assertEquals((Object)"foo", (Object)field.getName());
        Assert.assertEquals((Object)"/path", (Object)field.getPath());
        Assert.assertEquals((Object)Boolean.FALSE, (Object)field.isPrimitive());
        Assert.assertEquals((Object)Boolean.FALSE, (Object)field.isRequired());
        Assert.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
        Assert.assertEquals((Object)"bar", (Object)field.getValue());
        Assert.assertEquals((Object)NodeType.ELEMENT, (Object)field.getNodeType());
        Assert.assertEquals((Object)"typeName", (Object)field.getTypeName());
        Assert.assertEquals((Object)Boolean.TRUE, (Object)field.isUserCreated());
        Assert.assertEquals((Object)RestrictionType.LENGTH, (Object)((Restriction)field.getRestrictions().getRestriction().get(0)).getType());
        Assert.assertEquals((Object)"100", (Object)((Restriction)field.getRestrictions().getRestriction().get(0)).getValue());
    }

    private void validateLookupTable(LookupTable lookupTable) {
        Assert.assertEquals((Object)"lookupTableDescription", (Object)lookupTable.getDescription());
        Assert.assertEquals((Object)"lookupTable", (Object)lookupTable.getName());
        Assert.assertEquals((Object)FieldType.STRING, (Object)((LookupEntry)lookupTable.getLookupEntry().get(0)).getSourceType());
        Assert.assertEquals((Object)"Foo", (Object)((LookupEntry)lookupTable.getLookupEntry().get(0)).getSourceValue());
        Assert.assertEquals((Object)FieldType.STRING, (Object)((LookupEntry)lookupTable.getLookupEntry().get(0)).getTargetType());
        Assert.assertEquals((Object)"Bar", (Object)((LookupEntry)lookupTable.getLookupEntry().get(0)).getTargetValue());
    }

    private void validateProperty(Property p) {
        Assert.assertEquals((Object)FieldType.INTEGER, (Object)p.getFieldType());
        Assert.assertEquals((Object)"foo", (Object)p.getName());
        Assert.assertEquals((Object)"bar", (Object)p.getValue());
    }

    protected AtlasMapping generateSeparateAtlasMapping() {
        AtlasMapping atlasMapping = new AtlasMapping();
        atlasMapping.setName("junit");
        atlasMapping.setMappings(new Mappings());
        Mapping mapping = (Mapping)AtlasModelFactory.createMapping((MappingType)MappingType.SEPARATE);
        XmlField inputField = new XmlField();
        inputField.setName("foo");
        inputField.setValue((Object)"bar");
        XmlField outputFieldA = new XmlField();
        outputFieldA.setName("woot");
        outputFieldA.setValue((Object)"blerg");
        outputFieldA.setIndex(Integer.valueOf(1));
        XmlField outputFieldB = new XmlField();
        outputFieldB.setName("meow");
        outputFieldB.setValue((Object)"ruff");
        outputFieldB.setIndex(Integer.valueOf(2));
        mapping.getInputField().add(inputField);
        mapping.getOutputField().add(outputFieldA);
        mapping.getOutputField().add(outputFieldB);
        atlasMapping.getMappings().getMapping().add(mapping);
        return atlasMapping;
    }

    protected void validateSeparateAtlasMapping(AtlasMapping mapping) {
        Assert.assertNotNull((Object)mapping);
        Assert.assertNotNull((Object)mapping.getName());
        Assert.assertEquals((Object)"junit", (Object)mapping.getName());
        Assert.assertNotNull((Object)mapping.getMappings());
        Assert.assertEquals((Object)new Integer(1), (Object)new Integer(mapping.getMappings().getMapping().size()));
        Assert.assertNull((Object)mapping.getProperties());
        Mapping fm = (Mapping)mapping.getMappings().getMapping().get(0);
        Assert.assertNotNull((Object)fm);
        Assert.assertEquals((Object)MappingType.SEPARATE, (Object)fm.getMappingType());
        Assert.assertNull((Object)fm.getAlias());
        XmlField m1 = (XmlField)fm.getInputField().get(0);
        Assert.assertNotNull((Object)m1);
        Assert.assertNull((Object)m1.getActions());
        Assert.assertEquals((Object)"foo", (Object)m1.getName());
        Assert.assertEquals((Object)"bar", (Object)m1.getValue());
        Assert.assertNull((Object)m1.getFieldType());
        XmlField m2 = (XmlField)fm.getOutputField().get(0);
        Assert.assertNotNull((Object)m2);
        Assert.assertNull((Object)m2.getActions());
        Assert.assertEquals((Object)"woot", (Object)m2.getName());
        Assert.assertEquals((Object)"blerg", (Object)m2.getValue());
        Assert.assertNull((Object)m2.getFieldType());
        Assert.assertEquals((Object)new Integer(1), (Object)m2.getIndex());
        XmlField m3 = (XmlField)fm.getOutputField().get(0);
        Assert.assertNotNull((Object)m3);
        Assert.assertNull((Object)m3.getActions());
        Assert.assertEquals((Object)"meow", (Object)m3.getName());
        Assert.assertEquals((Object)"ruff", (Object)m3.getValue());
        Assert.assertNull((Object)m3.getFieldType());
        Assert.assertEquals((Object)new Integer(2), (Object)m3.getIndex());
    }

    public XmlInspectionRequest generateInspectionRequest() {
        XmlInspectionRequest xmlInspectionRequest = new XmlInspectionRequest();
        xmlInspectionRequest.setType(InspectionType.INSTANCE);
        String xmlData = "<data>\n     <intField a='1'>32000</intField>\n     <longField>12421</longField>\n     <stringField>abc</stringField>\n     <booleanField>true</booleanField>\n     <doubleField b='2'>12.0</doubleField>\n     <shortField>1000</shortField>\n     <floatField>234.5f</floatField>\n     <charField>A</charField>\n</data>";
        xmlInspectionRequest.setXmlData("<data>\n     <intField a='1'>32000</intField>\n     <longField>12421</longField>\n     <stringField>abc</stringField>\n     <booleanField>true</booleanField>\n     <doubleField b='2'>12.0</doubleField>\n     <shortField>1000</shortField>\n     <floatField>234.5f</floatField>\n     <charField>A</charField>\n</data>");
        return xmlInspectionRequest;
    }
}

