/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.xml.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.namespace.NamespaceContext;

public class AtlasXmlNamespaceContext
implements NamespaceContext {
    protected Map<String, String> nsMap = new HashMap<String, String>();
    private int nsIndex = 1;

    public AtlasXmlNamespaceContext() {
        this.nsMap.put("xs", "http://www.w3.org/2001/XMLSchema");
        this.nsMap.put("ss", "http://atlasmap.io/xml/schemaset/v2");
    }

    public void add(String prefix, String uri) {
        this.nsMap.put(prefix, uri);
    }

    public String addWithIndex(String uri) {
        String prefix = "ns" + this.nsIndex++;
        while (this.nsMap.containsKey(prefix)) {
            prefix = "ns" + this.nsIndex++;
        }
        this.add(prefix, uri);
        return prefix;
    }

    public Map<String, String> getNamespaceMap() {
        return Collections.unmodifiableMap(this.nsMap);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.nsMap.get(prefix);
    }

    @Override
    public String getPrefix(String namespaceURI) {
        if (namespaceURI == null || namespaceURI.isEmpty()) {
            return null;
        }
        Optional<Map.Entry> entry = this.nsMap.entrySet().stream().filter(e -> namespaceURI.equals(e.getValue())).findFirst();
        return entry.isPresent() ? (String)entry.get().getKey() : null;
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        if (namespaceURI == null || namespaceURI.isEmpty()) {
            return null;
        }
        return this.nsMap.entrySet().stream().filter(e -> namespaceURI.equals(e.getValue())).map(Map.Entry::getKey).collect(Collectors.toList()).iterator();
    }
}

