/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.xml.inspect;

import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.FieldType;
import io.atlasmap.xml.inspect.BaseXmlInspectionServiceTest;
import io.atlasmap.xml.inspect.XmlInspectionException;
import io.atlasmap.xml.inspect.XmlInspectionService;
import io.atlasmap.xml.v2.XmlComplexType;
import io.atlasmap.xml.v2.XmlDocument;
import io.atlasmap.xml.v2.XmlField;
import io.atlasmap.xml.v2.XmlNamespace;
import java.io.File;
import java.nio.file.Paths;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class XmlSchemaInspectionMultipleNamespacesTest
extends BaseXmlInspectionServiceTest {
    @Test
    public void testMultipleNamespaces() throws Exception {
        File schemaFile = Paths.get("src/test/resources/inspect/multiple-namespaces-schemaset.xml", new String[0]).toFile();
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument answer = service.inspectSchema(schemaFile);
        Assertions.assertEquals((int)3, (int)answer.getXmlNamespaces().getXmlNamespace().size());
        block38: for (XmlNamespace namespace : answer.getXmlNamespaces().getXmlNamespace()) {
            switch (namespace.getAlias()) {
                case "tns": {
                    Assertions.assertEquals((Object)"io.atlasmap.xml.test:Root", (Object)namespace.getUri());
                    Assertions.assertEquals(null, (Object)namespace.isTargetNamespace());
                    continue block38;
                }
                case "first": {
                    Assertions.assertEquals((Object)"io.atlasmap.xml.test:First", (Object)namespace.getUri());
                    Assertions.assertEquals(null, (Object)namespace.isTargetNamespace());
                    continue block38;
                }
                case "second": {
                    Assertions.assertEquals((Object)"io.atlasmap.xml.test:Second", (Object)namespace.getUri());
                    Assertions.assertEquals(null, (Object)namespace.isTargetNamespace());
                    continue block38;
                }
            }
            Assertions.fail((String)String.format("Unknown alias '%s'", namespace.getAlias()));
        }
        List fields = answer.getFields().getField();
        Assertions.assertEquals((int)1, (int)fields.size());
        XmlComplexType complex = (XmlComplexType)XmlComplexType.class.cast(fields.get(0));
        Assertions.assertEquals((Object)"tns:RootDocument", (Object)complex.getName());
        List rootFields = complex.getXmlFields().getXmlField();
        Assertions.assertEquals((int)4, (int)rootFields.size());
        block39: for (XmlField xmlField : rootFields) {
            switch (xmlField.getName()) {
                case "Name": {
                    Assertions.assertEquals((Object)FieldType.STRING, (Object)xmlField.getFieldType());
                    Assertions.assertEquals((Object)"/tns:RootDocument/Name", (Object)xmlField.getPath());
                    break;
                }
                case "Value": {
                    Assertions.assertEquals((Object)FieldType.STRING, (Object)xmlField.getFieldType());
                    Assertions.assertEquals((Object)"/tns:RootDocument/Value", (Object)xmlField.getPath());
                    break;
                }
                case "first:FirstElement": {
                    Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)xmlField.getFieldType());
                    Assertions.assertEquals((Object)"/tns:RootDocument/first:FirstElement", (Object)xmlField.getPath());
                    List firstFields = ((XmlComplexType)XmlComplexType.class.cast(xmlField)).getXmlFields().getXmlField();
                    Assertions.assertEquals((int)2, (int)firstFields.size());
                    block40: for (XmlField firstField : firstFields) {
                        switch (firstField.getName()) {
                            case "Name": {
                                Assertions.assertEquals((Object)FieldType.STRING, (Object)firstField.getFieldType());
                                Assertions.assertEquals((Object)"/tns:RootDocument/first:FirstElement/Name", (Object)firstField.getPath());
                                continue block40;
                            }
                            case "Value": {
                                Assertions.assertEquals((Object)FieldType.STRING, (Object)firstField.getFieldType());
                                Assertions.assertEquals((Object)"/tns:RootDocument/first:FirstElement/Value", (Object)firstField.getPath());
                                continue block40;
                            }
                        }
                        Assertions.fail((String)String.format("Unknown field '%s'", firstField.getPath()));
                    }
                    continue block39;
                }
                case "second:SecondElement": {
                    Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)xmlField.getFieldType());
                    Assertions.assertEquals((Object)"/tns:RootDocument/second:SecondElement", (Object)xmlField.getPath());
                    List secondFields = ((XmlComplexType)XmlComplexType.class.cast(xmlField)).getXmlFields().getXmlField();
                    Assertions.assertEquals((int)2, (int)secondFields.size());
                    block41: for (XmlField secondField : secondFields) {
                        switch (secondField.getName()) {
                            case "Name": {
                                Assertions.assertEquals((Object)FieldType.STRING, (Object)secondField.getFieldType());
                                Assertions.assertEquals((Object)"/tns:RootDocument/second:SecondElement/Name", (Object)secondField.getPath());
                                continue block41;
                            }
                            case "Value": {
                                Assertions.assertEquals((Object)FieldType.STRING, (Object)secondField.getFieldType());
                                Assertions.assertEquals((Object)"/tns:RootDocument/second:SecondElement/Value", (Object)secondField.getPath());
                                continue block41;
                            }
                        }
                        Assertions.fail((String)String.format("Unknown field '%s'", secondField.getPath()));
                    }
                    continue block39;
                }
                default: {
                    Assertions.fail((String)String.format("Unknown field '%s'", xmlField.getPath()));
                }
            }
        }
    }

    @Test
    public void testMultipleNoNamespaceSchemas() throws Exception {
        File schemaFile = Paths.get("src/test/resources/inspect/multiple-no-namespace-schemas.xml", new String[0]).toFile();
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument answer = service.inspectSchema(schemaFile);
        Assertions.assertEquals((int)1, (int)answer.getXmlNamespaces().getXmlNamespace().size());
        XmlNamespace namespace = (XmlNamespace)answer.getXmlNamespaces().getXmlNamespace().get(0);
        Assertions.assertEquals((Object)"tns", (Object)namespace.getAlias());
        Assertions.assertEquals((Object)"io.atlasmap.xml.test:Root", (Object)namespace.getUri());
        Assertions.assertEquals(null, (Object)namespace.isTargetNamespace());
        Assertions.assertEquals((int)1, (int)answer.getFields().getField().size());
        XmlComplexType complex = (XmlComplexType)XmlComplexType.class.cast(answer.getFields().getField().get(0));
        Assertions.assertEquals((Object)"tns:RootDocument", (Object)complex.getName());
        Assertions.assertEquals((int)2, (int)complex.getXmlFields().getXmlField().size());
        block8: for (XmlField field : complex.getXmlFields().getXmlField()) {
            switch (field.getName()) {
                case "FirstElement": {
                    Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)field.getFieldType());
                    Assertions.assertEquals((Object)"/tns:RootDocument/FirstElement", (Object)field.getPath());
                    List firstFields = ((XmlComplexType)XmlComplexType.class.cast(field)).getXmlFields().getXmlField();
                    Assertions.assertEquals((int)1, (int)firstFields.size());
                    XmlField firstField = (XmlField)firstFields.get(0);
                    Assertions.assertEquals((Object)"FirstValue", (Object)firstField.getName());
                    Assertions.assertEquals((Object)FieldType.STRING, (Object)firstField.getFieldType());
                    Assertions.assertEquals((Object)"/tns:RootDocument/FirstElement/FirstValue", (Object)firstField.getPath());
                    continue block8;
                }
                case "SecondElement": {
                    Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)field.getFieldType());
                    Assertions.assertEquals((Object)"/tns:RootDocument/SecondElement", (Object)field.getPath());
                    List secondFields = ((XmlComplexType)XmlComplexType.class.cast(field)).getXmlFields().getXmlField();
                    Assertions.assertEquals((int)1, (int)secondFields.size());
                    XmlField secondField = (XmlField)secondFields.get(0);
                    Assertions.assertEquals((Object)"SecondValue", (Object)secondField.getName());
                    Assertions.assertEquals((Object)FieldType.STRING, (Object)secondField.getFieldType());
                    Assertions.assertEquals((Object)"/tns:RootDocument/SecondElement/SecondValue", (Object)secondField.getPath());
                    continue block8;
                }
            }
            Assertions.fail((String)String.format("Unknown field '%s'", field.getPath()));
        }
    }

    @Test
    public void testMultipleNoNamespaceRootSchema() throws Exception {
        File schemaFile = Paths.get("src/test/resources/inspect/multiple-no-namespace-root-schema.xml", new String[0]).toFile();
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument answer = service.inspectSchema(schemaFile);
        Assertions.assertEquals((int)1, (int)answer.getXmlNamespaces().getXmlNamespace().size());
        XmlNamespace namespace = (XmlNamespace)answer.getXmlNamespaces().getXmlNamespace().get(0);
        Assertions.assertEquals((Object)"second", (Object)namespace.getAlias());
        Assertions.assertEquals((Object)"io.atlasmap.xml.test:Second", (Object)namespace.getUri());
        Assertions.assertEquals(null, (Object)namespace.isTargetNamespace());
        Assertions.assertEquals((int)2, (int)answer.getFields().getField().size());
        XmlComplexType complex = (XmlComplexType)XmlComplexType.class.cast(answer.getFields().getField().get(1));
        Assertions.assertEquals((Object)"RootDocument", (Object)complex.getName());
        Assertions.assertEquals((int)2, (int)complex.getXmlFields().getXmlField().size());
        block8: for (XmlField field : complex.getXmlFields().getXmlField()) {
            switch (field.getName()) {
                case "FirstElement": {
                    Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)field.getFieldType());
                    Assertions.assertEquals((Object)"/RootDocument/FirstElement", (Object)field.getPath());
                    List firstFields = ((XmlComplexType)XmlComplexType.class.cast(field)).getXmlFields().getXmlField();
                    Assertions.assertEquals((int)1, (int)firstFields.size());
                    XmlField firstField = (XmlField)firstFields.get(0);
                    Assertions.assertEquals((Object)"FirstValue", (Object)firstField.getName());
                    Assertions.assertEquals((Object)FieldType.STRING, (Object)firstField.getFieldType());
                    Assertions.assertEquals((Object)"/RootDocument/FirstElement/FirstValue", (Object)firstField.getPath());
                    continue block8;
                }
                case "second:SecondElement": {
                    Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)field.getFieldType());
                    Assertions.assertEquals((Object)"/RootDocument/second:SecondElement", (Object)field.getPath());
                    List secondFields = ((XmlComplexType)XmlComplexType.class.cast(field)).getXmlFields().getXmlField();
                    Assertions.assertEquals((int)1, (int)secondFields.size());
                    XmlField secondField = (XmlField)secondFields.get(0);
                    Assertions.assertEquals((Object)"SecondValue", (Object)secondField.getName());
                    Assertions.assertEquals((Object)FieldType.STRING, (Object)secondField.getFieldType());
                    Assertions.assertEquals((Object)"/RootDocument/second:SecondElement/SecondValue", (Object)secondField.getPath());
                    continue block8;
                }
            }
            Assertions.fail((String)String.format("Unknown field '%s'", field.getPath()));
        }
    }

    @Test
    public void testMultipleNoNamespaceSchemasConflict() throws Exception {
        File schemaFile = Paths.get("src/test/resources/inspect/multiple-no-namespace-schemas-conflict.xml", new String[0]).toFile();
        XmlInspectionService service = new XmlInspectionService();
        Assertions.assertThrows(XmlInspectionException.class, () -> service.inspectSchema(schemaFile));
    }

    @Test
    public void testSyndesis() throws Exception {
        File schemaFile = Paths.get("src/test/resources/inspect/multiple-namespaces-syndesis.xml", new String[0]).toFile();
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument answer = service.inspectSchema(schemaFile);
        Assertions.assertEquals((int)1, (int)answer.getXmlNamespaces().getXmlNamespace().size());
        XmlNamespace namespace = (XmlNamespace)answer.getXmlNamespaces().getXmlNamespace().get(0);
        Assertions.assertEquals((Object)"tns", (Object)namespace.getAlias());
        Assertions.assertEquals((Object)"http://syndesis.io/v1/swagger-connector-template/request", (Object)namespace.getUri());
        Assertions.assertEquals(null, (Object)namespace.isTargetNamespace());
        List fields = answer.getFields().getField();
        Assertions.assertEquals((int)1, (int)fields.size());
        XmlComplexType complex = (XmlComplexType)XmlComplexType.class.cast(fields.get(0));
        Assertions.assertEquals((Object)"tns:request", (Object)complex.getName());
        List rootFields = complex.getXmlFields().getXmlField();
        Assertions.assertEquals((int)1, (int)rootFields.size());
        complex = (XmlComplexType)XmlComplexType.class.cast(rootFields.get(0));
        Assertions.assertEquals((Object)"tns:body", (Object)complex.getName());
        List bodyFields = complex.getXmlFields().getXmlField();
        Assertions.assertEquals((int)1, (int)bodyFields.size());
        complex = (XmlComplexType)XmlComplexType.class.cast(bodyFields.get(0));
        Assertions.assertEquals((Object)"Pet", (Object)complex.getName());
        List petFields = complex.getXmlFields().getXmlField();
        Assertions.assertEquals((int)6, (int)petFields.size());
        block32: for (XmlField xmlField : petFields) {
            switch (xmlField.getName()) {
                case "id": {
                    Assertions.assertEquals((Object)FieldType.DECIMAL, (Object)xmlField.getFieldType());
                    Assertions.assertEquals((Object)"/tns:request/tns:body/Pet/id", (Object)xmlField.getPath());
                    break;
                }
                case "Category": {
                    Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)xmlField.getFieldType());
                    Assertions.assertEquals((Object)"/tns:request/tns:body/Pet/Category", (Object)xmlField.getPath());
                    List categoryFields = ((XmlComplexType)XmlComplexType.class.cast(xmlField)).getXmlFields().getXmlField();
                    Assertions.assertEquals((int)2, (int)categoryFields.size());
                    block33: for (XmlField categoryField : categoryFields) {
                        switch (categoryField.getName()) {
                            case "id": {
                                Assertions.assertEquals((Object)FieldType.DECIMAL, (Object)categoryField.getFieldType());
                                Assertions.assertEquals((Object)"/tns:request/tns:body/Pet/Category/id", (Object)categoryField.getPath());
                                continue block33;
                            }
                            case "name": {
                                Assertions.assertEquals((Object)FieldType.STRING, (Object)categoryField.getFieldType());
                                Assertions.assertEquals((Object)"/tns:request/tns:body/Pet/Category/name", (Object)categoryField.getPath());
                                continue block33;
                            }
                        }
                        Assertions.fail((String)String.format("Unknown field '%s'", categoryField.getPath()));
                    }
                    continue block32;
                }
                case "name": {
                    Assertions.assertEquals((Object)FieldType.STRING, (Object)xmlField.getFieldType());
                    Assertions.assertEquals((Object)"/tns:request/tns:body/Pet/name", (Object)xmlField.getPath());
                    break;
                }
                case "photoUrl": {
                    Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)xmlField.getFieldType());
                    Assertions.assertEquals((Object)"/tns:request/tns:body/Pet/photoUrl", (Object)xmlField.getPath());
                    List photoUrlFields = ((XmlComplexType)XmlComplexType.class.cast(xmlField)).getXmlFields().getXmlField();
                    Assertions.assertEquals((int)1, (int)photoUrlFields.size());
                    XmlField photoUrlField = (XmlField)photoUrlFields.get(0);
                    Assertions.assertEquals((Object)FieldType.STRING, (Object)photoUrlField.getFieldType());
                    Assertions.assertEquals((Object)"/tns:request/tns:body/Pet/photoUrl/photoUrl<>", (Object)photoUrlField.getPath());
                    Assertions.assertEquals((Object)CollectionType.LIST, (Object)photoUrlField.getCollectionType());
                    break;
                }
                case "tag": {
                    Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)xmlField.getFieldType());
                    Assertions.assertEquals((Object)"/tns:request/tns:body/Pet/tag", (Object)xmlField.getPath());
                    List tagFields = ((XmlComplexType)XmlComplexType.class.cast(xmlField)).getXmlFields().getXmlField();
                    Assertions.assertEquals((int)1, (int)tagFields.size());
                    XmlField tagField = (XmlField)tagFields.get(0);
                    Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)tagField.getFieldType());
                    Assertions.assertEquals((Object)"/tns:request/tns:body/Pet/tag/Tag<>", (Object)tagField.getPath());
                    Assertions.assertEquals((Object)CollectionType.LIST, (Object)tagField.getCollectionType());
                    List tagTagFields = ((XmlComplexType)XmlComplexType.class.cast(tagField)).getXmlFields().getXmlField();
                    Assertions.assertEquals((int)2, (int)tagTagFields.size());
                    block34: for (XmlField tagTagField : tagTagFields) {
                        switch (tagTagField.getName()) {
                            case "id": {
                                Assertions.assertEquals((Object)FieldType.DECIMAL, (Object)tagTagField.getFieldType());
                                Assertions.assertEquals((Object)"/tns:request/tns:body/Pet/tag/Tag<>/id", (Object)tagTagField.getPath());
                                continue block34;
                            }
                            case "name": {
                                Assertions.assertEquals((Object)FieldType.STRING, (Object)tagTagField.getFieldType());
                                Assertions.assertEquals((Object)"/tns:request/tns:body/Pet/tag/Tag<>/name", (Object)tagTagField.getPath());
                                continue block34;
                            }
                        }
                        Assertions.fail((String)String.format("Unknown field '%s'", tagTagField.getPath()));
                    }
                    continue block32;
                }
                case "status": {
                    Assertions.assertEquals((Object)FieldType.STRING, (Object)xmlField.getFieldType());
                    Assertions.assertEquals((Object)"/tns:request/tns:body/Pet/status", (Object)xmlField.getPath());
                    break;
                }
                default: {
                    Assertions.fail((String)String.format("Unknown field '%s'", xmlField.getPath()));
                }
            }
        }
    }
}

