/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.xml.inspect;

import io.atlasmap.xml.inspect.BaseXmlInspectionServiceTest;
import io.atlasmap.xml.inspect.XmlInspectionService;
import io.atlasmap.xml.v2.XmlComplexType;
import io.atlasmap.xml.v2.XmlDocument;
import io.atlasmap.xml.v2.XmlField;
import java.io.File;
import java.nio.file.Paths;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class XmlSchemaInspectionFormTest
extends BaseXmlInspectionServiceTest {
    @Test
    public void testInspectSchemaFileFormNoDefault() throws Exception {
        File schemaFile = Paths.get("src/test/resources/inspect/form-no-default-schema.xsd", new String[0]).toFile();
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument xmlDocument = service.inspectSchema(schemaFile);
        this.assertDefaultUnqualified(xmlDocument);
    }

    @Test
    public void testInspectSchemaFileFormDefaultUnqualified() throws Exception {
        File schemaFile = Paths.get("src/test/resources/inspect/form-default-unqualified-schema.xsd", new String[0]).toFile();
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument xmlDocument = service.inspectSchema(schemaFile);
        this.assertDefaultUnqualified(xmlDocument);
    }

    private void assertDefaultUnqualified(XmlDocument xmlDocument) throws Exception {
        Assertions.assertNotNull((Object)xmlDocument);
        Assertions.assertNotNull((Object)xmlDocument.getFields());
        Assertions.assertEquals((int)1, (int)xmlDocument.getFields().getField().size());
        XmlComplexType a = (XmlComplexType)xmlDocument.getFields().getField().get(0);
        Assertions.assertNotNull((Object)a);
        Assertions.assertEquals((Object)"tns:a", (Object)a.getName());
        Assertions.assertEquals((int)6, (int)a.getXmlFields().getXmlField().size());
        XmlComplexType aa = (XmlComplexType)a.getXmlFields().getXmlField().get(3);
        Assertions.assertEquals((Object)"aa", (Object)aa.getName());
        Assertions.assertEquals((int)4, (int)aa.getXmlFields().getXmlField().size());
        XmlField aaa = (XmlField)aa.getXmlFields().getXmlField().get(1);
        Assertions.assertEquals((Object)"aaa", (Object)aaa.getName());
        XmlField aab = (XmlField)aa.getXmlFields().getXmlField().get(2);
        Assertions.assertEquals((Object)"tns:aab", (Object)aab.getName());
        XmlField aac = (XmlField)aa.getXmlFields().getXmlField().get(3);
        Assertions.assertEquals((Object)"aac", (Object)aac.getName());
        XmlField aad = (XmlField)aa.getXmlFields().getXmlField().get(0);
        Assertions.assertEquals((Object)"aad", (Object)aad.getName());
        XmlComplexType ab = (XmlComplexType)a.getXmlFields().getXmlField().get(4);
        Assertions.assertEquals((Object)"tns:ab", (Object)ab.getName());
        XmlField aba = (XmlField)ab.getXmlFields().getXmlField().get(1);
        Assertions.assertEquals((Object)"aba", (Object)aba.getName());
        XmlField abb = (XmlField)ab.getXmlFields().getXmlField().get(2);
        Assertions.assertEquals((Object)"tns:abb", (Object)abb.getName());
        XmlField abc = (XmlField)ab.getXmlFields().getXmlField().get(3);
        Assertions.assertEquals((Object)"abc", (Object)abc.getName());
        XmlField abd = (XmlField)ab.getXmlFields().getXmlField().get(0);
        Assertions.assertEquals((Object)"abd", (Object)abd.getName());
        XmlComplexType ac = (XmlComplexType)a.getXmlFields().getXmlField().get(5);
        Assertions.assertEquals((Object)"ac", (Object)ac.getName());
        XmlField aca = (XmlField)ac.getXmlFields().getXmlField().get(1);
        Assertions.assertEquals((Object)"aca", (Object)aca.getName());
        XmlField acb = (XmlField)ac.getXmlFields().getXmlField().get(2);
        Assertions.assertEquals((Object)"tns:acb", (Object)acb.getName());
        XmlField acc = (XmlField)ac.getXmlFields().getXmlField().get(3);
        Assertions.assertEquals((Object)"acc", (Object)acc.getName());
        XmlField acd = (XmlField)ac.getXmlFields().getXmlField().get(0);
        Assertions.assertEquals((Object)"acd", (Object)acd.getName());
        XmlField ad = (XmlField)a.getXmlFields().getXmlField().get(0);
        Assertions.assertEquals((Object)"ad", (Object)ad.getName());
        XmlField ae = (XmlField)a.getXmlFields().getXmlField().get(1);
        Assertions.assertEquals((Object)"tns:ae", (Object)ae.getName());
        XmlField af = (XmlField)a.getXmlFields().getXmlField().get(2);
        Assertions.assertEquals((Object)"af", (Object)af.getName());
    }

    @Test
    public void testInspectSchemaFileFormDefaultQualified() throws Exception {
        File schemaFile = Paths.get("src/test/resources/inspect/form-default-qualified-schema.xsd", new String[0]).toFile();
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument xmlDocument = service.inspectSchema(schemaFile);
        Assertions.assertNotNull((Object)xmlDocument);
        Assertions.assertNotNull((Object)xmlDocument.getFields());
        Assertions.assertEquals((int)1, (int)xmlDocument.getFields().getField().size());
        XmlComplexType a = (XmlComplexType)xmlDocument.getFields().getField().get(0);
        Assertions.assertNotNull((Object)a);
        Assertions.assertEquals((Object)"tns:a", (Object)a.getName());
        Assertions.assertEquals((int)6, (int)a.getXmlFields().getXmlField().size());
        XmlComplexType aa = (XmlComplexType)a.getXmlFields().getXmlField().get(3);
        Assertions.assertEquals((Object)"tns:aa", (Object)aa.getName());
        Assertions.assertEquals((int)4, (int)aa.getXmlFields().getXmlField().size());
        XmlField aaa = (XmlField)aa.getXmlFields().getXmlField().get(1);
        Assertions.assertEquals((Object)"tns:aaa", (Object)aaa.getName());
        XmlField aab = (XmlField)aa.getXmlFields().getXmlField().get(2);
        Assertions.assertEquals((Object)"tns:aab", (Object)aab.getName());
        XmlField aac = (XmlField)aa.getXmlFields().getXmlField().get(3);
        Assertions.assertEquals((Object)"aac", (Object)aac.getName());
        XmlField aad = (XmlField)aa.getXmlFields().getXmlField().get(0);
        Assertions.assertEquals((Object)"tns:aad", (Object)aad.getName());
        XmlComplexType ab = (XmlComplexType)a.getXmlFields().getXmlField().get(4);
        Assertions.assertEquals((Object)"tns:ab", (Object)ab.getName());
        XmlField aba = (XmlField)ab.getXmlFields().getXmlField().get(1);
        Assertions.assertEquals((Object)"tns:aba", (Object)aba.getName());
        XmlField abb = (XmlField)ab.getXmlFields().getXmlField().get(2);
        Assertions.assertEquals((Object)"tns:abb", (Object)abb.getName());
        XmlField abc = (XmlField)ab.getXmlFields().getXmlField().get(3);
        Assertions.assertEquals((Object)"abc", (Object)abc.getName());
        XmlField abd = (XmlField)ab.getXmlFields().getXmlField().get(0);
        Assertions.assertEquals((Object)"tns:abd", (Object)abd.getName());
        XmlComplexType ac = (XmlComplexType)a.getXmlFields().getXmlField().get(5);
        Assertions.assertEquals((Object)"ac", (Object)ac.getName());
        XmlField aca = (XmlField)ac.getXmlFields().getXmlField().get(1);
        Assertions.assertEquals((Object)"tns:aca", (Object)aca.getName());
        XmlField acb = (XmlField)ac.getXmlFields().getXmlField().get(2);
        Assertions.assertEquals((Object)"tns:acb", (Object)acb.getName());
        XmlField acc = (XmlField)ac.getXmlFields().getXmlField().get(3);
        Assertions.assertEquals((Object)"acc", (Object)acc.getName());
        XmlField acd = (XmlField)ac.getXmlFields().getXmlField().get(0);
        Assertions.assertEquals((Object)"tns:acd", (Object)acd.getName());
        XmlField ad = (XmlField)a.getXmlFields().getXmlField().get(0);
        Assertions.assertEquals((Object)"tns:ad", (Object)ad.getName());
        XmlField ae = (XmlField)a.getXmlFields().getXmlField().get(1);
        Assertions.assertEquals((Object)"tns:ae", (Object)ae.getName());
        XmlField af = (XmlField)a.getXmlFields().getXmlField().get(2);
        Assertions.assertEquals((Object)"af", (Object)af.getName());
    }
}

