/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.xml.inspect;

import io.atlasmap.v2.FieldType;
import io.atlasmap.xml.inspect.BaseXmlInspectionServiceTest;
import io.atlasmap.xml.inspect.XmlInspectionService;
import io.atlasmap.xml.v2.XmlComplexType;
import io.atlasmap.xml.v2.XmlDocument;
import io.atlasmap.xml.v2.XmlField;
import java.io.File;
import java.nio.file.Paths;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class XmlSchemaInspectionFhirTest
extends BaseXmlInspectionServiceTest {
    @Test
    public void test() throws Exception {
        File schemaFile = Paths.get("src/test/resources/inspect/fhir-patient.xsd", new String[0]).toFile();
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument xmlDocument = service.inspectSchema(schemaFile);
        Assertions.assertNotNull((Object)xmlDocument);
        Assertions.assertNotNull((Object)xmlDocument.getFields());
        Assertions.assertEquals((int)1, (int)xmlDocument.getFields().getField().size());
        XmlComplexType root = (XmlComplexType)xmlDocument.getFields().getField().get(0);
        Assertions.assertNotNull((Object)root);
        Assertions.assertEquals((int)26, (int)root.getXmlFields().getXmlField().size());
        XmlComplexType id = (XmlComplexType)root.getXmlFields().getXmlField().get(0);
        Assertions.assertEquals((Object)"tns:id", (Object)id.getName());
        Assertions.assertEquals((int)2, (int)id.getXmlFields().getXmlField().size());
        XmlField value = (XmlField)id.getXmlFields().getXmlField().get(0);
        Assertions.assertEquals((Object)"value", (Object)value.getName());
        Assertions.assertTrue((boolean)value.isAttribute());
        XmlComplexType extension = (XmlComplexType)id.getXmlFields().getXmlField().get(1);
        Assertions.assertEquals((Object)"tns:extension", (Object)extension.getName());
        Assertions.assertNull((Object)extension.getStatus());
        Assertions.assertEquals((int)40, (int)extension.getXmlFields().getXmlField().size());
        XmlComplexType meta = (XmlComplexType)root.getXmlFields().getXmlField().get(1);
        Assertions.assertEquals((Object)"tns:meta", (Object)meta.getName());
        Assertions.assertNull((Object)meta.getStatus());
        XmlComplexType name = (XmlComplexType)root.getXmlFields().getXmlField().get(9);
        Assertions.assertEquals((Object)"tns:name", (Object)name.getName());
        Assertions.assertEquals((int)8, (int)name.getXmlFields().getXmlField().size());
        XmlComplexType family = (XmlComplexType)name.getXmlFields().getXmlField().get(3);
        Assertions.assertEquals((Object)"tns:family", (Object)family.getName());
        Assertions.assertEquals((int)2, (int)family.getXmlFields().getXmlField().size());
        XmlField familyValue = (XmlField)family.getXmlFields().getXmlField().get(0);
        Assertions.assertEquals((Object)FieldType.STRING, (Object)familyValue.getFieldType());
        Assertions.assertTrue((boolean)familyValue.isAttribute());
        XmlComplexType given = (XmlComplexType)name.getXmlFields().getXmlField().get(4);
        Assertions.assertEquals((Object)"tns:given", (Object)given.getName());
        Assertions.assertEquals((int)2, (int)given.getXmlFields().getXmlField().size());
        XmlField givenValue = (XmlField)given.getXmlFields().getXmlField().get(0);
        Assertions.assertEquals((Object)FieldType.STRING, (Object)givenValue.getFieldType());
        Assertions.assertTrue((boolean)givenValue.isAttribute());
    }
}

