/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.xml.inspect;

import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.FieldType;
import io.atlasmap.xml.inspect.BaseXmlInspectionServiceTest;
import io.atlasmap.xml.inspect.XmlInspectionException;
import io.atlasmap.xml.inspect.XmlInspectionService;
import io.atlasmap.xml.v2.Restriction;
import io.atlasmap.xml.v2.RestrictionType;
import io.atlasmap.xml.v2.XmlComplexType;
import io.atlasmap.xml.v2.XmlDocument;
import io.atlasmap.xml.v2.XmlEnumField;
import io.atlasmap.xml.v2.XmlField;
import io.atlasmap.xml.v2.XmlNamespace;
import java.io.File;
import java.nio.file.Paths;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class XmlSchemaInspectionTest
extends BaseXmlInspectionServiceTest {
    @Test
    public void testInspectSchemaString() throws Exception {
        String source = "<xs:schema attributeFormDefault=\"unqualified\" elementFormDefault=\"qualified\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">\n  <xs:element name=\"data\">\n    <xs:complexType>\n      <xs:sequence>\n        <xs:element type=\"xs:int\" name=\"intField\"/>\n        <xs:element type=\"xs:long\" name=\"longField\"/>\n        <xs:element type=\"xs:string\" name=\"stringField\"/>\n        <xs:element type=\"xs:boolean\" name=\"booleanField\"/>\n        <xs:element type=\"xs:double\" name=\"doubleField\"/>\n        <xs:element type=\"xs:short\" name=\"shortField\"/>\n        <xs:element type=\"xs:float\" name=\"floatField\"/>\n        <xs:element type=\"xs:string\" name=\"charField\"/>\n      </xs:sequence>\n    </xs:complexType>\n  </xs:element>\n</xs:schema>";
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument xmlDocument = service.inspectSchema("<xs:schema attributeFormDefault=\"unqualified\" elementFormDefault=\"qualified\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">\n  <xs:element name=\"data\">\n    <xs:complexType>\n      <xs:sequence>\n        <xs:element type=\"xs:int\" name=\"intField\"/>\n        <xs:element type=\"xs:long\" name=\"longField\"/>\n        <xs:element type=\"xs:string\" name=\"stringField\"/>\n        <xs:element type=\"xs:boolean\" name=\"booleanField\"/>\n        <xs:element type=\"xs:double\" name=\"doubleField\"/>\n        <xs:element type=\"xs:short\" name=\"shortField\"/>\n        <xs:element type=\"xs:float\" name=\"floatField\"/>\n        <xs:element type=\"xs:string\" name=\"charField\"/>\n      </xs:sequence>\n    </xs:complexType>\n  </xs:element>\n</xs:schema>");
        Assertions.assertNotNull((Object)xmlDocument);
        Assertions.assertNotNull((Object)xmlDocument.getFields());
        Assertions.assertEquals((int)1, (int)xmlDocument.getFields().getField().size());
        XmlComplexType root = (XmlComplexType)xmlDocument.getFields().getField().get(0);
        Assertions.assertNotNull((Object)root);
        Assertions.assertEquals((int)8, (int)root.getXmlFields().getXmlField().size());
    }

    @Test
    public void testInspectSchemaFile() throws Exception {
        File schemaFile = Paths.get("src/test/resources/inspect/simple-schema.xsd", new String[0]).toFile();
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument xmlDocument = service.inspectSchema(schemaFile);
        Assertions.assertNotNull((Object)xmlDocument);
        Assertions.assertNotNull((Object)xmlDocument.getFields());
        Assertions.assertEquals((int)1, (int)xmlDocument.getFields().getField().size());
        XmlComplexType root = (XmlComplexType)xmlDocument.getFields().getField().get(0);
        Assertions.assertNotNull((Object)root);
        Assertions.assertEquals((int)15, (int)root.getXmlFields().getXmlField().size());
        XmlField nmtokenField = (XmlField)root.getXmlFields().getXmlField().get(8);
        Assertions.assertEquals((Object)"nmtokenField", (Object)nmtokenField.getName());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)nmtokenField.getFieldType());
        XmlField anyuriField = (XmlField)root.getXmlFields().getXmlField().get(9);
        Assertions.assertEquals((Object)"anyuriField", (Object)anyuriField.getName());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)anyuriField.getFieldType());
        XmlField base64BinaryField = (XmlField)root.getXmlFields().getXmlField().get(10);
        Assertions.assertEquals((Object)"base64binaryField", (Object)base64BinaryField.getName());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)base64BinaryField.getFieldType());
        XmlField byteField = (XmlField)root.getXmlFields().getXmlField().get(11);
        Assertions.assertEquals((Object)"byteField", (Object)byteField.getName());
        Assertions.assertEquals((Object)FieldType.SHORT, (Object)byteField.getFieldType());
        XmlField unsignedByteField = (XmlField)root.getXmlFields().getXmlField().get(12);
        Assertions.assertEquals((Object)"unsignedByteField", (Object)unsignedByteField.getName());
        Assertions.assertEquals((Object)FieldType.UNSIGNED_SHORT, (Object)unsignedByteField.getFieldType());
        XmlField hexBinaryField = (XmlField)root.getXmlFields().getXmlField().get(13);
        Assertions.assertEquals((Object)"hexBinaryField", (Object)hexBinaryField.getName());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)hexBinaryField.getFieldType());
        XmlField qnameField = (XmlField)root.getXmlFields().getXmlField().get(14);
        Assertions.assertEquals((Object)"qnameField", (Object)qnameField.getName());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)qnameField.getFieldType());
    }

    @Test
    public void testInspectSchemaFileComplex() throws Exception {
        File schemaFile = Paths.get("src/test/resources/inspect/complex-schema.xsd", new String[0]).toFile();
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument xmlDocument = service.inspectSchema(schemaFile);
        Assertions.assertNotNull((Object)xmlDocument);
        Assertions.assertNotNull((Object)xmlDocument.getFields());
        Assertions.assertEquals((int)1, (int)xmlDocument.getFields().getField().size());
        XmlComplexType root = (XmlComplexType)xmlDocument.getFields().getField().get(0);
        Assertions.assertNotNull((Object)root);
        Assertions.assertEquals((int)10, (int)root.getXmlFields().getXmlField().size());
        XmlField enumField = (XmlField)root.getXmlFields().getXmlField().get(9);
        Assertions.assertEquals((Object)"enumField", (Object)enumField.getName());
        Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)enumField.getFieldType());
        XmlComplexType enumComplex = (XmlComplexType)enumField;
        Assertions.assertTrue((boolean)enumComplex.isEnumeration());
        List enumFields = enumComplex.getXmlEnumFields().getXmlEnumField();
        Assertions.assertEquals((int)6, (int)enumFields.size());
        Assertions.assertEquals((Object)"aaa", (Object)((XmlEnumField)enumFields.get(0)).getName());
        Assertions.assertEquals((Object)"fff", (Object)((XmlEnumField)enumFields.get(5)).getName());
    }

    @Test
    public void testInspectSchemaFileWithNamespace() throws Exception {
        File schemaFile = Paths.get("src/test/resources/inspect/simple-namespace-schema.xsd", new String[0]).toFile();
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument xmlDocument = service.inspectSchema(schemaFile);
        Assertions.assertNotNull((Object)xmlDocument);
        Assertions.assertNotNull((Object)xmlDocument.getFields());
        Assertions.assertEquals((int)1, (int)xmlDocument.getFields().getField().size());
        Assertions.assertNotNull((Object)xmlDocument.getXmlNamespaces());
        Assertions.assertEquals((int)1, (int)xmlDocument.getXmlNamespaces().getXmlNamespace().size());
        XmlNamespace namespace = (XmlNamespace)xmlDocument.getXmlNamespaces().getXmlNamespace().get(0);
        Assertions.assertEquals((Object)"tns", (Object)namespace.getAlias());
        Assertions.assertEquals((Object)"http://example.com/", (Object)namespace.getUri());
    }

    @Test
    public void testInspectShipOrderSchemaFile() throws Exception {
        File schemaFile = Paths.get("src/test/resources/inspect/ship-order-schema.xsd", new String[0]).toFile();
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument xmlDocument = service.inspectSchema(schemaFile);
        Assertions.assertNotNull((Object)xmlDocument);
        Assertions.assertNotNull((Object)xmlDocument.getFields());
        Assertions.assertEquals((int)1, (int)xmlDocument.getFields().getField().size());
        XmlComplexType root = (XmlComplexType)xmlDocument.getFields().getField().get(0);
        Assertions.assertNotNull((Object)root);
        Assertions.assertEquals((int)4, (int)root.getXmlFields().getXmlField().size());
        XmlField orderIdAttr = (XmlField)root.getXmlFields().getXmlField().get(0);
        Assertions.assertNotNull((Object)orderIdAttr);
        Assertions.assertEquals((Object)"orderid", (Object)orderIdAttr.getName());
        Assertions.assertEquals((Object)"2", (Object)orderIdAttr.getValue());
        Assertions.assertEquals((Object)"/shiporder/@orderid", (Object)orderIdAttr.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)orderIdAttr.getFieldType());
        Assertions.assertEquals((Object)true, (Object)orderIdAttr.isAttribute());
        XmlField orderPerson = (XmlField)root.getXmlFields().getXmlField().get(1);
        Assertions.assertNotNull((Object)orderPerson);
        Assertions.assertEquals((Object)"orderperson", (Object)orderPerson.getName());
        Assertions.assertNull((Object)orderPerson.getValue());
        Assertions.assertEquals((Object)"/shiporder/orderperson", (Object)orderPerson.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)orderPerson.getFieldType());
        Assertions.assertEquals((Object)false, (Object)orderPerson.isAttribute());
        XmlField shipTo = (XmlField)root.getXmlFields().getXmlField().get(2);
        Assertions.assertNotNull((Object)shipTo);
        Assertions.assertTrue((boolean)(shipTo instanceof XmlComplexType));
        Assertions.assertEquals((int)4, (int)((XmlComplexType)shipTo).getXmlFields().getXmlField().size());
        XmlField item = (XmlField)root.getXmlFields().getXmlField().get(3);
        Assertions.assertNotNull((Object)item);
        Assertions.assertTrue((boolean)(item instanceof XmlComplexType));
        Assertions.assertEquals((int)4, (int)((XmlComplexType)item).getXmlFields().getXmlField().size());
    }

    @Test
    public void testInspectPOExampleSchemaFile() throws Exception {
        File schemaFile = Paths.get("src/test/resources/inspect/po-example-schema.xsd", new String[0]).toFile();
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument xmlDocument = service.inspectSchema(schemaFile);
        Assertions.assertNotNull((Object)xmlDocument);
        Assertions.assertNotNull((Object)xmlDocument.getFields());
        Assertions.assertEquals((int)2, (int)xmlDocument.getFields().getField().size());
        XmlComplexType purchaseOrder = (XmlComplexType)xmlDocument.getFields().getField().get(0);
        Assertions.assertNotNull((Object)purchaseOrder);
        Assertions.assertEquals((int)5, (int)purchaseOrder.getXmlFields().getXmlField().size());
        XmlField orderDateAttr = (XmlField)purchaseOrder.getXmlFields().getXmlField().get(0);
        Assertions.assertNotNull((Object)orderDateAttr);
        Assertions.assertEquals((Object)"orderDate", (Object)orderDateAttr.getName());
        Assertions.assertNull((Object)orderDateAttr.getValue());
        Assertions.assertEquals((Object)"/tns:purchaseOrder/@orderDate", (Object)orderDateAttr.getPath());
        Assertions.assertEquals((Object)FieldType.DATE, (Object)orderDateAttr.getFieldType());
        Assertions.assertEquals((Object)true, (Object)orderDateAttr.isAttribute());
        XmlField shipTo = (XmlField)purchaseOrder.getXmlFields().getXmlField().get(1);
        Assertions.assertNotNull((Object)shipTo);
        Assertions.assertEquals((Object)"shipTo", (Object)shipTo.getName());
        Assertions.assertNull((Object)shipTo.getValue());
        Assertions.assertEquals((Object)"/tns:purchaseOrder/shipTo", (Object)shipTo.getPath());
        Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)shipTo.getFieldType());
        Assertions.assertEquals((int)6, (int)((XmlComplexType)shipTo).getXmlFields().getXmlField().size());
        XmlField shipToCountry = (XmlField)((XmlComplexType)shipTo).getXmlFields().getXmlField().get(0);
        Assertions.assertNotNull((Object)shipTo);
        Assertions.assertEquals((Object)"country", (Object)shipToCountry.getName());
        Assertions.assertEquals((Object)"US", (Object)shipToCountry.getValue());
        Assertions.assertEquals((Object)"/tns:purchaseOrder/shipTo/@country", (Object)shipToCountry.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)shipToCountry.getFieldType());
        Assertions.assertEquals((Object)true, (Object)shipToCountry.isAttribute());
        XmlField shipToName = (XmlField)((XmlComplexType)shipTo).getXmlFields().getXmlField().get(1);
        Assertions.assertNotNull((Object)shipToName);
        Assertions.assertEquals((Object)"name", (Object)shipToName.getName());
        Assertions.assertNull((Object)shipToName.getValue());
        Assertions.assertEquals((Object)"/tns:purchaseOrder/shipTo/name", (Object)shipToName.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)shipToName.getFieldType());
        Assertions.assertEquals((Object)false, (Object)shipToName.isAttribute());
        XmlField shipToStreet = (XmlField)((XmlComplexType)shipTo).getXmlFields().getXmlField().get(2);
        Assertions.assertNotNull((Object)shipToStreet);
        Assertions.assertEquals((Object)"street", (Object)shipToStreet.getName());
        Assertions.assertNull((Object)shipToStreet.getValue());
        Assertions.assertEquals((Object)"/tns:purchaseOrder/shipTo/street", (Object)shipToStreet.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)shipToStreet.getFieldType());
        Assertions.assertEquals((Object)false, (Object)shipToStreet.isAttribute());
        XmlField shipToCity = (XmlField)((XmlComplexType)shipTo).getXmlFields().getXmlField().get(3);
        Assertions.assertNotNull((Object)shipToCity);
        Assertions.assertEquals((Object)"city", (Object)shipToCity.getName());
        Assertions.assertNull((Object)shipToCity.getValue());
        Assertions.assertEquals((Object)"/tns:purchaseOrder/shipTo/city", (Object)shipToCity.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)shipToCity.getFieldType());
        Assertions.assertEquals((Object)false, (Object)shipToCity.isAttribute());
        XmlField shipToState = (XmlField)((XmlComplexType)shipTo).getXmlFields().getXmlField().get(4);
        Assertions.assertNotNull((Object)shipToState);
        Assertions.assertEquals((Object)"state", (Object)shipToState.getName());
        Assertions.assertNull((Object)shipToState.getValue());
        Assertions.assertEquals((Object)"/tns:purchaseOrder/shipTo/state", (Object)shipToState.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)shipToState.getFieldType());
        Assertions.assertEquals((Object)false, (Object)shipToState.isAttribute());
        XmlField shipToZip = (XmlField)((XmlComplexType)shipTo).getXmlFields().getXmlField().get(5);
        Assertions.assertNotNull((Object)shipToZip);
        Assertions.assertEquals((Object)"zip", (Object)shipToZip.getName());
        Assertions.assertNull((Object)shipToZip.getValue());
        Assertions.assertEquals((Object)"/tns:purchaseOrder/shipTo/zip", (Object)shipToZip.getPath());
        Assertions.assertEquals((Object)FieldType.DECIMAL, (Object)shipToZip.getFieldType());
        Assertions.assertEquals((Object)false, (Object)shipToZip.isAttribute());
        XmlField comment = (XmlField)purchaseOrder.getXmlFields().getXmlField().get(3);
        Assertions.assertNotNull((Object)comment);
        Assertions.assertEquals((Object)"tns:comment", (Object)comment.getName());
        Assertions.assertNull((Object)comment.getValue());
        Assertions.assertEquals((Object)"/tns:purchaseOrder/tns:comment", (Object)comment.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)comment.getFieldType());
        Assertions.assertEquals((Object)false, (Object)comment.isAttribute());
        XmlField items = (XmlField)purchaseOrder.getXmlFields().getXmlField().get(4);
        Assertions.assertNotNull((Object)items);
        Assertions.assertEquals((Object)"items", (Object)items.getName());
        Assertions.assertNull((Object)items.getValue());
        Assertions.assertEquals((Object)"/tns:purchaseOrder/items", (Object)items.getPath());
        Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)items.getFieldType());
        Assertions.assertEquals((Object)false, (Object)items.isAttribute());
        Assertions.assertEquals((int)1, (int)((XmlComplexType)items).getXmlFields().getXmlField().size());
        XmlComplexType item = (XmlComplexType)((XmlComplexType)items).getXmlFields().getXmlField().get(0);
        Assertions.assertNotNull((Object)item);
        Assertions.assertEquals((Object)"item", (Object)item.getName());
        Assertions.assertNull((Object)item.getValue());
        Assertions.assertEquals((Object)"/tns:purchaseOrder/items/item", (Object)item.getPath());
        Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)item.getFieldType());
        Assertions.assertEquals((Object)false, (Object)item.isAttribute());
        Assertions.assertEquals((Object)CollectionType.LIST, (Object)item.getCollectionType());
        Assertions.assertEquals((int)6, (int)item.getXmlFields().getXmlField().size());
        XmlField partNum = (XmlField)item.getXmlFields().getXmlField().get(0);
        Assertions.assertNotNull((Object)partNum);
        Assertions.assertEquals((Object)"partNum", (Object)partNum.getName());
        Assertions.assertNull((Object)partNum.getValue());
        Assertions.assertEquals((Object)"/tns:purchaseOrder/items/item/@partNum", (Object)partNum.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)partNum.getFieldType());
        Assertions.assertEquals((Object)"SKU", (Object)partNum.getTypeName());
        Assertions.assertEquals((Object)true, (Object)partNum.isAttribute());
        XmlField productName = (XmlField)item.getXmlFields().getXmlField().get(1);
        Assertions.assertNotNull((Object)productName);
        Assertions.assertEquals((Object)"productName", (Object)productName.getName());
        Assertions.assertNull((Object)productName.getValue());
        Assertions.assertEquals((Object)"/tns:purchaseOrder/items/item/productName", (Object)productName.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)productName.getFieldType());
        Assertions.assertEquals((Object)false, (Object)productName.isAttribute());
        XmlField quantity = (XmlField)item.getXmlFields().getXmlField().get(2);
        Assertions.assertNotNull((Object)quantity);
        Assertions.assertEquals((Object)"quantity", (Object)quantity.getName());
        Assertions.assertNull((Object)quantity.getValue());
        Assertions.assertEquals((Object)"/tns:purchaseOrder/items/item/quantity", (Object)quantity.getPath());
        Assertions.assertEquals((Object)FieldType.BIG_INTEGER, (Object)quantity.getFieldType());
        Assertions.assertEquals((Object)false, (Object)quantity.isAttribute());
        Assertions.assertNotNull((Object)quantity.getRestrictions().getRestriction());
        Assertions.assertEquals((int)1, (int)quantity.getRestrictions().getRestriction().size());
        Restriction qRestriction = (Restriction)quantity.getRestrictions().getRestriction().get(0);
        Assertions.assertNotNull((Object)qRestriction);
        Assertions.assertNotNull((Object)qRestriction.getType());
        Assertions.assertEquals((Object)RestrictionType.MAX_EXCLUSIVE, (Object)qRestriction.getType());
        Assertions.assertNotNull((Object)qRestriction.getValue());
        Assertions.assertEquals((Object)"99", (Object)qRestriction.getValue());
        XmlField usPrice = (XmlField)item.getXmlFields().getXmlField().get(3);
        Assertions.assertNotNull((Object)usPrice);
        Assertions.assertEquals((Object)"USPrice", (Object)usPrice.getName());
        Assertions.assertNull((Object)usPrice.getValue());
        Assertions.assertEquals((Object)"/tns:purchaseOrder/items/item/USPrice", (Object)usPrice.getPath());
        Assertions.assertEquals((Object)FieldType.DECIMAL, (Object)usPrice.getFieldType());
        Assertions.assertEquals((Object)false, (Object)usPrice.isAttribute());
        XmlField itemComment = (XmlField)item.getXmlFields().getXmlField().get(4);
        Assertions.assertNotNull((Object)itemComment);
        Assertions.assertEquals((Object)"tns:comment", (Object)itemComment.getName());
        Assertions.assertNull((Object)itemComment.getValue());
        Assertions.assertEquals((Object)"/tns:purchaseOrder/items/item/tns:comment", (Object)itemComment.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)itemComment.getFieldType());
        Assertions.assertEquals((Object)false, (Object)itemComment.isAttribute());
        XmlField shipDate = (XmlField)item.getXmlFields().getXmlField().get(5);
        Assertions.assertNotNull((Object)shipDate);
        Assertions.assertEquals((Object)"shipDate", (Object)shipDate.getName());
        Assertions.assertNull((Object)shipDate.getValue());
        Assertions.assertEquals((Object)"/tns:purchaseOrder/items/item/shipDate", (Object)shipDate.getPath());
        Assertions.assertEquals((Object)FieldType.DATE, (Object)shipDate.getFieldType());
        Assertions.assertEquals((Object)false, (Object)shipDate.isAttribute());
        Assertions.assertNotNull((Object)xmlDocument.getXmlNamespaces());
        Assertions.assertEquals((int)1, (int)xmlDocument.getXmlNamespaces().getXmlNamespace().size());
        XmlNamespace namespace = (XmlNamespace)xmlDocument.getXmlNamespaces().getXmlNamespace().get(0);
        Assertions.assertEquals((Object)"tns", (Object)namespace.getAlias());
        Assertions.assertEquals((Object)"http://tempuri.org/po.xsd", (Object)namespace.getUri());
    }

    @Test
    public void testInspectSchemaStringAsSourceNull() throws Exception {
        XmlInspectionService service = new XmlInspectionService();
        String schema = null;
        Assertions.assertThrows(IllegalArgumentException.class, () -> service.inspectSchema(schema));
    }

    @Test
    public void testInspectSchemaStringAsSourceBlank() throws Exception {
        XmlInspectionService service = new XmlInspectionService();
        String schema = "";
        Assertions.assertThrows(IllegalArgumentException.class, () -> service.inspectSchema(schema));
    }

    @Test
    public void testInspectSchemaFileAsSourceNull() throws Exception {
        XmlInspectionService service = new XmlInspectionService();
        File schema = null;
        Assertions.assertThrows(IllegalArgumentException.class, () -> service.inspectSchema(schema));
    }

    @Test
    public void testInspectSchemaBad() throws Exception {
        String source = "<xs:schema/>";
        XmlInspectionService service = new XmlInspectionService();
        Assertions.assertThrows(XmlInspectionException.class, () -> service.inspectSchema("<xs:schema/>"));
    }

    @Test
    public void testInspectSchemaFileBad() throws Exception {
        File schemaFile = Paths.get("src/test/resources/inspect/simple-schema-bad.xsd", new String[0]).toFile();
        XmlInspectionService service = new XmlInspectionService();
        Assertions.assertThrows(XmlInspectionException.class, () -> service.inspectSchema(schemaFile));
    }
}

