/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.xml.inspect;

import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.FieldType;
import io.atlasmap.xml.inspect.BaseXmlInspectionServiceTest;
import io.atlasmap.xml.inspect.XmlInspectionException;
import io.atlasmap.xml.inspect.XmlInspectionService;
import io.atlasmap.xml.v2.XmlComplexType;
import io.atlasmap.xml.v2.XmlDocument;
import io.atlasmap.xml.v2.XmlField;
import io.atlasmap.xml.v2.XmlNamespace;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;

public class XmlInstanceInspectionTest
extends BaseXmlInspectionServiceTest {
    @Test
    public void testInspectXmlStringAsSource() throws Exception {
        String source = "<data>\n     <intField>32000</intField>\n     <longField>12421</longField>\n     <stringField>abc</stringField>\n     <booleanField>true</booleanField>\n     <doubleField>12.0</doubleField>\n     <shortField>1000</shortField>\n     <floatField>234.5f</floatField>\n     <charField>A</charField>\n</data>";
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument xmlDocument = service.inspectXmlDocument("<data>\n     <intField>32000</intField>\n     <longField>12421</longField>\n     <stringField>abc</stringField>\n     <booleanField>true</booleanField>\n     <doubleField>12.0</doubleField>\n     <shortField>1000</shortField>\n     <floatField>234.5f</floatField>\n     <charField>A</charField>\n</data>");
        Assertions.assertNotNull((Object)xmlDocument);
        Assertions.assertNotNull((Object)xmlDocument.getFields());
        Assertions.assertEquals((int)1, (int)xmlDocument.getFields().getField().size());
        List complexTypeList = xmlDocument.getFields().getField().stream().filter(xmlField -> xmlField instanceof XmlComplexType).map(xmlField -> (XmlComplexType)xmlField).collect(Collectors.toList());
        Assertions.assertEquals((int)1, (int)complexTypeList.size());
        XmlComplexType root = (XmlComplexType)xmlDocument.getFields().getField().get(0);
        Assertions.assertNotNull((Object)root);
        Assertions.assertEquals((int)8, (int)root.getXmlFields().getXmlField().size());
        complexTypeList = root.getXmlFields().getXmlField().stream().filter(xmlField -> xmlField instanceof XmlComplexType).map(xmlField -> (XmlComplexType)xmlField).collect(Collectors.toList());
        Assertions.assertEquals((int)0, (int)complexTypeList.size());
    }

    @Test
    public void testInspectXmlStringAsSourceElementsWithAttrs() throws Exception {
        String source = "<data>\n     <intField a='1'>32000</intField>\n     <longField>12421</longField>\n     <stringField>abc</stringField>\n     <booleanField>true</booleanField>\n     <doubleField b='2'>12.0</doubleField>\n     <shortField>1000</shortField>\n     <floatField>234.5f</floatField>\n     <charField>A</charField>\n</data>";
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument xmlDocument = service.inspectXmlDocument("<data>\n     <intField a='1'>32000</intField>\n     <longField>12421</longField>\n     <stringField>abc</stringField>\n     <booleanField>true</booleanField>\n     <doubleField b='2'>12.0</doubleField>\n     <shortField>1000</shortField>\n     <floatField>234.5f</floatField>\n     <charField>A</charField>\n</data>");
        Assertions.assertNotNull((Object)xmlDocument);
        Assertions.assertNotNull((Object)xmlDocument.getFields());
        Assertions.assertEquals((int)1, (int)xmlDocument.getFields().getField().size());
        XmlComplexType root = (XmlComplexType)xmlDocument.getFields().getField().get(0);
        Assertions.assertNotNull((Object)root);
        Assertions.assertEquals((int)10, (int)root.getXmlFields().getXmlField().size());
    }

    @Test
    public void testInspectXmlStringAsSourceUsingAttrs() throws Exception {
        String source = "<data intField='32000' longField='12421' stringField='abc' booleanField='true' doubleField='12.0' shortField='1000' floatField='234.5f' charField='A' />";
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument xmlDocument = service.inspectXmlDocument("<data intField='32000' longField='12421' stringField='abc' booleanField='true' doubleField='12.0' shortField='1000' floatField='234.5f' charField='A' />");
        Assertions.assertNotNull((Object)xmlDocument);
        Assertions.assertNotNull((Object)xmlDocument.getFields());
        Assertions.assertEquals((int)1, (int)xmlDocument.getFields().getField().size());
        XmlComplexType root = (XmlComplexType)xmlDocument.getFields().getField().get(0);
        Assertions.assertNotNull((Object)root);
        Assertions.assertEquals((int)8, (int)root.getXmlFields().getXmlField().size());
    }

    @Test
    public void testInspectXmlStringWithDefaultNamespace() throws Exception {
        String source = "<data xmlns=\"http://x.namespace.com/\">\n     <intField>32000</intField>\n     <longField>12421</longField>\n     <stringField>abc</stringField>\n     <booleanField>true</booleanField>\n     <doubleField>12.0</doubleField>\n     <shortField>1000</shortField>\n     <floatField>234.5f</floatField>\n     <charField>A</charField>\n</data>";
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument xmlDocument = service.inspectXmlDocument("<data xmlns=\"http://x.namespace.com/\">\n     <intField>32000</intField>\n     <longField>12421</longField>\n     <stringField>abc</stringField>\n     <booleanField>true</booleanField>\n     <doubleField>12.0</doubleField>\n     <shortField>1000</shortField>\n     <floatField>234.5f</floatField>\n     <charField>A</charField>\n</data>");
        Assertions.assertNotNull((Object)xmlDocument);
        Assertions.assertNotNull((Object)xmlDocument.getXmlNamespaces());
        XmlNamespace namespace = (XmlNamespace)xmlDocument.getXmlNamespaces().getXmlNamespace().get(0);
        Assertions.assertEquals((int)1, (int)xmlDocument.getXmlNamespaces().getXmlNamespace().size());
        Assertions.assertNotNull((Object)namespace);
        Assertions.assertNull((Object)namespace.getAlias());
        Assertions.assertEquals((Object)"http://x.namespace.com/", (Object)namespace.getUri());
        Assertions.assertNotNull((Object)xmlDocument.getFields());
        Assertions.assertEquals((int)1, (int)xmlDocument.getFields().getField().size());
        XmlComplexType root = (XmlComplexType)xmlDocument.getFields().getField().get(0);
        Assertions.assertNotNull((Object)root);
        Assertions.assertEquals((int)8, (int)root.getXmlFields().getXmlField().size());
    }

    @Test
    public void testInspectXmlStringWithNamespaces() throws Exception {
        String source = "<x:data xmlns:x=\"http://x.namespace.com/\">\n     <x:intField>32000</x:intField>\n     <x:longField>12421</x:longField>\n     <x:stringField>abc</x:stringField>\n     <x:booleanField>true</x:booleanField>\n     <x:doubleField>12.0</x:doubleField>\n     <x:shortField>1000</x:shortField>\n     <x:floatField>234.5f</x:floatField>\n     <x:charField>A</x:charField>\n</x:data>";
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument xmlDocument = service.inspectXmlDocument("<x:data xmlns:x=\"http://x.namespace.com/\">\n     <x:intField>32000</x:intField>\n     <x:longField>12421</x:longField>\n     <x:stringField>abc</x:stringField>\n     <x:booleanField>true</x:booleanField>\n     <x:doubleField>12.0</x:doubleField>\n     <x:shortField>1000</x:shortField>\n     <x:floatField>234.5f</x:floatField>\n     <x:charField>A</x:charField>\n</x:data>");
        Assertions.assertNotNull((Object)xmlDocument);
        Assertions.assertNotNull((Object)xmlDocument.getFields());
        Assertions.assertNotNull((Object)xmlDocument.getXmlNamespaces());
        XmlNamespace namespace = (XmlNamespace)xmlDocument.getXmlNamespaces().getXmlNamespace().get(0);
        Assertions.assertEquals((int)1, (int)xmlDocument.getXmlNamespaces().getXmlNamespace().size());
        Assertions.assertNotNull((Object)namespace);
        Assertions.assertEquals((Object)"x", (Object)namespace.getAlias());
        Assertions.assertEquals((Object)"http://x.namespace.com/", (Object)namespace.getUri());
        Assertions.assertNotNull((Object)xmlDocument.getFields());
        Assertions.assertEquals((int)1, (int)xmlDocument.getFields().getField().size());
        XmlComplexType root = (XmlComplexType)xmlDocument.getFields().getField().get(0);
        Assertions.assertNotNull((Object)root);
        Assertions.assertEquals((int)8, (int)root.getXmlFields().getXmlField().size());
    }

    @Test
    public void testInspectXmlStringAsSourceAttrsWithNamespace() throws Exception {
        String source = "<data xmlns:y=\"http://y.namespace.com/\" y:intField='32000' longField='12421' stringField='abc' booleanField='true' doubleField='12.0' shortField='1000' floatField='234.5f' y:charField='A' />";
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument xmlDocument = service.inspectXmlDocument("<data xmlns:y=\"http://y.namespace.com/\" y:intField='32000' longField='12421' stringField='abc' booleanField='true' doubleField='12.0' shortField='1000' floatField='234.5f' y:charField='A' />");
        Assertions.assertNotNull((Object)xmlDocument);
        Assertions.assertNotNull((Object)xmlDocument.getFields());
        Assertions.assertNotNull((Object)xmlDocument.getXmlNamespaces());
        Assertions.assertEquals((int)1, (int)xmlDocument.getXmlNamespaces().getXmlNamespace().size());
        XmlNamespace namespace = (XmlNamespace)xmlDocument.getXmlNamespaces().getXmlNamespace().get(0);
        Assertions.assertNotNull((Object)namespace);
        Assertions.assertEquals((Object)"y", (Object)namespace.getAlias());
        Assertions.assertEquals((Object)"http://y.namespace.com/", (Object)namespace.getUri());
        Assertions.assertNotNull((Object)xmlDocument.getFields());
        Assertions.assertEquals((int)1, (int)xmlDocument.getFields().getField().size());
        XmlComplexType root = (XmlComplexType)xmlDocument.getFields().getField().get(0);
        Assertions.assertNotNull((Object)root);
        Assertions.assertEquals((int)8, (int)root.getXmlFields().getXmlField().size());
    }

    @Test
    public void testInspectXmlStringAsSourceMultipleChildren() throws Exception {
        String source = "<data>\n     <intFields><int>3200</int><int>2500</int><int>15</int></intFields>\n     <longFields><long>12421</long></longFields>\n     <stringFields><string>abc</string></stringFields>\n     <booleanFields><boolean>true</boolean></booleanFields>\n     <doubleFields><double>12.0</double></doubleFields>\n     <shortFields><short>1000</short></shortFields>\n     <floatFields><float>234.5f</float></floatFields>\n     <charFields><char>A</char></charFields>\n</data>";
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument xmlDocument = service.inspectXmlDocument("<data>\n     <intFields><int>3200</int><int>2500</int><int>15</int></intFields>\n     <longFields><long>12421</long></longFields>\n     <stringFields><string>abc</string></stringFields>\n     <booleanFields><boolean>true</boolean></booleanFields>\n     <doubleFields><double>12.0</double></doubleFields>\n     <shortFields><short>1000</short></shortFields>\n     <floatFields><float>234.5f</float></floatFields>\n     <charFields><char>A</char></charFields>\n</data>");
        Assertions.assertNotNull((Object)xmlDocument);
        Assertions.assertNotNull((Object)xmlDocument.getFields());
        Assertions.assertEquals((int)1, (int)xmlDocument.getFields().getField().size());
        XmlComplexType root = (XmlComplexType)xmlDocument.getFields().getField().get(0);
        Assertions.assertNotNull((Object)root);
        Assertions.assertEquals((int)8, (int)root.getXmlFields().getXmlField().size());
        XmlComplexType childZero = (XmlComplexType)root.getXmlFields().getXmlField().get(0);
        Assertions.assertNotNull((Object)childZero);
        Assertions.assertEquals((int)1, (int)childZero.getXmlFields().getXmlField().size());
        XmlField childZeroZero = (XmlField)childZero.getXmlFields().getXmlField().get(0);
        Assertions.assertNotNull((Object)childZeroZero);
        Assertions.assertEquals((Object)"int", (Object)childZeroZero.getName());
        Assertions.assertEquals((Object)"3200", (Object)childZeroZero.getValue());
        Assertions.assertEquals((Object)"/data/intFields/int<>", (Object)childZeroZero.getPath());
    }

    @Test
    public void testInspectXmlStringAsSourceAT370A() throws Exception {
        String source = "<order>\n   <orders>\n      <order>\n\t      <items>\n\t\t     <item sku=\"4\"/>\n\t\t     <item sku=\"5\"/>\n\t      </items>\n      </order>\n   </orders>\n</order>";
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument xmlDocument = service.inspectXmlDocument("<order>\n   <orders>\n      <order>\n\t      <items>\n\t\t     <item sku=\"4\"/>\n\t\t     <item sku=\"5\"/>\n\t      </items>\n      </order>\n   </orders>\n</order>");
        Assertions.assertNotNull((Object)xmlDocument);
        Assertions.assertNotNull((Object)xmlDocument.getFields());
        Assertions.assertEquals((int)1, (int)xmlDocument.getFields().getField().size());
        XmlComplexType root = (XmlComplexType)xmlDocument.getFields().getField().get(0);
        Assertions.assertNotNull((Object)root);
        Assertions.assertEquals((int)1, (int)root.getXmlFields().getXmlField().size());
    }

    @Test
    public void testInspectXmlStringAsSourceAT370B() throws Exception {
        String source = "<order>\n   <orders>\n      <order>\n\t      <items>\n\t\t     <item sku=\"4\"/>\n\t\t     <item sku=\"7\"/>\n\t      </items>\n      </order>\n      <order>\n\t      <items>\n\t\t     <item sku=\"5\"/>\n\t\t     <item sku=\"8\"/>\n\t      </items>\n      </order>\n   </orders>\n</order>";
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument xmlDocument = service.inspectXmlDocument("<order>\n   <orders>\n      <order>\n\t      <items>\n\t\t     <item sku=\"4\"/>\n\t\t     <item sku=\"7\"/>\n\t      </items>\n      </order>\n      <order>\n\t      <items>\n\t\t     <item sku=\"5\"/>\n\t\t     <item sku=\"8\"/>\n\t      </items>\n      </order>\n   </orders>\n</order>");
        Assertions.assertNotNull((Object)xmlDocument);
        Assertions.assertNotNull((Object)xmlDocument.getFields());
        Assertions.assertEquals((int)1, (int)xmlDocument.getFields().getField().size());
        XmlComplexType root = (XmlComplexType)xmlDocument.getFields().getField().get(0);
        Assertions.assertNotNull((Object)root);
        Assertions.assertEquals((int)1, (int)root.getXmlFields().getXmlField().size());
    }

    @Test
    public void testInspectInstanceFileWithXSIType() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/xsi-type-instance.xml", new String[0])));
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument xmlDocument = service.inspectXmlDocument(instance);
        Assertions.assertNotNull((Object)xmlDocument);
        Assertions.assertNotNull((Object)xmlDocument.getFields());
        Assertions.assertEquals((int)1, (int)xmlDocument.getFields().getField().size());
        XmlComplexType root = (XmlComplexType)xmlDocument.getFields().getField().get(0);
        Assertions.assertNotNull((Object)root);
        Assertions.assertEquals((int)8, (int)root.getXmlFields().getXmlField().size());
    }

    @Test
    public void testInspectXmlStringAsSourceNull() throws Exception {
        XmlInspectionService service = new XmlInspectionService();
        String xmlDocument = null;
        Assertions.assertThrows(IllegalArgumentException.class, () -> service.inspectXmlDocument(xmlDocument));
    }

    @Test
    public void testInspectXmlStringAsSourceBlank() throws Exception {
        XmlInspectionService service = new XmlInspectionService();
        String xmlDocument = "";
        Assertions.assertThrows(IllegalArgumentException.class, () -> service.inspectXmlDocument(xmlDocument));
    }

    @Test
    public void testInspectXmlStringAsSourceParseExpection() throws Exception {
        XmlInspectionService service = new XmlInspectionService();
        String xmlDocument = "<?>";
        Assertions.assertThrows(XmlInspectionException.class, () -> service.inspectXmlDocument(xmlDocument));
    }

    @Test
    public void testInspectXmlDocumentAsSourceNull() {
        XmlInspectionService service = new XmlInspectionService();
        Document xmlDocument = null;
        Assertions.assertThrows(IllegalArgumentException.class, () -> service.inspectXmlDocument(xmlDocument));
    }

    @Test
    public void testInspectXmlStringAsSourceBadHeaderWithBOM() throws Exception {
        XmlInspectionService service = new XmlInspectionService();
        String xmlDocument = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\\ufeff<foo>bar</foo>";
        Assertions.assertThrows(XmlInspectionException.class, () -> service.inspectXmlDocument(xmlDocument));
    }

    @Test
    public void testInspectXmlNestedCollection() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/nested-collection-instance.xml", new String[0])));
        XmlInspectionService service = new XmlInspectionService();
        this.assertNestedCollection(service.inspectXmlDocument(instance));
    }

    @Test
    public void testInspectXmlNestedCollection2() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/nested-collection-2-instance.xml", new String[0])));
        XmlInspectionService service = new XmlInspectionService();
        this.assertNestedCollection(service.inspectXmlDocument(instance));
    }

    private void assertNestedCollection(XmlDocument xmlDocument) throws Exception {
        Assertions.assertNotNull((Object)xmlDocument);
        Assertions.assertNotNull((Object)xmlDocument.getFields());
        Assertions.assertEquals((int)1, (int)xmlDocument.getFields().getField().size());
        XmlComplexType root = (XmlComplexType)xmlDocument.getFields().getField().get(0);
        Assertions.assertNotNull((Object)root);
        Assertions.assertEquals((Object)"root", (Object)root.getName());
        Assertions.assertEquals((int)2, (int)root.getXmlFields().getXmlField().size());
        XmlComplexType firstArray = (XmlComplexType)root.getXmlFields().getXmlField().get(0);
        Assertions.assertNotNull((Object)firstArray);
        Assertions.assertEquals((Object)"firstArray", (Object)firstArray.getName());
        Assertions.assertEquals((Object)CollectionType.LIST, (Object)firstArray.getCollectionType());
        Assertions.assertEquals((int)3, (int)firstArray.getXmlFields().getXmlField().size());
        XmlField firstValue = (XmlField)firstArray.getXmlFields().getXmlField().get(0);
        Assertions.assertNotNull((Object)firstValue);
        Assertions.assertEquals((Object)"value", (Object)firstValue.getName());
        Assertions.assertNull((Object)firstValue.getCollectionType());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)firstValue.getFieldType());
        XmlField firstArrayAttr = (XmlField)firstArray.getXmlFields().getXmlField().get(2);
        Assertions.assertNotNull((Object)firstArrayAttr);
        Assertions.assertEquals((Object)"firstArrayAttr", (Object)firstArrayAttr.getName());
        Assertions.assertNull((Object)firstArrayAttr.getCollectionType());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)firstArrayAttr.getFieldType());
        Assertions.assertTrue((boolean)firstArrayAttr.isAttribute());
        XmlComplexType secondArray = (XmlComplexType)firstArray.getXmlFields().getXmlField().get(1);
        Assertions.assertNotNull((Object)secondArray);
        Assertions.assertEquals((Object)"secondArray", (Object)secondArray.getName());
        Assertions.assertEquals((Object)CollectionType.LIST, (Object)secondArray.getCollectionType());
        Assertions.assertEquals((int)3, (int)firstArray.getXmlFields().getXmlField().size());
        XmlField secondValue = (XmlField)secondArray.getXmlFields().getXmlField().get(0);
        Assertions.assertNotNull((Object)secondValue);
        Assertions.assertEquals((Object)"value", (Object)secondValue.getName());
        Assertions.assertNull((Object)secondValue.getCollectionType());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)secondValue.getFieldType());
        XmlField secondArrayAttr = (XmlField)secondArray.getXmlFields().getXmlField().get(2);
        Assertions.assertNotNull((Object)secondArrayAttr);
        Assertions.assertEquals((Object)"secondArrayAttr", (Object)secondArrayAttr.getName());
        Assertions.assertNull((Object)secondArrayAttr.getCollectionType());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)secondArrayAttr.getFieldType());
        Assertions.assertTrue((boolean)secondArrayAttr.isAttribute());
        XmlComplexType thirdArray = (XmlComplexType)secondArray.getXmlFields().getXmlField().get(1);
        Assertions.assertNotNull((Object)thirdArray);
        Assertions.assertEquals((Object)"thirdArray", (Object)thirdArray.getName());
        Assertions.assertEquals((Object)CollectionType.LIST, (Object)thirdArray.getCollectionType());
        Assertions.assertEquals((int)2, (int)thirdArray.getXmlFields().getXmlField().size());
        XmlField thirdValue = (XmlField)thirdArray.getXmlFields().getXmlField().get(0);
        Assertions.assertNotNull((Object)thirdValue);
        Assertions.assertEquals((Object)"value", (Object)thirdValue.getName());
        Assertions.assertNull((Object)thirdValue.getCollectionType());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)thirdValue.getFieldType());
        XmlField thirdArrayAttr = (XmlField)thirdArray.getXmlFields().getXmlField().get(1);
        Assertions.assertNotNull((Object)thirdArrayAttr);
        Assertions.assertEquals((Object)"thirdArrayAttr", (Object)thirdArrayAttr.getName());
        Assertions.assertNull((Object)thirdArrayAttr.getCollectionType());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)thirdArrayAttr.getFieldType());
        Assertions.assertTrue((boolean)thirdArrayAttr.isAttribute());
    }
}

