/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.xml.core;

import io.atlasmap.api.AtlasException;
import io.atlasmap.core.DefaultAtlasConversionService;
import io.atlasmap.spi.AtlasConversionService;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.Audit;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.Audits;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.DataSourceType;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.FieldType;
import io.atlasmap.xml.core.XmlFieldReader;
import io.atlasmap.xml.v2.AtlasXmlModelFactory;
import io.atlasmap.xml.v2.XmlDataSource;
import io.atlasmap.xml.v2.XmlField;
import io.atlasmap.xml.v2.XmlNamespace;
import io.atlasmap.xml.v2.XmlNamespaces;
import java.io.File;
import java.io.StringReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class XmlFieldReaderTest {
    private XmlFieldReader reader = new XmlFieldReader(XmlFieldReader.class.getClassLoader(), (AtlasConversionService)DefaultAtlasConversionService.getInstance());

    @Test
    public void testReadDocumentSetElementValueAsString() throws Exception {
        Document doc = this.getDocumentFromFile("src/test/resources/simple_example.xml", false);
        this.reader.setDocument(doc);
        XmlField xmlField = AtlasXmlModelFactory.createXmlField();
        xmlField.setPath("/orders/order/id");
        Assertions.assertNull((Object)xmlField.getValue());
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn((Object)((AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class)));
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)xmlField);
        this.reader.read(session);
        Assertions.assertNotNull((Object)xmlField.getValue());
        Assertions.assertEquals((Object)"12312", (Object)xmlField.getValue());
    }

    @Test
    public void testReadDocumentSetValueFromAttrAsString() throws Exception {
        Document doc = this.getDocumentFromFile("src/test/resources/simple_example.xml", false);
        this.reader.setDocument(doc);
        XmlField xmlField = AtlasXmlModelFactory.createXmlField();
        xmlField.setPath("/orders/@totalCost");
        Assertions.assertNull((Object)xmlField.getValue());
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn((Object)((AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class)));
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)xmlField);
        this.reader.read(session);
        Assertions.assertNotNull((Object)xmlField.getValue());
        Assertions.assertEquals((Object)"12525.00", (Object)xmlField.getValue());
    }

    @Test
    public void testReadDocumentSetElementValueComplex() throws Exception {
        Document doc = this.getDocumentFromFile("src/test/resources/complex_example.xml", false);
        this.reader.setDocument(doc);
        XmlField xmlField = AtlasXmlModelFactory.createXmlField();
        xmlField.setPath("/orders/order[3]/id[1]");
        Assertions.assertNull((Object)xmlField.getValue());
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn((Object)((AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class)));
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)xmlField);
        this.reader.read(session);
        Assertions.assertNotNull((Object)xmlField.getValue());
        Assertions.assertEquals((Object)"54554555", (Object)xmlField.getValue());
    }

    @Test
    public void testReadDocumentSetAttributeValueAsString() throws Exception {
        Document doc = this.getDocumentFromFile("src/test/resources/simple_example.xml", false);
        this.reader.setDocument(doc);
        XmlField xmlField = AtlasXmlModelFactory.createXmlField();
        xmlField.setPath("/orders/order/id/@custId");
        Assertions.assertNull((Object)xmlField.getValue());
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn((Object)((AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class)));
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)xmlField);
        this.reader.read(session);
        Assertions.assertNotNull((Object)xmlField.getValue());
        Assertions.assertEquals((Object)"a", (Object)xmlField.getValue());
    }

    @Test
    public void testReadDocumentSetAttributeValueComplex() throws Exception {
        Document doc = this.getDocumentFromFile("src/test/resources/complex_example.xml", false);
        this.reader.setDocument(doc);
        XmlField xmlField = AtlasXmlModelFactory.createXmlField();
        xmlField.setPath("/orders/order[2]/id[1]/@custId");
        Assertions.assertNull((Object)xmlField.getValue());
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn((Object)((AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class)));
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)xmlField);
        this.reader.read(session);
        Assertions.assertNotNull((Object)xmlField.getValue());
        Assertions.assertEquals((Object)"b", (Object)xmlField.getValue());
    }

    @Test
    public void testReadDocumentWithSingleNamespaceSetElementValueAsString() throws Exception {
        Document doc = this.getDocumentFromFile("src/test/resources/simple_example_single_ns.xml", true);
        this.reader.setDocument(doc);
        XmlField xmlField = AtlasXmlModelFactory.createXmlField();
        xmlField.setPath("/x:orders/order/id");
        Assertions.assertNull((Object)xmlField.getValue());
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn((Object)((AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class)));
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)xmlField);
        this.reader.read(session);
        Assertions.assertNotNull((Object)xmlField.getValue());
        Assertions.assertEquals((Object)"12312", (Object)xmlField.getValue());
    }

    @Test
    public void testReadDocumentWithMultipleNamespaceSetElementValueAsString() throws Exception {
        Document doc = this.getDocumentFromFile("src/test/resources/simple_example_multiple_ns.xml", true);
        this.reader.setDocument(doc);
        XmlField xmlField = AtlasXmlModelFactory.createXmlField();
        xmlField.setPath("/x:orders/order/y:id/@custId");
        Assertions.assertNull((Object)xmlField.getValue());
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn((Object)((AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class)));
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)xmlField);
        this.reader.read(session);
        Assertions.assertNotNull((Object)xmlField.getValue());
        Assertions.assertEquals((Object)"a", (Object)xmlField.getValue());
    }

    @Test
    public void testReadDocumentWithMultipleNamespaceComplex() throws Exception {
        Document doc = this.getDocumentFromFile("src/test/resources/complex_example_ns.xml", true);
        this.reader.setDocument(doc);
        XmlField xmlField = AtlasXmlModelFactory.createXmlField();
        xmlField.setPath("/orders/order[2]/id[1]/@y:custId");
        Assertions.assertNull((Object)xmlField.getValue());
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn((Object)((AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class)));
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)xmlField);
        this.reader.read(session);
        Assertions.assertNotNull((Object)xmlField.getValue());
        Assertions.assertEquals((Object)"b", (Object)xmlField.getValue());
    }

    @Test
    public void testReadDocumentElementWithMultipleNamespaceComplex() throws Exception {
        Document doc = this.getDocumentFromFile("src/test/resources/complex_example_multiple_ns.xml", true);
        this.reader.setDocument(doc);
        XmlField xmlField = AtlasXmlModelFactory.createXmlField();
        xmlField.setPath("/orders/q:order[0]/id[0]/@y:custId");
        String docId = "docId";
        xmlField.setDocId(docId);
        Assertions.assertNull((Object)xmlField.getValue());
        LinkedHashMap<String, String> namespaces = new LinkedHashMap<String, String>();
        namespaces.put("http://www.example.com/q/", "q");
        namespaces.put("http://www.example.com/y/", "y");
        namespaces.put("http://www.example.com/x/", "");
        this.reader.setNamespaces(namespaces);
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        this.mockDataSources(docId, session);
        Mockito.when((Object)session.head()).thenReturn((Object)((AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class)));
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)xmlField);
        this.reader.read(session);
        Assertions.assertNotNull((Object)xmlField.getValue());
        Assertions.assertEquals((Object)"cx", (Object)xmlField.getValue());
        XmlField xmlField2 = AtlasXmlModelFactory.createXmlField();
        xmlField2.setDocId(docId);
        xmlField2.setPath("/orders/order/id/@y:custId");
        Assertions.assertNull((Object)xmlField2.getValue());
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)xmlField2);
        this.reader.read(session);
        Assertions.assertNotNull((Object)xmlField2.getValue());
        Assertions.assertEquals((Object)"aa", (Object)xmlField2.getValue());
        XmlField xmlField3 = AtlasXmlModelFactory.createXmlField();
        xmlField3.setDocId(docId);
        xmlField3.setPath("/orders/q:order[1]/id/@y:custId");
        Assertions.assertNull((Object)xmlField3.getValue());
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)xmlField3);
        this.reader.read(session);
        Assertions.assertNotNull((Object)xmlField3.getValue());
        Assertions.assertEquals((Object)"ea", (Object)xmlField3.getValue());
    }

    @Test
    public void testReadDocumentElementWithMultipleNamespaceComplexConstructorArg() throws Exception {
        Document doc = this.getDocumentFromFile("src/test/resources/complex_example_multiple_ns.xml", true);
        this.reader.setDocument(doc);
        XmlField xmlField = AtlasXmlModelFactory.createXmlField();
        xmlField.setPath("/orders/q:order/id/@y:custId");
        String docId = "docId";
        xmlField.setDocId(docId);
        Assertions.assertNull((Object)xmlField.getValue());
        LinkedHashMap<String, String> namespaces = new LinkedHashMap<String, String>();
        namespaces.put("http://www.example.com/q/", "q");
        namespaces.put("http://www.example.com/y/", "y");
        namespaces.put("http://www.example.com/x/", "");
        XmlFieldReader multipleNamespacesReader = new XmlFieldReader(XmlFieldReader.class.getClassLoader(), (AtlasConversionService)DefaultAtlasConversionService.getInstance(), namespaces);
        multipleNamespacesReader.setDocument(doc);
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        this.mockDataSources(docId, session);
        Mockito.when((Object)session.head()).thenReturn((Object)((AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class)));
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)xmlField);
        multipleNamespacesReader.read(session);
        Assertions.assertNotNull((Object)xmlField.getValue());
        Assertions.assertEquals((Object)"cx", (Object)xmlField.getValue());
        XmlField xmlField2 = AtlasXmlModelFactory.createXmlField();
        xmlField2.setPath("/orders/order/id/@y:custId");
        Assertions.assertNull((Object)xmlField2.getValue());
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)xmlField2);
        multipleNamespacesReader.read(session);
        Assertions.assertNotNull((Object)xmlField2.getValue());
        Assertions.assertEquals((Object)"aa", (Object)xmlField2.getValue());
    }

    @Test
    public void testReadDocumentMultipleFieldsSetElementValuesComplex() throws Exception {
        Document doc = this.getDocumentFromFile("src/test/resources/complex_example.xml", false);
        this.reader.setDocument(doc);
        LinkedList<XmlField> fieldList = new LinkedList<XmlField>();
        XmlField xmlField = AtlasXmlModelFactory.createXmlField();
        xmlField.setPath("/orders/order[3]/id[1]");
        fieldList.addLast(xmlField);
        XmlField xmlField2 = AtlasXmlModelFactory.createXmlField();
        xmlField2.setPath("/orders/order[1]/id");
        fieldList.addLast(xmlField2);
        XmlField xmlField3 = AtlasXmlModelFactory.createXmlField();
        xmlField3.setPath("/orders/order[2]/id[2]");
        fieldList.addLast(xmlField3);
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn((Object)((AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class)));
        for (XmlField field : fieldList) {
            Assertions.assertNull((Object)field.getValue());
            Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)field);
            this.reader.read(session);
            Assertions.assertNotNull((Object)field.getValue());
        }
        Assertions.assertEquals((Object)"54554555", (Object)((XmlField)fieldList.getFirst()).getValue());
        Assertions.assertEquals((Object)"12312", (Object)((XmlField)fieldList.get(1)).getValue());
        Assertions.assertEquals((Object)"54554555", (Object)((XmlField)fieldList.getLast()).getValue());
    }

    @Test
    public void testReadDocumentMisMatchedFieldNameAT416() throws Exception {
        Document doc = this.getDocumentFromFile("src/test/resources/simple_example.xml", false);
        this.reader.setDocument(doc);
        XmlField xmlField = AtlasXmlModelFactory.createXmlField();
        xmlField.setPath("/orders/order/id1");
        Assertions.assertNull((Object)xmlField.getValue());
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn((Object)((AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class)));
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)xmlField);
        this.reader.read(session);
        Assertions.assertNull((Object)xmlField.getValue());
    }

    @Test
    public void testReadDocumentMixedNamespacesNoNSDocument() throws Exception {
        Document doc = this.getDocumentFromFile("src/test/resources/simple_example.xml", false);
        this.reader.setDocument(doc);
        XmlField xmlField = AtlasXmlModelFactory.createXmlField();
        xmlField.setPath("/ns:orders/order/id");
        Assertions.assertNull((Object)xmlField.getValue());
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn((Object)((AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class)));
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)xmlField);
        this.reader.read(session);
        Assertions.assertNotNull((Object)xmlField.getValue());
        Assertions.assertEquals((Object)"12312", (Object)xmlField.getValue());
    }

    @Test
    public void testReadDocumentMixedNamespacesNoNSOnPaths() throws Exception {
        Document doc = this.getDocumentFromFile("src/test/resources/simple_example_single_ns.xml", true);
        this.reader.setDocument(doc);
        XmlField xmlField = AtlasXmlModelFactory.createXmlField();
        xmlField.setPath("/orders/order/id");
        Assertions.assertNull((Object)xmlField.getValue());
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn((Object)((AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class)));
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)xmlField);
        this.reader.read(session);
        Assertions.assertNotNull((Object)xmlField.getValue());
        Assertions.assertEquals((Object)"12312", (Object)xmlField.getValue());
    }

    @Test
    public void testNullDocument() throws Exception {
        this.reader.setDocument(null);
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn((Object)((AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class)));
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)new XmlField());
        Audits audits = new Audits();
        Mockito.when((Object)session.getAudits()).thenReturn((Object)audits);
        this.reader.read(session);
        Assertions.assertEquals((int)1, (int)audits.getAudit().size());
        Assertions.assertEquals((Object)AuditStatus.ERROR, (Object)((Audit)audits.getAudit().get(0)).getStatus());
    }

    @Test
    public void testEmptyDocument() throws Exception {
        this.reader.setDocument(this.getDocumentFromString("", false));
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn((Object)((AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class)));
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)new XmlField());
        Audits audits = new Audits();
        Mockito.when((Object)session.getAudits()).thenReturn((Object)audits);
        this.reader.read(session);
        Assertions.assertEquals((int)1, (int)audits.getAudit().size());
        Assertions.assertEquals((Object)AuditStatus.ERROR, (Object)((Audit)audits.getAudit().get(0)).getStatus());
    }

    public void testThrowExceptionOnNullAmlFeilds() throws Exception {
        Document doc = this.getDocumentFromFile("src/test/resources/complex_example.xml", false);
        this.reader.setDocument(doc);
        Object fieldList = null;
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn((Object)((AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class)));
        Mockito.when((Object)session.head().getSourceField()).thenReturn(fieldList);
        this.reader.read(session);
    }

    @Test
    public void testThrowExceptionOnNullXmlField() throws Exception {
        Document doc = this.getDocumentFromFile("src/test/resources/complex_example.xml", false);
        this.reader.setDocument(doc);
        Object xmlField = null;
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn((Object)((AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class)));
        Mockito.when((Object)session.head().getSourceField()).thenReturn(xmlField);
        Assertions.assertThrows(AtlasException.class, () -> this.reader.read(session));
    }

    @Test
    public void testXmlFieldDoubleMax() throws Exception {
        this.validateBoundaryValue(FieldType.DOUBLE, "test-read-field-double-max.xml", Double.MAX_VALUE);
    }

    @Test
    public void testXmlFieldDoubleMin() throws Exception {
        this.validateBoundaryValue(FieldType.DOUBLE, "test-read-field-double-min.xml", Double.MIN_VALUE);
    }

    @Test
    public void testXmlFieldFloatMax() throws Exception {
        this.validateBoundaryValue(FieldType.FLOAT, "test-read-field-float-max.xml", Float.valueOf(Float.MAX_VALUE));
    }

    @Test
    public void testXmlFieldFloatMin() throws Exception {
        this.validateBoundaryValue(FieldType.FLOAT, "test-read-field-float-min.xml", Float.valueOf(Float.MIN_VALUE));
    }

    @Test
    public void testXmlFieldLongMax() throws Exception {
        this.validateBoundaryValue(FieldType.LONG, "test-read-field-long-max.xml", Long.MAX_VALUE);
    }

    @Test
    public void testXmlFieldLongMin() throws Exception {
        this.validateBoundaryValue(FieldType.LONG, "test-read-field-long-min.xml", Long.MIN_VALUE);
    }

    @Test
    public void testXmlFieldIntegerMax() throws Exception {
        this.validateBoundaryValue(FieldType.INTEGER, "test-read-field-integer-max.xml", Integer.MAX_VALUE);
    }

    @Test
    public void testXmlFieldIntegerMin() throws Exception {
        this.validateBoundaryValue(FieldType.INTEGER, "test-read-field-integer-min.xml", Integer.MIN_VALUE);
    }

    @Test
    public void testXmlFieldShortMax() throws Exception {
        this.validateBoundaryValue(FieldType.SHORT, "test-read-field-short-max.xml", (short)Short.MAX_VALUE);
    }

    @Test
    public void testXmlFieldShortMin() throws Exception {
        this.validateBoundaryValue(FieldType.SHORT, "test-read-field-short-min.xml", (short)Short.MIN_VALUE);
    }

    @Test
    public void testXmlFieldChar() throws Exception {
        this.validateBoundaryValue(FieldType.CHAR, "test-read-field-char.xml", Character.valueOf('!'));
    }

    @Test
    public void testXmlFieldByteMax() throws Exception {
        this.validateBoundaryValue(FieldType.BYTE, "test-read-field-byte-max.xml", (byte)127);
    }

    @Test
    public void testXmlFieldByteMin() throws Exception {
        this.validateBoundaryValue(FieldType.BYTE, "test-read-field-byte-min.xml", (byte)-128);
    }

    @Test
    public void testXmlFieldBooleanTrue() throws Exception {
        this.validateBoundaryValue(FieldType.BOOLEAN, "test-read-field-boolean-true.xml", Boolean.TRUE);
    }

    @Test
    public void testXmlFieldBooleanFalse() throws Exception {
        this.validateBoundaryValue(FieldType.BOOLEAN, "test-read-field-boolean-false.xml", Boolean.FALSE);
    }

    @Test
    public void testXmlFieldBooleanNumber1() throws Exception {
        this.validateBoundaryValue(FieldType.BOOLEAN, "test-read-field-boolean-one.xml", Boolean.TRUE);
    }

    @Test
    public void testXmlFieldBooleanNumber0() throws Exception {
        this.validateBoundaryValue(FieldType.BOOLEAN, "test-read-field-boolean-zero.xml", Boolean.FALSE);
    }

    @Test
    public void testXmlFieldBooleanLetterT() throws Exception {
        this.validateBoundaryValue(FieldType.BOOLEAN, "test-read-field-boolean-letter-T.xml", Boolean.TRUE);
    }

    @Test
    public void testXmlFieldBooleanLetterF() throws Exception {
        this.validateBoundaryValue(FieldType.BOOLEAN, "test-read-field-boolean-letter-F.xml", Boolean.FALSE);
    }

    @Test
    public void testXmlFieldDoubleMaxRangeOut() throws Exception {
        this.validateRangeOutValue(FieldType.DOUBLE, "test-read-field-double-max-range-out.xml", "1.7976931348623157E309");
    }

    @Test
    public void testXmlFieldDoubleMinRangeOut() throws Exception {
        String fieldPath = "/primitive/value";
        FieldType fieldType = FieldType.DOUBLE;
        Path path = Paths.get("src" + File.separator + "test" + File.separator + "resources" + File.separator + "xmlFields" + File.separator + "test-read-field-double-min-range-out.xml", new String[0]);
        AtlasInternalSession session = this.readFromFile(fieldPath, fieldType, path);
        Assertions.assertEquals((Object)0.0, (Object)session.head().getSourceField().getValue());
        Assertions.assertEquals((int)0, (int)session.getAudits().getAudit().size());
    }

    @Test
    public void testXmlFieldFloatMaxRangeOut() throws Exception {
        this.validateRangeOutValue(FieldType.FLOAT, "test-read-field-float-max-range-out.xml", "3.4028235E39");
    }

    @Test
    public void testXmlFieldFloatMinRangeOut() throws Exception {
        String fieldPath = "/primitive/value";
        FieldType fieldType = FieldType.FLOAT;
        Path path = Paths.get("src" + File.separator + "test" + File.separator + "resources" + File.separator + "xmlFields" + File.separator + "test-read-field-float-min-range-out.xml", new String[0]);
        AtlasInternalSession session = this.readFromFile(fieldPath, fieldType, path);
        Assertions.assertEquals((Object)Float.valueOf(0.0f), (Object)session.head().getSourceField().getValue());
        Assertions.assertEquals((int)0, (int)session.getAudits().getAudit().size());
    }

    @Test
    public void testXmlFieldLongMaxRangeOut() throws Exception {
        this.validateRangeOutValue(FieldType.LONG, "test-read-field-long-max-range-out.xml", "9223372036854775808");
    }

    @Test
    public void testXmlFieldLongMinRangeOut() throws Exception {
        this.validateRangeOutValue(FieldType.LONG, "test-read-field-long-min-range-out.xml", "-9223372036854775809");
    }

    @Test
    public void testXmlFieldIntegerMaxRangeOut() throws Exception {
        this.validateRangeOutValue(FieldType.INTEGER, "test-read-field-integer-max-range-out.xml", "9223372036854775807");
    }

    @Test
    public void testXmlFieldIntegerMinRangeOut() throws Exception {
        this.validateRangeOutValue(FieldType.INTEGER, "test-read-field-integer-min-range-out.xml", "-9223372036854775808");
    }

    @Test
    public void testXmlFieldShortMaxRangeOut() throws Exception {
        this.validateRangeOutValue(FieldType.SHORT, "test-read-field-short-max-range-out.xml", "9223372036854775807");
    }

    @Test
    public void testXmlFieldShortMinRangeOut() throws Exception {
        this.validateRangeOutValue(FieldType.SHORT, "test-read-field-short-min-range-out.xml", "-9223372036854775808");
    }

    @Test
    public void testXmlFieldCharMaxRangeOut() throws Exception {
        this.validateRangeOutValue(FieldType.CHAR, "test-read-field-char-max-range-out.xml", "9223372036854775807");
    }

    @Test
    public void testXmlFieldCharMinRangeOut() throws Exception {
        this.validateRangeOutValue(FieldType.CHAR, "test-read-field-char-min-range-out.xml", "-9223372036854775808");
    }

    @Test
    public void testXmlFieldByteMaxRangeOut() throws Exception {
        this.validateRangeOutValue(FieldType.BYTE, "test-read-field-byte-max-range-out.xml", "9223372036854775807");
    }

    @Test
    public void testXmlFieldByteMinRangeOut() throws Exception {
        this.validateRangeOutValue(FieldType.BYTE, "test-read-field-byte-min-range-out.xml", "-9223372036854775808");
    }

    @Test
    public void testXmlFieldBooleanRangeOut() throws Exception {
        this.validateBoundaryValue(FieldType.BOOLEAN, "test-read-field-boolean-range-out.xml", Boolean.FALSE);
    }

    @Test
    public void testXmlFieldBooleanDecimal() throws Exception {
        this.validateBoundaryValue(FieldType.BOOLEAN, "test-read-field-boolean-decimal.xml", Boolean.TRUE);
    }

    @Test
    public void testXmlFieldLongDecimal() throws Exception {
        this.validateDecimalValue(FieldType.LONG, "test-read-field-long-decimal.xml", 126L);
    }

    @Test
    public void testXmlFieldIntegerDecimal() throws Exception {
        this.validateDecimalValue(FieldType.INTEGER, "test-read-field-integer-decimal.xml", 126);
    }

    @Test
    public void testXmlFieldShortDecimal() throws Exception {
        this.validateDecimalValue(FieldType.SHORT, "test-read-field-short-decimal.xml", (short)126);
    }

    @Test
    public void testXmlFieldCharDecimal() throws Exception {
        this.validateRangeOutValue(FieldType.CHAR, "test-read-field-char-decimal.xml", "126.1234");
    }

    @Test
    public void testXmlFieldByteDecimal() throws Exception {
        this.validateDecimalValue(FieldType.BYTE, "test-read-field-byte-decimal.xml", (byte)126);
    }

    @Test
    public void testXmlFieldDoubleString() throws Exception {
        this.validateRangeOutValue(FieldType.DOUBLE, "test-read-field-double-string.xml", "abcd");
    }

    @Test
    public void testXmlFieldFloatString() throws Exception {
        this.validateRangeOutValue(FieldType.FLOAT, "test-read-field-float-string.xml", "abcd");
    }

    @Test
    public void testXmlFieldLongString() throws Exception {
        this.validateRangeOutValue(FieldType.LONG, "test-read-field-long-string.xml", "abcd");
    }

    @Test
    public void testXmlFieldIntegerString() throws Exception {
        this.validateRangeOutValue(FieldType.INTEGER, "test-read-field-integer-string.xml", "abcd");
    }

    @Test
    public void testXmlFieldShortString() throws Exception {
        this.validateRangeOutValue(FieldType.SHORT, "test-read-field-short-string.xml", "abcd");
    }

    @Test
    public void testXmlFieldCharString() throws Exception {
        this.validateRangeOutValue(FieldType.CHAR, "test-read-field-char-string.xml", "abcd");
    }

    @Test
    public void testXmlFieldByteString() throws Exception {
        this.validateRangeOutValue(FieldType.BYTE, "test-read-field-byte-string.xml", "abcd");
    }

    @Test
    public void testReadParentCollection() throws Exception {
        Document document = this.getDocumentFromFile("src/test/resources/complex-repeated.xml", false);
        this.reader.setDocument(document);
        FieldGroup orders = new FieldGroup();
        orders.setFieldType(FieldType.COMPLEX);
        orders.setDocId("xml");
        orders.setPath("/orders/order[]");
        orders.setCollectionType(CollectionType.ARRAY);
        FieldGroup address = new FieldGroup();
        address.setFieldType(FieldType.COMPLEX);
        address.setDocId("xml");
        address.setPath("/orders/order[]/address");
        orders.getField().add(address);
        XmlField addressLine1 = AtlasXmlModelFactory.createXmlField();
        addressLine1.setFieldType(FieldType.STRING);
        addressLine1.setDocId("xml");
        addressLine1.setPath("/orders/order[]/address/addressLine1");
        address.getField().add(addressLine1);
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn((Object)((AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class)));
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)address);
        Field readField = this.reader.read(session);
        Assertions.assertNotNull((Object)readField);
        Assertions.assertEquals(FieldGroup.class, readField.getClass());
        FieldGroup readGroup = (FieldGroup)FieldGroup.class.cast(readField);
        Assertions.assertEquals((int)5, (int)readGroup.getField().size());
        for (int i = 0; i < 5; ++i) {
            FieldGroup addr = (FieldGroup)readGroup.getField().get(i);
            Assertions.assertEquals((Object)("/orders/order[" + i + "]/address"), (Object)addr.getPath());
            Assertions.assertEquals((int)1, (int)addr.getField().size());
            Field addressLine = (Field)addr.getField().get(0);
            Assertions.assertEquals((Object)("/orders/order[" + i + "]/address/addressLine1"), (Object)addressLine.getPath());
            Assertions.assertEquals((Object)("123 Main St (" + (i + 1) + ")"), (Object)addressLine.getValue());
        }
    }

    @Test
    public void testReadParentCollectionEmpty() throws Exception {
        Document document = this.getDocumentFromFile("src/test/resources/complex-repeated-empty.xml", false);
        this.reader.setDocument(document);
        FieldGroup orders = new FieldGroup();
        orders.setFieldType(FieldType.COMPLEX);
        orders.setDocId("xml");
        orders.setPath("/orders/order[]");
        orders.setCollectionType(CollectionType.ARRAY);
        FieldGroup address = new FieldGroup();
        address.setFieldType(FieldType.COMPLEX);
        address.setDocId("xml");
        address.setPath("/orders/order[]/address");
        orders.getField().add(address);
        XmlField addressLine1 = AtlasXmlModelFactory.createXmlField();
        addressLine1.setFieldType(FieldType.STRING);
        addressLine1.setDocId("xml");
        addressLine1.setPath("/orders/order[]/address/addressLine1");
        address.getField().add(addressLine1);
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn((Object)((AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class)));
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)address);
        Field readField = this.reader.read(session);
        Assertions.assertNotNull((Object)readField);
        Assertions.assertEquals(FieldGroup.class, readField.getClass());
        FieldGroup readGroup = (FieldGroup)FieldGroup.class.cast(readField);
        Assertions.assertEquals((int)0, (int)readGroup.getField().size());
    }

    @Test
    public void testReadParentCollectionEmptyItem() throws Exception {
        Document document = this.getDocumentFromFile("src/test/resources/complex-repeated-empty-item.xml", false);
        this.reader.setDocument(document);
        FieldGroup orders = new FieldGroup();
        orders.setFieldType(FieldType.COMPLEX);
        orders.setDocId("xml");
        orders.setPath("/orders/order[]");
        orders.setCollectionType(CollectionType.ARRAY);
        FieldGroup address = new FieldGroup();
        address.setFieldType(FieldType.COMPLEX);
        address.setDocId("xml");
        address.setPath("/orders/order[]/address");
        orders.getField().add(address);
        XmlField addressLine1 = AtlasXmlModelFactory.createXmlField();
        addressLine1.setFieldType(FieldType.STRING);
        addressLine1.setDocId("xml");
        addressLine1.setPath("/orders/order[]/address/addressLine1");
        address.getField().add(addressLine1);
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn((Object)((AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class)));
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)address);
        Field readField = this.reader.read(session);
        Assertions.assertNotNull((Object)readField);
        Assertions.assertEquals(FieldGroup.class, readField.getClass());
        FieldGroup readGroup = (FieldGroup)FieldGroup.class.cast(readField);
        Assertions.assertEquals((int)2, (int)readGroup.getField().size());
        FieldGroup address0 = (FieldGroup)readGroup.getField().get(0);
        Assertions.assertEquals((Object)"/orders/order[0]/address", (Object)address0.getPath());
        Assertions.assertEquals((int)1, (int)address0.getField().size());
        Field addressLine0 = (Field)address0.getField().get(0);
        Assertions.assertEquals((Object)"/orders/order[0]/address/addressLine1", (Object)addressLine0.getPath());
        Assertions.assertEquals((Object)"123 Main St (1)", (Object)addressLine0.getValue());
        FieldGroup address2 = (FieldGroup)readGroup.getField().get(1);
        Assertions.assertEquals((Object)"/orders/order[2]/address", (Object)address2.getPath());
        Assertions.assertEquals((int)1, (int)address2.getField().size());
        Field addressLine2 = (Field)address2.getField().get(0);
        Assertions.assertEquals((Object)"/orders/order[2]/address/addressLine1", (Object)addressLine2.getPath());
        Assertions.assertEquals((Object)"123 Main St (3)", (Object)addressLine2.getValue());
    }

    private Document getDocumentFromFile(String uri, boolean namespaced) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(namespaced);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(new File(uri));
    }

    private Document getDocumentFromString(String body, boolean namespaced) throws Exception {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(namespaced);
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(new InputSource(new StringReader(body)));
        }
        catch (Exception e) {
            return null;
        }
    }

    private Document getDocumentFromPath(Path path, boolean namespaced) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(namespaced);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(path.toFile());
    }

    private void validateBoundaryValue(FieldType fieldType, String fileName, Object testObject) throws Exception {
        Path path = Paths.get("src" + File.separator + "test" + File.separator + "resources" + File.separator + "xmlFields" + File.separator + fileName, new String[0]);
        AtlasInternalSession session = this.readFromFile("/primitive/value", fieldType, path);
        Assertions.assertNotNull((Object)session.head().getSourceField().getValue());
        Assertions.assertEquals((Object)testObject, (Object)session.head().getSourceField().getValue());
    }

    private AtlasInternalSession readFromFile(String fieldPath, FieldType fieldType, Path path) throws Exception {
        this.reader.setDocument(this.getDocumentFromPath(path, false));
        XmlField xmlField = AtlasXmlModelFactory.createXmlField();
        xmlField.setPath(fieldPath);
        xmlField.setPrimitive(Boolean.TRUE);
        xmlField.setFieldType(fieldType);
        Assertions.assertNull((Object)xmlField.getValue());
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn((Object)((AtlasInternalSession.Head)Mockito.mock(AtlasInternalSession.Head.class)));
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)xmlField);
        Audits audits = new Audits();
        Mockito.when((Object)session.getAudits()).thenReturn((Object)audits);
        this.reader.read(session);
        return session;
    }

    private void validateRangeOutValue(FieldType fieldType, String fileName, String inputValue) throws Exception {
        Path path = Paths.get("src" + File.separator + "test" + File.separator + "resources" + File.separator + "xmlFields" + File.separator + fileName, new String[0]);
        AtlasInternalSession session = this.readFromFile("/primitive/value", fieldType, path);
        Assertions.assertEquals(null, (Object)session.head().getSourceField().getValue());
        Assertions.assertEquals((int)1, (int)session.getAudits().getAudit().size());
        Assertions.assertEquals((Object)("Failed to convert field value '" + inputValue + "' into type '" + fieldType.value().toUpperCase() + "'"), (Object)((Audit)session.getAudits().getAudit().get(0)).getMessage());
        Assertions.assertEquals((Object)inputValue, (Object)((Audit)session.getAudits().getAudit().get(0)).getValue());
        Assertions.assertEquals((Object)AuditStatus.ERROR, (Object)((Audit)session.getAudits().getAudit().get(0)).getStatus());
    }

    private void validateDecimalValue(FieldType fieldType, String fileName, Object expectedValue) throws Exception {
        Path path = Paths.get("src" + File.separator + "test" + File.separator + "resources" + File.separator + "xmlFields" + File.separator + fileName, new String[0]);
        AtlasInternalSession session = this.readFromFile("/primitive/value", fieldType, path);
        Assertions.assertEquals((Object)expectedValue, (Object)session.head().getSourceField().getValue());
        Assertions.assertEquals((int)0, (int)session.getAudits().getAudit().size());
    }

    private void mockDataSources(String docId, AtlasInternalSession session) {
        AtlasMapping atlasMapping = (AtlasMapping)Mockito.mock(AtlasMapping.class);
        ArrayList<XmlDataSource> dataSources = new ArrayList<XmlDataSource>();
        XmlDataSource xmlDataSource = new XmlDataSource();
        xmlDataSource.setId(docId);
        xmlDataSource.setDataSourceType(DataSourceType.SOURCE);
        XmlNamespaces atlasNamespaces = new XmlNamespaces();
        XmlNamespace xmlNamespaceQ = new XmlNamespace();
        xmlNamespaceQ.setAlias("q");
        xmlNamespaceQ.setUri("http://www.example.com/q/");
        XmlNamespace xmlNamespaceX = new XmlNamespace();
        xmlNamespaceX.setAlias("");
        xmlNamespaceX.setUri("http://www.example.com/x/");
        XmlNamespace xmlNamespaceY = new XmlNamespace();
        xmlNamespaceY.setAlias("y");
        xmlNamespaceY.setUri("http://www.example.com/y/");
        atlasNamespaces.getXmlNamespace().add(xmlNamespaceQ);
        atlasNamespaces.getXmlNamespace().add(xmlNamespaceX);
        atlasNamespaces.getXmlNamespace().add(xmlNamespaceY);
        xmlDataSource.setXmlNamespaces(atlasNamespaces);
        dataSources.add(xmlDataSource);
        Mockito.when((Object)atlasMapping.getDataSource()).thenReturn(dataSources);
        Mockito.when((Object)session.getMapping()).thenReturn((Object)atlasMapping);
    }
}

