/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.xml.inspect;

import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.FieldType;
import io.atlasmap.xml.inspect.BaseXmlInspectionServiceTest;
import io.atlasmap.xml.inspect.XmlInspectionException;
import io.atlasmap.xml.inspect.XmlInspectionService;
import io.atlasmap.xml.v2.Restriction;
import io.atlasmap.xml.v2.RestrictionType;
import io.atlasmap.xml.v2.XmlComplexType;
import io.atlasmap.xml.v2.XmlDocument;
import io.atlasmap.xml.v2.XmlEnumField;
import io.atlasmap.xml.v2.XmlField;
import io.atlasmap.xml.v2.XmlNamespace;
import java.io.File;
import java.nio.file.Paths;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class XmlSchemaInspectionTest
extends BaseXmlInspectionServiceTest {
    @Test
    public void testInspectSchemaString() throws Exception {
        String source = "<xs:schema attributeFormDefault=\"unqualified\" elementFormDefault=\"qualified\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">\n  <xs:element name=\"data\">\n    <xs:complexType>\n      <xs:sequence>\n        <xs:element type=\"xs:int\" name=\"intField\"/>\n        <xs:element type=\"xs:long\" name=\"longField\"/>\n        <xs:element type=\"xs:string\" name=\"stringField\"/>\n        <xs:element type=\"xs:boolean\" name=\"booleanField\"/>\n        <xs:element type=\"xs:double\" name=\"doubleField\"/>\n        <xs:element type=\"xs:short\" name=\"shortField\"/>\n        <xs:element type=\"xs:float\" name=\"floatField\"/>\n        <xs:element type=\"xs:string\" name=\"charField\"/>\n      </xs:sequence>\n    </xs:complexType>\n  </xs:element>\n</xs:schema>";
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument xmlDocument = service.inspectSchema("<xs:schema attributeFormDefault=\"unqualified\" elementFormDefault=\"qualified\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">\n  <xs:element name=\"data\">\n    <xs:complexType>\n      <xs:sequence>\n        <xs:element type=\"xs:int\" name=\"intField\"/>\n        <xs:element type=\"xs:long\" name=\"longField\"/>\n        <xs:element type=\"xs:string\" name=\"stringField\"/>\n        <xs:element type=\"xs:boolean\" name=\"booleanField\"/>\n        <xs:element type=\"xs:double\" name=\"doubleField\"/>\n        <xs:element type=\"xs:short\" name=\"shortField\"/>\n        <xs:element type=\"xs:float\" name=\"floatField\"/>\n        <xs:element type=\"xs:string\" name=\"charField\"/>\n      </xs:sequence>\n    </xs:complexType>\n  </xs:element>\n</xs:schema>");
        Assert.assertNotNull((Object)xmlDocument);
        Assert.assertNotNull((Object)xmlDocument.getFields());
        Assert.assertEquals((long)1L, (long)xmlDocument.getFields().getField().size());
        XmlComplexType root = (XmlComplexType)xmlDocument.getFields().getField().get(0);
        Assert.assertNotNull((Object)root);
        Assert.assertEquals((long)8L, (long)root.getXmlFields().getXmlField().size());
    }

    @Test
    public void testInspectSchemaFile() throws Exception {
        File schemaFile = Paths.get("src/test/resources/inspect/simple-schema.xsd", new String[0]).toFile();
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument xmlDocument = service.inspectSchema(schemaFile);
        Assert.assertNotNull((Object)xmlDocument);
        Assert.assertNotNull((Object)xmlDocument.getFields());
        Assert.assertEquals((long)1L, (long)xmlDocument.getFields().getField().size());
        XmlComplexType root = (XmlComplexType)xmlDocument.getFields().getField().get(0);
        Assert.assertNotNull((Object)root);
        Assert.assertEquals((long)15L, (long)root.getXmlFields().getXmlField().size());
        XmlField nmtokenField = (XmlField)root.getXmlFields().getXmlField().get(8);
        Assert.assertEquals((Object)"nmtokenField", (Object)nmtokenField.getName());
        Assert.assertEquals((Object)FieldType.STRING, (Object)nmtokenField.getFieldType());
        XmlField anyuriField = (XmlField)root.getXmlFields().getXmlField().get(9);
        Assert.assertEquals((Object)"anyuriField", (Object)anyuriField.getName());
        Assert.assertEquals((Object)FieldType.STRING, (Object)anyuriField.getFieldType());
        XmlField base64BinaryField = (XmlField)root.getXmlFields().getXmlField().get(10);
        Assert.assertEquals((Object)"base64binaryField", (Object)base64BinaryField.getName());
        Assert.assertEquals((Object)FieldType.STRING, (Object)base64BinaryField.getFieldType());
        XmlField byteField = (XmlField)root.getXmlFields().getXmlField().get(11);
        Assert.assertEquals((Object)"byteField", (Object)byteField.getName());
        Assert.assertEquals((Object)FieldType.SHORT, (Object)byteField.getFieldType());
        XmlField unsignedByteField = (XmlField)root.getXmlFields().getXmlField().get(12);
        Assert.assertEquals((Object)"unsignedByteField", (Object)unsignedByteField.getName());
        Assert.assertEquals((Object)FieldType.UNSIGNED_SHORT, (Object)unsignedByteField.getFieldType());
        XmlField hexBinaryField = (XmlField)root.getXmlFields().getXmlField().get(13);
        Assert.assertEquals((Object)"hexBinaryField", (Object)hexBinaryField.getName());
        Assert.assertEquals((Object)FieldType.STRING, (Object)hexBinaryField.getFieldType());
        XmlField qnameField = (XmlField)root.getXmlFields().getXmlField().get(14);
        Assert.assertEquals((Object)"qnameField", (Object)qnameField.getName());
        Assert.assertEquals((Object)FieldType.STRING, (Object)qnameField.getFieldType());
    }

    @Test
    public void testInspectSchemaFileComplex() throws Exception {
        File schemaFile = Paths.get("src/test/resources/inspect/complex-schema.xsd", new String[0]).toFile();
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument xmlDocument = service.inspectSchema(schemaFile);
        Assert.assertNotNull((Object)xmlDocument);
        Assert.assertNotNull((Object)xmlDocument.getFields());
        Assert.assertEquals((long)1L, (long)xmlDocument.getFields().getField().size());
        XmlComplexType root = (XmlComplexType)xmlDocument.getFields().getField().get(0);
        Assert.assertNotNull((Object)root);
        Assert.assertEquals((long)10L, (long)root.getXmlFields().getXmlField().size());
        XmlField enumField = (XmlField)root.getXmlFields().getXmlField().get(9);
        Assert.assertEquals((Object)"enumField", (Object)enumField.getName());
        Assert.assertEquals((Object)FieldType.COMPLEX, (Object)enumField.getFieldType());
        XmlComplexType enumComplex = (XmlComplexType)enumField;
        Assert.assertTrue((boolean)enumComplex.isEnumeration());
        List enumFields = enumComplex.getXmlEnumFields().getXmlEnumField();
        Assert.assertEquals((long)6L, (long)enumFields.size());
        Assert.assertEquals((Object)"aaa", (Object)((XmlEnumField)enumFields.get(0)).getName());
        Assert.assertEquals((Object)"fff", (Object)((XmlEnumField)enumFields.get(5)).getName());
    }

    @Test
    public void testInspectSchemaFileWithNamespace() throws Exception {
        File schemaFile = Paths.get("src/test/resources/inspect/simple-namespace-schema.xsd", new String[0]).toFile();
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument xmlDocument = service.inspectSchema(schemaFile);
        Assert.assertNotNull((Object)xmlDocument);
        Assert.assertNotNull((Object)xmlDocument.getFields());
        Assert.assertEquals((long)1L, (long)xmlDocument.getFields().getField().size());
        Assert.assertNotNull((Object)xmlDocument.getXmlNamespaces());
        Assert.assertEquals((long)1L, (long)xmlDocument.getXmlNamespaces().getXmlNamespace().size());
        XmlNamespace namespace = (XmlNamespace)xmlDocument.getXmlNamespaces().getXmlNamespace().get(0);
        Assert.assertEquals((Object)"tns", (Object)namespace.getAlias());
        Assert.assertEquals((Object)"http://example.com/", (Object)namespace.getUri());
    }

    @Test
    public void testInspectShipOrderSchemaFile() throws Exception {
        File schemaFile = Paths.get("src/test/resources/inspect/ship-order-schema.xsd", new String[0]).toFile();
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument xmlDocument = service.inspectSchema(schemaFile);
        Assert.assertNotNull((Object)xmlDocument);
        Assert.assertNotNull((Object)xmlDocument.getFields());
        Assert.assertEquals((long)1L, (long)xmlDocument.getFields().getField().size());
        XmlComplexType root = (XmlComplexType)xmlDocument.getFields().getField().get(0);
        Assert.assertNotNull((Object)root);
        Assert.assertEquals((long)4L, (long)root.getXmlFields().getXmlField().size());
        XmlField orderIdAttr = (XmlField)root.getXmlFields().getXmlField().get(0);
        Assert.assertNotNull((Object)orderIdAttr);
        Assert.assertEquals((Object)"orderid", (Object)orderIdAttr.getName());
        Assert.assertEquals((Object)"2", (Object)orderIdAttr.getValue());
        Assert.assertEquals((Object)"/shiporder/@orderid", (Object)orderIdAttr.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)orderIdAttr.getFieldType());
        Assert.assertEquals((Object)true, (Object)orderIdAttr.isAttribute());
        XmlField orderPerson = (XmlField)root.getXmlFields().getXmlField().get(1);
        Assert.assertNotNull((Object)orderPerson);
        Assert.assertEquals((Object)"orderperson", (Object)orderPerson.getName());
        Assert.assertNull((Object)orderPerson.getValue());
        Assert.assertEquals((Object)"/shiporder/orderperson", (Object)orderPerson.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)orderPerson.getFieldType());
        Assert.assertEquals((Object)false, (Object)orderPerson.isAttribute());
        XmlField shipTo = (XmlField)root.getXmlFields().getXmlField().get(2);
        Assert.assertNotNull((Object)shipTo);
        Assert.assertTrue((boolean)(shipTo instanceof XmlComplexType));
        Assert.assertEquals((long)4L, (long)((XmlComplexType)shipTo).getXmlFields().getXmlField().size());
        XmlField item = (XmlField)root.getXmlFields().getXmlField().get(3);
        Assert.assertNotNull((Object)item);
        Assert.assertTrue((boolean)(item instanceof XmlComplexType));
        Assert.assertEquals((long)4L, (long)((XmlComplexType)item).getXmlFields().getXmlField().size());
    }

    @Test
    public void testInspectPOExampleSchemaFile() throws Exception {
        File schemaFile = Paths.get("src/test/resources/inspect/po-example-schema.xsd", new String[0]).toFile();
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument xmlDocument = service.inspectSchema(schemaFile);
        Assert.assertNotNull((Object)xmlDocument);
        Assert.assertNotNull((Object)xmlDocument.getFields());
        Assert.assertEquals((long)2L, (long)xmlDocument.getFields().getField().size());
        XmlComplexType purchaseOrder = (XmlComplexType)xmlDocument.getFields().getField().get(0);
        Assert.assertNotNull((Object)purchaseOrder);
        Assert.assertEquals((long)5L, (long)purchaseOrder.getXmlFields().getXmlField().size());
        XmlField orderDateAttr = (XmlField)purchaseOrder.getXmlFields().getXmlField().get(0);
        Assert.assertNotNull((Object)orderDateAttr);
        Assert.assertEquals((Object)"orderDate", (Object)orderDateAttr.getName());
        Assert.assertNull((Object)orderDateAttr.getValue());
        Assert.assertEquals((Object)"/tns:purchaseOrder/@orderDate", (Object)orderDateAttr.getPath());
        Assert.assertEquals((Object)FieldType.DATE, (Object)orderDateAttr.getFieldType());
        Assert.assertEquals((Object)true, (Object)orderDateAttr.isAttribute());
        XmlField shipTo = (XmlField)purchaseOrder.getXmlFields().getXmlField().get(1);
        Assert.assertNotNull((Object)shipTo);
        Assert.assertEquals((Object)"shipTo", (Object)shipTo.getName());
        Assert.assertNull((Object)shipTo.getValue());
        Assert.assertEquals((Object)"/tns:purchaseOrder/shipTo", (Object)shipTo.getPath());
        Assert.assertEquals((Object)FieldType.COMPLEX, (Object)shipTo.getFieldType());
        Assert.assertEquals((long)6L, (long)((XmlComplexType)shipTo).getXmlFields().getXmlField().size());
        XmlField shipToCountry = (XmlField)((XmlComplexType)shipTo).getXmlFields().getXmlField().get(0);
        Assert.assertNotNull((Object)shipTo);
        Assert.assertEquals((Object)"country", (Object)shipToCountry.getName());
        Assert.assertEquals((Object)"US", (Object)shipToCountry.getValue());
        Assert.assertEquals((Object)"/tns:purchaseOrder/shipTo/@country", (Object)shipToCountry.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)shipToCountry.getFieldType());
        Assert.assertEquals((Object)true, (Object)shipToCountry.isAttribute());
        XmlField shipToName = (XmlField)((XmlComplexType)shipTo).getXmlFields().getXmlField().get(1);
        Assert.assertNotNull((Object)shipToName);
        Assert.assertEquals((Object)"name", (Object)shipToName.getName());
        Assert.assertNull((Object)shipToName.getValue());
        Assert.assertEquals((Object)"/tns:purchaseOrder/shipTo/name", (Object)shipToName.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)shipToName.getFieldType());
        Assert.assertEquals((Object)false, (Object)shipToName.isAttribute());
        XmlField shipToStreet = (XmlField)((XmlComplexType)shipTo).getXmlFields().getXmlField().get(2);
        Assert.assertNotNull((Object)shipToStreet);
        Assert.assertEquals((Object)"street", (Object)shipToStreet.getName());
        Assert.assertNull((Object)shipToStreet.getValue());
        Assert.assertEquals((Object)"/tns:purchaseOrder/shipTo/street", (Object)shipToStreet.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)shipToStreet.getFieldType());
        Assert.assertEquals((Object)false, (Object)shipToStreet.isAttribute());
        XmlField shipToCity = (XmlField)((XmlComplexType)shipTo).getXmlFields().getXmlField().get(3);
        Assert.assertNotNull((Object)shipToCity);
        Assert.assertEquals((Object)"city", (Object)shipToCity.getName());
        Assert.assertNull((Object)shipToCity.getValue());
        Assert.assertEquals((Object)"/tns:purchaseOrder/shipTo/city", (Object)shipToCity.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)shipToCity.getFieldType());
        Assert.assertEquals((Object)false, (Object)shipToCity.isAttribute());
        XmlField shipToState = (XmlField)((XmlComplexType)shipTo).getXmlFields().getXmlField().get(4);
        Assert.assertNotNull((Object)shipToState);
        Assert.assertEquals((Object)"state", (Object)shipToState.getName());
        Assert.assertNull((Object)shipToState.getValue());
        Assert.assertEquals((Object)"/tns:purchaseOrder/shipTo/state", (Object)shipToState.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)shipToState.getFieldType());
        Assert.assertEquals((Object)false, (Object)shipToState.isAttribute());
        XmlField shipToZip = (XmlField)((XmlComplexType)shipTo).getXmlFields().getXmlField().get(5);
        Assert.assertNotNull((Object)shipToZip);
        Assert.assertEquals((Object)"zip", (Object)shipToZip.getName());
        Assert.assertNull((Object)shipToZip.getValue());
        Assert.assertEquals((Object)"/tns:purchaseOrder/shipTo/zip", (Object)shipToZip.getPath());
        Assert.assertEquals((Object)FieldType.DECIMAL, (Object)shipToZip.getFieldType());
        Assert.assertEquals((Object)false, (Object)shipToZip.isAttribute());
        XmlField comment = (XmlField)purchaseOrder.getXmlFields().getXmlField().get(3);
        Assert.assertNotNull((Object)comment);
        Assert.assertEquals((Object)"tns:comment", (Object)comment.getName());
        Assert.assertNull((Object)comment.getValue());
        Assert.assertEquals((Object)"/tns:purchaseOrder/tns:comment", (Object)comment.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)comment.getFieldType());
        Assert.assertEquals((Object)false, (Object)comment.isAttribute());
        XmlField items = (XmlField)purchaseOrder.getXmlFields().getXmlField().get(4);
        Assert.assertNotNull((Object)items);
        Assert.assertEquals((Object)"items", (Object)items.getName());
        Assert.assertNull((Object)items.getValue());
        Assert.assertEquals((Object)"/tns:purchaseOrder/items", (Object)items.getPath());
        Assert.assertEquals((Object)FieldType.COMPLEX, (Object)items.getFieldType());
        Assert.assertEquals((Object)false, (Object)items.isAttribute());
        Assert.assertEquals((long)1L, (long)((XmlComplexType)items).getXmlFields().getXmlField().size());
        XmlComplexType item = (XmlComplexType)((XmlComplexType)items).getXmlFields().getXmlField().get(0);
        Assert.assertNotNull((Object)item);
        Assert.assertEquals((Object)"item", (Object)item.getName());
        Assert.assertNull((Object)item.getValue());
        Assert.assertEquals((Object)"/tns:purchaseOrder/items/item", (Object)item.getPath());
        Assert.assertEquals((Object)FieldType.COMPLEX, (Object)item.getFieldType());
        Assert.assertEquals((Object)false, (Object)item.isAttribute());
        Assert.assertEquals((Object)CollectionType.LIST, (Object)item.getCollectionType());
        Assert.assertEquals((long)6L, (long)item.getXmlFields().getXmlField().size());
        XmlField partNum = (XmlField)item.getXmlFields().getXmlField().get(0);
        Assert.assertNotNull((Object)partNum);
        Assert.assertEquals((Object)"partNum", (Object)partNum.getName());
        Assert.assertNull((Object)partNum.getValue());
        Assert.assertEquals((Object)"/tns:purchaseOrder/items/item/@partNum", (Object)partNum.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)partNum.getFieldType());
        Assert.assertEquals((Object)"SKU", (Object)partNum.getTypeName());
        Assert.assertEquals((Object)true, (Object)partNum.isAttribute());
        XmlField productName = (XmlField)item.getXmlFields().getXmlField().get(1);
        Assert.assertNotNull((Object)productName);
        Assert.assertEquals((Object)"productName", (Object)productName.getName());
        Assert.assertNull((Object)productName.getValue());
        Assert.assertEquals((Object)"/tns:purchaseOrder/items/item/productName", (Object)productName.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)productName.getFieldType());
        Assert.assertEquals((Object)false, (Object)productName.isAttribute());
        XmlField quantity = (XmlField)item.getXmlFields().getXmlField().get(2);
        Assert.assertNotNull((Object)quantity);
        Assert.assertEquals((Object)"quantity", (Object)quantity.getName());
        Assert.assertNull((Object)quantity.getValue());
        Assert.assertEquals((Object)"/tns:purchaseOrder/items/item/quantity", (Object)quantity.getPath());
        Assert.assertEquals((Object)FieldType.BIG_INTEGER, (Object)quantity.getFieldType());
        Assert.assertEquals((Object)false, (Object)quantity.isAttribute());
        Assert.assertNotNull((Object)quantity.getRestrictions().getRestriction());
        Assert.assertEquals((long)1L, (long)quantity.getRestrictions().getRestriction().size());
        Restriction qRestriction = (Restriction)quantity.getRestrictions().getRestriction().get(0);
        Assert.assertNotNull((Object)qRestriction);
        Assert.assertNotNull((Object)qRestriction.getType());
        Assert.assertEquals((Object)RestrictionType.MAX_EXCLUSIVE, (Object)qRestriction.getType());
        Assert.assertNotNull((Object)qRestriction.getValue());
        Assert.assertEquals((Object)"99", (Object)qRestriction.getValue());
        XmlField usPrice = (XmlField)item.getXmlFields().getXmlField().get(3);
        Assert.assertNotNull((Object)usPrice);
        Assert.assertEquals((Object)"USPrice", (Object)usPrice.getName());
        Assert.assertNull((Object)usPrice.getValue());
        Assert.assertEquals((Object)"/tns:purchaseOrder/items/item/USPrice", (Object)usPrice.getPath());
        Assert.assertEquals((Object)FieldType.DECIMAL, (Object)usPrice.getFieldType());
        Assert.assertEquals((Object)false, (Object)usPrice.isAttribute());
        XmlField itemComment = (XmlField)item.getXmlFields().getXmlField().get(4);
        Assert.assertNotNull((Object)itemComment);
        Assert.assertEquals((Object)"tns:comment", (Object)itemComment.getName());
        Assert.assertNull((Object)itemComment.getValue());
        Assert.assertEquals((Object)"/tns:purchaseOrder/items/item/tns:comment", (Object)itemComment.getPath());
        Assert.assertEquals((Object)FieldType.STRING, (Object)itemComment.getFieldType());
        Assert.assertEquals((Object)false, (Object)itemComment.isAttribute());
        XmlField shipDate = (XmlField)item.getXmlFields().getXmlField().get(5);
        Assert.assertNotNull((Object)shipDate);
        Assert.assertEquals((Object)"shipDate", (Object)shipDate.getName());
        Assert.assertNull((Object)shipDate.getValue());
        Assert.assertEquals((Object)"/tns:purchaseOrder/items/item/shipDate", (Object)shipDate.getPath());
        Assert.assertEquals((Object)FieldType.DATE, (Object)shipDate.getFieldType());
        Assert.assertEquals((Object)false, (Object)shipDate.isAttribute());
        Assert.assertNotNull((Object)xmlDocument.getXmlNamespaces());
        Assert.assertEquals((long)1L, (long)xmlDocument.getXmlNamespaces().getXmlNamespace().size());
        XmlNamespace namespace = (XmlNamespace)xmlDocument.getXmlNamespaces().getXmlNamespace().get(0);
        Assert.assertEquals((Object)"tns", (Object)namespace.getAlias());
        Assert.assertEquals((Object)"http://tempuri.org/po.xsd", (Object)namespace.getUri());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInspectSchemaStringAsSourceNull() throws Exception {
        XmlInspectionService service = new XmlInspectionService();
        String schema = null;
        service.inspectSchema(schema);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInspectSchemaStringAsSourceBlank() throws Exception {
        XmlInspectionService service = new XmlInspectionService();
        String schema = "";
        service.inspectSchema(schema);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInspectSchemaFileAsSourceNull() throws Exception {
        XmlInspectionService service = new XmlInspectionService();
        File schema = null;
        service.inspectSchema(schema);
    }

    @Test(expected=XmlInspectionException.class)
    public void testInspectSchemaBad() throws Exception {
        String source = "<xs:schema/>";
        XmlInspectionService service = new XmlInspectionService();
        service.inspectSchema("<xs:schema/>");
    }

    @Test(expected=XmlInspectionException.class)
    public void testInspectSchemaFileBad() throws Exception {
        File schemaFile = Paths.get("src/test/resources/inspect/simple-schema-bad.xsd", new String[0]).toFile();
        XmlInspectionService service = new XmlInspectionService();
        service.inspectSchema(schemaFile);
    }
}

