/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.xml.inspect;

import io.atlasmap.v2.FieldType;
import io.atlasmap.xml.inspect.BaseXmlInspectionServiceTest;
import io.atlasmap.xml.inspect.XmlInspectionException;
import io.atlasmap.xml.inspect.XmlInspectionService;
import io.atlasmap.xml.v2.XmlComplexType;
import io.atlasmap.xml.v2.XmlDocument;
import io.atlasmap.xml.v2.XmlField;
import io.atlasmap.xml.v2.XmlNamespace;
import java.io.File;
import java.nio.file.Paths;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class XmlSchemaInspectionMultipleNamespacesTest
extends BaseXmlInspectionServiceTest {
    @Test
    public void testMultipleNamespaces() throws Exception {
        File schemaFile = Paths.get("src/test/resources/inspect/multiple-namespaces-schemaset.xml", new String[0]).toFile();
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument answer = service.inspectSchema(schemaFile);
        Assert.assertEquals((long)3L, (long)answer.getXmlNamespaces().getXmlNamespace().size());
        block38: for (XmlNamespace namespace : answer.getXmlNamespaces().getXmlNamespace()) {
            switch (namespace.getAlias()) {
                case "tns": {
                    Assert.assertEquals((Object)"io.atlasmap.xml.test:Root", (Object)namespace.getUri());
                    Assert.assertEquals(null, (Object)namespace.isTargetNamespace());
                    continue block38;
                }
                case "first": {
                    Assert.assertEquals((Object)"io.atlasmap.xml.test:First", (Object)namespace.getUri());
                    Assert.assertEquals(null, (Object)namespace.isTargetNamespace());
                    continue block38;
                }
                case "second": {
                    Assert.assertEquals((Object)"io.atlasmap.xml.test:Second", (Object)namespace.getUri());
                    Assert.assertEquals(null, (Object)namespace.isTargetNamespace());
                    continue block38;
                }
            }
            Assert.fail((String)String.format("Unknown alias '%s'", namespace.getAlias()));
        }
        List fields = answer.getFields().getField();
        Assert.assertEquals((long)1L, (long)fields.size());
        XmlComplexType complex = (XmlComplexType)XmlComplexType.class.cast(fields.get(0));
        Assert.assertEquals((Object)"tns:RootDocument", (Object)complex.getName());
        List rootFields = complex.getXmlFields().getXmlField();
        Assert.assertEquals((long)4L, (long)rootFields.size());
        block39: for (XmlField xmlField : rootFields) {
            switch (xmlField.getName()) {
                case "Name": {
                    Assert.assertEquals((Object)FieldType.STRING, (Object)xmlField.getFieldType());
                    Assert.assertEquals((Object)"/tns:RootDocument/Name", (Object)xmlField.getPath());
                    break;
                }
                case "Value": {
                    Assert.assertEquals((Object)FieldType.STRING, (Object)xmlField.getFieldType());
                    Assert.assertEquals((Object)"/tns:RootDocument/Value", (Object)xmlField.getPath());
                    break;
                }
                case "first:FirstElement": {
                    Assert.assertEquals((Object)FieldType.COMPLEX, (Object)xmlField.getFieldType());
                    Assert.assertEquals((Object)"/tns:RootDocument/first:FirstElement", (Object)xmlField.getPath());
                    List firstFields = ((XmlComplexType)XmlComplexType.class.cast(xmlField)).getXmlFields().getXmlField();
                    Assert.assertEquals((long)2L, (long)firstFields.size());
                    block40: for (XmlField firstField : firstFields) {
                        switch (firstField.getName()) {
                            case "Name": {
                                Assert.assertEquals((Object)FieldType.STRING, (Object)firstField.getFieldType());
                                Assert.assertEquals((Object)"/tns:RootDocument/first:FirstElement/Name", (Object)firstField.getPath());
                                continue block40;
                            }
                            case "Value": {
                                Assert.assertEquals((Object)FieldType.STRING, (Object)firstField.getFieldType());
                                Assert.assertEquals((Object)"/tns:RootDocument/first:FirstElement/Value", (Object)firstField.getPath());
                                continue block40;
                            }
                        }
                        Assert.fail((String)String.format("Unknown field '%s'", firstField.getPath()));
                    }
                    continue block39;
                }
                case "second:SecondElement": {
                    Assert.assertEquals((Object)FieldType.COMPLEX, (Object)xmlField.getFieldType());
                    Assert.assertEquals((Object)"/tns:RootDocument/second:SecondElement", (Object)xmlField.getPath());
                    List secondFields = ((XmlComplexType)XmlComplexType.class.cast(xmlField)).getXmlFields().getXmlField();
                    Assert.assertEquals((long)2L, (long)secondFields.size());
                    block41: for (XmlField secondField : secondFields) {
                        switch (secondField.getName()) {
                            case "Name": {
                                Assert.assertEquals((Object)FieldType.STRING, (Object)secondField.getFieldType());
                                Assert.assertEquals((Object)"/tns:RootDocument/second:SecondElement/Name", (Object)secondField.getPath());
                                continue block41;
                            }
                            case "Value": {
                                Assert.assertEquals((Object)FieldType.STRING, (Object)secondField.getFieldType());
                                Assert.assertEquals((Object)"/tns:RootDocument/second:SecondElement/Value", (Object)secondField.getPath());
                                continue block41;
                            }
                        }
                        Assert.fail((String)String.format("Unknown field '%s'", secondField.getPath()));
                    }
                    continue block39;
                }
                default: {
                    Assert.fail((String)String.format("Unknown field '%s'", xmlField.getPath()));
                }
            }
        }
    }

    @Test
    public void testMultipleNoNamespaceSchemas() throws Exception {
        File schemaFile = Paths.get("src/test/resources/inspect/multiple-no-namespace-schemas.xml", new String[0]).toFile();
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument answer = service.inspectSchema(schemaFile);
        Assert.assertEquals((long)1L, (long)answer.getXmlNamespaces().getXmlNamespace().size());
        XmlNamespace namespace = (XmlNamespace)answer.getXmlNamespaces().getXmlNamespace().get(0);
        Assert.assertEquals((Object)"tns", (Object)namespace.getAlias());
        Assert.assertEquals((Object)"io.atlasmap.xml.test:Root", (Object)namespace.getUri());
        Assert.assertEquals(null, (Object)namespace.isTargetNamespace());
        Assert.assertEquals((long)1L, (long)answer.getFields().getField().size());
        XmlComplexType complex = (XmlComplexType)XmlComplexType.class.cast(answer.getFields().getField().get(0));
        Assert.assertEquals((Object)"tns:RootDocument", (Object)complex.getName());
        Assert.assertEquals((long)2L, (long)complex.getXmlFields().getXmlField().size());
        block8: for (XmlField field : complex.getXmlFields().getXmlField()) {
            switch (field.getName()) {
                case "FirstElement": {
                    Assert.assertEquals((Object)FieldType.COMPLEX, (Object)field.getFieldType());
                    Assert.assertEquals((Object)"/tns:RootDocument/FirstElement", (Object)field.getPath());
                    List firstFields = ((XmlComplexType)XmlComplexType.class.cast(field)).getXmlFields().getXmlField();
                    Assert.assertEquals((long)1L, (long)firstFields.size());
                    XmlField firstField = (XmlField)firstFields.get(0);
                    Assert.assertEquals((Object)"FirstValue", (Object)firstField.getName());
                    Assert.assertEquals((Object)FieldType.STRING, (Object)firstField.getFieldType());
                    Assert.assertEquals((Object)"/tns:RootDocument/FirstElement/FirstValue", (Object)firstField.getPath());
                    continue block8;
                }
                case "SecondElement": {
                    Assert.assertEquals((Object)FieldType.COMPLEX, (Object)field.getFieldType());
                    Assert.assertEquals((Object)"/tns:RootDocument/SecondElement", (Object)field.getPath());
                    List secondFields = ((XmlComplexType)XmlComplexType.class.cast(field)).getXmlFields().getXmlField();
                    Assert.assertEquals((long)1L, (long)secondFields.size());
                    XmlField secondField = (XmlField)secondFields.get(0);
                    Assert.assertEquals((Object)"SecondValue", (Object)secondField.getName());
                    Assert.assertEquals((Object)FieldType.STRING, (Object)secondField.getFieldType());
                    Assert.assertEquals((Object)"/tns:RootDocument/SecondElement/SecondValue", (Object)secondField.getPath());
                    continue block8;
                }
            }
            Assert.fail((String)String.format("Unknown field '%s'", field.getPath()));
        }
    }

    @Test
    public void testMultipleNoNamespaceRootSchema() throws Exception {
        File schemaFile = Paths.get("src/test/resources/inspect/multiple-no-namespace-root-schema.xml", new String[0]).toFile();
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument answer = service.inspectSchema(schemaFile);
        Assert.assertEquals((long)1L, (long)answer.getXmlNamespaces().getXmlNamespace().size());
        XmlNamespace namespace = (XmlNamespace)answer.getXmlNamespaces().getXmlNamespace().get(0);
        Assert.assertEquals((Object)"second", (Object)namespace.getAlias());
        Assert.assertEquals((Object)"io.atlasmap.xml.test:Second", (Object)namespace.getUri());
        Assert.assertEquals(null, (Object)namespace.isTargetNamespace());
        Assert.assertEquals((long)2L, (long)answer.getFields().getField().size());
        XmlComplexType complex = (XmlComplexType)XmlComplexType.class.cast(answer.getFields().getField().get(1));
        Assert.assertEquals((Object)"RootDocument", (Object)complex.getName());
        Assert.assertEquals((long)2L, (long)complex.getXmlFields().getXmlField().size());
        block8: for (XmlField field : complex.getXmlFields().getXmlField()) {
            switch (field.getName()) {
                case "FirstElement": {
                    Assert.assertEquals((Object)FieldType.COMPLEX, (Object)field.getFieldType());
                    Assert.assertEquals((Object)"/RootDocument/FirstElement", (Object)field.getPath());
                    List firstFields = ((XmlComplexType)XmlComplexType.class.cast(field)).getXmlFields().getXmlField();
                    Assert.assertEquals((long)1L, (long)firstFields.size());
                    XmlField firstField = (XmlField)firstFields.get(0);
                    Assert.assertEquals((Object)"FirstValue", (Object)firstField.getName());
                    Assert.assertEquals((Object)FieldType.STRING, (Object)firstField.getFieldType());
                    Assert.assertEquals((Object)"/RootDocument/FirstElement/FirstValue", (Object)firstField.getPath());
                    continue block8;
                }
                case "second:SecondElement": {
                    Assert.assertEquals((Object)FieldType.COMPLEX, (Object)field.getFieldType());
                    Assert.assertEquals((Object)"/RootDocument/second:SecondElement", (Object)field.getPath());
                    List secondFields = ((XmlComplexType)XmlComplexType.class.cast(field)).getXmlFields().getXmlField();
                    Assert.assertEquals((long)1L, (long)secondFields.size());
                    XmlField secondField = (XmlField)secondFields.get(0);
                    Assert.assertEquals((Object)"SecondValue", (Object)secondField.getName());
                    Assert.assertEquals((Object)FieldType.STRING, (Object)secondField.getFieldType());
                    Assert.assertEquals((Object)"/RootDocument/second:SecondElement/SecondValue", (Object)secondField.getPath());
                    continue block8;
                }
            }
            Assert.fail((String)String.format("Unknown field '%s'", field.getPath()));
        }
    }

    @Test(expected=XmlInspectionException.class)
    public void testMultipleNoNamespaceSchemasConflict() throws Exception {
        File schemaFile = Paths.get("src/test/resources/inspect/multiple-no-namespace-schemas-conflict.xml", new String[0]).toFile();
        XmlInspectionService service = new XmlInspectionService();
        service.inspectSchema(schemaFile);
    }

    @Test
    public void testSyndesis() throws Exception {
        File schemaFile = Paths.get("src/test/resources/inspect/multiple-namespaces-syndesis.xml", new String[0]).toFile();
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument answer = service.inspectSchema(schemaFile);
        Assert.assertEquals((long)1L, (long)answer.getXmlNamespaces().getXmlNamespace().size());
        XmlNamespace namespace = (XmlNamespace)answer.getXmlNamespaces().getXmlNamespace().get(0);
        Assert.assertEquals((Object)"tns", (Object)namespace.getAlias());
        Assert.assertEquals((Object)"http://syndesis.io/v1/swagger-connector-template/request", (Object)namespace.getUri());
        Assert.assertEquals(null, (Object)namespace.isTargetNamespace());
        List fields = answer.getFields().getField();
        Assert.assertEquals((long)1L, (long)fields.size());
        XmlComplexType complex = (XmlComplexType)XmlComplexType.class.cast(fields.get(0));
        Assert.assertEquals((Object)"tns:request", (Object)complex.getName());
        List rootFields = complex.getXmlFields().getXmlField();
        Assert.assertEquals((long)1L, (long)rootFields.size());
        complex = (XmlComplexType)XmlComplexType.class.cast(rootFields.get(0));
        Assert.assertEquals((Object)"tns:body", (Object)complex.getName());
        List bodyFields = complex.getXmlFields().getXmlField();
        Assert.assertEquals((long)1L, (long)bodyFields.size());
        complex = (XmlComplexType)XmlComplexType.class.cast(bodyFields.get(0));
        Assert.assertEquals((Object)"Pet", (Object)complex.getName());
        List petFields = complex.getXmlFields().getXmlField();
        Assert.assertEquals((long)6L, (long)petFields.size());
        block32: for (XmlField xmlField : petFields) {
            switch (xmlField.getName()) {
                case "id": {
                    Assert.assertEquals((Object)FieldType.DECIMAL, (Object)xmlField.getFieldType());
                    Assert.assertEquals((Object)"/tns:request/tns:body/Pet/id", (Object)xmlField.getPath());
                    break;
                }
                case "Category": {
                    Assert.assertEquals((Object)FieldType.COMPLEX, (Object)xmlField.getFieldType());
                    Assert.assertEquals((Object)"/tns:request/tns:body/Pet/Category", (Object)xmlField.getPath());
                    List categoryFields = ((XmlComplexType)XmlComplexType.class.cast(xmlField)).getXmlFields().getXmlField();
                    Assert.assertEquals((long)2L, (long)categoryFields.size());
                    block33: for (XmlField categoryField : categoryFields) {
                        switch (categoryField.getName()) {
                            case "id": {
                                Assert.assertEquals((Object)FieldType.DECIMAL, (Object)categoryField.getFieldType());
                                Assert.assertEquals((Object)"/tns:request/tns:body/Pet/Category/id", (Object)categoryField.getPath());
                                continue block33;
                            }
                            case "name": {
                                Assert.assertEquals((Object)FieldType.STRING, (Object)categoryField.getFieldType());
                                Assert.assertEquals((Object)"/tns:request/tns:body/Pet/Category/name", (Object)categoryField.getPath());
                                continue block33;
                            }
                        }
                        Assert.fail((String)String.format("Unknown field '%s'", categoryField.getPath()));
                    }
                    continue block32;
                }
                case "name": {
                    Assert.assertEquals((Object)FieldType.STRING, (Object)xmlField.getFieldType());
                    Assert.assertEquals((Object)"/tns:request/tns:body/Pet/name", (Object)xmlField.getPath());
                    break;
                }
                case "photoUrl": {
                    Assert.assertEquals((Object)FieldType.COMPLEX, (Object)xmlField.getFieldType());
                    Assert.assertEquals((Object)"/tns:request/tns:body/Pet/photoUrl", (Object)xmlField.getPath());
                    List photoUrlFields = ((XmlComplexType)XmlComplexType.class.cast(xmlField)).getXmlFields().getXmlField();
                    Assert.assertEquals((long)1L, (long)photoUrlFields.size());
                    XmlField photoUrlField = (XmlField)photoUrlFields.get(0);
                    Assert.assertEquals((Object)FieldType.STRING, (Object)photoUrlField.getFieldType());
                    Assert.assertEquals((Object)"/tns:request/tns:body/Pet/photoUrl/photoUrl", (Object)photoUrlField.getPath());
                    break;
                }
                case "tag": {
                    Assert.assertEquals((Object)FieldType.COMPLEX, (Object)xmlField.getFieldType());
                    Assert.assertEquals((Object)"/tns:request/tns:body/Pet/tag", (Object)xmlField.getPath());
                    List tagFields = ((XmlComplexType)XmlComplexType.class.cast(xmlField)).getXmlFields().getXmlField();
                    Assert.assertEquals((long)1L, (long)tagFields.size());
                    XmlField tagField = (XmlField)tagFields.get(0);
                    Assert.assertEquals((Object)FieldType.COMPLEX, (Object)tagField.getFieldType());
                    Assert.assertEquals((Object)"/tns:request/tns:body/Pet/tag/Tag", (Object)tagField.getPath());
                    List tagTagFields = ((XmlComplexType)XmlComplexType.class.cast(tagField)).getXmlFields().getXmlField();
                    Assert.assertEquals((long)2L, (long)tagTagFields.size());
                    block34: for (XmlField tagTagField : tagTagFields) {
                        switch (tagTagField.getName()) {
                            case "id": {
                                Assert.assertEquals((Object)FieldType.DECIMAL, (Object)tagTagField.getFieldType());
                                Assert.assertEquals((Object)"/tns:request/tns:body/Pet/tag/Tag/id", (Object)tagTagField.getPath());
                                continue block34;
                            }
                            case "name": {
                                Assert.assertEquals((Object)FieldType.STRING, (Object)tagTagField.getFieldType());
                                Assert.assertEquals((Object)"/tns:request/tns:body/Pet/tag/Tag/name", (Object)tagTagField.getPath());
                                continue block34;
                            }
                        }
                        Assert.fail((String)String.format("Unknown field '%s'", tagTagField.getPath()));
                    }
                    continue block32;
                }
                case "status": {
                    Assert.assertEquals((Object)FieldType.STRING, (Object)xmlField.getFieldType());
                    Assert.assertEquals((Object)"/tns:request/tns:body/Pet/status", (Object)xmlField.getPath());
                    break;
                }
                default: {
                    Assert.fail((String)String.format("Unknown field '%s'", xmlField.getPath()));
                }
            }
        }
    }
}

