/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.xml.inspect;

import io.atlasmap.v2.FieldType;
import io.atlasmap.xml.inspect.BaseXmlInspectionServiceTest;
import io.atlasmap.xml.inspect.XmlInspectionService;
import io.atlasmap.xml.v2.XmlComplexType;
import io.atlasmap.xml.v2.XmlDocument;
import io.atlasmap.xml.v2.XmlField;
import java.io.File;
import java.nio.file.Paths;
import org.junit.Assert;
import org.junit.Test;

public class XmlSchemaInspectionFhirTest
extends BaseXmlInspectionServiceTest {
    @Test
    public void test() throws Exception {
        File schemaFile = Paths.get("src/test/resources/inspect/fhir-patient.xsd", new String[0]).toFile();
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument xmlDocument = service.inspectSchema(schemaFile);
        Assert.assertNotNull((Object)xmlDocument);
        Assert.assertNotNull((Object)xmlDocument.getFields());
        Assert.assertEquals((long)1L, (long)xmlDocument.getFields().getField().size());
        XmlComplexType root = (XmlComplexType)xmlDocument.getFields().getField().get(0);
        Assert.assertNotNull((Object)root);
        Assert.assertEquals((long)26L, (long)root.getXmlFields().getXmlField().size());
        XmlComplexType id = (XmlComplexType)root.getXmlFields().getXmlField().get(0);
        Assert.assertEquals((Object)"tns:id", (Object)id.getName());
        Assert.assertEquals((long)2L, (long)id.getXmlFields().getXmlField().size());
        XmlField value = (XmlField)id.getXmlFields().getXmlField().get(0);
        Assert.assertEquals((Object)"value", (Object)value.getName());
        Assert.assertTrue((boolean)value.isAttribute());
        XmlComplexType extension = (XmlComplexType)id.getXmlFields().getXmlField().get(1);
        Assert.assertEquals((Object)"tns:extension", (Object)extension.getName());
        Assert.assertNull((Object)extension.getStatus());
        Assert.assertEquals((long)40L, (long)extension.getXmlFields().getXmlField().size());
        XmlComplexType meta = (XmlComplexType)root.getXmlFields().getXmlField().get(1);
        Assert.assertEquals((Object)"tns:meta", (Object)meta.getName());
        Assert.assertNull((Object)meta.getStatus());
        XmlComplexType name = (XmlComplexType)root.getXmlFields().getXmlField().get(9);
        Assert.assertEquals((Object)"tns:name", (Object)name.getName());
        Assert.assertEquals((long)8L, (long)name.getXmlFields().getXmlField().size());
        XmlComplexType family = (XmlComplexType)name.getXmlFields().getXmlField().get(3);
        Assert.assertEquals((Object)"tns:family", (Object)family.getName());
        Assert.assertEquals((long)2L, (long)family.getXmlFields().getXmlField().size());
        XmlField familyValue = (XmlField)family.getXmlFields().getXmlField().get(0);
        Assert.assertEquals((Object)FieldType.STRING, (Object)familyValue.getFieldType());
        Assert.assertTrue((boolean)familyValue.isAttribute());
        XmlComplexType given = (XmlComplexType)name.getXmlFields().getXmlField().get(4);
        Assert.assertEquals((Object)"tns:given", (Object)given.getName());
        Assert.assertEquals((long)2L, (long)given.getXmlFields().getXmlField().size());
        XmlField givenValue = (XmlField)given.getXmlFields().getXmlField().get(0);
        Assert.assertEquals((Object)FieldType.STRING, (Object)givenValue.getFieldType());
        Assert.assertTrue((boolean)givenValue.isAttribute());
    }
}

