/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.xml.core;

import io.atlasmap.api.AtlasException;
import io.atlasmap.core.DefaultAtlasConversionService;
import io.atlasmap.spi.AtlasConversionService;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.v2.Audit;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.Audits;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldType;
import io.atlasmap.xml.core.XmlFieldReader;
import io.atlasmap.xml.core.XmlFieldWriter;
import io.atlasmap.xml.core.XmlIOHelper;
import io.atlasmap.xml.v2.AtlasXmlModelFactory;
import io.atlasmap.xml.v2.XmlField;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.validation.Schema;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XmlFieldWriterTest {
    private static final String HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n";
    private XmlFieldWriter writer = null;
    private Document document = null;
    private String seedDocument = null;
    private Map<String, String> namespaces = new HashMap<String, String>();
    private XmlFieldReader reader = new XmlFieldReader(XmlFieldReader.class.getClassLoader(), (AtlasConversionService)DefaultAtlasConversionService.getInstance());
    private XmlIOHelper xmlHelper = new XmlIOHelper(XmlIOHelper.class.getClassLoader());

    @Before
    public void setup() {
        this.writer = null;
        this.document = null;
        this.seedDocument = null;
        this.namespaces = new HashMap<String, String>();
    }

    public void createWriter() throws Exception {
        this.createWriter(null);
    }

    public void createWriter(Schema schema) throws Exception {
        this.writer = new XmlFieldWriter(XmlFieldWriter.class.getClassLoader(), this.namespaces, this.seedDocument);
        this.document = this.writer.getDocument();
        Assert.assertNotNull((Object)this.document);
    }

    public void writeValue(String path, Object value) throws Exception {
        if (this.writer == null) {
            this.createWriter();
        }
        XmlField xmlField = AtlasXmlModelFactory.createXmlField();
        xmlField.setPath(path);
        xmlField.setValue(value);
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn(Mockito.mock(AtlasInternalSession.Head.class));
        Mockito.when((Object)session.head().getSourceField()).thenReturn(Mockito.mock(Field.class));
        Mockito.when((Object)session.head().getTargetField()).thenReturn((Object)xmlField);
        this.writer.write(session);
    }

    @Test
    public void testWriteValueToDefaultDocument() throws Exception {
        this.writeValue("/orders/order/id", "3333333354");
        String expected = "<orders><order><id>3333333354</id></order></orders>";
        this.checkResult("<orders><order><id>3333333354</id></order></orders>");
    }

    @Test
    public void testWriteValueToAttributeWithDefaultDocument() throws Exception {
        this.writeValue("/orders/order/id/@custId", "b");
        String expected = "<orders><order><id custId=\"b\"/></order></orders>";
        this.checkResult("<orders><order><id custId=\"b\"/></order></orders>");
    }

    @Test
    public void testWriteValueWithSeedDocument() throws Exception {
        this.seedDocument = "<orders/>";
        this.writeValue("/orders/order/id/@custId", "b");
        this.writeValue("/orders/order/id", "3333333354");
        String expected = "<orders><order><id custId=\"b\">3333333354</id></order></orders>";
        this.checkResult("<orders><order><id custId=\"b\">3333333354</id></order></orders>");
    }

    @Test
    public void testWriteValueWithSeedDocumentWithNamespaces() throws Exception {
        this.seedDocument = "<orders xmlns:x=\"http://www.example.com/x/\"/>";
        this.writeValue("/orders/order/x:id/@custId", "b");
        this.writeValue("/orders/order/x:id", "3333333354");
        String expected = "<orders xmlns:x=\"http://www.example.com/x/\"><order><x:id custId=\"b\">3333333354</x:id></order></orders>";
        this.checkResult("<orders xmlns:x=\"http://www.example.com/x/\"><order><x:id custId=\"b\">3333333354</x:id></order></orders>");
    }

    @Test
    public void testWriteValueWithSeedDocumentWithDefaultNamespace() throws Exception {
        this.seedDocument = "<orders xmlns=\"http://www.example.com/x/\"/>";
        this.writeValue("/orders/order/id/@custId", "b");
        this.writeValue("/orders/order/id", "3333333354");
        String expected = "<orders xmlns=\"http://www.example.com/x/\"><order><id custId=\"b\">3333333354</id></order></orders>";
        this.checkResult("<orders xmlns=\"http://www.example.com/x/\"><order><id custId=\"b\">3333333354</id></order></orders>");
    }

    @Test
    public void testWriteValueWithSeedDocumentWithNamespacesAddNamespace() throws Exception {
        this.seedDocument = "<orders xmlns:x=\"http://www.example.com/x/\"><x:order foo=\"bar\">preexisting</x:order></orders>";
        this.namespaces.put("y", "http://www.example.com/y/");
        this.writeValue("/orders/y:order/x:id/@custId", "b");
        this.writeValue("/orders/y:order/x:id", "3333333354");
        String expected = "<orders xmlns:x=\"http://www.example.com/x/\" xmlns:y=\"http://www.example.com/y/\"><x:order foo=\"bar\">preexisting</x:order><y:order><x:id custId=\"b\">3333333354</x:id></y:order></orders>";
        this.checkResult("<orders xmlns:x=\"http://www.example.com/x/\" xmlns:y=\"http://www.example.com/y/\"><x:order foo=\"bar\">preexisting</x:order><y:order><x:id custId=\"b\">3333333354</x:id></y:order></orders>");
    }

    @Test
    public void testWriteValueToDefaultDocumentComplex() throws Exception {
        this.seedDocument = new String(Files.readAllBytes(Paths.get("src/test/resources/complex_example_write.xml", new String[0])));
        this.writeValue("/orders/order[2]/id[2]", "54554555");
        this.checkResultFromFile("complex_example.xml");
    }

    @Test
    public void testWriteNewNodeWithAttrToDocumentComplex() throws Exception {
        this.seedDocument = new String(Files.readAllBytes(Paths.get("src/test/resources/complex_example_write_attr.xml", new String[0])));
        this.writeValue("/orders/order[2]/id[2]", "54554555");
        this.writeValue("/orders/order[2]/id[2]/@custId", "c");
        this.checkResultFromFile("complex_example.xml");
    }

    @Test
    public void testBuildSimpleExampleDocument() throws Exception {
        this.writeValue("/orders/@totalCost", "12525.00");
        this.writeValue("/orders/order/id/@custId", "a");
        this.writeValue("/orders/order/id", "12312");
        this.writeValue("/orders/order/id[1]/@custId", "b");
        this.writeValue("/orders/order/id[1]", "4423423");
        this.checkResultFromFile("simple_example.xml");
    }

    @Test
    public void testBuildSimpleExampleDocumentFromSeedWithNamespace() throws Exception {
        this.namespaces.put("x", "http://www.example.com/x/");
        this.writeValue("/x:orders/@totalCost", "12525.00");
        this.writeValue("/x:orders/order/id/@custId", "a");
        this.writeValue("/x:orders/order/id", "12312");
        this.writeValue("/x:orders/order/id[1]/@custId", "b");
        this.writeValue("/x:orders/order/id[1]", "4423423");
        this.checkResultFromFile("simple_example_single_ns.xml");
    }

    @Test
    public void testBuildSimpleExampleDocumentWithMultipleNamespaces() throws Exception {
        this.namespaces.put("x", "http://www.example.com/x/");
        this.namespaces.put("y", "http://www.example.com/y/");
        this.writeValue("/x:orders/@totalCost", "12525.00");
        this.writeValue("/x:orders/order/y:id/@custId", "a");
        this.writeValue("/x:orders/order/y:id", "12312");
        this.writeValue("/x:orders/order/y:id[1]/@custId", "b");
        this.writeValue("/x:orders/order/y:id[1]", "4423423");
        this.checkResultFromFile("simple_example_multiple_ns.xml");
    }

    @Test
    public void testBuildSimpleExampleDocumentWithMultipleNamespacesConstructor() throws Exception {
        this.namespaces.put("x", "http://www.example.com/x/");
        this.namespaces.put("y", "http://www.example.com/y/");
        this.writeValue("/x:orders/@totalCost", "12525.00");
        this.writeValue("/x:orders/order/y:id/@custId", "a");
        this.writeValue("/x:orders/order/y:id", "12312");
        this.writeValue("/x:orders/order/y:id[1]/@custId", "b");
        this.writeValue("/x:orders/order/y:id[1]", "4423423");
        this.checkResultFromFile("simple_example_multiple_ns.xml");
    }

    @Test
    public void testBuildSimpleExampleDocumentWithNamespaceSingleFieldAndNS() throws Exception {
        this.namespaces.put("x", "http://www.example.com/x/");
        this.writeValue("/x:orders/@totalCost", "12525.00");
        String expected = "<x:orders xmlns:x=\"http://www.example.com/x/\" totalCost=\"12525.00\"/>";
        this.checkResult("<x:orders xmlns:x=\"http://www.example.com/x/\" totalCost=\"12525.00\"/>");
    }

    @Test
    public void testBuildDocumentWithMixedParentAttributeNamespaces() throws Exception {
        this.namespaces.put("", "http://www.example.com/x/");
        this.namespaces.put("y", "http://www.example.com/y/");
        this.writeValue("/orders/order/@y:totalCost", "12525.00");
        this.checkResultFromFile("simple_example_mixed_ns.xml");
    }

    @Test
    public void testBuildComplexNamespaceDuplicateElements() throws Exception {
        this.namespaces.put("", "http://www.example.com/x/");
        this.namespaces.put("y", "http://www.example.com/y/");
        this.namespaces.put("q", "http://www.example.com/q/");
        this.writeValue("/orders/@totalCost", "12525.00");
        this.writeValue("/orders/order/id", "a12312");
        this.writeValue("/orders/order/id/@y:custId", "aa");
        this.writeValue("/orders/order/id[1]", "b4423423");
        this.writeValue("/orders/order/id[1]/@y:custId", "bb");
        this.writeValue("/orders/q:order/id", "c12312");
        this.writeValue("/orders/q:order/id/@y:custId", "cx");
        this.writeValue("/orders/order[1]/id", "d54554555");
        this.writeValue("/orders/order[1]/id/@y:custId", "dc");
        this.writeValue("/orders/q:order[1]/id", "e12312");
        this.writeValue("/orders/q:order[1]/id/@y:custId", "ea");
        this.checkResultFromFile("complex_example_multiple_ns.xml");
    }

    @Test
    public void testWriteCollectionWithNamespace() throws Exception {
        this.namespaces.put("tns", "http://www.example.com/tns");
        this.writeValue("/tns:orders/tns:order[1]/tns:id", "1111");
        String expected = "<tns:orders xmlns:tns=\"http://www.example.com/tns\"><tns:order/><tns:order><tns:id>1111</tns:id></tns:order></tns:orders>";
        this.checkResult(expected);
    }

    @Test(expected=AtlasException.class)
    public void testThrowExceptionOnNullXmlField() throws Exception {
        this.createWriter();
        Object field = null;
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn(Mockito.mock(AtlasInternalSession.Head.class));
        Mockito.when((Object)session.head().getSourceField()).thenReturn(Mockito.mock(Field.class));
        Mockito.when((Object)session.head().getTargetField()).thenReturn(field);
        this.writer.write(session);
    }

    @Test
    public void testXmlFieldDoubleMax() throws Exception {
        this.validateBoundaryValue(FieldType.DOUBLE, "test-write-field-double-max.xml", Double.MAX_VALUE);
    }

    @Test
    public void testXmlFieldDoubleMin() throws Exception {
        this.validateBoundaryValue(FieldType.DOUBLE, "test-write-field-double-min.xml", Double.MIN_VALUE);
    }

    @Test
    public void testXmlFieldFloatMax() throws Exception {
        this.validateBoundaryValue(FieldType.FLOAT, "test-write-field-float-max.xml", Float.valueOf(Float.MAX_VALUE));
    }

    @Test
    public void testXmlFieldFloatMin() throws Exception {
        this.validateBoundaryValue(FieldType.FLOAT, "test-write-field-float-min.xml", Float.valueOf(Float.MIN_VALUE));
    }

    @Test
    public void testXmlFieldLongMax() throws Exception {
        this.validateBoundaryValue(FieldType.LONG, "test-write-field-long-max.xml", Long.MAX_VALUE);
    }

    @Test
    public void testXmlFieldLongMin() throws Exception {
        this.validateBoundaryValue(FieldType.LONG, "test-write-field-long-min.xml", Long.MIN_VALUE);
    }

    @Test
    public void testXmlFieldIntegerMax() throws Exception {
        this.validateBoundaryValue(FieldType.INTEGER, "test-write-field-integer-max.xml", Integer.MAX_VALUE);
    }

    @Test
    public void testXmlFieldIntegerMin() throws Exception {
        this.validateBoundaryValue(FieldType.INTEGER, "test-write-field-integer-min.xml", Integer.MIN_VALUE);
    }

    @Test
    public void testXmlFieldShortMax() throws Exception {
        this.validateBoundaryValue(FieldType.SHORT, "test-write-field-short-max.xml", (short)Short.MAX_VALUE);
    }

    @Test
    public void testXmlFieldShortMin() throws Exception {
        this.validateBoundaryValue(FieldType.SHORT, "test-write-field-short-min.xml", (short)Short.MIN_VALUE);
    }

    @Test
    public void testXmlFieldChar() throws Exception {
        this.validateBoundaryValue(FieldType.CHAR, "test-write-field-char.xml", Character.valueOf('!'));
    }

    @Test
    public void testXmlFieldByteMax() throws Exception {
        this.validateBoundaryValue(FieldType.BYTE, "test-write-field-byte-max.xml", (byte)127);
    }

    @Test
    public void testXmlFieldByteMin() throws Exception {
        this.validateBoundaryValue(FieldType.BYTE, "test-write-field-byte-min.xml", (byte)-128);
    }

    @Test
    public void testXmlFieldBooleanTrue() throws Exception {
        this.validateBoundaryValue(FieldType.BOOLEAN, "test-write-field-boolean-true.xml", Boolean.TRUE);
    }

    @Test
    public void testXmlFieldBooleanFalse() throws Exception {
        this.validateBoundaryValue(FieldType.BOOLEAN, "test-write-field-boolean-false.xml", Boolean.FALSE);
    }

    @Test
    public void testXmlFieldBooleanNumber1() throws Exception {
        this.validatePrimitiveValue(FieldType.BOOLEAN, "test-write-field-boolean-one.xml", 1, Boolean.TRUE);
    }

    @Test
    public void testXmlFieldBooleanNumber0() throws Exception {
        this.validatePrimitiveValue(FieldType.BOOLEAN, "test-write-field-boolean-zero.xml", 0, Boolean.FALSE);
    }

    @Test
    public void testXmlFieldBooleanLetterT() throws Exception {
        this.validatePrimitiveValue(FieldType.BOOLEAN, "test-write-field-boolean-letter-T.xml", "T", Boolean.TRUE);
    }

    @Test
    public void testXmlFieldBooleanLetterF() throws Exception {
        this.validatePrimitiveValue(FieldType.BOOLEAN, "test-write-field-boolean-letter-F.xml", "F", Boolean.FALSE);
    }

    @Test
    public void testXmlFieldDoubleMaxRangeOut() throws Exception {
        this.validateRangeOutValue(FieldType.DOUBLE, "test-write-field-double-max-range-out.xml", "1.7976931348623157E309");
    }

    @Test
    public void testXmlFieldDoubleMinRangeOut() throws Exception {
        this.validateRangeOutMinValue(FieldType.DOUBLE, "test-write-field-double-min-range-out.xml", "4.9E-325", 0.0);
    }

    @Test
    public void testXmlFieldFloatMaxRangeOut() throws Exception {
        this.validateRangeOutValue(FieldType.FLOAT, "test-write-field-float-max-range-out.xml", "3.4028235E39");
    }

    @Test
    public void testXmlFieldFloatMinRangeOut() throws Exception {
        this.validateRangeOutMinValue(FieldType.FLOAT, "test-write-field-float-min-range-out.xml", "1.4E-46", Float.valueOf(0.0f));
    }

    @Test
    public void testXmlFieldLongMaxRangeOut() throws Exception {
        this.validateRangeOutValue(FieldType.LONG, "test-write-field-long-max-range-out.xml", "9223372036854775808");
    }

    @Test
    public void testXmlFieldLongMinRangeOut() throws Exception {
        this.validateRangeOutValue(FieldType.LONG, "test-write-field-long-min-range-out.xml", "-9223372036854775809");
    }

    @Test
    public void testXmlFieldIntegerMaxRangeOut() throws Exception {
        this.validateRangeOutValue(FieldType.INTEGER, "test-write-field-integer-max-range-out.xml", Long.MAX_VALUE);
    }

    @Test
    public void testXmlFieldIntegerMinRangeOut() throws Exception {
        this.validateRangeOutValue(FieldType.INTEGER, "test-write-field-integer-min-range-out.xml", Long.MIN_VALUE);
    }

    @Test
    public void testXmlFieldShortMaxRangeOut() throws Exception {
        this.validateRangeOutValue(FieldType.SHORT, "test-write-field-short-max-range-out.xml", Long.MAX_VALUE);
    }

    @Test
    public void testXmlFieldShortMinRangeOut() throws Exception {
        this.validateRangeOutValue(FieldType.SHORT, "test-write-field-short-min-range-out.xml", Long.MIN_VALUE);
    }

    @Test
    public void testXmlFieldCharMaxRangeOut() throws Exception {
        this.validateRangeOutValue(FieldType.CHAR, "test-write-field-char-max-range-out.xml", Long.MAX_VALUE);
    }

    @Test
    public void testXmlFieldCharMinRangeOut() throws Exception {
        this.validateRangeOutValue(FieldType.CHAR, "test-write-field-char-min-range-out.xml", Long.MIN_VALUE);
    }

    @Test
    public void testXmlFieldByteMaxRangeOut() throws Exception {
        this.validateRangeOutValue(FieldType.BYTE, "test-write-field-byte-max-range-out.xml", Long.MAX_VALUE);
    }

    @Test
    public void testXmlFieldByteMinRangeOut() throws Exception {
        this.validateRangeOutValue(FieldType.BYTE, "test-write-field-byte-min-range-out.xml", Long.MIN_VALUE);
    }

    @Test
    public void testXmlFieldBooleanRangeOut() throws Exception {
        this.validatePrimitiveValue(FieldType.BOOLEAN, "test-write-field-boolean-range-out.xml", "abcd", Boolean.FALSE);
    }

    @Test
    public void testXmlFieldBooleanDecimal() throws Exception {
        this.validatePrimitiveValue(FieldType.BOOLEAN, "test-write-field-boolean-decimal.xml", Double.valueOf("126.1234"), Boolean.TRUE);
    }

    @Test
    public void testXmlFieldLongDecimal() throws Exception {
        this.validateDecimalValue(FieldType.LONG, "test-write-field-long-decimal.xml", Double.valueOf("126.1234"), 126L);
    }

    @Test
    public void testXmlFieldIntegerDecimal() throws Exception {
        this.validateDecimalValue(FieldType.INTEGER, "test-write-field-integer-decimal.xml", Double.valueOf("126.1234"), 126);
    }

    @Test
    public void testXmlFieldShortDecimal() throws Exception {
        this.validateDecimalValue(FieldType.SHORT, "test-write-field-short-decimal.xml", Double.valueOf("126.1234"), (short)126);
    }

    @Test
    public void testXmlFieldCharDecimal() throws Exception {
        this.validateRangeOutValue(FieldType.CHAR, "test-write-field-char-decimal.xml", Double.valueOf("126.1234"));
    }

    @Test
    public void testXmlFieldByteDecimal() throws Exception {
        this.validateDecimalValue(FieldType.BYTE, "test-write-field-byte-decimal.xml", Double.valueOf("126.1234"), (byte)126);
    }

    @Test
    public void testXmlFieldDoubleString() throws Exception {
        this.validateRangeOutValue(FieldType.DOUBLE, "test-write-field-double-string.xml", "abcd");
    }

    @Test
    public void testXmlFieldFloatString() throws Exception {
        this.validateRangeOutValue(FieldType.FLOAT, "test-write-field-float-string.xml", "abcd");
    }

    @Test
    public void testXmlFieldLongString() throws Exception {
        this.validateRangeOutValue(FieldType.LONG, "test-write-field-long-string.xml", "abcd");
    }

    @Test
    public void testXmlFieldIntegerString() throws Exception {
        this.validateRangeOutValue(FieldType.INTEGER, "test-write-field-integer-string.xml", "abcd");
    }

    @Test
    public void testXmlFieldShortString() throws Exception {
        this.validateRangeOutValue(FieldType.SHORT, "test-write-field-short-string.xml", "abcd");
    }

    @Test
    public void testXmlFieldCharString() throws Exception {
        this.validateRangeOutValue(FieldType.CHAR, "test-write-field-char-string.xml", "abcd");
    }

    @Test
    public void testXmlFieldByteString() throws Exception {
        this.validateRangeOutValue(FieldType.BYTE, "test-write-field-byte-string.xml", "abcd");
    }

    private void validateBoundaryValue(FieldType fieldType, String fileName, Object testObject) throws Exception {
        this.validatePrimitiveValue(fieldType, fileName, testObject, testObject);
    }

    private void validatePrimitiveValue(FieldType fieldType, String fileName, Object testObject, Object expectedObject) throws Exception {
        Path path = Paths.get("target" + File.separator + fileName, new String[0]);
        AtlasInternalSession session = this.readSession(fieldType, path, testObject);
        Assert.assertNotNull((Object)session.head().getSourceField().getValue());
        Assert.assertEquals((Object)expectedObject, (Object)session.head().getSourceField().getValue());
    }

    private void writeToFile(String fieldPath, Path path, Object testObject) throws Exception {
        this.writeValue(fieldPath, testObject.toString());
        String output = this.xmlHelper.writeDocumentToString(true, (Node)this.writer.getDocument());
        Files.write(path, output.getBytes(), new OpenOption[0]);
    }

    private AtlasInternalSession readFromFile(String fieldPath, FieldType fieldType, Path path) throws Exception {
        this.reader.setDocument(this.getDocumentFromPath(path, false));
        XmlField xmlField = AtlasXmlModelFactory.createXmlField();
        xmlField.setPath(fieldPath);
        xmlField.setPrimitive(Boolean.TRUE);
        xmlField.setFieldType(fieldType);
        Assert.assertNull((Object)xmlField.getValue());
        AtlasInternalSession session = (AtlasInternalSession)Mockito.mock(AtlasInternalSession.class);
        Mockito.when((Object)session.head()).thenReturn(Mockito.mock(AtlasInternalSession.Head.class));
        Mockito.when((Object)session.head().getSourceField()).thenReturn((Object)xmlField);
        Audits audits = new Audits();
        Mockito.when((Object)session.getAudits()).thenReturn((Object)audits);
        this.reader.read(session);
        return session;
    }

    private Document getDocumentFromPath(Path path, boolean namespaced) throws Exception {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(namespaced);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(path.toFile());
    }

    private void validateRangeOutMinValue(FieldType fieldType, String fileName, Object testObject, Object expectedObject) throws Exception {
        Path path = Paths.get("target" + File.separator + fileName, new String[0]);
        AtlasInternalSession session = this.readSession(fieldType, path, testObject);
        Assert.assertEquals((Object)expectedObject, (Object)session.head().getSourceField().getValue());
        Assert.assertEquals((long)0L, (long)session.getAudits().getAudit().size());
    }

    private AtlasInternalSession readSession(FieldType fieldType, Path path, Object testObject) throws Exception {
        String fieldPath = "/primitive/value";
        this.writeToFile(fieldPath, path, testObject);
        AtlasInternalSession session = this.readFromFile(fieldPath, fieldType, path);
        return session;
    }

    private void validateRangeOutValue(FieldType fieldType, String fileName, Object testObject) throws Exception {
        Path path = Paths.get("target" + File.separator + fileName, new String[0]);
        AtlasInternalSession session = this.readSession(fieldType, path, testObject);
        Assert.assertEquals(null, (Object)session.head().getSourceField().getValue());
        Assert.assertEquals((long)1L, (long)session.getAudits().getAudit().size());
        Assert.assertEquals((Object)("Failed to convert field value '" + testObject.toString() + "' into type '" + fieldType.value().toUpperCase() + "'"), (Object)((Audit)session.getAudits().getAudit().get(0)).getMessage());
        Assert.assertEquals((Object)testObject.toString(), (Object)((Audit)session.getAudits().getAudit().get(0)).getValue());
        Assert.assertEquals((Object)AuditStatus.ERROR, (Object)((Audit)session.getAudits().getAudit().get(0)).getStatus());
    }

    private void validateDecimalValue(FieldType fieldType, String fileName, Object testObject, Object expectedValue) throws Exception {
        Path path = Paths.get("target" + File.separator + fileName, new String[0]);
        AtlasInternalSession session = this.readSession(fieldType, path, testObject);
        Assert.assertEquals((Object)expectedValue, (Object)session.head().getSourceField().getValue());
        Assert.assertEquals((long)0L, (long)session.getAudits().getAudit().size());
    }

    private void checkResultFromFile(String expectedFilename) throws Exception {
        String filename = "src/test/resources/" + expectedFilename;
        String expected = new String(Files.readAllBytes(Paths.get(filename, new String[0])));
        this.checkResult(expected);
    }

    private void checkResult(String s) throws Exception {
        String expected = HEADER + s;
        if (this.document == null) {
            throw new Exception("document is not initialized.");
        }
        String actual = this.xmlHelper.writeDocumentToString(true, (Node)this.writer.getDocument());
        expected = expected.replaceAll("\n|\r", "");
        expected = expected.replaceAll("> *?<", "><");
        expected = expected.replace("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>", "");
        System.out.println("Expected: " + expected);
        System.out.println("Actual:   " + actual);
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

