/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.xml.inspect;

import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.FieldStatus;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.Fields;
import io.atlasmap.xml.core.XmlComplexTypeFactory;
import io.atlasmap.xml.v2.AtlasXmlModelFactory;
import io.atlasmap.xml.v2.XmlComplexType;
import io.atlasmap.xml.v2.XmlDocument;
import io.atlasmap.xml.v2.XmlField;
import io.atlasmap.xml.v2.XmlFields;
import io.atlasmap.xml.v2.XmlNamespace;
import io.atlasmap.xml.v2.XmlNamespaces;
import java.util.ArrayList;
import java.util.HashSet;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlInstanceInspector {
    private XmlDocument xmlDocument = AtlasXmlModelFactory.createXmlDocument();

    public void inspect(Document document) {
        this.xmlDocument.setFields(new Fields());
        this.parseDocument(document.getDocumentElement());
    }

    public XmlDocument getXmlDocument() {
        return this.xmlDocument;
    }

    private void parseDocument(Node rootNode) {
        if (rootNode.getParentNode() != null && rootNode.getParentNode().getNodeType() == 9) {
            XmlComplexType rootComplexType = this.getXmlComplexType(rootNode);
            this.xmlDocument.getFields().getField().add(rootComplexType);
            this.mapAttributes(rootNode, rootComplexType);
            if (rootNode.hasChildNodes()) {
                this.mapChildNodes(rootNode.getChildNodes(), rootComplexType);
                this.mapCollectionType(rootComplexType, (Element)rootNode);
            }
        }
    }

    private void mapChildNodes(NodeList nodes, XmlComplexType rootComplexType) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node childNode = nodes.item(i);
            if (childNode.getNodeType() != 1 && childNode.getNodeType() != 2) continue;
            if (childNode.hasAttributes()) {
                this.mapAttributes(childNode, rootComplexType);
            }
            if (((Element)childNode).getElementsByTagName("*").getLength() > 0) {
                this.mapParentNode(childNode, rootComplexType);
            } else {
                this.mapNodeToXmlField(childNode, rootComplexType);
            }
            if (childNode.getNamespaceURI() == null) continue;
            this.mapNamespace(childNode);
        }
    }

    private void mapNamespace(Node node) {
        if (this.xmlDocument.getXmlNamespaces() == null) {
            XmlNamespaces namespaces = new XmlNamespaces();
            this.xmlDocument.setXmlNamespaces(namespaces);
        }
        XmlNamespace namespace = new XmlNamespace();
        namespace.setAlias(node.getPrefix());
        namespace.setUri(node.getNamespaceURI());
        if (!this.xmlDocument.getXmlNamespaces().getXmlNamespace().contains(namespace)) {
            this.xmlDocument.getXmlNamespaces().getXmlNamespace().add(namespace);
        }
    }

    private void mapParentNode(Node node, XmlComplexType parent) {
        if (node.hasChildNodes()) {
            NodeList childNodes = node.getChildNodes();
            XmlComplexType childParent = this.getXmlComplexType(node);
            StringBuffer stringBuffer = new StringBuffer();
            this.getXmlPath(node, stringBuffer);
            if (node.hasAttributes()) {
                this.mapAttributes(node, childParent);
            }
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node e = childNodes.item(i);
                if (e.getNodeType() != 1) continue;
                NodeList childElements = ((Element)e).getElementsByTagName("*");
                if (childElements.getLength() > 0) {
                    this.mapParentNode(e, childParent);
                    continue;
                }
                this.mapNodeToXmlField(e, childParent);
                if (!e.hasAttributes()) continue;
                this.mapAttributes(e, childParent);
            }
            this.mapCollectionType(childParent, (Element)node);
            parent.getXmlFields().getXmlField().add(childParent);
        }
    }

    private void mapAttributes(Node node, XmlComplexType xmlComplexType) {
        NamedNodeMap attrs = node.getAttributes();
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node attrNode = attrs.item(i);
                if (attrNode.getNamespaceURI() != null && attrNode.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) continue;
                if (attrNode.getNamespaceURI() != null && attrNode.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema-instance")) {
                    this.mapNamespace(attrNode);
                    xmlComplexType.setTypeName(attrNode.getTextContent());
                    continue;
                }
                if (attrNode.getNamespaceURI() != null) {
                    this.mapNamespace(attrNode);
                }
                this.mapNodeToXmlField(attrNode, xmlComplexType);
            }
        }
    }

    private void mapNodeToXmlField(Node node, XmlComplexType parentComplexType) {
        XmlField xmlField = AtlasXmlModelFactory.createXmlField();
        StringBuffer sb = new StringBuffer(1024);
        this.getXmlPath(node, sb);
        xmlField.setPath(sb.toString());
        xmlField.setValue((Object)node.getTextContent());
        xmlField.setFieldType(FieldType.STRING);
        xmlField.setName(node.getNodeName());
        xmlField.setStatus(FieldStatus.SUPPORTED);
        parentComplexType.getXmlFields().getXmlField().add(xmlField);
    }

    private void mapCollectionType(XmlComplexType childParent, Element e) {
        if (!e.hasChildNodes()) {
            return;
        }
        HashSet<String> checked = new HashSet<String>();
        NodeList children = e.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || checked.contains(child.getNodeName())) continue;
            checked.add(child.getNodeName());
            ArrayList<XmlField> detected = new ArrayList<XmlField>();
            for (XmlField f2 : childParent.getXmlFields().getXmlField()) {
                if (!child.getNodeName().equals(f2.getName())) continue;
                detected.add(f2);
            }
            if (detected.size() <= 1) continue;
            detected.forEach(f -> f.setCollectionType(CollectionType.LIST));
        }
    }

    private void getXmlPath(Node node, StringBuffer sb) {
        if (node.getParentNode() != null && node.getParentNode().getNodeType() == 1) {
            this.getXmlPath(node.getParentNode(), sb);
        }
        if (node.getNodeType() == 2) {
            Element owner = ((Attr)node).getOwnerElement();
            if (owner.getParentNode() != null && owner.getParentNode().getNodeType() == 1) {
                this.getXmlPath(owner.getParentNode(), sb);
            }
            int index = this.getNodeIndex(owner);
            sb.append("/").append(owner.getNodeName());
            if (index > 0) {
                sb.append("[").append(index).append("]");
            }
            sb.append("/");
            if (node.getPrefix() != null) {
                sb.append(node.getPrefix()).append(":");
            }
            sb.append("@").append(node.getLocalName());
        } else {
            int index = this.getNodeIndex(node);
            sb.append("/").append(node.getNodeName());
            if (index > 0) {
                sb.append("[").append(index).append("]");
            }
        }
    }

    private int getNodeIndex(Node node) {
        Element parent;
        NodeList siblings;
        if (node.getParentNode().getNodeType() == 1 && (siblings = (parent = (Element)node.getParentNode()).getElementsByTagName(node.getNodeName())) != null) {
            for (int i = 0; i < siblings.getLength(); ++i) {
                Node nextSibling = siblings.item(i);
                if (!nextSibling.isSameNode(node)) continue;
                return i;
            }
        }
        return 0;
    }

    private XmlComplexType getXmlComplexType(Node childNode) {
        XmlComplexType childComplexType = XmlComplexTypeFactory.createXmlComlexField();
        childComplexType.setXmlFields(new XmlFields());
        childComplexType.setName(childNode.getNodeName());
        StringBuffer stringBuffer = new StringBuffer();
        this.getXmlPath(childNode, stringBuffer);
        childComplexType.setPath(stringBuffer.toString());
        return childComplexType;
    }
}

