/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.xml.core;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.AtlasPath;
import io.atlasmap.core.AtlasUtil;
import io.atlasmap.spi.AtlasConversionService;
import io.atlasmap.spi.AtlasFieldReader;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.DataSource;
import io.atlasmap.v2.DataSourceType;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.FieldType;
import io.atlasmap.xml.core.XmlFieldTransformer;
import io.atlasmap.xml.core.XmlIOHelper;
import io.atlasmap.xml.core.XmlPath;
import io.atlasmap.xml.v2.XmlDataSource;
import io.atlasmap.xml.v2.XmlField;
import io.atlasmap.xml.v2.XmlNamespace;
import io.atlasmap.xml.v2.XmlNamespaces;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlFieldReader
extends XmlFieldTransformer
implements AtlasFieldReader {
    private static final Logger LOG = LoggerFactory.getLogger(XmlFieldReader.class);
    private AtlasConversionService conversionService;
    private Document document;

    public XmlFieldReader(ClassLoader cl, AtlasConversionService conversionService) {
        super(cl);
        this.conversionService = conversionService;
    }

    public XmlFieldReader(ClassLoader cl, AtlasConversionService conversionService, Map<String, String> namespaces) {
        super(cl, namespaces);
        this.conversionService = conversionService;
    }

    public Field read(AtlasInternalSession session) throws AtlasException {
        Field field = session.head().getSourceField();
        if (this.document == null) {
            AtlasUtil.addAudit((AtlasSession)session, (String)field.getDocId(), (String)String.format("Cannot read field '%s' of document '%s', document is null", field.getPath(), field.getDocId()), (String)field.getPath(), (AuditStatus)AuditStatus.ERROR, null);
            return field;
        }
        if (field == null) {
            throw new AtlasException((Throwable)new IllegalArgumentException("Argument 'field' cannot be null"));
        }
        this.seedDocumentNamespaces(this.document);
        XmlField xmlField = (XmlField)XmlField.class.cast(field);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reading source value for field: " + xmlField.getPath());
        }
        Optional<XmlNamespaces> xmlNamespaces = this.getSourceNamespaces(session, xmlField);
        XmlPath path = new XmlPath(xmlField.getPath());
        List<XmlField> fields = this.getFieldsForPath(session, xmlNamespaces, this.document.getDocumentElement(), field, path, 0);
        if (path.hasCollection() && !path.isIndexedCollection()) {
            FieldGroup fieldGroup = AtlasModelFactory.createFieldGroupFrom((Field)field);
            fieldGroup.getField().addAll(fields);
            session.head().setSourceField((Field)fieldGroup);
            return fieldGroup;
        }
        if (fields.size() == 1) {
            field.setValue(fields.get(0).getValue());
            return field;
        }
        return field;
    }

    private List<XmlField> getFieldsForPath(AtlasInternalSession session, Optional<XmlNamespaces> xmlNamespaces, Element node, Field field, XmlPath path, int depth) {
        ArrayList<XmlField> xmlFields = new ArrayList<XmlField>();
        List<XmlPath.XmlSegmentContext> segments = path.getXmlSegments(false);
        if (segments.size() == depth) {
            XmlField xmlField = new XmlField();
            AtlasModelFactory.copyField((Field)field, (Field)xmlField, (boolean)false);
            XmlPath.XmlSegmentContext lastSegment = segments.get(depth - 1);
            this.copyValue(session, lastSegment, node, xmlField);
            xmlFields.add(xmlField);
        } else if (segments.size() > depth) {
            XmlPath.XmlSegmentContext segment = segments.get(depth);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Now processing segment: " + segment.getName());
            }
            if (depth == 0 && segment.getName().startsWith(XmlIOHelper.getNodeNameWithoutNamespaceAlias(node))) {
                Optional<Object> namespace = Optional.empty();
                if (segment.getNamespace() != null) {
                    namespace = this.getNamespace(xmlNamespaces, segment.getNamespace());
                }
                if (!namespace.isPresent() || ((String)namespace.get()).equals(node.getNamespaceURI())) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Skipping root segment: " + (Object)((Object)segment));
                    }
                    if (segments.size() > 1) {
                        depth = 1;
                        segment = segments.get(depth);
                    }
                }
            }
            String fieldName = segment.getName();
            String fieldNamespace = segment.getNamespace();
            Optional<String> namespace = this.getNamespace(xmlNamespaces, fieldNamespace);
            if (segment.isAttribute() && segments.size() == depth + 1) {
                List<XmlField> fields = this.getFieldsForPath(session, xmlNamespaces, node, field, path, depth + 1);
                xmlFields.addAll(fields);
            } else {
                List<Element> children = XmlIOHelper.getChildrenWithNameStripAlias(fieldName, namespace, node);
                if (children == null || children.isEmpty()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Skipping source value set, couldn't find children with name '" + fieldName + "', for segment: " + (Object)((Object)segment));
                    }
                    return xmlFields;
                }
                if (segment.getCollectionType() != CollectionType.NONE) {
                    Integer index = segment.getCollectionIndex();
                    if (index == null) {
                        int arrayIndex = 0;
                        for (Element arrayItem : children) {
                            List<XmlField> arrayFields = this.getFieldsForPath(session, xmlNamespaces, arrayItem, field, path, depth + 1);
                            for (XmlField arrayField : arrayFields) {
                                AtlasPath subPath = new AtlasPath(arrayField.getPath());
                                subPath.setCollectionIndex(depth + 1, Integer.valueOf(arrayIndex));
                                arrayField.setPath(subPath.toString());
                            }
                            xmlFields.addAll(arrayFields);
                            ++arrayIndex;
                        }
                    } else if (index < children.size()) {
                        List<XmlField> fields = this.getFieldsForPath(session, xmlNamespaces, children.get(index), field, path, depth + 1);
                        xmlFields.addAll(fields);
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("Skipping source value set, children list can't fit index " + index + ", children list size: " + children.size());
                    }
                } else {
                    List<XmlField> fields = this.getFieldsForPath(session, xmlNamespaces, children.get(0), field, path, depth + 1);
                    xmlFields.addAll(fields);
                }
            }
        }
        return xmlFields;
    }

    private void copyValue(AtlasInternalSession session, XmlPath.XmlSegmentContext sc, Element node, XmlField xmlField) {
        String value;
        if (xmlField.getFieldType() == null) {
            xmlField.setFieldType(FieldType.STRING);
        }
        if (sc.isAttribute()) {
            String attributeName = sc.getQName();
            value = node.getAttribute(attributeName);
        } else {
            value = node.getTextContent();
        }
        if (value == null) {
            return;
        }
        if (xmlField.getFieldType() == FieldType.STRING) {
            xmlField.setValue((Object)value);
        } else {
            try {
                Object convertedValue = this.conversionService.convertType((Object)value, xmlField.getFormat(), xmlField.getFieldType(), null);
                xmlField.setValue(convertedValue);
            }
            catch (AtlasConversionException e) {
                AtlasUtil.addAudit((AtlasSession)session, (String)xmlField.getDocId(), (String)String.format("Failed to convert field value '%s' into type '%s'", value, xmlField.getFieldType()), (String)xmlField.getPath(), (AuditStatus)AuditStatus.ERROR, (String)value);
            }
        }
    }

    public void setDocument(Document document) throws AtlasException {
        this.document = document;
    }

    private Optional<XmlNamespaces> getSourceNamespaces(AtlasInternalSession session, XmlField xmlField) {
        DataSource dataSource = null;
        AtlasMapping mapping = session.getMapping();
        if (mapping == null || mapping.getDataSource() == null || xmlField.getDocId() == null) {
            return Optional.empty();
        }
        List dataSources = mapping.getDataSource();
        for (DataSource source : dataSources) {
            if (!source.getDataSourceType().equals((Object)DataSourceType.SOURCE) || !xmlField.getDocId().equals(source.getId())) continue;
            dataSource = source;
            break;
        }
        if (dataSource == null || !XmlDataSource.class.isInstance(dataSource)) {
            return Optional.empty();
        }
        XmlDataSource xmlDataSource = (XmlDataSource)XmlDataSource.class.cast(dataSource);
        return Optional.of(xmlDataSource.getXmlNamespaces());
    }

    private Optional<String> getNamespace(Optional<XmlNamespaces> xmlNamespaces, String namespaceAlias) {
        Optional<String> namespace = Optional.empty();
        if (xmlNamespaces.isPresent()) {
            for (XmlNamespace xmlNamespace : xmlNamespaces.get().getXmlNamespace()) {
                if ((xmlNamespace.getAlias() != null || namespaceAlias != null) && !xmlNamespace.getAlias().equals(namespaceAlias)) continue;
                namespace = Optional.of(xmlNamespace.getUri());
                break;
            }
        }
        return namespace;
    }
}

