/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.xml.inspect;

import com.sun.xml.xsom.XSAttributeDecl;
import com.sun.xml.xsom.XSAttributeUse;
import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSDeclaration;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSModelGroup;
import com.sun.xml.xsom.XSModelGroupDecl;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSRestrictionSimpleType;
import com.sun.xml.xsom.XSSchema;
import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.XSSimpleType;
import com.sun.xml.xsom.XSTerm;
import com.sun.xml.xsom.parser.AnnotationParserFactory;
import com.sun.xml.xsom.parser.XSOMParser;
import com.sun.xml.xsom.util.DomAnnotationParserFactory;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.FieldStatus;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.Fields;
import io.atlasmap.xml.core.XmlComplexTypeFactory;
import io.atlasmap.xml.inspect.SimpleTypeRestriction;
import io.atlasmap.xml.inspect.XmlInspectionException;
import io.atlasmap.xml.v2.AtlasXmlModelFactory;
import io.atlasmap.xml.v2.Restriction;
import io.atlasmap.xml.v2.RestrictionType;
import io.atlasmap.xml.v2.Restrictions;
import io.atlasmap.xml.v2.XmlComplexType;
import io.atlasmap.xml.v2.XmlDocument;
import io.atlasmap.xml.v2.XmlField;
import io.atlasmap.xml.v2.XmlFields;
import io.atlasmap.xml.v2.XmlNamespace;
import io.atlasmap.xml.v2.XmlNamespaces;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlSchemaInspector {
    private static final Logger LOG = LoggerFactory.getLogger(XmlSchemaInspector.class);
    private static final Map<String, FieldType> XS_TYPE_TO_FIELD_TYPE_MAP = new HashMap<String, FieldType>();
    private static final Map<String, FieldType> BLACKLISTED_TYPES;
    private static final String NS_PREFIX_XMLSCHEMA = "xs";
    private static final String NS_PREFIX_SCHEMASET = "ss";
    private XmlDocument xmlDocument;
    private AtlasXmlNamespaceContext namespaceContext;
    private String rootNamespace;

    public XmlDocument getXmlDocument() {
        return this.xmlDocument;
    }

    public void inspect(File schemaFile) throws XmlInspectionException {
        try {
            this.doInspect(new FileInputStream(schemaFile));
        }
        catch (Exception e) {
            throw new XmlInspectionException(e);
        }
    }

    public void inspect(String schemaAsString) throws XmlInspectionException {
        try {
            this.doInspect(new ByteArrayInputStream(schemaAsString.getBytes("UTF-8")));
        }
        catch (Exception e) {
            throw new XmlInspectionException(e);
        }
    }

    private void doInspect(InputStream is) throws Exception {
        this.xmlDocument = AtlasXmlModelFactory.createXmlDocument();
        Fields fields = new Fields();
        this.xmlDocument.setFields(fields);
        this.namespaceContext = new AtlasXmlNamespaceContext();
        this.rootNamespace = null;
        XSOMParser parser = new XSOMParser(SAXParserFactory.newInstance());
        parser.setAnnotationParser((AnnotationParserFactory)new DomAnnotationParserFactory());
        parser.setErrorHandler((ErrorHandler)new XSOMErrorHandler());
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        Document doc = dbf.newDocumentBuilder().parse(is);
        Element root = doc.getDocumentElement();
        if (root == null) {
            throw new XmlInspectionException("XML schema document is empty");
        }
        if ("SchemaSet".equals(root.getLocalName())) {
            XPath xpath = XPathFactory.newInstance().newXPath();
            xpath.setNamespaceContext(this.namespaceContext);
            NodeList subSchemas = (NodeList)xpath.evaluate(String.format("/%s:SchemaSet/%s:AdditionalSchemas/%s:schema", NS_PREFIX_SCHEMASET, NS_PREFIX_SCHEMASET, NS_PREFIX_XMLSCHEMA), doc, XPathConstants.NODESET);
            for (int i = 0; i < subSchemas.getLength(); ++i) {
                Element e = (Element)subSchemas.item(i);
                this.inheritNamespaces(e, false);
                parser.parse((InputStream)this.toInputStream(transformer, e));
            }
            Element rootSchema = (Element)xpath.evaluate(String.format("/%s:SchemaSet/%s:schema", NS_PREFIX_SCHEMASET, NS_PREFIX_XMLSCHEMA), doc, XPathConstants.NODE);
            if (rootSchema == null) {
                throw new XmlInspectionException("The root schema '/SchemaSet/schema' must be specified once and only once");
            }
            this.rootNamespace = this.getTargetNamespace(rootSchema);
            if (this.rootNamespace != null && !this.rootNamespace.isEmpty()) {
                this.namespaceContext.add("tns", this.rootNamespace);
            }
            this.inheritNamespaces(rootSchema, true);
            parser.parse((InputStream)this.toInputStream(transformer, rootSchema));
        } else if ("schema".equals(root.getLocalName())) {
            parser.parse((InputStream)this.toInputStream(transformer, root));
            this.rootNamespace = this.getTargetNamespace(root);
            if (this.rootNamespace != null && !this.rootNamespace.isEmpty()) {
                this.namespaceContext.add("tns", this.rootNamespace);
            }
        } else {
            throw new XmlInspectionException(String.format("Unsupported document element '%s': root element must be 'schema' or 'SchemaSet'", root.getLocalName()));
        }
        XSSchemaSet schemaSet = parser.getResult();
        this.printSchemaSet(schemaSet);
        this.populateNamespaces();
    }

    private String getTargetNamespace(Node n) {
        NamedNodeMap attributes = n.getAttributes();
        if (attributes == null) {
            return "";
        }
        Attr tns = (Attr)attributes.getNamedItem("targetNamespace");
        return tns != null ? tns.getValue() : "";
    }

    private void inheritNamespaces(Element element, boolean updateContext) {
        for (Node target = element.getParentNode(); target != null; target = target.getParentNode()) {
            NamedNodeMap attributes = target.getAttributes();
            if (attributes == null) continue;
            for (int i = 0; i < attributes.getLength(); ++i) {
                Attr attr = (Attr)attributes.item(i);
                if (!"xmlns".equals(attr.getPrefix()) || "xmlns".equals(attr.getLocalName())) continue;
                element.setAttribute(attr.getName(), attr.getValue());
                if (!updateContext) continue;
                this.namespaceContext.add(attr.getLocalName(), attr.getValue());
            }
        }
    }

    private ByteArrayInputStream toInputStream(Transformer transformer, Node n) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        transformer.transform(new DOMSource(n), new StreamResult(baos));
        byte[] output = baos.toByteArray();
        if (LOG.isTraceEnabled()) {
            LOG.trace(">>> {}", (Object)new String(output));
        }
        return new ByteArrayInputStream(output);
    }

    private String getNameNS(XSDeclaration decl) {
        String targetNamespace = decl.getTargetNamespace();
        if (targetNamespace == null || targetNamespace.isEmpty()) {
            targetNamespace = decl.getOwnerSchema().getTargetNamespace();
        }
        if (targetNamespace != null && !targetNamespace.isEmpty()) {
            String prefix = this.namespaceContext.getPrefix(targetNamespace);
            if (prefix == null || prefix.isEmpty()) {
                prefix = this.namespaceContext.addWithIndex(targetNamespace);
            }
            return String.format("%s:%s", prefix, decl.getName());
        }
        return decl.getName();
    }

    private void populateNamespaces() {
        for (Map.Entry<String, String> entry : this.namespaceContext.getNamespaceMap().entrySet()) {
            String prefix = entry.getKey();
            String uri = entry.getValue();
            if ("http://www.w3.org/2001/XMLSchema".equals(uri) || "http://atlasmap.io/xml/schemaset/v2".equals(uri)) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace("adding a namespace >>> prefix={}, uri={}", (Object)prefix, (Object)uri);
            }
            if (this.xmlDocument.getXmlNamespaces() == null) {
                this.xmlDocument.setXmlNamespaces(new XmlNamespaces());
            }
            XmlNamespace namespace = new XmlNamespace();
            namespace.setAlias(prefix);
            namespace.setUri(uri);
            this.xmlDocument.getXmlNamespaces().getXmlNamespace().add(namespace);
        }
    }

    private void printSchemaSet(XSSchemaSet schemaSet) throws Exception {
        if (schemaSet == null) {
            throw new XmlInspectionException("Schema set is null");
        }
        XSSchema schema = this.rootNamespace != null ? schemaSet.getSchema(this.rootNamespace) : schemaSet.getSchema("");
        Iterator jtr = schema.iterateElementDecls();
        while (jtr.hasNext()) {
            HashSet<String> cachedComplexType = new HashSet<String>();
            XSElementDecl e = (XSElementDecl)jtr.next();
            String rootName = this.getNameNS((XSDeclaration)e);
            if (e.getType().isComplexType()) {
                XmlComplexType rootComplexType = this.getXmlComplexType();
                rootComplexType.setName(rootName);
                rootComplexType.setPath("/" + rootName);
                rootComplexType.setFieldType(FieldType.COMPLEX);
                this.xmlDocument.getFields().getField().add(rootComplexType);
                this.printComplexType(e.getType().asComplexType(), "/" + rootName, rootComplexType, cachedComplexType);
                continue;
            }
            if (!e.getType().isSimpleType()) continue;
            XmlField xmlField = AtlasXmlModelFactory.createXmlField();
            xmlField.setName(rootName);
            xmlField.setPath("/" + rootName);
            this.xmlDocument.getFields().getField().add(xmlField);
            this.printSimpleType(e.getType().asSimpleType(), xmlField);
        }
    }

    private void printComplexType(XSComplexType complexType, String rootName, XmlComplexType xmlComplexType, Set<String> cachedComplexType) throws Exception {
        this.printAttributes(complexType, rootName, xmlComplexType);
        XSParticle particle = complexType.getContentType().asParticle();
        if (particle != null) {
            this.printParticle(particle, rootName, xmlComplexType, cachedComplexType);
        }
    }

    private void printParticle(XSParticle particle, String rootName, XmlComplexType xmlComplexType, Set<String> cachedComplexType) throws Exception {
        XSTerm term = particle.getTerm();
        if (term.isModelGroup()) {
            XSModelGroup group = term.asModelGroup();
            this.printGroup(group, rootName, xmlComplexType, cachedComplexType);
        } else if (term.isModelGroupDecl()) {
            this.printGroupDecl(term.asModelGroupDecl(), rootName, xmlComplexType, cachedComplexType);
        } else if (term.isElementDecl()) {
            CollectionType collectionType = this.getCollectionType(particle);
            this.printElement(term.asElementDecl(), rootName, xmlComplexType, collectionType, cachedComplexType);
        }
    }

    private void printGroup(XSModelGroup modelGroup, String rootName, XmlComplexType xmlComplexType, Set<String> cachedComplexType) throws Exception {
        for (XSParticle particle : modelGroup.getChildren()) {
            HashSet<String> cachedTypeCopy = new HashSet<String>(cachedComplexType);
            this.printParticle(particle, rootName, xmlComplexType, cachedTypeCopy);
        }
    }

    private void printGroupDecl(XSModelGroupDecl modelGroupDecl, String rootName, XmlComplexType parentXmlComplexType, Set<String> cachedComplexType) throws Exception {
        this.printGroup(modelGroupDecl.getModelGroup(), rootName, parentXmlComplexType, cachedComplexType);
    }

    private void printElement(XSElementDecl element, String root, XmlComplexType xmlComplexType, CollectionType collectionType, Set<String> cachedComplexType) throws Exception {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Element: {}/{}", (Object)root, (Object)this.getNameNS((XSDeclaration)element));
        }
        String rootName = root;
        if (element.getType().isComplexType()) {
            XmlComplexType complexType = this.getXmlComplexType();
            rootName = rootName + "/" + this.getNameNS((XSDeclaration)element);
            complexType.setName(this.getNameNS((XSDeclaration)element));
            complexType.setPath(rootName);
            complexType.setCollectionType(collectionType);
            xmlComplexType.getXmlFields().getXmlField().add(complexType);
            String typeName = this.getNameNS((XSDeclaration)element.getType());
            if (typeName != null && !typeName.isEmpty() && cachedComplexType.contains(typeName)) {
                complexType.setStatus(FieldStatus.CACHED);
            } else {
                cachedComplexType.add(typeName);
                this.printComplexType(element.getType().asComplexType(), rootName, complexType, cachedComplexType);
            }
        } else if (element.getType() != null && element.getType().asSimpleType() != null) {
            XmlField xmlField = AtlasXmlModelFactory.createXmlField();
            xmlField.setName(this.getNameNS((XSDeclaration)element));
            xmlField.setPath(rootName + "/" + this.getNameNS((XSDeclaration)element));
            xmlComplexType.getXmlFields().getXmlField().add(xmlField);
            if (element.getDefaultValue() != null) {
                xmlField.setValue((Object)element.getDefaultValue());
            } else if (element.getFixedValue() != null) {
                xmlField.setValue((Object)element.getFixedValue());
            }
            XSRestrictionSimpleType typeRestriction = element.getType().asSimpleType().asRestriction();
            if (typeRestriction != null) {
                xmlField.setFieldType(XS_TYPE_TO_FIELD_TYPE_MAP.get(typeRestriction.getBaseType().getName()));
                this.mapRestrictions(xmlField, typeRestriction);
            }
            this.printSimpleType(element.getType().asSimpleType(), xmlField);
        }
    }

    private void printAttributes(XSComplexType xsComplexType, String rootName, XmlComplexType xmlComplexType) {
        Collection c = xsComplexType.getDeclaredAttributeUses();
        for (XSAttributeUse aC : c) {
            XmlField xmlField = AtlasXmlModelFactory.createXmlField();
            XSAttributeDecl attributeDecl = aC.getDecl();
            xmlField.setName(this.getNameNS((XSDeclaration)attributeDecl));
            if (attributeDecl.getDefaultValue() != null) {
                xmlField.setValue((Object)attributeDecl.getDefaultValue().value);
            } else if (attributeDecl.getFixedValue() != null) {
                xmlField.setValue((Object)attributeDecl.getFixedValue().value);
            }
            xmlField.setPath(rootName + "/@" + this.getNameNS((XSDeclaration)attributeDecl));
            FieldType attrType = this.getFieldType(attributeDecl.getType().getName());
            xmlField.setFieldType(attrType);
            if (xmlField.getFieldType() == null) {
                XSSimpleType simpleType = xsComplexType.getRoot().getSimpleType(xsComplexType.getTargetNamespace(), attributeDecl.getType().getName());
                if (simpleType != null) {
                    FieldType fieldType = this.getFieldType(simpleType.getBaseType().getName());
                    xmlField.setFieldType(fieldType);
                    xmlField.setTypeName(attributeDecl.getType().getName());
                    if (simpleType.asRestriction() != null) {
                        this.mapRestrictions(xmlField, simpleType.asRestriction());
                    }
                } else {
                    xmlField.setFieldType(FieldType.UNSUPPORTED);
                }
            }
            xmlComplexType.getXmlFields().getXmlField().add(xmlField);
        }
    }

    private void printSimpleType(XSSimpleType simpleType, XmlField xmlField) {
        if (xmlField.getFieldType() == null) {
            FieldType attrType = this.getFieldType(simpleType.getName());
            xmlField.setFieldType(attrType);
        }
    }

    private void mapRestrictions(XmlField xmlField, XSRestrictionSimpleType restrictionSimpleType) {
        SimpleTypeRestriction simpleTypeRestriction = new SimpleTypeRestriction();
        simpleTypeRestriction.initRestrictions(restrictionSimpleType);
        Restrictions restrictions = new Restrictions();
        xmlField.setRestrictions(restrictions);
        this.mapSimpleRestrictionToRestriction(simpleTypeRestriction, xmlField);
    }

    private XmlComplexType getXmlComplexType() {
        XmlComplexType rootComplexType = XmlComplexTypeFactory.createXmlComlexField();
        rootComplexType.setFieldType(FieldType.COMPLEX);
        rootComplexType.setXmlFields(new XmlFields());
        return rootComplexType;
    }

    private FieldType getFieldType(String name) {
        FieldType attrType = BLACKLISTED_TYPES.get(name);
        if (attrType == null) {
            attrType = XS_TYPE_TO_FIELD_TYPE_MAP.get(name);
        }
        return attrType;
    }

    private CollectionType getCollectionType(XSParticle particle) {
        if (!particle.isRepeated()) {
            return null;
        }
        if (particle.isRepeated() && particle.getMaxOccurs().intValue() == -1) {
            return CollectionType.LIST;
        }
        if (particle.isRepeated() && particle.getMaxOccurs().intValue() > 1) {
            return CollectionType.ARRAY;
        }
        return null;
    }

    private void mapSimpleRestrictionToRestriction(SimpleTypeRestriction simpleTypeRestriction, XmlField xmlField) {
        for (Field field : SimpleTypeRestriction.class.getDeclaredFields()) {
            field.setAccessible(true);
            try {
                if (!this.typeRestrictionExists(field.getName())) continue;
                Object value = field.get(simpleTypeRestriction);
                if (value instanceof String[]) {
                    String[] values;
                    for (String v : values = (String[])value) {
                        Restriction restriction = new Restriction();
                        restriction.setValue(v.toString());
                        restriction.setType(RestrictionType.fromValue((String)field.getName()));
                        xmlField.getRestrictions().getRestriction().add(restriction);
                    }
                    continue;
                }
                if (value == null) continue;
                Restriction restriction = new Restriction();
                restriction.setValue(value.toString());
                restriction.setType(RestrictionType.fromValue((String)field.getName()));
                xmlField.getRestrictions().getRestriction().add(restriction);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    private boolean typeRestrictionExists(String name) {
        for (RestrictionType restrictionType : RestrictionType.values()) {
            if (!name.equals(restrictionType.value())) continue;
            return true;
        }
        return false;
    }

    static {
        XS_TYPE_TO_FIELD_TYPE_MAP.put("int", FieldType.INTEGER);
        XS_TYPE_TO_FIELD_TYPE_MAP.put("integer", FieldType.BIG_INTEGER);
        XS_TYPE_TO_FIELD_TYPE_MAP.put("negativeInteger", FieldType.BIG_INTEGER);
        XS_TYPE_TO_FIELD_TYPE_MAP.put("nonNegativeInteger", FieldType.BIG_INTEGER);
        XS_TYPE_TO_FIELD_TYPE_MAP.put("positiveInteger", FieldType.BIG_INTEGER);
        XS_TYPE_TO_FIELD_TYPE_MAP.put("nonPositiveInteger", FieldType.BIG_INTEGER);
        XS_TYPE_TO_FIELD_TYPE_MAP.put("string", FieldType.STRING);
        XS_TYPE_TO_FIELD_TYPE_MAP.put("short", FieldType.SHORT);
        XS_TYPE_TO_FIELD_TYPE_MAP.put("long", FieldType.LONG);
        XS_TYPE_TO_FIELD_TYPE_MAP.put("double", FieldType.DOUBLE);
        XS_TYPE_TO_FIELD_TYPE_MAP.put("float", FieldType.FLOAT);
        XS_TYPE_TO_FIELD_TYPE_MAP.put("boolean", FieldType.BOOLEAN);
        XS_TYPE_TO_FIELD_TYPE_MAP.put("date", FieldType.DATE);
        XS_TYPE_TO_FIELD_TYPE_MAP.put("dateTime", FieldType.DATE_TIME);
        XS_TYPE_TO_FIELD_TYPE_MAP.put("decimal", FieldType.DECIMAL);
        XS_TYPE_TO_FIELD_TYPE_MAP.put("float", FieldType.FLOAT);
        XS_TYPE_TO_FIELD_TYPE_MAP.put("unsignedLong", FieldType.UNSIGNED_LONG);
        XS_TYPE_TO_FIELD_TYPE_MAP.put("unsignedInt", FieldType.UNSIGNED_INTEGER);
        XS_TYPE_TO_FIELD_TYPE_MAP.put("unsignedLong", FieldType.UNSIGNED_LONG);
        XS_TYPE_TO_FIELD_TYPE_MAP.put("unsignedShort", FieldType.UNSIGNED_SHORT);
        BLACKLISTED_TYPES = new HashMap<String, FieldType>();
        BLACKLISTED_TYPES.put("NMTOKEN", FieldType.UNSUPPORTED);
        BLACKLISTED_TYPES.put("anyURI", FieldType.UNSUPPORTED);
        BLACKLISTED_TYPES.put("base64Binary", FieldType.UNSUPPORTED);
        BLACKLISTED_TYPES.put("byte", FieldType.UNSUPPORTED);
        BLACKLISTED_TYPES.put("unsignedByte", FieldType.UNSUPPORTED);
        BLACKLISTED_TYPES.put("hexBinary", FieldType.UNSUPPORTED);
        BLACKLISTED_TYPES.put("NOTATION", FieldType.UNSUPPORTED);
        BLACKLISTED_TYPES.put("QName", FieldType.UNSUPPORTED);
    }

    private class XSOMErrorHandler
    implements ErrorHandler {
        private XSOMErrorHandler() {
        }

        @Override
        public void error(SAXParseException arg0) throws SAXException {
            throw arg0;
        }

        @Override
        public void fatalError(SAXParseException arg0) throws SAXException {
            throw arg0;
        }

        @Override
        public void warning(SAXParseException arg0) throws SAXException {
            LOG.warn(arg0.getMessage(), (Throwable)arg0);
        }
    }

    private class AtlasXmlNamespaceContext
    implements NamespaceContext {
        protected Map<String, String> nsMap = new HashMap<String, String>();
        private int nsIndex = 1;

        public AtlasXmlNamespaceContext() {
            this.nsMap.put(XmlSchemaInspector.NS_PREFIX_XMLSCHEMA, "http://www.w3.org/2001/XMLSchema");
            this.nsMap.put(XmlSchemaInspector.NS_PREFIX_SCHEMASET, "http://atlasmap.io/xml/schemaset/v2");
        }

        public void add(String prefix, String uri) {
            this.nsMap.put(prefix, uri);
        }

        public String addWithIndex(String uri) {
            String prefix = "ns" + this.nsIndex++;
            while (this.nsMap.containsKey(prefix)) {
                prefix = "ns" + this.nsIndex++;
            }
            this.add(prefix, uri);
            return prefix;
        }

        public Map<String, String> getNamespaceMap() {
            return Collections.unmodifiableMap(this.nsMap);
        }

        @Override
        public String getNamespaceURI(String prefix) {
            return this.nsMap.get(prefix);
        }

        @Override
        public String getPrefix(String namespaceURI) {
            if (namespaceURI == null || namespaceURI.isEmpty()) {
                return null;
            }
            Optional<Map.Entry> entry = this.nsMap.entrySet().stream().filter(e -> namespaceURI.equals(e.getValue())).findFirst();
            return entry.isPresent() ? (String)entry.get().getKey() : null;
        }

        public Iterator<?> getPrefixes(String namespaceURI) {
            if (namespaceURI == null || namespaceURI.isEmpty()) {
                return null;
            }
            return this.nsMap.entrySet().stream().filter(e -> namespaceURI.equals(e.getValue())).map(Map.Entry::getKey).collect(Collectors.toList()).iterator();
        }
    }
}

