/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.xml.core;

import io.atlasmap.api.AtlasException;
import java.io.StringWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XmlIOHelper {
    private TransformerFactory transformerFactory;

    public XmlIOHelper(ClassLoader cl) {
        ClassLoader origTccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(cl);
            this.transformerFactory = TransformerFactory.newInstance();
        }
        finally {
            Thread.currentThread().setContextClassLoader(origTccl);
        }
    }

    public static List<Element> getChildrenWithName(String name, Element parentNode) {
        LinkedList<Element> children = new LinkedList<Element>();
        if (parentNode == null) {
            return children;
        }
        NodeList nodeChildren = parentNode.getChildNodes();
        for (int i = 0; i < nodeChildren.getLength(); ++i) {
            Node child = nodeChildren.item(i);
            if (!(child instanceof Element) || !child.getNodeName().equals(name)) continue;
            children.add((Element)child);
        }
        return children;
    }

    public static List<Element> getChildrenWithNameStripAlias(String name, Optional<String> namespace, Element parentNode) {
        LinkedList<Element> children = new LinkedList<Element>();
        if (parentNode == null) {
            return children;
        }
        NodeList nodeChildren = parentNode.getChildNodes();
        for (int i = 0; i < nodeChildren.getLength(); ++i) {
            Node child = nodeChildren.item(i);
            String nodeName = XmlIOHelper.getNodeNameWithoutNamespaceAlias(child);
            if (!(child instanceof Element) || !nodeName.equals(name)) continue;
            if (!namespace.isPresent()) {
                children.add((Element)child);
                continue;
            }
            if (!namespace.get().equals(child.getNamespaceURI())) continue;
            children.add((Element)child);
        }
        return children;
    }

    public String writeDocumentToString(boolean stripSpaces, Node node) throws AtlasException {
        try {
            if (node == null) {
                return "";
            }
            Transformer transformer = this.transformerFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(node), new StreamResult(writer));
            String result = writer.getBuffer().toString();
            if (stripSpaces) {
                result = result.replaceAll("\n|\r", "");
                result = result.replaceAll("> *?<", "><");
            }
            return result;
        }
        catch (Exception e) {
            throw new AtlasException((Throwable)e);
        }
    }

    private static String getNodeNameWithoutNamespaceAlias(Node child) {
        String nodeName = child.getNodeName();
        int index = nodeName.indexOf(":");
        if (index >= 0) {
            nodeName = nodeName.substring(index + 1);
        }
        return nodeName;
    }
}

