/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.xml.core;

import io.atlasmap.api.AtlasConversionException;
import io.atlasmap.api.AtlasException;
import io.atlasmap.api.AtlasSession;
import io.atlasmap.core.AtlasUtil;
import io.atlasmap.spi.AtlasConversionService;
import io.atlasmap.spi.AtlasFieldReader;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.AuditStatus;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.DataSource;
import io.atlasmap.v2.DataSourceType;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.FieldType;
import io.atlasmap.xml.core.XmlFieldTransformer;
import io.atlasmap.xml.core.XmlIOHelper;
import io.atlasmap.xml.core.XmlPath;
import io.atlasmap.xml.v2.XmlDataSource;
import io.atlasmap.xml.v2.XmlField;
import io.atlasmap.xml.v2.XmlNamespace;
import io.atlasmap.xml.v2.XmlNamespaces;
import java.io.ByteArrayInputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlFieldReader
extends XmlFieldTransformer
implements AtlasFieldReader {
    private static final Logger LOG = LoggerFactory.getLogger(XmlFieldReader.class);
    private AtlasConversionService conversionService;
    private Document document;

    public XmlFieldReader(ClassLoader cl, AtlasConversionService conversionService) {
        super(cl);
        this.conversionService = conversionService;
    }

    public XmlFieldReader(ClassLoader cl, AtlasConversionService conversionService, Map<String, String> namespaces) {
        super(cl, namespaces);
        this.conversionService = conversionService;
    }

    public Field read(AtlasInternalSession session) throws AtlasException {
        Field field = session.head().getSourceField();
        if (this.document == null) {
            AtlasUtil.addAudit((AtlasSession)session, (String)field.getDocId(), (String)String.format("Cannot read field '%s' of document '%s', document is null", field.getPath(), field.getDocId()), (String)field.getPath(), (AuditStatus)AuditStatus.ERROR, null);
            return field;
        }
        if (field == null) {
            throw new AtlasException((Throwable)new IllegalArgumentException("Argument 'field' cannot be null"));
        }
        this.seedDocumentNamespaces(this.document);
        XmlField xmlField = (XmlField)XmlField.class.cast(field);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reading source value for field: " + xmlField.getPath());
        }
        Optional<XmlNamespaces> xmlNamespaces = this.getSourceNamespaces(session, xmlField);
        XmlPath.XmlSegmentContext lastSegment = null;
        List<Element> parentNodes = Arrays.asList(this.document.getDocumentElement());
        XmlPath path = new XmlPath(xmlField.getPath());
        Iterator<XmlPath.XmlSegmentContext> iterator = path.getXmlSegments(false).iterator();
        while (iterator.hasNext()) {
            XmlPath.XmlSegmentContext sc;
            lastSegment = sc = iterator.next();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Now processing segment: " + sc.getName());
            }
            if (path.getParentSegmentOf(sc) == null || path.getParentSegmentOf(sc).isRoot()) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Skipping root segment: " + (Object)((Object)sc));
                continue;
            }
            parentNodes = this.extractSegment(parentNodes, sc, xmlNamespaces);
        }
        if (lastSegment != null) {
            this.readValue(session, parentNodes, lastSegment, xmlField);
        }
        return session.head().getSourceField();
    }

    private List<Element> extractSegment(List<Element> parentNodes, XmlPath.XmlSegmentContext sc, Optional<XmlNamespaces> xmlNamespaces) throws AtlasException {
        LinkedList<Element> answer = new LinkedList<Element>();
        for (Element parentNode : parentNodes) {
            List<Element> children;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Parent element is currently: " + this.xmlHelper.writeDocumentToString(true, parentNode));
            }
            if (sc.isAttribute()) {
                answer.add(parentNode);
                continue;
            }
            String childrenElementName = sc.getName();
            String namespaceAlias = sc.getNamespace();
            Optional<String> namespace = this.getNamespace(xmlNamespaces, namespaceAlias);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Looking for children elements with name: " + childrenElementName);
            }
            if ((children = XmlIOHelper.getChildrenWithNameStripAlias(childrenElementName, namespace, parentNode)) == null || children.isEmpty()) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Skipping source value set, couldn't find children with name '" + childrenElementName + "', for segment: " + (Object)((Object)sc));
                continue;
            }
            if (sc.getCollectionType() != CollectionType.NONE) {
                Integer index = sc.getCollectionIndex();
                if (index == null) {
                    answer.addAll(children);
                    continue;
                }
                if (index >= children.size()) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Skipping source value set, children list can't fit index " + index + ", children list size: " + children.size());
                    continue;
                }
                answer.add(children.get(index));
                continue;
            }
            answer.add(children.get(0));
        }
        return answer;
    }

    private void readValue(AtlasInternalSession session, List<Element> parentNodes, XmlPath.XmlSegmentContext sc, XmlField xmlField) {
        if (xmlField.getFieldType() == null) {
            xmlField.setFieldType(FieldType.STRING);
        }
        XmlPath path = new XmlPath(xmlField.getPath());
        FieldGroup fieldGroup = null;
        if (path.hasCollection() && !path.isIndexedCollection()) {
            fieldGroup = AtlasModelFactory.createFieldGroupFrom((Field)xmlField);
            session.head().setSourceField((Field)fieldGroup);
        }
        for (int i = 0; i < parentNodes.size(); ++i) {
            Element parentNode = parentNodes.get(i);
            XmlField targetField = xmlField;
            if (fieldGroup != null) {
                targetField = new XmlField();
                AtlasModelFactory.copyField((Field)xmlField, (Field)targetField, (boolean)false);
                XmlPath subPath = new XmlPath(targetField.getPath());
                subPath.setVacantCollectionIndex(i);
                targetField.setPath(subPath.toString());
                fieldGroup.getField().add(targetField);
            }
            String value = parentNode.getTextContent();
            if (sc.isAttribute()) {
                String attributeName = sc.getQName();
                value = parentNode.getAttribute(attributeName);
            }
            if (value == null) {
                return;
            }
            if (targetField.getFieldType() == FieldType.STRING) {
                targetField.setValue((Object)value);
                continue;
            }
            try {
                Object convertedValue = this.conversionService.convertType((Object)value, targetField.getFormat(), targetField.getFieldType(), null);
                targetField.setValue(convertedValue);
                continue;
            }
            catch (AtlasConversionException e) {
                AtlasUtil.addAudit((AtlasSession)session, (String)targetField.getDocId(), (String)String.format("Failed to convert field value '%s' into type '%s'", value, targetField.getFieldType()), (String)targetField.getPath(), (AuditStatus)AuditStatus.ERROR, (String)value);
            }
        }
    }

    public void setDocument(String docString, boolean namespaced) throws AtlasException {
        if (docString == null || docString.isEmpty()) {
            return;
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(namespaced);
            DocumentBuilder b = dbf.newDocumentBuilder();
            this.document = b.parse(new ByteArrayInputStream(docString.getBytes("UTF-8")));
        }
        catch (Exception e) {
            LOG.warn("Failed to parse XML document", (Throwable)e);
        }
    }

    private Optional<XmlNamespaces> getSourceNamespaces(AtlasInternalSession session, XmlField xmlField) {
        DataSource dataSource = null;
        AtlasMapping mapping = session.getMapping();
        if (mapping == null || mapping.getDataSource() == null || xmlField.getDocId() == null) {
            return Optional.empty();
        }
        List dataSources = mapping.getDataSource();
        for (DataSource source : dataSources) {
            if (!source.getDataSourceType().equals((Object)DataSourceType.SOURCE) || !xmlField.getDocId().equals(source.getId())) continue;
            dataSource = source;
            break;
        }
        if (dataSource == null || !XmlDataSource.class.isInstance(dataSource)) {
            return Optional.empty();
        }
        XmlDataSource xmlDataSource = (XmlDataSource)XmlDataSource.class.cast(dataSource);
        return Optional.of(xmlDataSource.getXmlNamespaces());
    }

    private Optional<String> getNamespace(Optional<XmlNamespaces> xmlNamespaces, String namespaceAlias) {
        Optional<String> namespace = Optional.empty();
        if (xmlNamespaces.isPresent()) {
            for (XmlNamespace xmlNamespace : xmlNamespaces.get().getXmlNamespace()) {
                if (!xmlNamespace.getAlias().equals(namespaceAlias)) continue;
                namespace = Optional.of(xmlNamespace.getUri());
                break;
            }
        }
        return namespace;
    }
}

