/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.xml.inspect;

import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.FieldType;
import io.atlasmap.xml.inspect.BaseXmlInspectionServiceTest;
import io.atlasmap.xml.inspect.XmlInspectionException;
import io.atlasmap.xml.inspect.XmlInspectionService;
import io.atlasmap.xml.v2.Restriction;
import io.atlasmap.xml.v2.RestrictionType;
import io.atlasmap.xml.v2.XmlComplexType;
import io.atlasmap.xml.v2.XmlDocument;
import io.atlasmap.xml.v2.XmlField;
import io.atlasmap.xml.v2.XmlNamespace;
import java.io.File;
import java.nio.file.Paths;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class XmlSchemaInspectionTest
extends BaseXmlInspectionServiceTest {
    @Test
    public void testInspectSchemaString() throws Exception {
        String source = "<xs:schema attributeFormDefault=\"unqualified\" elementFormDefault=\"qualified\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">\n  <xs:element name=\"data\">\n    <xs:complexType>\n      <xs:sequence>\n        <xs:element type=\"xs:int\" name=\"intField\"/>\n        <xs:element type=\"xs:long\" name=\"longField\"/>\n        <xs:element type=\"xs:string\" name=\"stringField\"/>\n        <xs:element type=\"xs:boolean\" name=\"booleanField\"/>\n        <xs:element type=\"xs:double\" name=\"doubleField\"/>\n        <xs:element type=\"xs:short\" name=\"shortField\"/>\n        <xs:element type=\"xs:float\" name=\"floatField\"/>\n        <xs:element type=\"xs:string\" name=\"charField\"/>\n      </xs:sequence>\n    </xs:complexType>\n  </xs:element>\n</xs:schema>";
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument xmlDocument = service.inspectSchema("<xs:schema attributeFormDefault=\"unqualified\" elementFormDefault=\"qualified\" xmlns:xs=\"http://www.w3.org/2001/XMLSchema\">\n  <xs:element name=\"data\">\n    <xs:complexType>\n      <xs:sequence>\n        <xs:element type=\"xs:int\" name=\"intField\"/>\n        <xs:element type=\"xs:long\" name=\"longField\"/>\n        <xs:element type=\"xs:string\" name=\"stringField\"/>\n        <xs:element type=\"xs:boolean\" name=\"booleanField\"/>\n        <xs:element type=\"xs:double\" name=\"doubleField\"/>\n        <xs:element type=\"xs:short\" name=\"shortField\"/>\n        <xs:element type=\"xs:float\" name=\"floatField\"/>\n        <xs:element type=\"xs:string\" name=\"charField\"/>\n      </xs:sequence>\n    </xs:complexType>\n  </xs:element>\n</xs:schema>");
        Assert.assertNotNull((Object)xmlDocument);
        Assert.assertNotNull((Object)xmlDocument.getFields());
        Assert.assertThat((Object)xmlDocument.getFields().getField().size(), (Matcher)Is.is((Object)1));
        XmlComplexType root = (XmlComplexType)xmlDocument.getFields().getField().get(0);
        Assert.assertNotNull((Object)root);
        Assert.assertThat((Object)root.getXmlFields().getXmlField().size(), (Matcher)Is.is((Object)8));
    }

    @Test
    public void testInspectSchemaFile() throws Exception {
        File schemaFile = Paths.get("src/test/resources/inspect/simple-schema.xsd", new String[0]).toFile();
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument xmlDocument = service.inspectSchema(schemaFile);
        Assert.assertNotNull((Object)xmlDocument);
        Assert.assertNotNull((Object)xmlDocument.getFields());
        Assert.assertThat((Object)xmlDocument.getFields().getField().size(), (Matcher)Is.is((Object)1));
        XmlComplexType root = (XmlComplexType)xmlDocument.getFields().getField().get(0);
        Assert.assertNotNull((Object)root);
        Assert.assertThat((Object)root.getXmlFields().getXmlField().size(), (Matcher)Is.is((Object)8));
    }

    @Test
    public void testInspectSchemaFileComplex() throws Exception {
        File schemaFile = Paths.get("src/test/resources/inspect/complex-schema.xsd", new String[0]).toFile();
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument xmlDocument = service.inspectSchema(schemaFile);
        Assert.assertNotNull((Object)xmlDocument);
        Assert.assertNotNull((Object)xmlDocument.getFields());
        Assert.assertThat((Object)xmlDocument.getFields().getField().size(), (Matcher)Is.is((Object)1));
        XmlComplexType root = (XmlComplexType)xmlDocument.getFields().getField().get(0);
        Assert.assertNotNull((Object)root);
        Assert.assertThat((Object)root.getXmlFields().getXmlField().size(), (Matcher)Is.is((Object)9));
    }

    @Test
    public void testInspectSchemaFileWithNamespace() throws Exception {
        File schemaFile = Paths.get("src/test/resources/inspect/simple-namespace-schema.xsd", new String[0]).toFile();
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument xmlDocument = service.inspectSchema(schemaFile);
        Assert.assertNotNull((Object)xmlDocument);
        Assert.assertNotNull((Object)xmlDocument.getFields());
        Assert.assertThat((Object)xmlDocument.getFields().getField().size(), (Matcher)Is.is((Object)1));
        Assert.assertNotNull((Object)xmlDocument.getXmlNamespaces());
        Assert.assertThat((Object)xmlDocument.getXmlNamespaces().getXmlNamespace().size(), (Matcher)Is.is((Object)1));
        XmlNamespace namespace = (XmlNamespace)xmlDocument.getXmlNamespaces().getXmlNamespace().get(0);
        Assert.assertThat((Object)namespace.getAlias(), (Matcher)Is.is((Object)"tns"));
        Assert.assertThat((Object)namespace.getUri(), (Matcher)Is.is((Object)"http://example.com/"));
    }

    @Test
    public void testInspectShipOrderSchemaFile() throws Exception {
        File schemaFile = Paths.get("src/test/resources/inspect/ship-order-schema.xsd", new String[0]).toFile();
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument xmlDocument = service.inspectSchema(schemaFile);
        Assert.assertNotNull((Object)xmlDocument);
        Assert.assertNotNull((Object)xmlDocument.getFields());
        Assert.assertThat((Object)xmlDocument.getFields().getField().size(), (Matcher)Is.is((Object)1));
        XmlComplexType root = (XmlComplexType)xmlDocument.getFields().getField().get(0);
        Assert.assertNotNull((Object)root);
        Assert.assertThat((Object)root.getXmlFields().getXmlField().size(), (Matcher)Is.is((Object)4));
        XmlField orderIdAttr = (XmlField)root.getXmlFields().getXmlField().get(0);
        Assert.assertNotNull((Object)orderIdAttr);
        Assert.assertThat((Object)orderIdAttr.getName(), (Matcher)Is.is((Object)"orderid"));
        Assert.assertThat((Object)orderIdAttr.getValue(), (Matcher)Is.is((Object)"2"));
        Assert.assertThat((Object)orderIdAttr.getPath(), (Matcher)Is.is((Object)"/shiporder/@orderid"));
        Assert.assertThat((Object)orderIdAttr.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        XmlField orderPerson = (XmlField)root.getXmlFields().getXmlField().get(1);
        Assert.assertNotNull((Object)orderPerson);
        Assert.assertThat((Object)orderPerson.getName(), (Matcher)Is.is((Object)"orderperson"));
        Assert.assertNull((Object)orderPerson.getValue());
        Assert.assertThat((Object)orderPerson.getPath(), (Matcher)Is.is((Object)"/shiporder/orderperson"));
        Assert.assertThat((Object)orderPerson.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        XmlField shipTo = (XmlField)root.getXmlFields().getXmlField().get(2);
        Assert.assertNotNull((Object)shipTo);
        Assert.assertTrue((boolean)(shipTo instanceof XmlComplexType));
        Assert.assertThat((Object)((XmlComplexType)shipTo).getXmlFields().getXmlField().size(), (Matcher)Is.is((Object)4));
        XmlField item = (XmlField)root.getXmlFields().getXmlField().get(3);
        Assert.assertNotNull((Object)item);
        Assert.assertTrue((boolean)(item instanceof XmlComplexType));
        Assert.assertThat((Object)((XmlComplexType)item).getXmlFields().getXmlField().size(), (Matcher)Is.is((Object)4));
    }

    @Test
    public void testInspectPOExampleSchemaFile() throws Exception {
        File schemaFile = Paths.get("src/test/resources/inspect/po-example-schema.xsd", new String[0]).toFile();
        XmlInspectionService service = new XmlInspectionService();
        XmlDocument xmlDocument = service.inspectSchema(schemaFile);
        Assert.assertNotNull((Object)xmlDocument);
        Assert.assertNotNull((Object)xmlDocument.getFields());
        Assert.assertThat((Object)xmlDocument.getFields().getField().size(), (Matcher)Is.is((Object)2));
        XmlComplexType purchaseOrder = (XmlComplexType)xmlDocument.getFields().getField().get(0);
        Assert.assertNotNull((Object)purchaseOrder);
        Assert.assertThat((Object)purchaseOrder.getXmlFields().getXmlField().size(), (Matcher)Is.is((Object)5));
        XmlField orderDateAttr = (XmlField)purchaseOrder.getXmlFields().getXmlField().get(0);
        Assert.assertNotNull((Object)orderDateAttr);
        Assert.assertThat((Object)orderDateAttr.getName(), (Matcher)Is.is((Object)"tns:orderDate"));
        Assert.assertNull((Object)orderDateAttr.getValue());
        Assert.assertThat((Object)orderDateAttr.getPath(), (Matcher)Is.is((Object)"/tns:purchaseOrder/@tns:orderDate"));
        Assert.assertThat((Object)orderDateAttr.getFieldType(), (Matcher)Is.is((Object)FieldType.DATE));
        XmlField shipTo = (XmlField)purchaseOrder.getXmlFields().getXmlField().get(1);
        Assert.assertNotNull((Object)shipTo);
        Assert.assertThat((Object)shipTo.getName(), (Matcher)Is.is((Object)"tns:shipTo"));
        Assert.assertNull((Object)shipTo.getValue());
        Assert.assertThat((Object)shipTo.getPath(), (Matcher)Is.is((Object)"/tns:purchaseOrder/tns:shipTo"));
        Assert.assertThat((Object)shipTo.getFieldType(), (Matcher)Is.is((Object)FieldType.COMPLEX));
        Assert.assertThat((Object)((XmlComplexType)shipTo).getXmlFields().getXmlField().size(), (Matcher)Is.is((Object)6));
        XmlField shipToCountry = (XmlField)((XmlComplexType)shipTo).getXmlFields().getXmlField().get(0);
        Assert.assertNotNull((Object)shipTo);
        Assert.assertThat((Object)shipToCountry.getName(), (Matcher)Is.is((Object)"tns:country"));
        Assert.assertThat((Object)shipToCountry.getValue(), (Matcher)Is.is((Object)"US"));
        Assert.assertThat((Object)shipToCountry.getPath(), (Matcher)Is.is((Object)"/tns:purchaseOrder/tns:shipTo/@tns:country"));
        Assert.assertThat((Object)shipToCountry.getFieldType(), (Matcher)Is.is((Object)FieldType.UNSUPPORTED));
        XmlField shipToName = (XmlField)((XmlComplexType)shipTo).getXmlFields().getXmlField().get(1);
        Assert.assertNotNull((Object)shipToName);
        Assert.assertThat((Object)shipToName.getName(), (Matcher)Is.is((Object)"tns:name"));
        Assert.assertNull((Object)shipToName.getValue());
        Assert.assertThat((Object)shipToName.getPath(), (Matcher)Is.is((Object)"/tns:purchaseOrder/tns:shipTo/tns:name"));
        Assert.assertThat((Object)shipToName.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        XmlField shipToStreet = (XmlField)((XmlComplexType)shipTo).getXmlFields().getXmlField().get(2);
        Assert.assertNotNull((Object)shipToStreet);
        Assert.assertThat((Object)shipToStreet.getName(), (Matcher)Is.is((Object)"tns:street"));
        Assert.assertNull((Object)shipToStreet.getValue());
        Assert.assertThat((Object)shipToStreet.getPath(), (Matcher)Is.is((Object)"/tns:purchaseOrder/tns:shipTo/tns:street"));
        Assert.assertThat((Object)shipToStreet.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        XmlField shipToCity = (XmlField)((XmlComplexType)shipTo).getXmlFields().getXmlField().get(3);
        Assert.assertNotNull((Object)shipToCity);
        Assert.assertThat((Object)shipToCity.getName(), (Matcher)Is.is((Object)"tns:city"));
        Assert.assertNull((Object)shipToCity.getValue());
        Assert.assertThat((Object)shipToCity.getPath(), (Matcher)Is.is((Object)"/tns:purchaseOrder/tns:shipTo/tns:city"));
        Assert.assertThat((Object)shipToCity.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        XmlField shipToState = (XmlField)((XmlComplexType)shipTo).getXmlFields().getXmlField().get(4);
        Assert.assertNotNull((Object)shipToState);
        Assert.assertThat((Object)shipToState.getName(), (Matcher)Is.is((Object)"tns:state"));
        Assert.assertNull((Object)shipToState.getValue());
        Assert.assertThat((Object)shipToState.getPath(), (Matcher)Is.is((Object)"/tns:purchaseOrder/tns:shipTo/tns:state"));
        Assert.assertThat((Object)shipToState.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        XmlField shipToZip = (XmlField)((XmlComplexType)shipTo).getXmlFields().getXmlField().get(5);
        Assert.assertNotNull((Object)shipToZip);
        Assert.assertThat((Object)shipToZip.getName(), (Matcher)Is.is((Object)"tns:zip"));
        Assert.assertNull((Object)shipToZip.getValue());
        Assert.assertThat((Object)shipToZip.getPath(), (Matcher)Is.is((Object)"/tns:purchaseOrder/tns:shipTo/tns:zip"));
        Assert.assertThat((Object)shipToZip.getFieldType(), (Matcher)Is.is((Object)FieldType.DECIMAL));
        XmlField comment = (XmlField)purchaseOrder.getXmlFields().getXmlField().get(3);
        Assert.assertNotNull((Object)comment);
        Assert.assertThat((Object)comment.getName(), (Matcher)Is.is((Object)"tns:comment"));
        Assert.assertNull((Object)comment.getValue());
        Assert.assertThat((Object)comment.getPath(), (Matcher)Is.is((Object)"/tns:purchaseOrder/tns:comment"));
        Assert.assertThat((Object)comment.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        XmlField items = (XmlField)purchaseOrder.getXmlFields().getXmlField().get(4);
        Assert.assertNotNull((Object)items);
        Assert.assertThat((Object)items.getName(), (Matcher)Is.is((Object)"tns:items"));
        Assert.assertNull((Object)items.getValue());
        Assert.assertThat((Object)items.getPath(), (Matcher)Is.is((Object)"/tns:purchaseOrder/tns:items"));
        Assert.assertThat((Object)items.getFieldType(), (Matcher)Is.is((Object)FieldType.COMPLEX));
        Assert.assertThat((Object)((XmlComplexType)items).getXmlFields().getXmlField().size(), (Matcher)Is.is((Object)1));
        XmlComplexType item = (XmlComplexType)((XmlComplexType)items).getXmlFields().getXmlField().get(0);
        Assert.assertNotNull((Object)item);
        Assert.assertThat((Object)item.getName(), (Matcher)Is.is((Object)"tns:item"));
        Assert.assertNull((Object)item.getValue());
        Assert.assertThat((Object)item.getPath(), (Matcher)Is.is((Object)"/tns:purchaseOrder/tns:items/tns:item"));
        Assert.assertThat((Object)item.getFieldType(), (Matcher)Is.is((Object)FieldType.COMPLEX));
        Assert.assertThat((Object)item.getCollectionType(), (Matcher)Is.is((Object)CollectionType.LIST));
        Assert.assertThat((Object)item.getXmlFields().getXmlField().size(), (Matcher)Is.is((Object)6));
        XmlField partNum = (XmlField)item.getXmlFields().getXmlField().get(0);
        Assert.assertNotNull((Object)partNum);
        Assert.assertThat((Object)partNum.getName(), (Matcher)Is.is((Object)"tns:partNum"));
        Assert.assertNull((Object)partNum.getValue());
        Assert.assertThat((Object)partNum.getPath(), (Matcher)Is.is((Object)"/tns:purchaseOrder/tns:items/tns:item/@tns:partNum"));
        Assert.assertThat((Object)partNum.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        Assert.assertThat((Object)partNum.getTypeName(), (Matcher)Is.is((Object)"SKU"));
        XmlField productName = (XmlField)item.getXmlFields().getXmlField().get(1);
        Assert.assertNotNull((Object)productName);
        Assert.assertThat((Object)productName.getName(), (Matcher)Is.is((Object)"tns:productName"));
        Assert.assertNull((Object)productName.getValue());
        Assert.assertThat((Object)productName.getPath(), (Matcher)Is.is((Object)"/tns:purchaseOrder/tns:items/tns:item/tns:productName"));
        Assert.assertThat((Object)productName.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        XmlField quantity = (XmlField)item.getXmlFields().getXmlField().get(2);
        Assert.assertNotNull((Object)quantity);
        Assert.assertThat((Object)quantity.getName(), (Matcher)Is.is((Object)"tns:quantity"));
        Assert.assertNull((Object)quantity.getValue());
        Assert.assertThat((Object)quantity.getPath(), (Matcher)Is.is((Object)"/tns:purchaseOrder/tns:items/tns:item/tns:quantity"));
        Assert.assertThat((Object)quantity.getFieldType(), (Matcher)Is.is((Object)FieldType.BIG_INTEGER));
        Assert.assertNotNull((Object)quantity.getRestrictions().getRestriction());
        Assert.assertThat((Object)quantity.getRestrictions().getRestriction().size(), (Matcher)Is.is((Object)1));
        Restriction qRestriction = (Restriction)quantity.getRestrictions().getRestriction().get(0);
        Assert.assertNotNull((Object)qRestriction);
        Assert.assertNotNull((Object)qRestriction.getType());
        Assert.assertThat((Object)qRestriction.getType(), (Matcher)Is.is((Object)RestrictionType.MAX_EXCLUSIVE));
        Assert.assertNotNull((Object)qRestriction.getValue());
        Assert.assertThat((Object)qRestriction.getValue(), (Matcher)Is.is((Object)"99"));
        XmlField usPrice = (XmlField)item.getXmlFields().getXmlField().get(3);
        Assert.assertNotNull((Object)usPrice);
        Assert.assertThat((Object)usPrice.getName(), (Matcher)Is.is((Object)"tns:USPrice"));
        Assert.assertNull((Object)usPrice.getValue());
        Assert.assertThat((Object)usPrice.getPath(), (Matcher)Is.is((Object)"/tns:purchaseOrder/tns:items/tns:item/tns:USPrice"));
        Assert.assertThat((Object)usPrice.getFieldType(), (Matcher)Is.is((Object)FieldType.DECIMAL));
        XmlField itemComment = (XmlField)item.getXmlFields().getXmlField().get(4);
        Assert.assertNotNull((Object)itemComment);
        Assert.assertThat((Object)itemComment.getName(), (Matcher)Is.is((Object)"tns:comment"));
        Assert.assertNull((Object)itemComment.getValue());
        Assert.assertThat((Object)itemComment.getPath(), (Matcher)Is.is((Object)"/tns:purchaseOrder/tns:items/tns:item/tns:comment"));
        Assert.assertThat((Object)itemComment.getFieldType(), (Matcher)Is.is((Object)FieldType.STRING));
        XmlField shipDate = (XmlField)item.getXmlFields().getXmlField().get(5);
        Assert.assertNotNull((Object)shipDate);
        Assert.assertThat((Object)shipDate.getName(), (Matcher)Is.is((Object)"tns:shipDate"));
        Assert.assertNull((Object)shipDate.getValue());
        Assert.assertThat((Object)shipDate.getPath(), (Matcher)Is.is((Object)"/tns:purchaseOrder/tns:items/tns:item/tns:shipDate"));
        Assert.assertThat((Object)shipDate.getFieldType(), (Matcher)Is.is((Object)FieldType.DATE));
        Assert.assertNotNull((Object)xmlDocument.getXmlNamespaces());
        Assert.assertThat((Object)xmlDocument.getXmlNamespaces().getXmlNamespace().size(), (Matcher)Is.is((Object)1));
        XmlNamespace namespace = (XmlNamespace)xmlDocument.getXmlNamespaces().getXmlNamespace().get(0);
        Assert.assertThat((Object)namespace.getAlias(), (Matcher)Is.is((Object)"tns"));
        Assert.assertThat((Object)namespace.getUri(), (Matcher)Is.is((Object)"http://tempuri.org/po.xsd"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInspectSchemaStringAsSourceNull() throws Exception {
        XmlInspectionService service = new XmlInspectionService();
        String schema = null;
        service.inspectSchema(schema);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInspectSchemaStringAsSourceBlank() throws Exception {
        XmlInspectionService service = new XmlInspectionService();
        String schema = "";
        service.inspectSchema(schema);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInspectSchemaFileAsSourceNull() throws Exception {
        XmlInspectionService service = new XmlInspectionService();
        File schema = null;
        service.inspectSchema(schema);
    }

    @Test(expected=XmlInspectionException.class)
    public void testInspectSchemaBad() throws Exception {
        String source = "<xs:schema/>";
        XmlInspectionService service = new XmlInspectionService();
        service.inspectSchema("<xs:schema/>");
    }

    @Test(expected=XmlInspectionException.class)
    public void testInspectSchemaFileBad() throws Exception {
        File schemaFile = Paths.get("src/test/resources/inspect/simple-schema-bad.xsd", new String[0]).toFile();
        XmlInspectionService service = new XmlInspectionService();
        service.inspectSchema(schemaFile);
    }
}

