/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.json.test;

import io.atlasmap.json.test.BaseAddress;
import io.atlasmap.json.test.BaseContact;
import io.atlasmap.json.test.BaseOrder;
import io.atlasmap.json.test.BaseOrderList;
import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;

public class AtlasJsonUtil {
    public static BaseOrderList generateOrderListClass(Class<? extends BaseOrderList> orderListClazz, Class<? extends BaseOrder> orderClazz, Class<? extends BaseAddress> addressClazz, Class<? extends BaseContact> contactClazz) throws Exception {
        Class<?> targetClazz = AtlasJsonUtil.class.getClassLoader().loadClass(orderListClazz.getName());
        BaseOrderList orderList = (BaseOrderList)targetClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        orderList.setNumberOrders(5);
        orderList.setOrderBatchNumber(4123562);
        for (int i = 0; i < 5; ++i) {
            BaseOrder baseOrder = AtlasJsonUtil.generateOrderClass(orderClazz, addressClazz, contactClazz);
            baseOrder.setOrderId(i);
            if (orderList.getOrders() == null) {
                orderList.setOrders(new ArrayList<BaseOrder>());
            }
            orderList.getOrders().add(baseOrder);
        }
        return orderList;
    }

    public static BaseOrder generateOrderClass(Class<? extends BaseOrder> orderClazz, Class<? extends BaseAddress> addressClazz, Class<? extends BaseContact> contactClazz) throws Exception {
        Class<?> targetClazz = AtlasJsonUtil.class.getClassLoader().loadClass(orderClazz.getName());
        BaseOrder newObject = (BaseOrder)targetClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        newObject.setOrderId(8765309);
        newObject.setAddress(AtlasJsonUtil.generateAddress(addressClazz));
        newObject.setContact(AtlasJsonUtil.generateContact(contactClazz));
        return newObject;
    }

    public static BaseAddress generateAddress(Class<? extends BaseAddress> addressClass) throws Exception {
        Class<?> targetClazz = AtlasJsonUtil.class.getClassLoader().loadClass(addressClass.getName());
        BaseAddress newObject = (BaseAddress)targetClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        newObject.setAddressLine1("123 Main St");
        newObject.setAddressLine2("Suite 42b");
        newObject.setCity("Anytown");
        newObject.setState("NY");
        newObject.setZipCode("90210");
        return newObject;
    }

    public static BaseContact generateContact(Class<? extends BaseContact> contactClass) throws Exception {
        Class<?> targetClazz = AtlasJsonUtil.class.getClassLoader().loadClass(contactClass.getName());
        BaseContact newObject = (BaseContact)targetClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        newObject.setFirstName("Ozzie");
        newObject.setLastName("Smith");
        newObject.setPhoneNumber("5551212");
        newObject.setZipCode("81111");
        return newObject;
    }

    public static void validateOrderList(BaseOrderList orderListObject) {
        Assertions.assertNotNull((Object)orderListObject);
        Assertions.assertNotNull((Object)orderListObject.getNumberOrders());
        Assertions.assertNotNull((Object)orderListObject.getOrderBatchNumber());
        Assertions.assertEquals((Integer)5, (Integer)orderListObject.getNumberOrders());
        Assertions.assertEquals((Integer)4123562, (Integer)orderListObject.getOrderBatchNumber());
        if (orderListObject.getOrders() != null) {
            for (int i = 0; i < orderListObject.getOrders().size(); ++i) {
                AtlasJsonUtil.validateOrder(orderListObject.getOrders().get(i), i);
            }
        }
    }

    public static void validateOrder(BaseOrder orderObject) {
        Assertions.assertNotNull((Object)orderObject);
        Assertions.assertNotNull((Object)orderObject.getOrderId());
        Assertions.assertEquals((Integer)8765309, (Integer)orderObject.getOrderId());
        AtlasJsonUtil.validateAddress(orderObject.getAddress());
        AtlasJsonUtil.validateContact(orderObject.getContact());
    }

    public static void validateOrder(BaseOrder orderObject, int expectedOrderId) {
        Assertions.assertNotNull((Object)orderObject);
        Assertions.assertNotNull((Object)orderObject.getOrderId());
        Assertions.assertEquals((Integer)expectedOrderId, (Integer)orderObject.getOrderId());
        AtlasJsonUtil.validateAddress(orderObject.getAddress());
        AtlasJsonUtil.validateContact(orderObject.getContact());
    }

    public static void validateAddress(BaseAddress addressObject) {
        Assertions.assertNotNull((Object)addressObject);
        Assertions.assertEquals((Object)"123 Main St", (Object)addressObject.getAddressLine1());
        Assertions.assertEquals((Object)"Suite 42b", (Object)addressObject.getAddressLine2());
        Assertions.assertEquals((Object)"Anytown", (Object)addressObject.getCity());
        Assertions.assertEquals((Object)"NY", (Object)addressObject.getState());
        Assertions.assertEquals((Object)"90210", (Object)addressObject.getZipCode());
    }

    public static void validateContact(BaseContact contactObject) {
        Assertions.assertNotNull((Object)contactObject);
        Assertions.assertEquals((Object)"Ozzie", (Object)contactObject.getFirstName());
        Assertions.assertEquals((Object)"Smith", (Object)contactObject.getLastName());
        Assertions.assertEquals((Object)"5551212", (Object)contactObject.getPhoneNumber());
        Assertions.assertEquals((Object)"81111", (Object)contactObject.getZipCode());
    }
}

