/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.json.test;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.atlasmap.json.test.AtlasJsonUtil;
import io.atlasmap.json.test.BaseOrderList;
import io.atlasmap.json.test.SourceAddress;
import io.atlasmap.json.test.SourceContact;
import io.atlasmap.json.test.SourceOrder;
import io.atlasmap.json.test.SourceOrderList;
import java.io.File;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class AtlasJsonDataGenerator {
    private ObjectMapper mapper = null;

    @Before
    public void setUp() {
        this.mapper = new ObjectMapper();
        this.mapper.enable(SerializationFeature.INDENT_OUTPUT);
        this.mapper.configure(SerializationFeature.WRAP_ROOT_VALUE, true);
        this.mapper.configure(DeserializationFeature.UNWRAP_ROOT_VALUE, true);
        this.mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    @After
    public void tearDown() {
        this.mapper = null;
    }

    @Test
    public void testGenerateOrderList() throws Exception {
        BaseOrderList orderList = AtlasJsonUtil.generateOrderListClass(SourceOrderList.class, SourceOrder.class, SourceAddress.class, SourceContact.class);
        SourceOrderList sourceOrderList = (SourceOrderList)orderList;
        this.mapper.writeValue(new File("target/list-rooted-sourceorderlist.json"), (Object)sourceOrderList);
        SourceOrderList rereadSourceOrderList = (SourceOrderList)this.mapper.readValue(new File("target/list-rooted-sourceorderlist.json"), SourceOrderList.class);
        AtlasJsonUtil.validateOrderList(rereadSourceOrderList);
    }
}

