/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.json.test;

import io.atlasmap.json.test.BaseAddress;
import io.atlasmap.json.test.BaseContact;
import io.atlasmap.json.test.BaseOrder;
import io.atlasmap.json.test.BaseOrderList;
import java.util.ArrayList;
import org.junit.Assert;

public class AtlasJsonUtil {
    public static BaseOrderList generateOrderListClass(Class<? extends BaseOrderList> orderListClazz, Class<? extends BaseOrder> orderClazz, Class<? extends BaseAddress> addressClazz, Class<? extends BaseContact> contactClazz) throws Exception {
        Class<?> targetClazz = AtlasJsonUtil.class.getClassLoader().loadClass(orderListClazz.getName());
        BaseOrderList orderList = (BaseOrderList)targetClazz.newInstance();
        orderList.setNumberOrders(5);
        orderList.setOrderBatchNumber(4123562);
        for (int i = 0; i < 5; ++i) {
            BaseOrder baseOrder = AtlasJsonUtil.generateOrderClass(orderClazz, addressClazz, contactClazz);
            baseOrder.setOrderId(i);
            if (orderList.getOrders() == null) {
                orderList.setOrders(new ArrayList<BaseOrder>());
            }
            orderList.getOrders().add(baseOrder);
        }
        return orderList;
    }

    public static BaseOrder generateOrderClass(Class<? extends BaseOrder> orderClazz, Class<? extends BaseAddress> addressClazz, Class<? extends BaseContact> contactClazz) throws Exception {
        Class<?> targetClazz = AtlasJsonUtil.class.getClassLoader().loadClass(orderClazz.getName());
        BaseOrder newObject = (BaseOrder)targetClazz.newInstance();
        newObject.setOrderId(8765309);
        newObject.setAddress(AtlasJsonUtil.generateAddress(addressClazz));
        newObject.setContact(AtlasJsonUtil.generateContact(contactClazz));
        return newObject;
    }

    public static BaseAddress generateAddress(Class<? extends BaseAddress> addressClass) throws Exception {
        Class<?> targetClazz = AtlasJsonUtil.class.getClassLoader().loadClass(addressClass.getName());
        BaseAddress newObject = (BaseAddress)targetClazz.newInstance();
        newObject.setAddressLine1("123 Main St");
        newObject.setAddressLine2("Suite 42b");
        newObject.setCity("Anytown");
        newObject.setState("NY");
        newObject.setZipCode("90210");
        return newObject;
    }

    public static BaseContact generateContact(Class<? extends BaseContact> contactClass) throws Exception {
        Class<?> targetClazz = AtlasJsonUtil.class.getClassLoader().loadClass(contactClass.getName());
        BaseContact newObject = (BaseContact)targetClazz.newInstance();
        newObject.setFirstName("Ozzie");
        newObject.setLastName("Smith");
        newObject.setPhoneNumber("5551212");
        newObject.setZipCode("81111");
        return newObject;
    }

    public static void validateOrderList(BaseOrderList orderListObject) {
        Assert.assertNotNull((Object)orderListObject);
        Assert.assertNotNull((Object)orderListObject.getNumberOrders());
        Assert.assertNotNull((Object)orderListObject.getOrderBatchNumber());
        Assert.assertEquals((Object)new Integer(5), (Object)orderListObject.getNumberOrders());
        Assert.assertEquals((Object)new Integer(4123562), (Object)orderListObject.getOrderBatchNumber());
        if (orderListObject.getOrders() != null) {
            for (int i = 0; i < orderListObject.getOrders().size(); ++i) {
                AtlasJsonUtil.validateOrder(orderListObject.getOrders().get(i), i);
            }
        }
    }

    public static void validateOrder(BaseOrder orderObject) {
        Assert.assertNotNull((Object)orderObject);
        Assert.assertNotNull((Object)orderObject.getOrderId());
        Assert.assertEquals((Object)new Integer(8765309), (Object)orderObject.getOrderId());
        AtlasJsonUtil.validateAddress(orderObject.getAddress());
        AtlasJsonUtil.validateContact(orderObject.getContact());
    }

    public static void validateOrder(BaseOrder orderObject, int expectedOrderId) {
        Assert.assertNotNull((Object)orderObject);
        Assert.assertNotNull((Object)orderObject.getOrderId());
        Assert.assertEquals((Object)new Integer(expectedOrderId), (Object)orderObject.getOrderId());
        AtlasJsonUtil.validateAddress(orderObject.getAddress());
        AtlasJsonUtil.validateContact(orderObject.getContact());
    }

    public static void validateAddress(BaseAddress addressObject) {
        Assert.assertNotNull((Object)addressObject);
        Assert.assertEquals((Object)"123 Main St", (Object)addressObject.getAddressLine1());
        Assert.assertEquals((Object)"Suite 42b", (Object)addressObject.getAddressLine2());
        Assert.assertEquals((Object)"Anytown", (Object)addressObject.getCity());
        Assert.assertEquals((Object)"NY", (Object)addressObject.getState());
        Assert.assertEquals((Object)"90210", (Object)addressObject.getZipCode());
    }

    public static void validateContact(BaseContact contactObject) {
        Assert.assertNotNull((Object)contactObject);
        Assert.assertEquals((Object)"Ozzie", (Object)contactObject.getFirstName());
        Assert.assertEquals((Object)"Smith", (Object)contactObject.getLastName());
        Assert.assertEquals((Object)"5551212", (Object)contactObject.getPhoneNumber());
        Assert.assertEquals((Object)"81111", (Object)contactObject.getZipCode());
    }
}

