/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.json.inspect;

import io.atlasmap.json.inspect.JsonInspectionException;
import io.atlasmap.json.inspect.JsonInspectionService;
import io.atlasmap.json.v2.JsonComplexType;
import io.atlasmap.json.v2.JsonDocument;
import io.atlasmap.json.v2.JsonEnumField;
import io.atlasmap.json.v2.JsonField;
import io.atlasmap.v2.CollectionType;
import io.atlasmap.v2.FieldStatus;
import io.atlasmap.v2.FieldType;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class JsonSchemaInspectorTest {
    private final JsonInspectionService inspectionService = new JsonInspectionService();

    @Test
    public void inspectJsonSchemaEmpty() throws Exception {
        String schema = "";
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.inspectionService.inspectJsonSchema(""));
    }

    @Test
    public void inspectJsonSchemaWhitespaceOnly() throws Exception {
        String schema = " ";
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.inspectionService.inspectJsonSchema(" "));
    }

    @Test
    public void inspectJsonSchemaNull() throws Exception {
        String schema = null;
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.inspectionService.inspectJsonSchema(schema));
    }

    @Test
    public void inspectJsonSchemaUnparseableMissingOpenCurly() throws Exception {
        String schema = "\"$schema\": \"http://json-schema.org/\"}";
        Assertions.assertThrows(JsonInspectionException.class, () -> this.inspectionService.inspectJsonSchema("\"$schema\": \"http://json-schema.org/\"}"));
    }

    @Test
    public void inspectJsonSchemaUnparseableMissingClosingCurly() throws Exception {
        String schema = "{\"$schema\": \"http://json-schema.org/\"";
        Assertions.assertThrows(JsonInspectionException.class, () -> this.inspectionService.inspectJsonSchema("{\"$schema\": \"http://json-schema.org/\""));
    }

    @Test
    public void inspectJsonSchemaEmptyDocument() throws Exception {
        String schema = "{\"$schema\": \"http://json-schema.org/\"}";
        JsonDocument document = this.inspectionService.inspectJsonSchema("{\"$schema\": \"http://json-schema.org/\"}");
        Assertions.assertNotNull((Object)document);
        Assertions.assertEquals((int)0, (int)document.getFields().getField().size());
    }

    @Test
    public void inspectJsonSchemaTopmostArraySimple() throws Exception {
        String schema = "{\"$schema\": \"http://json-schema.org/\", \"type\": \"array\", \"items\": { \"type\": \"integer\"}}";
        JsonDocument document = this.inspectionService.inspectJsonSchema("{\"$schema\": \"http://json-schema.org/\", \"type\": \"array\", \"items\": { \"type\": \"integer\"}}");
        Assertions.assertNotNull((Object)document);
        Assertions.assertEquals((int)1, (int)document.getFields().getField().size());
        JsonField jsonField = (JsonField)document.getFields().getField().get(0);
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)jsonField.getStatus());
        Assertions.assertEquals((Object)CollectionType.LIST, (Object)jsonField.getCollectionType());
        Assertions.assertEquals((Object)FieldType.BIG_INTEGER, (Object)jsonField.getFieldType());
        Assertions.assertEquals((Object)"", (Object)jsonField.getName());
        Assertions.assertEquals((Object)"/<>", (Object)jsonField.getPath());
    }

    @Test
    public void inspectJsonSchemaTopmostArrayObject() throws Exception {
        String schema = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/schema/topmost-array-object.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonSchema(schema);
        Assertions.assertNotNull((Object)document);
        Assertions.assertEquals((int)1, (int)document.getFields().getField().size());
        JsonField jsonField = (JsonField)document.getFields().getField().get(0);
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)jsonField.getStatus());
        Assertions.assertEquals((Object)CollectionType.LIST, (Object)jsonField.getCollectionType());
        Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)jsonField.getFieldType());
        Assertions.assertEquals((Object)"", (Object)jsonField.getName());
        Assertions.assertEquals((Object)"/<>", (Object)jsonField.getPath());
        JsonComplexType root = (JsonComplexType)JsonComplexType.class.cast(jsonField);
        Assertions.assertEquals((int)2, (int)root.getJsonFields().getJsonField().size());
        JsonField color = (JsonField)root.getJsonFields().getJsonField().get(0);
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)color.getStatus());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)color.getFieldType());
        Assertions.assertEquals((Object)"color", (Object)color.getName());
        Assertions.assertEquals((Object)"/<>/color", (Object)color.getPath());
        JsonField value = (JsonField)root.getJsonFields().getJsonField().get(1);
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)value.getStatus());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)value.getFieldType());
        Assertions.assertEquals((Object)"value", (Object)value.getName());
        Assertions.assertEquals((Object)"/<>/value", (Object)value.getPath());
    }

    @Test
    public void inspectJsonSchemaSimpleString() throws Exception {
        String schema = "{\"$schema\": \"http://json-schema.org/\", \"type\": \"string\"}";
        JsonDocument document = this.inspectionService.inspectJsonSchema("{\"$schema\": \"http://json-schema.org/\", \"type\": \"string\"}");
        Assertions.assertNotNull((Object)document);
        Assertions.assertEquals((int)1, (int)document.getFields().getField().size());
        JsonField jsonField = (JsonField)document.getFields().getField().get(0);
        Assertions.assertTrue((jsonField.getStatus().compareTo((Enum)FieldStatus.SUPPORTED) == 0 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)FieldType.STRING, (Object)jsonField.getFieldType());
        Assertions.assertEquals((Object)"", (Object)jsonField.getName());
        Assertions.assertEquals((Object)"/", (Object)jsonField.getPath());
    }

    @Test
    public void inspectFlatPrimitiveNoRoot() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/schema/flatprimitive-base-unrooted.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonSchema(instance);
        Assertions.assertNotNull((Object)document);
        Assertions.assertEquals((int)5, (int)document.getFields().getField().size());
        List fields = document.getFields().getField();
        JsonField field = (JsonField)fields.get(0);
        Assertions.assertEquals((Object)"booleanField", (Object)field.getName());
        Assertions.assertEquals((Object)"/booleanField", (Object)field.getPath());
        Assertions.assertEquals((Object)FieldType.BOOLEAN, (Object)field.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
        field = (JsonField)fields.get(1);
        Assertions.assertEquals((Object)"stringField", (Object)field.getName());
        Assertions.assertEquals((Object)"/stringField", (Object)field.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)field.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
        field = (JsonField)fields.get(2);
        Assertions.assertEquals((Object)"numberField", (Object)field.getName());
        Assertions.assertEquals((Object)"/numberField", (Object)field.getPath());
        Assertions.assertEquals((Object)FieldType.NUMBER, (Object)field.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
        field = (JsonField)fields.get(3);
        Assertions.assertEquals((Object)"intField", (Object)field.getName());
        Assertions.assertEquals((Object)"/intField", (Object)field.getPath());
        Assertions.assertEquals((Object)FieldType.BIG_INTEGER, (Object)field.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
        field = (JsonField)fields.get(4);
        Assertions.assertEquals((Object)"nullField", (Object)field.getName());
        Assertions.assertEquals((Object)"/nullField", (Object)field.getPath());
        Assertions.assertEquals((Object)FieldType.NONE, (Object)field.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
    }

    @Test
    public void inspectFlatPrimitiveWithRoot() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/schema/flatprimitive-base-rooted.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonSchema(instance);
        Assertions.assertNotNull((Object)document);
        Assertions.assertEquals((int)1, (int)document.getFields().getField().size());
        JsonComplexType root = (JsonComplexType)document.getFields().getField().get(0);
        Assertions.assertNotNull((Object)root);
        Assertions.assertEquals((Object)"SourceFlatPrimitive", (Object)root.getName());
        Assertions.assertEquals((Object)"/SourceFlatPrimitive", (Object)root.getPath());
        Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)root.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)root.getStatus());
        Assertions.assertEquals((int)5, (int)root.getJsonFields().getJsonField().size());
        List fields = root.getJsonFields().getJsonField();
        JsonField field = (JsonField)fields.get(0);
        Assertions.assertEquals((Object)"booleanField", (Object)field.getName());
        Assertions.assertEquals((Object)"/SourceFlatPrimitive/booleanField", (Object)field.getPath());
        Assertions.assertEquals((Object)FieldType.BOOLEAN, (Object)field.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
        field = (JsonField)fields.get(1);
        Assertions.assertEquals((Object)"stringField", (Object)field.getName());
        Assertions.assertEquals((Object)"/SourceFlatPrimitive/stringField", (Object)field.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)field.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
        field = (JsonField)fields.get(2);
        Assertions.assertEquals((Object)"numberField", (Object)field.getName());
        Assertions.assertEquals((Object)"/SourceFlatPrimitive/numberField", (Object)field.getPath());
        Assertions.assertEquals((Object)FieldType.NUMBER, (Object)field.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
        field = (JsonField)fields.get(3);
        Assertions.assertEquals((Object)"intField", (Object)field.getName());
        Assertions.assertEquals((Object)"/SourceFlatPrimitive/intField", (Object)field.getPath());
        Assertions.assertEquals((Object)FieldType.BIG_INTEGER, (Object)field.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
        field = (JsonField)fields.get(4);
        Assertions.assertEquals((Object)"nullField", (Object)field.getName());
        Assertions.assertEquals((Object)"/SourceFlatPrimitive/nullField", (Object)field.getPath());
        Assertions.assertEquals((Object)FieldType.NONE, (Object)field.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)field.getStatus());
    }

    @Test
    public void inspectComplexObjectNoRoot() throws Exception {
        String schema = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/schema/complex-object-unrooted.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonSchema(schema);
        Assertions.assertNotNull((Object)document);
        Assertions.assertEquals((int)3, (int)document.getFields().getField().size());
        JsonComplexType address = (JsonComplexType)document.getFields().getField().get(0);
        Assertions.assertNotNull((Object)address);
        Assertions.assertEquals((int)5, (int)address.getJsonFields().getJsonField().size());
        JsonField address1 = (JsonField)address.getJsonFields().getJsonField().get(0);
        Assertions.assertNotNull((Object)address1);
        Assertions.assertEquals((Object)"addressLine1", (Object)address1.getName());
        Assertions.assertEquals((Object)"/address/addressLine1", (Object)address1.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)address1.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)address1.getStatus());
        JsonField address2 = (JsonField)address.getJsonFields().getJsonField().get(1);
        Assertions.assertNotNull((Object)address2);
        Assertions.assertEquals((Object)"addressLine2", (Object)address2.getName());
        Assertions.assertEquals((Object)"/address/addressLine2", (Object)address2.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)address2.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)address2.getStatus());
        JsonField city = (JsonField)address.getJsonFields().getJsonField().get(2);
        Assertions.assertNotNull((Object)city);
        Assertions.assertEquals((Object)"city", (Object)city.getName());
        Assertions.assertEquals((Object)"/address/city", (Object)city.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)city.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)city.getStatus());
        JsonField state = (JsonField)address.getJsonFields().getJsonField().get(3);
        Assertions.assertNotNull((Object)state);
        Assertions.assertEquals((Object)"state", (Object)state.getName());
        Assertions.assertEquals((Object)"/address/state", (Object)state.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)state.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)state.getStatus());
        JsonField postalCode = (JsonField)address.getJsonFields().getJsonField().get(4);
        Assertions.assertNotNull((Object)postalCode);
        Assertions.assertEquals((Object)"zipCode", (Object)postalCode.getName());
        Assertions.assertEquals((Object)"/address/zipCode", (Object)postalCode.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)postalCode.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)postalCode.getStatus());
        JsonComplexType contact = (JsonComplexType)document.getFields().getField().get(1);
        Assertions.assertNotNull((Object)contact);
        Assertions.assertEquals((int)4, (int)contact.getJsonFields().getJsonField().size());
        JsonField firstName = (JsonField)contact.getJsonFields().getJsonField().get(0);
        Assertions.assertNotNull((Object)firstName);
        Assertions.assertEquals((Object)"firstName", (Object)firstName.getName());
        Assertions.assertEquals((Object)"/contact/firstName", (Object)firstName.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)firstName.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)firstName.getStatus());
        JsonField lastName = (JsonField)contact.getJsonFields().getJsonField().get(1);
        Assertions.assertNotNull((Object)lastName);
        Assertions.assertEquals((Object)"lastName", (Object)lastName.getName());
        Assertions.assertEquals((Object)"/contact/lastName", (Object)lastName.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)lastName.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)lastName.getStatus());
        JsonField phoneNumber = (JsonField)contact.getJsonFields().getJsonField().get(2);
        Assertions.assertNotNull((Object)phoneNumber);
        Assertions.assertEquals((Object)"phoneNumber", (Object)phoneNumber.getName());
        Assertions.assertEquals((Object)"/contact/phoneNumber", (Object)phoneNumber.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)phoneNumber.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)phoneNumber.getStatus());
        JsonField zipCode = (JsonField)contact.getJsonFields().getJsonField().get(3);
        Assertions.assertNotNull((Object)zipCode);
        Assertions.assertEquals((Object)"zipCode", (Object)zipCode.getName());
        Assertions.assertEquals((Object)"/contact/zipCode", (Object)zipCode.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)zipCode.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)zipCode.getStatus());
        JsonField orderId = (JsonField)document.getFields().getField().get(2);
        Assertions.assertNotNull((Object)orderId);
        Assertions.assertEquals((Object)"orderId", (Object)orderId.getName());
        Assertions.assertEquals((Object)"/orderId", (Object)orderId.getPath());
        Assertions.assertEquals((Object)FieldType.BIG_INTEGER, (Object)orderId.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)orderId.getStatus());
    }

    @Test
    public void inspectComplexObjectWithRoot() throws Exception {
        String schema = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/schema/complex-object-rooted.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonSchema(schema);
        Assertions.assertNotNull((Object)document);
        Assertions.assertEquals((int)1, (int)document.getFields().getField().size());
        JsonComplexType root = (JsonComplexType)document.getFields().getField().get(0);
        Assertions.assertEquals((int)3, (int)root.getJsonFields().getJsonField().size());
        JsonComplexType address = (JsonComplexType)root.getJsonFields().getJsonField().get(0);
        Assertions.assertNotNull((Object)address);
        Assertions.assertEquals((int)5, (int)address.getJsonFields().getJsonField().size());
        JsonField address1 = (JsonField)address.getJsonFields().getJsonField().get(0);
        Assertions.assertNotNull((Object)address1);
        Assertions.assertEquals((Object)"addressLine1", (Object)address1.getName());
        Assertions.assertEquals((Object)"/order/address/addressLine1", (Object)address1.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)address1.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)address1.getStatus());
        JsonField address2 = (JsonField)address.getJsonFields().getJsonField().get(1);
        Assertions.assertNotNull((Object)address2);
        Assertions.assertEquals((Object)"addressLine2", (Object)address2.getName());
        Assertions.assertEquals((Object)"/order/address/addressLine2", (Object)address2.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)address2.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)address2.getStatus());
        JsonField city = (JsonField)address.getJsonFields().getJsonField().get(2);
        Assertions.assertNotNull((Object)city);
        Assertions.assertEquals((Object)"city", (Object)city.getName());
        Assertions.assertEquals((Object)"/order/address/city", (Object)city.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)city.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)city.getStatus());
        JsonField state = (JsonField)address.getJsonFields().getJsonField().get(3);
        Assertions.assertNotNull((Object)state);
        Assertions.assertEquals((Object)"state", (Object)state.getName());
        Assertions.assertEquals((Object)"/order/address/state", (Object)state.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)state.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)state.getStatus());
        JsonField postalCode = (JsonField)address.getJsonFields().getJsonField().get(4);
        Assertions.assertNotNull((Object)postalCode);
        Assertions.assertEquals((Object)"zipCode", (Object)postalCode.getName());
        Assertions.assertEquals((Object)"/order/address/zipCode", (Object)postalCode.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)postalCode.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)postalCode.getStatus());
        JsonComplexType contact = (JsonComplexType)root.getJsonFields().getJsonField().get(1);
        Assertions.assertNotNull((Object)contact);
        Assertions.assertEquals((int)4, (int)contact.getJsonFields().getJsonField().size());
        JsonField firstName = (JsonField)contact.getJsonFields().getJsonField().get(0);
        Assertions.assertNotNull((Object)firstName);
        Assertions.assertEquals((Object)"firstName", (Object)firstName.getName());
        Assertions.assertEquals((Object)"/order/contact/firstName", (Object)firstName.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)firstName.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)firstName.getStatus());
        JsonField lastName = (JsonField)contact.getJsonFields().getJsonField().get(1);
        Assertions.assertNotNull((Object)lastName);
        Assertions.assertEquals((Object)"lastName", (Object)lastName.getName());
        Assertions.assertEquals((Object)"/order/contact/lastName", (Object)lastName.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)lastName.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)lastName.getStatus());
        JsonField phoneNumber = (JsonField)contact.getJsonFields().getJsonField().get(2);
        Assertions.assertNotNull((Object)phoneNumber);
        Assertions.assertEquals((Object)"phoneNumber", (Object)phoneNumber.getName());
        Assertions.assertEquals((Object)"/order/contact/phoneNumber", (Object)phoneNumber.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)phoneNumber.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)phoneNumber.getStatus());
        JsonField zipCode = (JsonField)contact.getJsonFields().getJsonField().get(3);
        Assertions.assertNotNull((Object)zipCode);
        Assertions.assertEquals((Object)"zipCode", (Object)zipCode.getName());
        Assertions.assertEquals((Object)"/order/contact/zipCode", (Object)zipCode.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)zipCode.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)zipCode.getStatus());
        JsonField orderId = (JsonField)root.getJsonFields().getJsonField().get(2);
        Assertions.assertNotNull((Object)orderId);
        Assertions.assertEquals((Object)"orderId", (Object)orderId.getName());
        Assertions.assertEquals((Object)"/order/orderId", (Object)orderId.getPath());
        Assertions.assertEquals((Object)FieldType.BIG_INTEGER, (Object)orderId.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)orderId.getStatus());
    }

    @Test
    public void inspectObjectArrayWithRoot() throws Exception {
        String schema = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/schema/complex-array-rooted.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonSchema(schema);
        Assertions.assertNotNull((Object)document);
        Assertions.assertEquals((int)1, (int)document.getFields().getField().size());
        JsonComplexType root = (JsonComplexType)document.getFields().getField().get(0);
        Assertions.assertNotNull((Object)root);
        Assertions.assertEquals((int)3, (int)root.getJsonFields().getJsonField().size());
        Assertions.assertEquals((Object)"SourceOrderList", (Object)root.getName());
        JsonComplexType orders = (JsonComplexType)root.getJsonFields().getJsonField().get(0);
        Assertions.assertNotNull((Object)orders);
        Assertions.assertEquals((int)3, (int)orders.getJsonFields().getJsonField().size());
        Assertions.assertEquals((Object)"orders", (Object)orders.getName());
        Assertions.assertEquals((Object)CollectionType.LIST, (Object)orders.getCollectionType());
        Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)orders.getFieldType());
        JsonField orderBatchNumber = (JsonField)root.getJsonFields().getJsonField().get(1);
        Assertions.assertNotNull((Object)orderBatchNumber);
        Assertions.assertEquals((Object)"orderBatchNumber", (Object)orderBatchNumber.getName());
        Assertions.assertEquals((Object)"/SourceOrderList/orderBatchNumber", (Object)orderBatchNumber.getPath());
        Assertions.assertEquals((Object)FieldType.BIG_INTEGER, (Object)orderBatchNumber.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)orderBatchNumber.getStatus());
        JsonField numberOrders = (JsonField)root.getJsonFields().getJsonField().get(2);
        Assertions.assertNotNull((Object)numberOrders);
        Assertions.assertEquals((Object)"numberOrders", (Object)numberOrders.getName());
        Assertions.assertEquals((Object)"/SourceOrderList/numberOrders", (Object)numberOrders.getPath());
        Assertions.assertEquals((Object)FieldType.BIG_INTEGER, (Object)numberOrders.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)numberOrders.getStatus());
        JsonComplexType address = (JsonComplexType)orders.getJsonFields().getJsonField().get(0);
        Assertions.assertNotNull((Object)address);
        Assertions.assertEquals((int)5, (int)address.getJsonFields().getJsonField().size());
        Assertions.assertEquals((Object)"address", (Object)address.getName());
        Assertions.assertEquals((Object)"/SourceOrderList/orders<>/address", (Object)address.getPath());
        JsonField addressLine1 = (JsonField)address.getJsonFields().getJsonField().get(0);
        Assertions.assertNotNull((Object)addressLine1);
        Assertions.assertEquals((Object)"addressLine1", (Object)addressLine1.getName());
        Assertions.assertEquals((Object)"/SourceOrderList/orders<>/address/addressLine1", (Object)addressLine1.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)addressLine1.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)addressLine1.getStatus());
        JsonField addressLine2 = (JsonField)address.getJsonFields().getJsonField().get(1);
        Assertions.assertNotNull((Object)addressLine2);
        Assertions.assertEquals((Object)"addressLine2", (Object)addressLine2.getName());
        Assertions.assertEquals((Object)"/SourceOrderList/orders<>/address/addressLine2", (Object)addressLine2.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)addressLine2.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)addressLine2.getStatus());
        JsonField city = (JsonField)address.getJsonFields().getJsonField().get(2);
        Assertions.assertNotNull((Object)city);
        Assertions.assertEquals((Object)"city", (Object)city.getName());
        Assertions.assertEquals((Object)"/SourceOrderList/orders<>/address/city", (Object)city.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)city.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)city.getStatus());
        JsonField state = (JsonField)address.getJsonFields().getJsonField().get(3);
        Assertions.assertNotNull((Object)state);
        Assertions.assertEquals((Object)"state", (Object)state.getName());
        Assertions.assertEquals((Object)"/SourceOrderList/orders<>/address/state", (Object)state.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)state.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)state.getStatus());
        JsonField postalCode = (JsonField)address.getJsonFields().getJsonField().get(4);
        Assertions.assertNotNull((Object)postalCode);
        Assertions.assertEquals((Object)"zipCode", (Object)postalCode.getName());
        Assertions.assertEquals((Object)"/SourceOrderList/orders<>/address/zipCode", (Object)postalCode.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)postalCode.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)postalCode.getStatus());
        JsonComplexType contact = (JsonComplexType)orders.getJsonFields().getJsonField().get(1);
        Assertions.assertNotNull((Object)contact);
        Assertions.assertEquals((int)4, (int)contact.getJsonFields().getJsonField().size());
        Assertions.assertEquals((Object)"contact", (Object)contact.getName());
        Assertions.assertEquals((Object)"/SourceOrderList/orders<>/contact", (Object)contact.getPath());
        JsonField firstName = (JsonField)contact.getJsonFields().getJsonField().get(0);
        Assertions.assertNotNull((Object)firstName);
        Assertions.assertEquals((Object)"firstName", (Object)firstName.getName());
        Assertions.assertEquals((Object)"/SourceOrderList/orders<>/contact/firstName", (Object)firstName.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)firstName.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)firstName.getStatus());
        JsonField lastName = (JsonField)contact.getJsonFields().getJsonField().get(1);
        Assertions.assertNotNull((Object)lastName);
        Assertions.assertEquals((Object)"lastName", (Object)lastName.getName());
        Assertions.assertEquals((Object)"/SourceOrderList/orders<>/contact/lastName", (Object)lastName.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)lastName.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)lastName.getStatus());
        JsonField phoneNumber = (JsonField)contact.getJsonFields().getJsonField().get(2);
        Assertions.assertNotNull((Object)phoneNumber);
        Assertions.assertEquals((Object)"phoneNumber", (Object)phoneNumber.getName());
        Assertions.assertEquals((Object)"/SourceOrderList/orders<>/contact/phoneNumber", (Object)phoneNumber.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)phoneNumber.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)phoneNumber.getStatus());
        JsonField zipCode = (JsonField)contact.getJsonFields().getJsonField().get(3);
        Assertions.assertNotNull((Object)zipCode);
        Assertions.assertEquals((Object)"zipCode", (Object)zipCode.getName());
        Assertions.assertEquals((Object)"/SourceOrderList/orders<>/contact/zipCode", (Object)zipCode.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)zipCode.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)zipCode.getStatus());
        JsonField orderId = (JsonField)orders.getJsonFields().getJsonField().get(2);
        Assertions.assertNotNull((Object)orderId);
        Assertions.assertEquals((Object)"orderId", (Object)orderId.getName());
        Assertions.assertEquals((Object)"/SourceOrderList/orders<>/orderId", (Object)orderId.getPath());
        Assertions.assertEquals((Object)FieldType.BIG_INTEGER, (Object)orderId.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)orderId.getStatus());
    }

    @Test
    public void inspectJsonSchemaRef() throws Exception {
        String schema = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/schema/ref.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonSchema(schema);
        Assertions.assertNotNull((Object)document);
        Assertions.assertEquals((int)4, (int)document.getFields().getField().size());
        JsonField refA = (JsonField)document.getFields().getField().get(0);
        Assertions.assertNotNull((Object)refA);
        Assertions.assertEquals((Object)"ref-a", (Object)refA.getName());
        Assertions.assertEquals((Object)"/ref-a", (Object)refA.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)refA.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)refA.getStatus());
        JsonComplexType refB = (JsonComplexType)document.getFields().getField().get(1);
        Assertions.assertNotNull((Object)refB);
        Assertions.assertEquals((Object)"ref-b", (Object)refB.getName());
        Assertions.assertEquals((Object)"/ref-b", (Object)refB.getPath());
        Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)refB.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)refB.getStatus());
        Assertions.assertEquals((int)2, (int)refB.getJsonFields().getJsonField().size());
        JsonComplexType refCFromB = (JsonComplexType)refB.getJsonFields().getJsonField().get(0);
        Assertions.assertNotNull((Object)refCFromB);
        Assertions.assertEquals((Object)"ref-c-from-b", (Object)refCFromB.getName());
        Assertions.assertEquals((Object)"/ref-b/ref-c-from-b", (Object)refCFromB.getPath());
        Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)refCFromB.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)refCFromB.getStatus());
        Assertions.assertEquals((int)1, (int)refCFromB.getJsonFields().getJsonField().size());
        JsonField strCFromB = (JsonField)refCFromB.getJsonFields().getJsonField().get(0);
        Assertions.assertNotNull((Object)strCFromB);
        Assertions.assertEquals((Object)"str-c", (Object)strCFromB.getName());
        Assertions.assertEquals((Object)"/ref-b/ref-c-from-b/str-c", (Object)strCFromB.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)strCFromB.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)strCFromB.getStatus());
        JsonField strB = (JsonField)refB.getJsonFields().getJsonField().get(1);
        Assertions.assertNotNull((Object)strB);
        Assertions.assertEquals((Object)"str-b", (Object)strB.getName());
        Assertions.assertEquals((Object)"/ref-b/str-b", (Object)strB.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)strB.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)strB.getStatus());
        JsonComplexType refC = (JsonComplexType)document.getFields().getField().get(2);
        Assertions.assertNotNull((Object)refC);
        Assertions.assertEquals((Object)"ref-c", (Object)refC.getName());
        Assertions.assertEquals((Object)"/ref-c", (Object)refC.getPath());
        Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)refC.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)refC.getStatus());
        Assertions.assertEquals((int)1, (int)refC.getJsonFields().getJsonField().size());
        JsonField strC = (JsonField)refC.getJsonFields().getJsonField().get(0);
        Assertions.assertNotNull((Object)strC);
        Assertions.assertEquals((Object)"str-c", (Object)strC.getName());
        Assertions.assertEquals((Object)"/ref-c/str-c", (Object)strC.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)strC.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)strC.getStatus());
        JsonComplexType refD = (JsonComplexType)document.getFields().getField().get(3);
        Assertions.assertNotNull((Object)refD);
        Assertions.assertEquals((Object)"ref-d", (Object)refD.getName());
        Assertions.assertEquals((Object)"/ref-d", (Object)refD.getPath());
        Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)refD.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)refD.getStatus());
        Assertions.assertEquals((int)1, (int)refD.getJsonFields().getJsonField().size());
        JsonField strD = (JsonField)refD.getJsonFields().getJsonField().get(0);
        Assertions.assertNotNull((Object)strD);
        Assertions.assertEquals((Object)"str-d", (Object)strD.getName());
        Assertions.assertEquals((Object)"/ref-d/str-d", (Object)strD.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)strD.getFieldType());
        Assertions.assertEquals((Object)FieldStatus.SUPPORTED, (Object)strD.getStatus());
    }

    @Test
    public void inspectJsonSchemaGeo() throws Exception {
        String schema = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/schema/geo.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonSchema(schema);
        List fields = document.getFields().getField();
        JsonField f = (JsonField)fields.get(0);
        Assertions.assertEquals((Object)"latitude", (Object)f.getName());
        Assertions.assertEquals((Object)"/latitude", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.NUMBER, (Object)f.getFieldType());
        f = (JsonField)fields.get(1);
        Assertions.assertEquals((Object)"longitude", (Object)f.getName());
        Assertions.assertEquals((Object)"/longitude", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.NUMBER, (Object)f.getFieldType());
    }

    @Test
    public void inspectJsonSchemaAddress() throws Exception {
        String schema = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/schema/address.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonSchema(schema);
        List fields = document.getFields().getField();
        JsonField f = (JsonField)fields.get(0);
        Assertions.assertEquals((Object)"post-office-box", (Object)f.getName());
        Assertions.assertEquals((Object)"/post-office-box", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(1);
        Assertions.assertEquals((Object)"extended-address", (Object)f.getName());
        Assertions.assertEquals((Object)"/extended-address", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(2);
        Assertions.assertEquals((Object)"street-address", (Object)f.getName());
        Assertions.assertEquals((Object)"/street-address", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(3);
        Assertions.assertEquals((Object)"locality", (Object)f.getName());
        Assertions.assertEquals((Object)"/locality", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(4);
        Assertions.assertEquals((Object)"region", (Object)f.getName());
        Assertions.assertEquals((Object)"/region", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)f.getFieldType());
        JsonComplexType c = (JsonComplexType)f;
        Assertions.assertEquals((Object)true, (Object)c.isEnumeration());
        ArrayList<String> regions = new ArrayList<String>(Arrays.asList("NA", "EMEA", "LATAM", "APAC"));
        for (JsonEnumField e : c.getJsonEnumFields().getJsonEnumField()) {
            if (regions.remove(e.getName())) continue;
            Assertions.fail((String)("Unknown enum value: " + e.getName()));
        }
        if (!regions.isEmpty()) {
            Assertions.fail((String)("Not found: " + regions));
        }
        f = (JsonField)fields.get(5);
        Assertions.assertEquals((Object)"postal-code", (Object)f.getName());
        Assertions.assertEquals((Object)"/postal-code", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(6);
        Assertions.assertEquals((Object)"country-name", (Object)f.getName());
        Assertions.assertEquals((Object)"/country-name", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
    }

    @Disabled(value="https://github.com/atlasmap/atlasmap/issues/3129")
    @Test
    public void inspectJsonSchemaCalendarExternal() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/schema/calendar.json", new String[0])));
        this.doInspectJsonSchemaCalendar(instance);
    }

    @Test
    public void inspectJsonSchemaCalendarInternal() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/schema/calendar-internal.json", new String[0])));
        this.doInspectJsonSchemaCalendar(instance);
    }

    @Test
    public void inspectJsonSchemaCalendarInline() throws Exception {
        String instance = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/schema/calendar-inline.json", new String[0])));
        this.doInspectJsonSchemaCalendar(instance);
    }

    private void doInspectJsonSchemaCalendar(String instance) throws Exception {
        JsonDocument document = this.inspectionService.inspectJsonSchema(instance);
        List fields = document.getFields().getField();
        JsonField f = (JsonField)fields.get(0);
        Assertions.assertEquals((Object)"dtstart", (Object)f.getName());
        Assertions.assertEquals((Object)"/dtstart", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(1);
        Assertions.assertEquals((Object)"dtend", (Object)f.getName());
        Assertions.assertEquals((Object)"/dtend", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(2);
        Assertions.assertEquals((Object)"summary", (Object)f.getName());
        Assertions.assertEquals((Object)"/summary", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(3);
        Assertions.assertEquals((Object)"location", (Object)f.getName());
        Assertions.assertEquals((Object)"/location", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(4);
        Assertions.assertEquals((Object)"url", (Object)f.getName());
        Assertions.assertEquals((Object)"/url", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(5);
        Assertions.assertEquals((Object)"duration", (Object)f.getName());
        Assertions.assertEquals((Object)"/duration", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(6);
        Assertions.assertEquals((Object)"rdate", (Object)f.getName());
        Assertions.assertEquals((Object)"/rdate", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(7);
        Assertions.assertEquals((Object)"rrule", (Object)f.getName());
        Assertions.assertEquals((Object)"/rrule", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(8);
        Assertions.assertEquals((Object)"category", (Object)f.getName());
        Assertions.assertEquals((Object)"/category", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(9);
        Assertions.assertEquals((Object)"description", (Object)f.getName());
        Assertions.assertEquals((Object)"/description", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)fields.get(10);
        Assertions.assertEquals((Object)"geo", (Object)f.getName());
        Assertions.assertEquals((Object)"/geo", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)f.getFieldType());
        List geofields = ((JsonComplexType)f).getJsonFields().getJsonField();
        f = (JsonField)geofields.get(0);
        Assertions.assertEquals((Object)"latitude", (Object)f.getName());
        Assertions.assertEquals((Object)"/geo/latitude", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.NUMBER, (Object)f.getFieldType());
        f = (JsonField)geofields.get(1);
        Assertions.assertEquals((Object)"longitude", (Object)f.getName());
        Assertions.assertEquals((Object)"/geo/longitude", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.NUMBER, (Object)f.getFieldType());
    }

    @Disabled(value="https://github.com/atlasmap/atlasmap/issues/3129")
    @Test
    public void inspectJsonSchemaCardExternal() throws Exception {
        String schema = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/schema/card.json", new String[0])));
        this.doInspectJsonSchemaCard(schema);
    }

    @Test
    public void inspectJsonSchemaCardInternal() throws Exception {
        String schema = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/schema/card-internal.json", new String[0])));
        this.doInspectJsonSchemaCard(schema);
    }

    @Test
    public void inspectJsonSchemaCardInline() throws Exception {
        String schema = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/schema/card-inline.json", new String[0])));
        this.doInspectJsonSchemaCard(schema);
    }

    private void doInspectJsonSchemaCard(String schema) throws Exception {
        JsonDocument document = this.inspectionService.inspectJsonSchema(schema);
        List fields = document.getFields().getField();
        JsonField f = (JsonField)fields.get(0);
        Assertions.assertEquals((Object)"fn", (Object)f.getName());
        Assertions.assertEquals((Object)"/fn", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(1);
        Assertions.assertEquals((Object)"familyName", (Object)f.getName());
        Assertions.assertEquals((Object)"/familyName", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(2);
        Assertions.assertEquals((Object)"givenName", (Object)f.getName());
        Assertions.assertEquals((Object)"/givenName", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(3);
        Assertions.assertEquals((Object)"additionalName", (Object)f.getName());
        Assertions.assertEquals((Object)"/additionalName<>", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        Assertions.assertEquals((Object)CollectionType.LIST, (Object)f.getCollectionType());
        f = (JsonField)fields.get(4);
        Assertions.assertEquals((Object)"honorificPrefix", (Object)f.getName());
        Assertions.assertEquals((Object)"/honorificPrefix<>", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        Assertions.assertEquals((Object)CollectionType.LIST, (Object)f.getCollectionType());
        f = (JsonField)fields.get(5);
        Assertions.assertEquals((Object)"honorificSuffix", (Object)f.getName());
        Assertions.assertEquals((Object)"/honorificSuffix<>", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        Assertions.assertEquals((Object)CollectionType.LIST, (Object)f.getCollectionType());
        f = (JsonField)fields.get(6);
        Assertions.assertEquals((Object)"nickname", (Object)f.getName());
        Assertions.assertEquals((Object)"/nickname", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(7);
        Assertions.assertEquals((Object)"url", (Object)f.getName());
        Assertions.assertEquals((Object)"/url", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)fields.get(8);
        Assertions.assertEquals((Object)"email", (Object)f.getName());
        Assertions.assertEquals((Object)"/email", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)f.getFieldType());
        List emailfields = ((JsonComplexType)f).getJsonFields().getJsonField();
        f = (JsonField)emailfields.get(0);
        Assertions.assertEquals((Object)"type", (Object)f.getName());
        Assertions.assertEquals((Object)"/email/type", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)emailfields.get(1);
        Assertions.assertEquals((Object)"value", (Object)f.getName());
        Assertions.assertEquals((Object)"/email/value", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)fields.get(9);
        Assertions.assertEquals((Object)"tel", (Object)f.getName());
        Assertions.assertEquals((Object)"/tel", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)f.getFieldType());
        List telfields = ((JsonComplexType)f).getJsonFields().getJsonField();
        f = (JsonField)telfields.get(0);
        Assertions.assertEquals((Object)"type", (Object)f.getName());
        Assertions.assertEquals((Object)"/tel/type", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)telfields.get(1);
        Assertions.assertEquals((Object)"value", (Object)f.getName());
        Assertions.assertEquals((Object)"/tel/value", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)fields.get(10);
        Assertions.assertEquals((Object)"adr", (Object)f.getName());
        Assertions.assertEquals((Object)"/adr", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)f.getFieldType());
        List addrfields = ((JsonComplexType)f).getJsonFields().getJsonField();
        f = (JsonField)addrfields.get(0);
        Assertions.assertEquals((Object)"post-office-box", (Object)f.getName());
        Assertions.assertEquals((Object)"/adr/post-office-box", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)addrfields.get(1);
        Assertions.assertEquals((Object)"extended-address", (Object)f.getName());
        Assertions.assertEquals((Object)"/adr/extended-address", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)addrfields.get(2);
        Assertions.assertEquals((Object)"street-address", (Object)f.getName());
        Assertions.assertEquals((Object)"/adr/street-address", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)addrfields.get(3);
        Assertions.assertEquals((Object)"locality", (Object)f.getName());
        Assertions.assertEquals((Object)"/adr/locality", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)addrfields.get(4);
        Assertions.assertEquals((Object)"region", (Object)f.getName());
        Assertions.assertEquals((Object)"/adr/region", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)addrfields.get(5);
        Assertions.assertEquals((Object)"postal-code", (Object)f.getName());
        Assertions.assertEquals((Object)"/adr/postal-code", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)addrfields.get(6);
        Assertions.assertEquals((Object)"country-name", (Object)f.getName());
        Assertions.assertEquals((Object)"/adr/country-name", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)fields.get(11);
        Assertions.assertEquals((Object)"geo", (Object)f.getName());
        Assertions.assertEquals((Object)"/geo", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)f.getFieldType());
        List geofields = ((JsonComplexType)f).getJsonFields().getJsonField();
        f = (JsonField)geofields.get(0);
        Assertions.assertEquals((Object)"latitude", (Object)f.getName());
        Assertions.assertEquals((Object)"/geo/latitude", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.NUMBER, (Object)f.getFieldType());
        f = (JsonField)geofields.get(1);
        Assertions.assertEquals((Object)"longitude", (Object)f.getName());
        Assertions.assertEquals((Object)"/geo/longitude", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.NUMBER, (Object)f.getFieldType());
        f = (JsonField)fields.get(12);
        Assertions.assertEquals((Object)"tz", (Object)f.getName());
        Assertions.assertEquals((Object)"/tz", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(13);
        Assertions.assertEquals((Object)"photo", (Object)f.getName());
        Assertions.assertEquals((Object)"/photo", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(14);
        Assertions.assertEquals((Object)"logo", (Object)f.getName());
        Assertions.assertEquals((Object)"/logo", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(15);
        Assertions.assertEquals((Object)"sound", (Object)f.getName());
        Assertions.assertEquals((Object)"/sound", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(16);
        Assertions.assertEquals((Object)"bday", (Object)f.getName());
        Assertions.assertEquals((Object)"/bday", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(17);
        Assertions.assertEquals((Object)"title", (Object)f.getName());
        Assertions.assertEquals((Object)"/title", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)fields.get(18);
        Assertions.assertEquals((Object)"role", (Object)f.getName());
        Assertions.assertEquals((Object)"/role", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonComplexType)fields.get(19);
        Assertions.assertEquals((Object)"org", (Object)f.getName());
        Assertions.assertEquals((Object)"/org", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.COMPLEX, (Object)f.getFieldType());
        List orgfields = ((JsonComplexType)f).getJsonFields().getJsonField();
        f = (JsonField)orgfields.get(0);
        Assertions.assertEquals((Object)"organizationName", (Object)f.getName());
        Assertions.assertEquals((Object)"/org/organizationName", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
        f = (JsonField)orgfields.get(1);
        Assertions.assertEquals((Object)"organizationUnit", (Object)f.getName());
        Assertions.assertEquals((Object)"/org/organizationUnit", (Object)f.getPath());
        Assertions.assertEquals((Object)FieldType.STRING, (Object)f.getFieldType());
    }

    @Test
    public void inspectJsonSchemaRecursiveObject() throws Exception {
        String schema = new String(Files.readAllBytes(Paths.get("src/test/resources/inspect/schema/recursive.json", new String[0])));
        JsonDocument document = this.inspectionService.inspectJsonSchema(schema);
        List fields = document.getFields().getField();
    }
}

